/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ButterflyPlant;
import dangerzone.entities.EntityBlockItem;
import dangerzone.items.Items;

public class RicePlant
extends ButterflyPlant {
    public RicePlant(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
        this.isLeaves = true;
        this.maxdamage = 1;
        this.burntime = 10;
        this.showInInventory = false;
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getItemDrop(Player p, World w, int dimension, int x, int y, int z) {
        if (this.blockID == Blocks.rice_plant3.blockID) {
            int howmany = 2 + w.rand.nextInt(5);
            int i = 0;
            while (i < howmany) {
                Utils.doDropRand(w, 0, Items.rice.itemID, 1.0f, dimension, x, y + 1, z);
                Utils.spawnExperience(1, w, dimension, x, y + 1, z);
                ++i;
            }
        }
        return 0;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID) {
            EntityBlockItem e;
            w.setblock(d, x, y, z, 0);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f)) != null) {
                e.setBID(Blocks.rice_plant.blockID);
                e.setIID(0);
                DangerZone.player.world.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (w.getblock(d, x, y + 1, z) != 0) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        if (w.isServer && w.isDaytime() && w.rand.nextInt(20) == 1) {
            int growto = 0;
            if (this.blockID == Blocks.rice_plant.blockID) {
                growto = Blocks.rice_plant1.blockID;
            }
            if (this.blockID == Blocks.rice_plant1.blockID) {
                growto = Blocks.rice_plant2.blockID;
            }
            if (this.blockID == Blocks.rice_plant2.blockID) {
                growto = Blocks.rice_plant3.blockID;
            }
            if (growto != 0) {
                w.setblock(d, x, y, z, growto);
            }
        }
    }
}

