/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.items.Items;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class Door
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public Door(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:woodbreak";
        this.placesound = "DangerZone:woodplace";
        this.hitsound = "DangerZone:woodhit";
        this.isSolidForRendering = false;
        this.isSolid = true;
        this.hasOwnRenderer = true;
        this.maxdamage = 100;
        this.burntime = 65;
        this.hasFront = true;
        this.showInInventory = false;
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:wood1";
        }
        if (i == 1) {
            return "DangerZone:wood2";
        }
        if (i == 2) {
            return "DangerZone:wood3";
        }
        return "DangerZone:wood4";
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        if (this.blockID == Blocks.doorbottom.blockID) {
            bid = w.getblock(d, x, y + 1, z);
            if (bid != Blocks.doortop.blockID) {
                w.setblock(d, x, y, z, 0);
            }
        } else {
            bid = w.getblock(d, x, y - 1, z);
            if (bid != Blocks.doorbottom.blockID) {
                w.setblock(d, x, y, z, 0);
            }
        }
    }

    @Override
    public boolean getIsSolid(World w, int d, int x, int y, int z) {
        int meta = w.getblockmeta(d, x, y, z);
        return (meta & 1) != 1;
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getItemDrop(Player p, World w, int dimension, int x, int y, int z) {
        return Items.door.itemID;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z) {
        if (p != null && !p.world.isServer) {
            int meta = p.world.getblockmeta(p.dimension, x, y, z);
            if ((meta & 1) == 1) {
                meta &= 0xFFFE;
                p.world.playSound("DangerZone:chest_close", dimension, x, y, z, 0.75f, 1.0f);
            } else {
                meta |= 1;
                p.world.playSound("DangerZone:chest_open", dimension, x, y, z, 0.75f, 1.0f);
            }
            p.world.setblockandmeta(p.dimension, x, y, z, this.blockID, meta);
            if (this.blockID == Blocks.doortop.blockID) {
                p.world.setblockandmeta(p.dimension, x, y - 1, z, Blocks.doorbottom.blockID, meta);
            } else {
                p.world.setblockandmeta(p.dimension, x, y + 1, z, Blocks.doortop.blockID, meta);
            }
        }
        return false;
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int inmeta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        float xoff = 0.0f;
        int meta = inmeta;
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        if (st == null) {
            return;
        }
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        if ((inmeta & 1) == 1) {
            xoff = 7.0f;
            meta = (inmeta & 0x3000) == 0 ? 4096 : ((inmeta & 0x3000) == 4096 ? 8192 : ((inmeta & 0x3000) == 8192 ? 12288 : 0));
        }
        this.addVertextWithRotation(v, 1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin + (st.yoffsetmax - st.yoffsetmin) / 8.0f, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmax, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin + (st.xoffsetmax - st.xoffsetmin) / 8.0f, st.yoffsetmax, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta);
        this.addVertextWithRotation(v, -1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmax, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmax, meta);
        this.addVertextWithRotation(v, 1.0f + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta);
    }

    public void addVertextWithRotation(VBOBuffer v, float x, float y, float z, float xo, float yo, float zo, float xtx, float ytx, int meta) {
        if ((meta & 0x3000) == 0) {
            v.addVertexInfoToVBO(z + xo, y + yo, -x + zo, xtx, ytx, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        } else if ((meta & 0x3000) == 4096) {
            v.addVertexInfoToVBO(-x + xo, y + yo, -z + zo, xtx, ytx, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        } else if ((meta & 0x3000) == 8192) {
            v.addVertexInfoToVBO(-z + xo, y + yo, x + zo, xtx, ytx, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        } else {
            v.addVertexInfoToVBO(x + xo, y + yo, z + zo, xtx, ytx, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)this.myrenderid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.125f);
            GL11.glVertex3f((float)1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.125f);
            GL11.glVertex3f((float)1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.125f);
            GL11.glVertex3f((float)1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.125f);
            GL11.glVertex3f((float)1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.125f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)-1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.125f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.125f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.125f, (float)1.0f);
            GL11.glVertex3f((float)-1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)-1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)-1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)-1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        float rot = 0.0f;
        rot = (meta & 1) == 0 ? ((meta & 0x3000) == 0 ? 90.0f : ((meta & 0x3000) == 4096 ? 180.0f : ((meta & 0x3000) == 8192 ? 270.0f : 0.0f))) : ((meta & 0x3000) == 0 ? 180.0f : ((meta & 0x3000) == 4096 ? 270.0f : ((meta & 0x3000) == 8192 ? 0.0f : 90.0f)));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (rot != 0.0f) {
            GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((meta & 1) == 1) {
            GL11.glTranslatef((float)6.93f, (float)0.0f, (float)0.0f);
        }
        GL11.glCallList((int)this.myrenderid);
        if ((meta & 1) == 1) {
            GL11.glTranslatef((float)-6.93f, (float)0.0f, (float)0.0f);
        }
        if (rot != 0.0f) {
            GL11.glRotatef((float)(-rot), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glDisable((int)3042);
    }
}

