/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.Player;
import dangerzone.World;
import dangerzone.blocks.BlockLiquid;
import dangerzone.blocks.Blocks;

public class BlockWater
extends BlockLiquid {
    public BlockWater(String n, String txt) {
        super(n, txt);
        this.maxdamage = 1;
        this.friction = 0.1f;
        this.isLiquid = true;
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.isTranslucent = true;
        this.showInInventory = false;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        this.doTick(w, d, x, y, z);
    }

    public void doTick(World w, int d, int x, int y, int z) {
        int meta;
        int bid;
        boolean change = true;
        int mymeta = w.getblockmeta(d, x, y, z);
        int i = -1;
        while (i <= 1 && change) {
            int j = -1;
            while (j <= 0 && change) {
                int k = -1;
                while (k <= 1 && change) {
                    if (i != 0 || j != 0 || k != 0) {
                        bid = w.getblock(d, x + i, y + j, z + k);
                        meta = w.getblockmeta(d, x + i, y + j, z + k);
                        if (bid == 0) {
                            change = false;
                        } else if (bid == Blocks.water.blockID) {
                            if (meta != 0) {
                                change = false;
                            }
                        } else if (bid != Blocks.watersource.blockID && !Blocks.isSolid(bid)) {
                            change = false;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (!change) {
            bid = w.getblock(d, x, y + 1, z);
            meta = w.getblockmeta(d, x, y + 1, z);
            if (bid == Blocks.watersource.blockID) {
                if (mymeta != 0) {
                    w.setblockandmeta(d, x, y, z, Blocks.water.blockID, 0);
                    return;
                }
            } else if (bid == Blocks.water.blockID && meta == 0 && mymeta != 0) {
                w.setblockandmeta(d, x, y, z, Blocks.water.blockID, 0);
                return;
            }
        }
        if (change) {
            w.setblockandmeta(d, x, y, z, Blocks.watersource.blockID, 0);
            return;
        }
        super.tickMe(w, d, x, y, z);
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }
}

