/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.StuffList;
import dangerzone.World;
import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityChest;
import dangerzone.items.Items;

public class WorldDecorator {
    public static StuffList[] things = new StuffList[]{new StuffList(Items.coinsilver, 5, 25, 75), new StuffList(Items.coingold, 3, 15, 65), new StuffList(Items.coinplatinum, 1, 5, 55), new StuffList(Items.diamond, 1, 5, 55), new StuffList(Items.emerald, 1, 5, 55), new StuffList(Items.bloodstone, 1, 5, 55), new StuffList(Items.sunstone, 1, 5, 55), new StuffList(Items.woodenaxe, 1, 1, 25), new StuffList(Items.woodenshovel, 1, 1, 25), new StuffList(Items.woodenhoe, 1, 1, 25), new StuffList(Items.woodenpickaxe, 1, 1, 25), new StuffList(Items.woodensword, 1, 1, 25), new StuffList(Items.silveraxe, 1, 1, 20), new StuffList(Items.silvershovel, 1, 1, 20), new StuffList(Items.silverhoe, 1, 1, 20), new StuffList(Items.silverpickaxe, 1, 1, 20), new StuffList(Items.silversword, 1, 1, 20), new StuffList(Items.tinsword, 1, 1, 20), new StuffList(Items.tinaxe, 1, 1, 20), new StuffList(Items.tinshovel, 1, 1, 20), new StuffList(Items.tinhoe, 1, 1, 20), new StuffList(Items.tinpickaxe, 1, 1, 20), new StuffList(Items.coppersword, 1, 1, 20), new StuffList(Items.copperaxe, 1, 1, 20), new StuffList(Items.coppershovel, 1, 1, 20), new StuffList(Items.copperhoe, 1, 1, 20), new StuffList(Items.copperpickaxe, 1, 1, 20), new StuffList(Items.platinumaxe, 1, 1, 15), new StuffList(Items.platinumshovel, 1, 1, 15), new StuffList(Items.platinumhoe, 1, 1, 15), new StuffList(Items.platinumpickaxe, 1, 1, 15), new StuffList(Items.platinumsword, 1, 1, 15), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.instability, 1, 16, 25), new StuffList(Items.instabilitylarge, 1, 16, 20), new StuffList(Items.instabilityhuge, 1, 16, 15), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.moosemeat, 1, 16, 45), new StuffList(Items.moosemeat_cooked, 1, 16, 35), new StuffList(Items.moosebone, 1, 16, 45), new StuffList(Items.goosemeat, 1, 16, 45), new StuffList(Items.goosemeat_cooked, 1, 16, 35), new StuffList(Items.feather, 1, 16, 45), new StuffList(Items.ostrichmeat, 1, 16, 35), new StuffList(Items.ostrichmeat_cooked, 1, 16, 45), new StuffList(Items.silverhelmet, 1, 1, 20), new StuffList(Items.silverchestplate, 1, 1, 20), new StuffList(Items.silverleggings, 1, 1, 20), new StuffList(Items.silverboots, 1, 1, 20), new StuffList(Items.platinumhelmet, 1, 1, 15), new StuffList(Items.platinumchestplate, 1, 1, 15), new StuffList(Items.platinumleggings, 1, 1, 15), new StuffList(Items.platinumboots, 1, 1, 15), new StuffList(Items.copperhelmet, 1, 1, 20), new StuffList(Items.copperchestplate, 1, 1, 20), new StuffList(Items.copperleggings, 1, 1, 20), new StuffList(Items.copperboots, 1, 1, 20), new StuffList(Items.tinhelmet, 1, 1, 20), new StuffList(Items.tinchestplate, 1, 1, 20), new StuffList(Items.tinleggings, 1, 1, 20), new StuffList(Items.tinboots, 1, 1, 20), new StuffList(Items.firestick, 1, 1, 45), new StuffList(Items.deadbug, 1, 16, 45), new StuffList(Items.peachseed, 1, 16, 45), new StuffList(Items.appleseed, 1, 16, 45), new StuffList(Items.cherryseed, 1, 16, 45), new StuffList(Items.dark, 1, 16, 25), new StuffList(Items.light, 1, 16, 25), new StuffList(Items.eggbutterfly, 1, 6, 15), new StuffList(Items.eggghost, 1, 6, 15), new StuffList(Items.eggghostskelly, 1, 6, 15), new StuffList(Items.eggrat, 1, 6, 15), new StuffList(Items.eggcockroach, 1, 6, 15), new StuffList(Items.eggmoose, 1, 6, 15), new StuffList(Items.egggoose, 1, 6, 15), new StuffList(Items.egggosling, 1, 6, 15), new StuffList(Items.eggostrich, 1, 6, 15), new StuffList(Items.eggsparklemuffin, 1, 6, 15), new StuffList(Items.eggskeletorus, 1, 6, 15), new StuffList(Items.egganteater, 1, 6, 15), new StuffList(Items.eggvampire, 1, 6, 15), new StuffList(Items.eggthecount, 1, 6, 15), new StuffList(Items.eggwerewolf, 1, 6, 15), new StuffList(Blocks.stone, 1, 5, 10), new StuffList(Blocks.greystone, 1, 5, 10), new StuffList(Blocks.lightstick, 1, 16, 10), new StuffList(Blocks.darkstick, 1, 16, 10), new StuffList(Blocks.blocklight, 1, 1, 5), new StuffList(Blocks.blockdark, 1, 1, 5), new StuffList(Blocks.blocksilver, 1, 1, 5), new StuffList(Blocks.blockcopper, 1, 1, 15), new StuffList(Blocks.blocktin, 1, 1, 15), new StuffList(Blocks.blockplatinum, 1, 1, 5), new StuffList(Blocks.oresilver, 5, 10, 15), new StuffList(Blocks.oreplatinum, 5, 10, 10), new StuffList(Blocks.log, 5, 10, 25), new StuffList(Blocks.willowlog, 5, 10, 25), new StuffList(Blocks.redwoodlog, 5, 10, 25), new StuffList(Blocks.stopblock, 1, 5, 10)};

    public void decorate(World world, int dimension, int chunkx, int chunkz) {
        int posY;
        int posZ;
        int posX;
        int i;
        int what;
        int iy;
        int iz;
        int ix;
        int m;
        int howmany;
        if (!world.isServer) {
            return;
        }
        Trees tr = new Trees();
        Biome b = world.getBiome(dimension, chunkx << 4, 0, chunkz << 4);
        if (b.should_add_caves) {
            this.add_cave(world, dimension, chunkx, chunkz);
        }
        if (b.should_add_dungeons) {
            this.add_dungeon(world, dimension, chunkx, chunkz);
        }
        if (b.should_add_roaches && world.rand.nextInt(40) == 1) {
            howmany = 1 + world.rand.nextInt(3);
            m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                iy = 150;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy, iz, Blocks.roachnest.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_butterflies && world.rand.nextInt(50) == 1) {
            howmany = 1 + world.rand.nextInt(3);
            m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                iy = 150;
                while (iy > 70) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.butterfly_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_flowers && world.rand.nextInt(12) == 1) {
            howmany = 1 + world.rand.nextInt(5);
            m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                iy = 165;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_red.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_flowers && world.rand.nextInt(12) == 1) {
            howmany = 1 + world.rand.nextInt(6);
            m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                iy = 180;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_yellow.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if ((Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension") || Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) && world.rand.nextInt(64) == 1) {
            howmany = 1 + world.rand.nextInt(5);
            m = 0;
            while (m < howmany) {
                ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                iy = 100;
                while (iy > 50) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.MyCornPlant1.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Big Round Tree Dimension")) {
            if (world.rand.nextInt(7) == 1) {
                howmany = 2 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_pink.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(64) == 1) {
                howmany = 1 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.radish_plant.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Pathway Dimension")) {
            if (world.rand.nextInt(8) == 1) {
                howmany = 2 + world.rand.nextInt(6);
                m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(64) == 1) {
                howmany = 1 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(3) == 0) {
                howmany = 0;
                what = world.rand.nextInt(3);
                howmany = world.rand.nextInt(6);
                i = 0;
                while (i < howmany) {
                    posX = 4 + (chunkx << 4) + world.rand.nextInt(12);
                    posZ = 4 + (chunkz << 4) + world.rand.nextInt(12);
                    posY = 90;
                    while (posY > 50) {
                        if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                            if (what == 0) {
                                tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.MyCherryLeaves.blockID);
                                break;
                            }
                            if (what != 1) break;
                            tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.MyAppleLeaves.blockID);
                            break;
                        }
                        --posY;
                    }
                    ++i;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) {
            if (world.rand.nextInt(18) == 1) {
                howmany = 2 + world.rand.nextInt(6);
                m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(100) == 1) {
                howmany = 1 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(30) == 0) {
                howmany = 1;
                what = world.rand.nextInt(3);
                i = 0;
                while (i < howmany) {
                    posX = 4 + (chunkx << 4) + world.rand.nextInt(12);
                    posZ = 4 + (chunkz << 4) + world.rand.nextInt(12);
                    posY = 90;
                    while (posY > 50) {
                        if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                            if (what == 0) {
                                tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.MyPeachLeaves.blockID);
                                break;
                            }
                            if (what != 1) break;
                            tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.MyAppleLeaves.blockID);
                            break;
                        }
                        --posY;
                    }
                    ++i;
                }
            }
        }
    }

    public void add_cave(World world, int dimension, int chunkx, int chunkz) {
        if (!DangerZone.generatecaves) {
            return;
        }
        if (world.rand.nextInt(5 + (chunkx + chunkz & 0x3F) * 2) != 0) {
            return;
        }
        float starty = 10.0f + world.rand.nextFloat() * 60.0f;
        float startx = world.rand.nextFloat() * 16.0f;
        float startz = world.rand.nextFloat() * 16.0f;
        float dxz = world.rand.nextFloat() * 360.0f;
        float dy = (world.rand.nextFloat() - world.rand.nextFloat()) * 25.0f;
        float ddxz = world.rand.nextFloat() - world.rand.nextFloat();
        float ddy = world.rand.nextFloat() - world.rand.nextFloat();
        ddxz *= 2.0f;
        float width = 3.0f + world.rand.nextFloat() * 6.0f;
        float length = 150.0f + world.rand.nextFloat() * 300.0f;
        float curx = startx + (float)(chunkx << 4);
        float cury = starty;
        float curz = startz + (float)(chunkz << 4);
        int i = 0;
        while ((float)i < length) {
            float currentwidth;
            if (cury > 35.0f) {
                if (dy > 0.0f) {
                    dy = -dy;
                }
                if (ddy > 0.0f) {
                    ddy = -ddy;
                }
            }
            if (cury < 0.0f) {
                if (dy < 0.0f) {
                    dy = -dy;
                }
                if (ddy < 0.0f) {
                    ddy = -ddy;
                }
            }
            if ((currentwidth = (float)Math.sin((double)((float)i / length) * Math.PI) * width) > 1.0f) {
                int da = 10;
                if (currentwidth < 4.0f) {
                    da = 15;
                }
                if (currentwidth > 6.0f) {
                    da = 5;
                }
                float dirang = (float)Math.toRadians(dxz - 90.0f);
                float dirax = (float)Math.cos(dirang);
                float diraz = (float)Math.sin(dirang);
                int j = 0;
                while (j < 360) {
                    float currad = 0.0f;
                    float ty = (float)Math.sin(Math.toRadians(j));
                    float tt = (float)Math.cos(Math.toRadians(j));
                    float tx = dirax * tt;
                    float tz = diraz * tt;
                    while (currad < currentwidth) {
                        int bid;
                        if ((int)(cury + ty * (currad += 0.2f)) <= 0 || !Blocks.isSolid(bid = world.getblock(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad)))) continue;
                        world.setblocknonotify(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad), 0);
                    }
                    j += da;
                }
            }
            curx = (float)((double)curx + Math.cos(Math.toRadians(dxz)));
            curz = (float)((double)curz + Math.sin(Math.toRadians(dxz)));
            dxz += ddxz;
            cury = (float)((double)cury + Math.sin(Math.toRadians(dy)));
            dy += ddy;
            if (world.rand.nextInt(20) == 1) {
                dy = (world.rand.nextFloat() - world.rand.nextFloat()) * 25.0f;
                ddy = world.rand.nextFloat() - world.rand.nextFloat();
            }
            if (world.rand.nextInt(50) == 1) {
                dxz += world.rand.nextFloat() * 45.0f;
                ddxz = world.rand.nextFloat() - world.rand.nextFloat();
                ddxz *= 2.0f;
            }
            ++i;
        }
    }

    public void add_dungeon(World world, int dimension, int chunkx, int chunkz) {
        int bid;
        if (world.rand.nextInt(64) != 0) {
            return;
        }
        int x = chunkx << 4;
        int z = chunkz << 4;
        int xoff = world.rand.nextInt(16);
        int zoff = world.rand.nextInt(16);
        int yoff = world.rand.nextInt(40) + 5;
        int i = 0;
        while (i < 11) {
            int j = 0;
            while (j < 5) {
                int k = 0;
                while (k < 11) {
                    bid = 0;
                    if (i == 0 || i == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (j == 0 || j == 4) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (k == 0 || k == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    world.setblocknonotify(dimension, x + xoff + i, yoff + j, z + zoff + k, bid);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int type = world.rand.nextInt(3);
        bid = Blocks.ratspawner.blockID;
        if (type == 1) {
            bid = Blocks.werewolfspawner.blockID;
        }
        if (type == 2) {
            bid = Blocks.vampirespawner.blockID;
        }
        world.setblock(dimension, x + xoff + 5, yoff + 1, z + zoff + 5, bid);
        world.setblock(dimension, x + xoff + 5, yoff + 1, z + zoff + 1, Blocks.chest.blockID);
        Entity eb = world.createEntityByName("DangerZone:EntityChest", dimension, (float)(x + xoff + 5) + 0.5f, (float)(yoff + 1) + 0.05f, (float)(z + zoff + 1) + 0.5f);
        if (eb != null) {
            if (!world.isServer) {
                eb.init();
            }
            EntityChest ec = (EntityChest)eb;
            int nthings = world.rand.nextInt(25) + 20;
            i = 0;
            while (i < nthings) {
                int where = world.rand.nextInt(ec.inventory.length);
                int val = world.rand.nextInt(100);
                int which = world.rand.nextInt(things.length);
                if (val <= WorldDecorator.things[which].chance) {
                    int howmany = WorldDecorator.things[which].min;
                    if (WorldDecorator.things[which].max - WorldDecorator.things[which].min > 0) {
                        howmany += world.rand.nextInt(WorldDecorator.things[which].max - WorldDecorator.things[which].min + 1);
                    }
                    ec.entity_inventory[where] = new InventoryContainer(things[which].getbid(), things[which].getiid(), howmany, 0);
                }
                ++i;
            }
            if (world.isServer) {
                ec.init();
            }
            world.spawnEntityInWorld(eb);
        }
    }
}

