/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class VBOBuffer {
    public volatile FloatBuffer vbodata = null;
    public volatile int vcount = 0;
    public volatile int drawvcount = 0;
    public volatile int vmax = 0;
    public volatile int drawvmax = 0;
    private int stride = 0;
    private int textureoff = this.stride = 12;
    private int coloroff = 0;
    private int nelement = 0;
    private volatile int glvboID = 0;
    public int textureindex = 0;
    public volatile long VBOid = 0L;
    public boolean isTranslucent = false;
    public int xoff;
    public int zoff;
    public long lastusedframe;
    public volatile int vbostate = 0;

    public VBOBuffer() {
        this.stride += 8;
        this.coloroff = this.stride;
        this.stride += 12;
        this.nelement = 8;
        this.vmax = 0;
        this.drawvmax = 0;
        this.vbostate = 0;
        this.glvboID = 0;
        this.vbodata = null;
        this.isTranslucent = false;
        this.zoff = 0;
        this.xoff = 0;
        this.lastusedframe = 0L;
    }

    public void addVertexInfoToVBO(float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        if (this.vbostate == 0) {
            ++this.vcount;
            return;
        }
        if (this.vbostate != 1) {
            return;
        }
        if (this.vcount >= this.vmax) {
            this.vmax += 512;
            DangerZone.wr.VBOmemorysize += 512 * this.stride;
            FloatBuffer tmpvbodata = BufferUtils.createFloatBuffer((int)(this.vmax * this.nelement));
            this.vbodata.position(0);
            this.vbodata.limit(this.vbodata.capacity());
            tmpvbodata.position(0);
            tmpvbodata.limit(tmpvbodata.capacity());
            tmpvbodata.put(this.vbodata);
            this.vbodata = tmpvbodata;
            this.vbodata.limit(this.vbodata.capacity());
            this.vbodata.position(this.vcount * this.nelement);
        }
        this.vbodata.put(vx);
        this.vbodata.put(vy);
        this.vbodata.put(vz);
        this.vbodata.put(tx);
        this.vbodata.put(ty);
        this.vbodata.put(br);
        this.vbodata.put(bg);
        this.vbodata.put(bb);
        ++this.vcount;
    }

    public void draw() {
        if (this.vbostate == 0) {
            return;
        }
        if (this.vbostate == 2) {
            if (this.vcount == 0) {
                this.drawvcount = 0;
                this.vbostate = 1;
                return;
            }
            if (this.glvboID == 0) {
                this.glvboID = GL15.glGenBuffers();
            }
            if (this.drawvmax >= this.vcount) {
                this.drawvcount = this.vcount;
                this.drawvmax = this.vmax;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnableClientState((int)32884);
                GL11.glEnableClientState((int)32888);
                GL11.glEnableClientState((int)32886);
                GL15.glBindBuffer((int)34962, (int)this.glvboID);
                GL11.glVertexPointer((int)3, (int)5126, (int)this.stride, (long)0L);
                GL11.glColorPointer((int)3, (int)5126, (int)this.stride, (long)this.coloroff);
                GL11.glTexCoordPointer((int)2, (int)5126, (int)this.stride, (long)this.textureoff);
                this.vbodata.position(0);
                this.vbodata.limit(this.vbodata.capacity());
                GL15.glBufferSubData((int)34962, (long)0L, (FloatBuffer)this.vbodata);
                GL11.glDrawArrays((int)7, (int)0, (int)this.drawvcount);
                GL15.glBindBuffer((int)34962, (int)0);
                GL11.glDisableClientState((int)32886);
                GL11.glDisableClientState((int)32888);
                GL11.glDisableClientState((int)32884);
                GL11.glDisable((int)3042);
                this.vbodata.limit(this.vbodata.capacity());
                this.vbostate = 1;
                return;
            }
            this.drawvcount = this.vcount;
            this.drawvmax = this.vmax;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32888);
            GL11.glEnableClientState((int)32886);
            GL15.glBindBuffer((int)34962, (int)this.glvboID);
            GL11.glVertexPointer((int)3, (int)5126, (int)this.stride, (long)0L);
            GL11.glColorPointer((int)3, (int)5126, (int)this.stride, (long)this.coloroff);
            GL11.glTexCoordPointer((int)2, (int)5126, (int)this.stride, (long)this.textureoff);
            this.vbodata.position(0);
            this.vbodata.limit(this.vbodata.capacity());
            GL15.glBufferData((int)34962, (FloatBuffer)this.vbodata, (int)35044);
            GL11.glDrawArrays((int)7, (int)0, (int)this.drawvcount);
            GL15.glBindBuffer((int)34962, (int)0);
            GL11.glDisableClientState((int)32886);
            GL11.glDisableClientState((int)32888);
            GL11.glDisableClientState((int)32884);
            GL11.glDisable((int)3042);
            this.vbostate = 1;
            return;
        }
        if (this.vbostate != 1) {
            return;
        }
        if (this.drawvcount == 0) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32886);
        GL15.glBindBuffer((int)34962, (int)this.glvboID);
        GL11.glVertexPointer((int)3, (int)5126, (int)this.stride, (long)0L);
        GL11.glColorPointer((int)3, (int)5126, (int)this.stride, (long)this.coloroff);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)this.stride, (long)this.textureoff);
        GL11.glDrawArrays((int)7, (int)0, (int)this.drawvcount);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32884);
        GL11.glDisable((int)3042);
    }

    public boolean finishDraw() {
        if (this.vbostate == 0) {
            this.vmax = this.vcount / 128;
            ++this.vmax;
            this.vmax *= 128;
            this.vbodata = BufferUtils.createFloatBuffer((int)(this.vmax * this.nelement));
            this.vbodata.rewind();
            this.vbodata.limit(this.vbodata.capacity());
            this.vbodata.position(0);
            DangerZone.wr.VBOmemorysize += this.vmax * this.stride;
            this.vcount = 0;
            this.drawvcount = 0;
            this.drawvmax = 0;
            this.vbostate = 1;
            return true;
        }
        if (this.vbostate == 1) {
            if (this.vmax > this.vcount + 128) {
                int downsize = this.vmax - (this.vcount + 128);
                DangerZone.wr.VBOmemorysize -= (downsize *= this.stride);
                this.vmax = this.vcount + 128;
                FloatBuffer tmpvbodata = BufferUtils.createFloatBuffer((int)(this.vmax * this.nelement));
                this.vbodata.position(0);
                this.vbodata.limit(this.vcount * this.nelement);
                tmpvbodata.position(0);
                tmpvbodata.limit(tmpvbodata.capacity());
                tmpvbodata.put(this.vbodata);
                this.vbodata = tmpvbodata;
                this.vbodata.limit(this.vbodata.capacity());
                this.vbodata.position(this.vcount * this.nelement);
                this.drawvmax = 0;
            }
            this.vbostate = 2;
        }
        return false;
    }

    public boolean reset() {
        if (this.vbostate != 1) {
            return false;
        }
        this.vbodata.position(0);
        this.vbodata.limit(this.vbodata.capacity());
        this.vcount = 0;
        return true;
    }

    public void free() {
        GL15.glBindBuffer((int)34962, (int)0);
        if (this.glvboID != 0) {
            GL15.glDeleteBuffers((int)this.glvboID);
        }
        this.glvboID = 0;
        if (this.vbodata != null) {
            DangerZone.wr.VBOmemorysize -= this.vbodata.capacity() * 4;
        }
        this.drawvcount = 0;
        this.vbostate = 3;
    }
}

