/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.StitchedTexture;
import dangerzone.Utils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;

public class StitchedTextureFile {
    public int textureID = -1;
    public int nextx = 0;
    public int nexty = 0;
    public Texture blankfile = null;
    public ByteBuffer texturedata = BufferUtils.createByteBuffer((int)this.total_size);
    public int total_size = 0x100000;
    public int total_sizemip1 = 262144;
    public ByteBuffer texturedatamip1 = BufferUtils.createByteBuffer((int)this.total_sizemip1);
    public int total_sizemip2 = 65536;
    public ByteBuffer texturedatamip2 = BufferUtils.createByteBuffer((int)this.total_sizemip2);
    public int total_sizemip3 = 16384;
    public ByteBuffer texturedatamip3 = BufferUtils.createByteBuffer((int)this.total_sizemip3);
    public int total_sizemip4 = 4096;
    public ByteBuffer texturedatamip4 = BufferUtils.createByteBuffer((int)this.total_sizemip4);

    public StitchedTexture doAddTexture(String texturename) {
        int i;
        int j;
        int k;
        Texture temp = null;
        if (this.nexty > 31) {
            return null;
        }
        if (texturename == null) {
            return null;
        }
        if (texturename.equals("")) {
            return null;
        }
        temp = Utils.initTexture(texturename);
        if (temp == null) {
            System.out.printf("Stitching texture not found: %s\n", texturename);
            return null;
        }
        byte[] b = temp.getTextureData();
        if (b.length < 768) {
            return null;
        }
        this.texturedata.position(0);
        if (b.length > 768) {
            k = 0;
            j = 0;
            while (j < 16) {
                i = 0;
                while (i < 64) {
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i, b[k]);
                    ++k;
                    ++i;
                }
                ++j;
            }
        } else {
            k = 0;
            j = 0;
            while (j < 16) {
                i = 0;
                while (i < 16) {
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4, b[k]);
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 1, b[++k]);
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 2, b[++k]);
                    ++k;
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 3, (byte)-1);
                    ++i;
                }
                ++j;
            }
        }
        temp.release();
        this.texturedata.position(0);
        this.texturedatamip1.position(0);
        i = 0;
        while (i < 256) {
            j = 0;
            while (j < 256) {
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8));
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8 + 1));
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8 + 2));
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedatamip1.position(0);
        this.texturedatamip2.position(0);
        i = 0;
        while (i < 128) {
            j = 0;
            while (j < 128) {
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8));
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8 + 1));
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8 + 2));
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedatamip2.position(0);
        this.texturedatamip3.position(0);
        i = 0;
        while (i < 64) {
            j = 0;
            while (j < 64) {
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8));
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8 + 1));
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8 + 2));
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedatamip3.position(0);
        this.texturedatamip4.position(0);
        i = 0;
        while (i < 32) {
            j = 0;
            while (j < 32) {
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8));
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8 + 1));
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8 + 2));
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedata.position(0);
        this.texturedata.limit(this.total_size);
        this.texturedatamip1.position(0);
        this.texturedatamip1.limit(this.total_sizemip1);
        this.texturedatamip2.position(0);
        this.texturedatamip2.limit(this.total_sizemip2);
        this.texturedatamip3.position(0);
        this.texturedatamip3.limit(this.total_sizemip3);
        this.texturedatamip4.position(0);
        this.texturedatamip4.limit(this.total_sizemip4);
        if (this.textureID >= 0) {
            IntBuffer texBuf = BufferUtils.createIntBuffer((int)1);
            texBuf.put(this.textureID);
            texBuf.flip();
            GL11.glDeleteTextures((IntBuffer)texBuf);
        }
        this.textureID = this.createTextureID();
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)StitchedTextureFile.getPow2(512), (int)StitchedTextureFile.getPow2(512), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedata);
        GL11.glTexImage2D((int)3553, (int)1, (int)6408, (int)StitchedTextureFile.getPow2(256), (int)StitchedTextureFile.getPow2(256), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip1);
        GL11.glTexImage2D((int)3553, (int)2, (int)6408, (int)StitchedTextureFile.getPow2(128), (int)StitchedTextureFile.getPow2(128), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip2);
        GL11.glTexImage2D((int)3553, (int)3, (int)6408, (int)StitchedTextureFile.getPow2(64), (int)StitchedTextureFile.getPow2(64), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip3);
        GL11.glTexImage2D((int)3553, (int)4, (int)6408, (int)StitchedTextureFile.getPow2(32), (int)StitchedTextureFile.getPow2(32), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip4);
        GL11.glTexParameteri((int)3553, (int)33085, (int)4);
        StitchedTexture st = new StitchedTexture();
        st.yoffsetmin = (float)this.nexty / 32.0f;
        st.yoffsetmax = ((float)this.nexty + 1.0f) / 32.0f;
        st.xoffsetmin = (float)this.nextx / 32.0f;
        st.xoffsetmax = ((float)this.nextx + 1.0f) / 32.0f;
        ++this.nextx;
        if (this.nextx >= 32) {
            ++this.nexty;
            this.nextx = 0;
        }
        return st;
    }

    public void bind() {
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public int createTextureID() {
        IntBuffer tmp = BufferUtils.createIntBuffer((int)1);
        GL11.glGenTextures((IntBuffer)tmp);
        return tmp.get(0);
    }

    public static int getPow2(int i) {
        int ret = 2;
        while (ret < i) {
            ret *= 2;
        }
        return ret;
    }
}

