/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.util.ResourceLoader;

public class SoundManager {
    Map<String, Soundinfo> soundmap = new HashMap<String, Soundinfo>();
    public int master_volume = 10;

    public void registerSound(String soundname, String filepath) {
        this.soundmap.put(soundname, new Soundinfo(filepath));
    }

    public void playSound(String soundname, float vol, float freq, int d, float px, float py, float pz) {
        Soundinfo s = this.soundmap.get(soundname);
        if (s != null && !s.equals("")) {
            if (s.sound == null) {
                try {
                    s.sound = AudioLoader.getAudio((String)"WAV", (InputStream)ResourceLoader.getResourceAsStream((String)s.filepath));
                }
                catch (Exception e) {
                    System.out.printf("Failed to load sound file: %s\n", s.filepath);
                    e.printStackTrace();
                    s.sound = null;
                    this.soundmap.remove(soundname);
                }
            }
            if (s.sound != null && this.master_volume > 0 && DangerZone.start_client && d == DangerZone.player.dimension) {
                float mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz);
                float mv = this.master_volume;
                mv /= 10.0f;
                if ((mx -= 2.0f) < 1.0f) {
                    mx = 1.0f;
                }
                mx /= 8.0f;
                if ((mx *= mx) < 1.0f) {
                    mx = 1.0f;
                }
                if (mx < 1024.0f) {
                    mx = vol / mx;
                    mx *= mv;
                    try {
                        s.sound.playAsSoundEffect(freq, mx, false);
                    }
                    catch (Exception e) {
                        System.out.printf("Sound broke again...\n", new Object[0]);
                    }
                }
            }
        }
    }

    public void playSoundClose(String soundname, float vol, float freq, int d, float px, float py, float pz) {
        Soundinfo s = this.soundmap.get(soundname);
        if (s != null && !s.equals("")) {
            if (s.sound == null) {
                try {
                    s.sound = AudioLoader.getAudio((String)"WAV", (InputStream)ResourceLoader.getResourceAsStream((String)s.filepath));
                }
                catch (Exception e) {
                    System.out.printf("Failed to load sound file: %s\n", s.filepath);
                    e.printStackTrace();
                    s.sound = null;
                    this.soundmap.remove(soundname);
                }
            }
            if (s.sound != null && this.master_volume > 0 && DangerZone.start_client && d == DangerZone.player.dimension) {
                float mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz);
                float mv = this.master_volume;
                mv /= 10.0f;
                if ((mx -= 2.0f) < 1.0f) {
                    mx = 1.0f;
                }
                if ((mx *= mx) < 1.0f) {
                    mx = 1.0f;
                }
                if (mx < 256.0f) {
                    mx = vol / mx;
                    mx *= mv;
                    try {
                        s.sound.playAsSoundEffect(freq, mx, false);
                    }
                    catch (Exception e) {
                        System.out.printf("Sound broke again...\n", new Object[0]);
                    }
                }
            }
        }
    }

    private class Soundinfo {
        public String filepath;
        public Audio sound;

        Soundinfo(String f) {
            this.filepath = f;
            this.sound = null;
        }
    }
}

