/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.CustomPacket;
import dangerzone.CustomPackets;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.ListInt;
import dangerzone.Player;
import dangerzone.entities.EntityFurnace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FurnaceInventoryPacket
extends CustomPacket {
    public FurnaceInventoryPacket() {
        this.uniquename = "DangerZone:FurnaceInventoryPacket";
        this.packetID = CustomPackets.getIDByName(this.uniquename);
    }

    public void inventoryUpdateToServer(int eid, int index, InventoryContainer ic) {
        ObjectOutputStream os = DangerZone.server_connection.getOutputStream();
        int subtype = 0;
        try {
            os.writeInt(this.packetID);
            os.writeInt(eid);
            os.writeInt(subtype);
            os.writeInt(index);
            if (ic != null) {
                os.writeInt(ic.count);
                os.writeInt(ic.bid);
                os.writeInt(ic.iid);
                os.writeInt(ic.currentuses);
            } else {
                int i = 0;
                os.writeInt(i);
                os.writeInt(i);
                os.writeInt(i);
                os.writeInt(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DangerZone.server_connection.releaseOutputStream();
    }

    public void requestContents(int eid) {
        ObjectOutputStream os = DangerZone.server_connection.getOutputStream();
        int subtype = 1;
        try {
            os.writeInt(this.packetID);
            os.writeInt(eid);
            os.writeInt(subtype);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DangerZone.server_connection.releaseOutputStream();
    }

    @Override
    public void messageFromServer(ObjectInputStream is) {
        int subtype = 0;
        int count = 0;
        int eid = 0;
        int bid = 0;
        int iid = 0;
        int currentuses = 0;
        int index = 0;
        try {
            eid = is.readInt();
            subtype = is.readInt();
            if (subtype == 0) {
                index = is.readInt();
                count = is.readInt();
                bid = is.readInt();
                iid = is.readInt();
                currentuses = is.readInt();
                EntityFurnace ce = (EntityFurnace)DangerZone.entityManager.findEntityByID(eid);
                if (ce != null && index >= 0 && index < ce.inventory.length) {
                    if (count == 0) {
                        ce.inventory[index] = null;
                    } else {
                        InventoryContainer ic = new InventoryContainer();
                        ic.count = count;
                        ic.bid = bid;
                        ic.iid = iid;
                        ic.currentuses = currentuses;
                        ce.inventory[index] = ic;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void inventoryUpdateToClient(Player p, int eid, int index, InventoryContainer ic) {
        ObjectOutputStream os = p.server_thread.getOutputStream();
        int subtype = 0;
        try {
            os.writeInt(this.packetID);
            os.writeInt(eid);
            os.writeInt(subtype);
            os.writeInt(index);
            if (ic != null) {
                os.writeInt(ic.count);
                os.writeInt(ic.bid);
                os.writeInt(ic.iid);
                os.writeInt(ic.currentuses);
            } else {
                int i = 0;
                os.writeInt(i);
                os.writeInt(i);
                os.writeInt(i);
                os.writeInt(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        p.server_thread.releaseOutputStream();
    }

    public void inventoryUpdateToAllClients(int eid, int d, int index, InventoryContainer ic) {
        DangerZone.server.player_list_lock.lock();
        for (ListInt st : DangerZone.server.server_thread_list) {
            if (DangerZone.server.players[st.index] == null || DangerZone.server.players[st.index].p.dimension != d) continue;
            this.inventoryUpdateToClient(DangerZone.server.players[st.index].p, eid, index, ic);
        }
        DangerZone.server.player_list_lock.unlock();
    }

    @Override
    public void messageFromClient(Player plyr, ObjectInputStream is) {
        int subtype = 0;
        int count = 0;
        int eid = 0;
        int bid = 0;
        int iid = 0;
        int currentuses = 0;
        int index = 0;
        try {
            EntityFurnace ce;
            eid = is.readInt();
            subtype = is.readInt();
            if (subtype == 0) {
                index = is.readInt();
                count = is.readInt();
                bid = is.readInt();
                iid = is.readInt();
                currentuses = is.readInt();
                EntityFurnace ce2 = (EntityFurnace)DangerZone.server.entityManager.findEntityByID(eid);
                if (ce2 != null && index >= 0 && index < ce2.inventory.length) {
                    if (count == 0) {
                        ce2.inventory[index] = null;
                    } else {
                        InventoryContainer ic = new InventoryContainer();
                        ic.count = count;
                        ic.bid = bid;
                        ic.iid = iid;
                        ic.currentuses = currentuses;
                        ce2.inventory[index] = ic;
                    }
                    DangerZone.server.player_list_lock.lock();
                    for (ListInt st : DangerZone.server.server_thread_list) {
                        if (DangerZone.server.players[st.index] == null || DangerZone.server.players[st.index].p == plyr || DangerZone.server.players[st.index].p.dimension != plyr.dimension) continue;
                        this.inventoryUpdateToClient(DangerZone.server.players[st.index].p, eid, index, ce2.inventory[index]);
                    }
                    DangerZone.server.player_list_lock.unlock();
                }
            } else if (subtype == 1 && (ce = (EntityFurnace)DangerZone.server.entityManager.findEntityByID(eid)) != null) {
                int i = 0;
                while (i < ce.inventory.length) {
                    this.inventoryUpdateToClient(plyr, eid, i, ce.inventory[i]);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

