/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.BaseMod;
import dangerzone.Chunk;
import dangerzone.ChunkCache;
import dangerzone.CommandHandlers;
import dangerzone.Cooking;
import dangerzone.Crafting;
import dangerzone.CustomPackets;
import dangerzone.DZCommandHandler;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.ModListEntry;
import dangerzone.ModLoader;
import dangerzone.Ores;
import dangerzone.Player;
import dangerzone.ServerChunkCache;
import dangerzone.SoundManager;
import dangerzone.Spawnlist;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldDecorators;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entities;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityExp;
import dangerzone.entities.ModelEntityBlockItem;
import dangerzone.entities.ModelExp;
import dangerzone.entities.ModelHumanoid;
import dangerzone.gui.GuiInterface;
import dangerzone.gui.OverlayGUI;
import dangerzone.gui.PlayerChatGUI;
import dangerzone.gui.PlayerCommandGUI;
import dangerzone.gui.PlayerEscapeGUI;
import dangerzone.gui.PlayerHelpGUI;
import dangerzone.gui.PlayerInventoryGUI;
import dangerzone.items.Items;
import dangerzone.particles.Particles;
import dangerzone.threads.ChunkWriterThread;
import dangerzone.threads.CleanerThread;
import dangerzone.threads.EntityUpdateLoop;
import dangerzone.threads.LightingThread;
import dangerzone.threads.ParticleUpdateLoop;
import dangerzone.threads.Server;
import dangerzone.threads.ServerConnection;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class DangerZone {
    public static String versionstring = "0.8";
    public static int gameover = 0;
    static String windowTitle = "Welcome to the Danger Zone...";
    static float deltaT = 0.0f;
    public static String server_address = null;
    public static int server_port = 0;
    public static ChunkCache client_chunk_cache = null;
    public static ServerChunkCache server_chunk_cache = null;
    public static ChunkWriterThread chunkwriter = null;
    public static int screen_width = 1000;
    public static int screen_height = 600;
    public static Player player = null;
    public static World world = null;
    public static World server_world = null;
    public static String worldname = null;
    public static String origworldname = null;
    public static WorldRenderer wr = null;
    public static ServerConnection server_connection = null;
    public static Server server = null;
    public static WorldDecorators wds = null;
    public static Blocks all_the_blocks;
    public static Items all_the_items;
    public static Dimensions all_the_dimensions;
    public static Crafting all_the_recipies;
    public static Cooking all_the_cooking;
    public static Entities all_the_entities;
    public static Particles all_the_particles;
    public static Ores all_the_ores;
    public static Spawnlist all_the_spawns;
    public static CustomPackets all_the_custompackets;
    public static CommandHandlers all_the_handlers;
    private static Texture logotexture;
    public static int messagetimer;
    public static String messagestring;
    public static int hotmessagetimer;
    public static String hotmessagestring;
    public static String ghost_string;
    public static String creative_string;
    public static String survival_string;
    public static int renderdistance;
    public static int savedrenderdistance;
    public static EntityUpdateLoop entityManager;
    public static ParticleUpdateLoop particleManager;
    public static int entityupdatedist;
    public static int max_entities;
    public static BaseMod base;
    public static int entityupdaterate;
    public static int serverentityupdaterate;
    public static boolean f3_on;
    public static boolean f5_front;
    public static boolean f5_back;
    public static boolean view_ores;
    public static String blockitemname;
    public static boolean escape_options_menu;
    public static boolean mouse_grabbed;
    public static volatile GuiInterface current_gui;
    public static PlayerEscapeGUI escapegui;
    public static PlayerHelpGUI helpgui;
    public static PlayerChatGUI chatgui;
    public static PlayerCommandGUI commandgui;
    public static DZCommandHandler commandhandler;
    public static PlayerInventoryGUI inventorygui;
    public static EntityBlockItem blockitem;
    public static int packets_per_second;
    public static int chunks_per_second;
    public static int gofasttimer;
    public static int gofast;
    public static volatile int do_hit_cycle;
    public static volatile int do_food_cycle;
    private static int volume_temp;
    public static SoundManager soundmangler;
    public static boolean start_server;
    public static boolean start_client;
    private static long nowtime;
    private static long thentime;
    private static int pps;
    public static Font awtfont;
    public static TrueTypeFont font;
    public static LightingThread lto;
    public static CleanerThread tidyup;
    public static String playername;
    public static Random rand;
    public static TextureMapper texmap;
    public static int fieldOfView;
    public static int fieldOfViewLast;
    public static int mouseSensitivity;
    public static float accel;
    public static volatile boolean doleftclick;
    public static volatile boolean dorightclick;
    public static boolean keepitsqueakyclean;
    public static boolean generatecaves;
    public static int mindrawlevel;
    public static ModLoader modloader;
    public static String alt_texture_path;
    public static List<ModListEntry> all_the_mods;
    public static boolean all_sides;
    public static boolean light_speed;
    public static volatile int new_dimension;
    public static volatile float new_posx;
    public static volatile float new_posy;
    public static volatile float new_posz;
    private static Chunk currchunk;
    private static boolean leftbuttondown;
    private static boolean rightbuttondown;
    private static int repeatdelay;
    private static int chunkwaitdelay;
    private static boolean nogui;
    public static volatile boolean dimension_change_in_progress;
    public static OverlayGUI overlayguis;
    public static boolean playnicely;
    public static boolean show_clouds;
    public static boolean show_rain;
    public static float testx;
    public static float testy;
    public static float testz;
    public static float testp;
    public static float testw;
    public static float testr;

    static {
        logotexture = null;
        messagetimer = 0;
        messagestring = null;
        hotmessagetimer = 0;
        hotmessagestring = null;
        ghost_string = "Game Mode Ghost";
        creative_string = "Game Mode Creative";
        survival_string = "Game Mode Survival";
        renderdistance = 24;
        savedrenderdistance = 0;
        entityupdatedist = 384;
        max_entities = 10000;
        entityupdaterate = 16;
        serverentityupdaterate = 100;
        f3_on = false;
        f5_front = false;
        f5_back = false;
        view_ores = false;
        blockitemname = "DangerZone:BlockItem";
        escape_options_menu = false;
        mouse_grabbed = false;
        current_gui = null;
        escapegui = null;
        helpgui = null;
        chatgui = null;
        commandgui = null;
        commandhandler = null;
        inventorygui = null;
        blockitem = null;
        packets_per_second = 0;
        chunks_per_second = 0;
        gofasttimer = 0;
        gofast = 0;
        do_hit_cycle = 0;
        do_food_cycle = 0;
        volume_temp = 0;
        soundmangler = null;
        start_server = true;
        start_client = true;
        nowtime = 0L;
        thentime = 0L;
        pps = 0;
        awtfont = null;
        font = null;
        lto = null;
        tidyup = null;
        playername = "Player";
        rand = null;
        texmap = new TextureMapper();
        accel = 0.0f;
        doleftclick = false;
        dorightclick = false;
        keepitsqueakyclean = true;
        generatecaves = true;
        mindrawlevel = 0;
        modloader = null;
        alt_texture_path = "";
        all_the_mods = new ArrayList<ModListEntry>();
        all_sides = true;
        light_speed = true;
        new_dimension = 0;
        new_posx = 0.0f;
        new_posy = 0.0f;
        new_posz = 0.0f;
        currchunk = null;
        leftbuttondown = false;
        rightbuttondown = false;
        repeatdelay = 0;
        chunkwaitdelay = 0;
        nogui = false;
        dimension_change_in_progress = false;
        overlayguis = new OverlayGUI();
        playnicely = false;
        show_clouds = true;
        show_rain = true;
    }

    public static void initGL() {
        screen_width = Display.getWidth();
        screen_height = Display.getHeight();
        GL11.glViewport((int)0, (int)0, (int)screen_width, (int)screen_height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(fieldOfView, (float)screen_width / (float)screen_height, 1.0f, 256.0f * (float)renderdistance);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glHint((int)3152, (int)4353);
        GL11.glEnable((int)3553);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
    }

    public static void main(String[] args) throws InterruptedException {
        long lasttime = System.currentTimeMillis();
        String curdir = System.getProperty("user.dir");
        File libfile = new File(String.valueOf(curdir) + "/DangerZone_lib/native");
        if (libfile.exists()) {
            System.setProperty("org.lwjgl.librarypath", String.valueOf(curdir) + "/DangerZone_lib/native");
        }
        CodeSource codeSource = DangerZone.class.getProtectionDomain().getCodeSource();
        try {
            File myfile = new File(codeSource.getLocation().toURI().getPath());
            ModLoader.addFile(myfile);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (args.length > 1) {
            int arglen = args.length;
            int i = 0;
            while (i < arglen) {
                if (args[i].contains("client")) {
                    start_server = false;
                }
                if (args[i].contains("server")) {
                    start_client = false;
                }
                if (args[i].contains("nogui")) {
                    nogui = true;
                    start_client = false;
                }
                ++i;
            }
            if (!start_client && !start_server) {
                System.out.printf("Bad args?\n", new Object[0]);
                System.exit(1);
            }
        } else {
            start_client = true;
            start_server = true;
        }
        rand = new Random(lasttime);
        DangerZone.readConfig();
        if (start_server && !start_client) {
            screen_width = 800;
            screen_height = 400;
        }
        if (!nogui) {
            try {
                Display.setDisplayMode((DisplayMode)new DisplayMode(screen_width, screen_height));
                Display.setResizable((boolean)true);
                Display.setVSyncEnabled((boolean)false);
                Display.setTitle((String)windowTitle);
                Display.create();
                Keyboard.create();
                Mouse.create();
                SoundStore.get().init();
                DangerZone.initGL();
            }
            catch (LWJGLException e1) {
                System.out.printf("Something went horribly wrong with initialization!\n", new Object[0]);
                e1.printStackTrace();
                System.exit(1);
            }
            DangerZone.showLogo(false);
            Display.update();
            if (font == null) {
                awtfont = new Font("Times New Roman", 0, 24);
                font = new TrueTypeFont(awtfont, false);
            }
        }
        if (start_server) {
            if (start_client) {
                DangerZone.doStartSinglePlayer();
            } else {
                DangerZone.doStartServer();
            }
        } else if (start_client) {
            DangerZone.doStartClient();
        } else {
            System.out.printf("Hunh?\n", new Object[0]);
            System.exit(1);
        }
        lasttime = System.currentTimeMillis();
        while (gameover == 0) {
            if (start_client) {
                long currtime = System.currentTimeMillis();
                long tlong = currtime - lasttime;
                if ((tlong = 16L - tlong) < 2L) {
                    tlong = 2L;
                }
                if (tlong > 16L) {
                    tlong = 16L;
                }
                Thread.sleep(tlong);
                currtime = System.currentTimeMillis();
                tlong = currtime - lasttime;
                lasttime = currtime;
                deltaT = tlong;
                if (deltaT < 8.0f) {
                    deltaT = 8.0f;
                }
                if (deltaT > 256.0f) {
                    deltaT = 256.0f;
                }
                deltaT /= 16.0f;
                if (new_dimension != 0) {
                    DangerZone.player.posx = new_posx;
                    DangerZone.player.posy = new_posy;
                    DangerZone.player.posz = new_posz;
                    DangerZone.player.dimension = new_dimension;
                    new_dimension = 0;
                }
                chunkwaitdelay = 0;
                currchunk = DangerZone.world.chunkcache.getDecoratedChunk(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
                while (chunkwaitdelay < 50 && currchunk == null && DangerZone.player.posy > 0.0f && DangerZone.player.posy < 255.0f) {
                    ++chunkwaitdelay;
                    Thread.sleep(100L);
                    currchunk = DangerZone.world.chunkcache.getDecoratedChunk(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
                }
                currchunk = null;
                player.update(deltaT);
                if (gofasttimer > 0) {
                    --gofasttimer;
                }
                wr.renderWorld(world);
                if (current_gui != null) {
                    if (mouse_grabbed) {
                        Mouse.setGrabbed((boolean)false);
                        mouse_grabbed = false;
                    }
                    GL11.glDisable((int)2929);
                    GL11.glMatrixMode((int)5889);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-320.0, (double)320.0);
                    GL11.glMatrixMode((int)5888);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    GL11.glEnable((int)3553);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    current_gui.process();
                    GL11.glDisable((int)3042);
                    GL11.glMatrixMode((int)5889);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5888);
                    GL11.glPopMatrix();
                    GL11.glEnable((int)2929);
                } else {
                    if (OverlayGUI.guiarray[1] != null) {
                        GL11.glDisable((int)2929);
                        GL11.glMatrixMode((int)5889);
                        GL11.glPushMatrix();
                        GL11.glLoadIdentity();
                        GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-320.0, (double)320.0);
                        GL11.glMatrixMode((int)5888);
                        GL11.glPushMatrix();
                        GL11.glLoadIdentity();
                        GL11.glEnable((int)3553);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                        int ig = 1;
                        while (ig < 16) {
                            if (OverlayGUI.guiarray[ig] != null) {
                                OverlayGUI.guiarray[ig].process();
                            }
                            ++ig;
                        }
                        GL11.glDisable((int)3042);
                        GL11.glMatrixMode((int)5889);
                        GL11.glPopMatrix();
                        GL11.glMatrixMode((int)5888);
                        GL11.glPopMatrix();
                        GL11.glEnable((int)2929);
                    }
                    if (!mouse_grabbed) {
                        Mouse.setGrabbed((boolean)true);
                        mouse_grabbed = true;
                    }
                    DangerZone.doNormalInput();
                }
                Display.update();
                if (Display.isCloseRequested()) {
                    gameover = 1;
                }
                if (Display.wasResized() || fieldOfView != fieldOfViewLast) {
                    DangerZone.initGL();
                    fieldOfViewLast = fieldOfView;
                }
                SoundStore.get().poll(0);
                continue;
            }
            Thread.sleep(100L);
            nowtime = System.currentTimeMillis();
            if (nowtime - thentime > 1000L) {
                thentime = nowtime;
                pps = packets_per_second;
                packets_per_second = 0;
            }
            if (nogui) continue;
            DangerZone.showLogo(false);
            GL11.glDisable((int)2929);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-320.0, (double)320.0);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glEnable((int)3553);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)10.0f, (float)(screen_height - 10), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            font.drawString(0.0f, 0.0f, String.format("Players: %d", DangerZone.server.server_thread_list.size()), Color.gray);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)10.0f, (float)(screen_height - 60), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            font.drawString(0.0f, 0.0f, String.format("Packets per Second: %d", pps), Color.gray);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)10.0f, (float)(screen_height - 110), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            font.drawString(0.0f, 0.0f, String.format("Entities: %d", DangerZone.server.entityManager.entity_list.size()), Color.gray);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
            Display.update();
            if (Display.isCloseRequested()) {
                gameover = 1;
            }
            if (Display.wasResized()) {
                DangerZone.initGL();
            }
            while (Keyboard.next()) {
                if (Keyboard.getEventKey() != 1 || !Keyboard.isKeyDown((int)1) || !Keyboard.getEventKeyState()) continue;
                gameover = 1;
            }
        }
        if (start_client) {
            if (DangerZone.player.deadflag) {
                String oops = "Oops. You died...";
                player.setHealth(-1.1f);
                GL11.glDisable((int)2929);
                GL11.glMatrixMode((int)5889);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-320.0, (double)320.0);
                GL11.glMatrixMode((int)5888);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GL11.glEnable((int)3553);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(screen_width / 2 - oops.length() * 5), (float)(screen_height / 2), (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                font.drawString(0.0f, 0.0f, oops, Color.white);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5889);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glPopMatrix();
                GL11.glEnable((int)2929);
                Display.update();
                Thread.sleep(5000L);
            }
            DangerZone.showLogo(DangerZone.player.deadflag);
            Display.update();
            DangerZone.writeConfig(DangerZone.player.deadflag);
        }
        Thread.sleep(200L);
        if (start_server) {
            DangerZone.saveWorld(server_world);
            Thread.sleep(500L);
            DangerZone.server_world.serverchunkcache.shutdown();
            while (chunkwriter.getSize() > 0) {
                Thread.sleep(100L);
            }
            Thread.sleep(100L);
            server.savePlayers();
            Thread.sleep(100L);
        }
        Thread.sleep(500L);
        if (!nogui) {
            Mouse.destroy();
            Keyboard.destroy();
            Display.destroy();
            AL.destroy();
        }
        System.exit(0);
    }

    public static boolean K_next() {
        return Keyboard.next();
    }

    public static int K_getEventKey() {
        return Keyboard.getEventKey();
    }

    public static boolean K_getEventKeyState() {
        return Keyboard.getEventKeyState();
    }

    public static boolean K_isKeyDown(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    public static boolean M_next() {
        return Mouse.next();
    }

    public static int M_getEventButton() {
        return Mouse.getEventButton();
    }

    public static boolean M_getEventButtonState() {
        return Mouse.getEventButtonState();
    }

    public static int M_getEventX() {
        return Mouse.getEventX();
    }

    public static int M_getEventY() {
        return Mouse.getEventY();
    }

    public static int M_getX() {
        return Mouse.getX();
    }

    public static int M_getY() {
        return Mouse.getY();
    }

    public static void setActiveGui(GuiInterface g) {
        if (current_gui == null) {
            current_gui = g;
            do_hit_cycle = 0;
            do_food_cycle = 0;
            repeatdelay = 0;
            doleftclick = false;
            dorightclick = false;
            leftbuttondown = false;
            rightbuttondown = false;
        }
    }

    public static void clearActiveGui() {
        current_gui = null;
    }

    private static void doNormalInput() {
        int i;
        if ((accel -= 0.05f) < 0.1f) {
            accel = 0.1f;
        }
        while (Keyboard.next()) {
            InventoryContainer ic;
            int meta;
            int bid;
            if (Keyboard.getEventKey() == 1 && Keyboard.isKeyDown((int)1) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(escapegui);
            }
            if (Keyboard.getEventKey() == 35 && Keyboard.isKeyDown((int)35) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(helpgui);
            }
            if (Keyboard.getEventKey() == 18 && Keyboard.isKeyDown((int)18) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(inventorygui);
            }
            if (Keyboard.getEventKey() == 20 && Keyboard.isKeyDown((int)20) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(chatgui);
            }
            if (Keyboard.getEventKey() == 53 && Keyboard.isKeyDown((int)53) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(commandgui);
            }
            if (Keyboard.getEventKey() == 34 && Keyboard.isKeyDown((int)34)) {
                if (player.getGameMode() == 0) {
                    player.setGameMode(2);
                    messagetimer = 100;
                    messagestring = ghost_string;
                } else if (player.getGameMode() == 1) {
                    player.setGameMode(0);
                    messagetimer = 100;
                    messagestring = survival_string;
                } else {
                    player.setGameMode(1);
                    messagetimer = 100;
                    messagestring = creative_string;
                }
            }
            if (Keyboard.getEventKey() == 45 && Keyboard.isKeyDown((int)45) && WorldRenderer.focus_x != 0 && WorldRenderer.focus_y != 0 && WorldRenderer.focus_z != 0) {
                bid = world.getblock(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                meta = world.getblockmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                if (!Blocks.isLiquid(bid)) {
                    if ((meta & 0xC000) == 0) {
                        meta = meta & 0x3FFF | 0x4000;
                    } else if ((meta & 0xC000) == 16384) {
                        meta = meta & 0x3FFF | 0x8000;
                    } else if ((meta & 0xC000) == 32768) {
                        meta = meta & 0x3FFF | 0xC000;
                    } else if ((meta & 0xC000) == 49152) {
                        meta &= 0x3FFF;
                    }
                    world.setblockandmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, bid, meta);
                }
            }
            if (Keyboard.getEventKey() == 46 && Keyboard.isKeyDown((int)46) && WorldRenderer.focus_x != 0 && WorldRenderer.focus_y != 0 && WorldRenderer.focus_z != 0) {
                bid = world.getblock(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                meta = world.getblockmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                if (!Blocks.isLiquid(bid)) {
                    if ((meta & 0x3000) == 0) {
                        meta = meta & 0xCFFF | 0x1000;
                    } else if ((meta & 0x3000) == 4096) {
                        meta = meta & 0xCFFF | 0x2000;
                    } else if ((meta & 0x3000) == 8192) {
                        meta = meta & 0xCFFF | 0x3000;
                    } else if ((meta & 0x3000) == 12288) {
                        meta &= 0xCFFF;
                    }
                    world.setblockandmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, bid, meta);
                }
            }
            if (Keyboard.getEventKey() == 47 && Keyboard.isKeyDown((int)47) && WorldRenderer.focus_x != 0 && WorldRenderer.focus_y != 0 && WorldRenderer.focus_z != 0) {
                bid = world.getblock(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                meta = world.getblockmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                if (!Blocks.isLiquid(bid)) {
                    if ((meta & 0xC00) == 0) {
                        meta = meta & 0xF3FF | 0x400;
                    } else if ((meta & 0xC00) == 1024) {
                        meta = meta & 0xF3FF | 0x800;
                    } else if ((meta & 0xC00) == 2048) {
                        meta = meta & 0xF3FF | 0xC00;
                    } else if ((meta & 0xC00) == 3072) {
                        meta &= 0xF3FF;
                    }
                    world.setblockandmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, bid, meta);
                }
            }
            if (Keyboard.getEventKey() == 21 && Keyboard.isKeyDown((int)21) && player.getGameMode() != 0) {
                i = 0;
                while (i < 256) {
                    int id = (DangerZone.player.dimension + i + 1) % 256;
                    if (Dimensions.DimensionArray[id] != null) {
                        Dimensions.DimensionArray[id].teleportToDimension(player, world, id, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
                        break;
                    }
                    ++i;
                }
            }
            if (Keyboard.getEventKey() == 16 && Keyboard.isKeyDown((int)16) && (ic = player.getHotbar(player.gethotbarindex())) != null) {
                if (ic.count != 0) {
                    if (player.getGameMode() == 0) {
                        --ic.count;
                    }
                    player.setHotbarChanged(player.gethotbarindex());
                    EntityBlockItem e = (EntityBlockItem)DangerZone.player.world.createEntityByName(blockitemname, DangerZone.player.dimension, DangerZone.player.posx + (float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)), DangerZone.player.posy + DangerZone.player.height * 7.0f / 8.0f - (float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f, DangerZone.player.posz + (float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)));
                    if (e != null) {
                        e.setBID(ic.bid);
                        e.setIID(ic.iid);
                        e.setItemDamage(ic.currentuses);
                        e.rotation_pitch = DangerZone.player.world.rand.nextInt(360);
                        e.rotation_yaw = DangerZone.player.world.rand.nextInt(360);
                        e.rotation_roll = DangerZone.player.world.rand.nextInt(360);
                        e.motionx = (float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f;
                        e.motiony = -((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)));
                        e.motionz = (float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f;
                        DangerZone.player.world.spawnEntityInWorld(e);
                    }
                }
                if (ic.count <= 0) {
                    player.setHotbar(player.gethotbarindex(), null);
                }
            }
            if (Keyboard.getEventKey() == 60 && Keyboard.isKeyDown((int)60)) {
                Utils.screenshot(screen_width, screen_height);
                messagestring = "Screenshot!";
                messagetimer = 60;
            }
            if (Keyboard.getEventKey() == 61 && Keyboard.isKeyDown((int)61)) {
                f3_on = !f3_on;
            }
            if (Keyboard.getEventKey() == 64 && Keyboard.isKeyDown((int)64) && player.getGameMode() != 0) {
                view_ores = !view_ores;
            }
            if (Keyboard.getEventKey() == 63 && Keyboard.isKeyDown((int)63)) {
                if (f5_front) {
                    f5_front = false;
                    f5_back = true;
                } else if (f5_back) {
                    f5_back = false;
                } else {
                    f5_front = true;
                }
            }
            if (Keyboard.getEventKey() == 2 && Keyboard.isKeyDown((int)2)) {
                DangerZone.show_selection(0);
            }
            if (Keyboard.getEventKey() == 3 && Keyboard.isKeyDown((int)3)) {
                DangerZone.show_selection(1);
            }
            if (Keyboard.getEventKey() == 4 && Keyboard.isKeyDown((int)4)) {
                DangerZone.show_selection(2);
            }
            if (Keyboard.getEventKey() == 5 && Keyboard.isKeyDown((int)5)) {
                DangerZone.show_selection(3);
            }
            if (Keyboard.getEventKey() == 6 && Keyboard.isKeyDown((int)6)) {
                DangerZone.show_selection(4);
            }
            if (Keyboard.getEventKey() == 7 && Keyboard.isKeyDown((int)7)) {
                DangerZone.show_selection(5);
            }
            if (Keyboard.getEventKey() == 8 && Keyboard.isKeyDown((int)8)) {
                DangerZone.show_selection(6);
            }
            if (Keyboard.getEventKey() == 9 && Keyboard.isKeyDown((int)9)) {
                DangerZone.show_selection(7);
            }
            if (Keyboard.getEventKey() == 10 && Keyboard.isKeyDown((int)10)) {
                DangerZone.show_selection(8);
            }
            if (Keyboard.getEventKey() == 11 && Keyboard.isKeyDown((int)11)) {
                DangerZone.show_selection(9);
            }
            if (Keyboard.getEventKey() != 17 || !Keyboard.isKeyDown((int)17)) continue;
            if (gofasttimer != 0) {
                gofast = 1;
            }
            gofasttimer = 20;
        }
        if (Keyboard.isKeyDown((int)57)) {
            if (player.getGameMode() == 2) {
                DangerZone.player.motiony += 0.055f * deltaT * accel;
                if ((accel += 0.1f) > 1.0f) {
                    accel = 1.0f;
                }
            } else if (player.getOnGround() || player.getInLiquid()) {
                player.jump();
            }
            player.setUp(true);
        } else {
            player.setUp(false);
        }
        if (Keyboard.isKeyDown((int)42)) {
            if (player.getGameMode() == 2) {
                DangerZone.player.motiony -= 0.055f * deltaT * accel;
                if ((accel += 0.1f) > 1.0f) {
                    accel = 1.0f;
                }
            }
            player.setDown(true);
        } else {
            player.setDown(false);
        }
        if (Keyboard.isKeyDown((int)17)) {
            float speed = 0.042f * accel;
            if (player.getGameMode() != 2 && (world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy + 2, (int)DangerZone.player.posz) != 0 || world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy + 3, (int)DangerZone.player.posz) != 0)) {
                speed *= 0.7f;
            }
            if ((accel += 0.2f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 4.0f;
            } else if (gofast != 0) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx + (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz + (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
            player.setForward(true);
        } else {
            gofast = 0;
            player.setForward(false);
        }
        if (Keyboard.isKeyDown((int)31)) {
            float speed = 0.03f * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx - (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz - (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
            player.setBackward(true);
        } else {
            player.setBackward(false);
        }
        if (Keyboard.isKeyDown((int)30)) {
            float speed = 0.03f * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx + (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz + (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
            player.setLeft(true);
        } else {
            player.setLeft(false);
        }
        if (Keyboard.isKeyDown((int)32)) {
            float speed = 0.03f * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx - (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz - (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
            player.setRight(true);
        } else {
            player.setRight(false);
        }
        while (Mouse.next()) {
            float dx = Mouse.getDX();
            float dy = Mouse.getDY();
            dy *= 0.1f + 0.01f * (float)mouseSensitivity;
            DangerZone.player.rotation_yaw_head += (dx *= 0.1f + 0.01f * (float)mouseSensitivity);
            if (DangerZone.player.rotation_yaw_head < 0.0f) {
                DangerZone.player.rotation_yaw_head += 360.0f;
            }
            DangerZone.player.rotation_yaw_head %= 360.0f;
            DangerZone.player.rotation_pitch_head -= dy;
            DangerZone.player.rotation_pitch_head %= 360.0f;
            if (DangerZone.player.rotation_pitch_head > 180.0f) {
                if (DangerZone.player.rotation_pitch_head < 270.0f) {
                    DangerZone.player.rotation_pitch_head = 270.0f;
                }
            } else if (DangerZone.player.rotation_pitch_head > 90.0f) {
                DangerZone.player.rotation_pitch_head = 90.0f;
            }
            if (Mouse.getEventButtonState()) {
                if (player.getGameMode() == 0) {
                    player.setHunger(player.getHunger() - 0.01f);
                }
                if (Mouse.getEventButton() == 0) {
                    leftbuttondown = true;
                    rightbuttondown = false;
                }
                if (Mouse.getEventButton() == 1) {
                    rightbuttondown = true;
                    leftbuttondown = false;
                }
                if (Mouse.getEventButton() == 2) {
                    player.middleclick(world, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, 0);
                }
            } else if (Mouse.getEventButton() >= 0) {
                do_hit_cycle = 0;
                do_food_cycle = 0;
                leftbuttondown = false;
                rightbuttondown = false;
                repeatdelay = 0;
            }
            if ((i = Mouse.getDWheel()) == 0) continue;
            i = -i / 120;
            i += player.gethotbarindex();
            while (i < 0) {
                i += 10;
            }
            DangerZone.show_selection(i %= 10);
        }
        if (leftbuttondown || rightbuttondown) {
            if (repeatdelay == 0 || repeatdelay > 30) {
                if (leftbuttondown) {
                    do_hit_cycle = 1;
                    do_food_cycle = 0;
                    doleftclick = true;
                    dorightclick = false;
                }
                if (rightbuttondown) {
                    InventoryContainer ic = player.getHotbar(player.gethotbarindex());
                    if (WorldRenderer.focus_entity != null) {
                        do_hit_cycle = 1;
                        do_food_cycle = 0;
                        dorightclick = true;
                        doleftclick = false;
                    } else if (ic != null && Items.isFood(ic.iid) && WorldRenderer.focus_x == 0 && WorldRenderer.focus_z == 0) {
                        do_food_cycle = 1;
                        do_hit_cycle = 0;
                        doleftclick = false;
                        dorightclick = false;
                    } else {
                        do_hit_cycle = 1;
                        do_food_cycle = 0;
                        dorightclick = true;
                        doleftclick = false;
                    }
                }
            }
            ++repeatdelay;
        } else {
            repeatdelay = 0;
        }
    }

    private static void showLogo(boolean redcolor) {
        if (logotexture == null) {
            try {
                logotexture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)"res/menus/logo.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (redcolor) {
            GL11.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        if (redcolor) {
            GL11.glColor3f((float)1.0f, (float)0.2f, (float)0.2f);
        } else {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        logotexture.bind();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        float x = 200.0f;
        float y = 190.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-600.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-x), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-x), (float)(-y), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)(-y), (float)0.0f);
        GL11.glEnd();
    }

    private static void readConfig() {
        Properties prop = new Properties();
        FileInputStream input = null;
        server_address = "127.0.0.1";
        server_port = 18668;
        screen_width = 1024;
        screen_height = 600;
        renderdistance = 24;
        volume_temp = 10;
        worldname = "my_world";
        playername = "Player";
        fieldOfView = 45;
        mouseSensitivity = 0;
        mindrawlevel = 0;
        all_sides = true;
        light_speed = true;
        keepitsqueakyclean = true;
        show_clouds = true;
        show_rain = true;
        alt_texture_path = "";
        try {
            input = new FileInputStream("DangerZone.properties");
            prop.load(input);
            screen_width = Utils.getPropertyInt(prop, "ScreenWidth", 500, 4000, 1024);
            screen_height = Utils.getPropertyInt(prop, "ScreenHeight", 300, 3000, 600);
            renderdistance = Utils.getPropertyInt(prop, "RenderDistance", 4, 24, 16);
            volume_temp = Utils.getPropertyInt(prop, "Volume", 0, 10, 10);
            server_address = Utils.getPropertyString(prop, "ServerAddress", "127.0.0.1");
            server_port = Utils.getPropertyInt(prop, "ServerPort", 0, Integer.MAX_VALUE, 18668);
            origworldname = worldname = Utils.getPropertyString(prop, "WorldName", "my_world");
            playername = Utils.getPropertyString(prop, "Playername", "Player");
            fieldOfView = Utils.getPropertyInt(prop, "FieldOfView", 30, 80, 45);
            mouseSensitivity = Utils.getPropertyInt(prop, "MouseSensitivity", -9, 9, 0);
            keepitsqueakyclean = Utils.getPropertyBoolean(prop, "RunFinalization", true);
            mindrawlevel = Utils.getPropertyInt(prop, "MinDrawLevel", 0, 40, 0);
            alt_texture_path = Utils.getPropertyString(prop, "AltTextureDir", "");
            all_sides = Utils.getPropertyBoolean(prop, "MaxGraphics", true);
            light_speed = Utils.getPropertyBoolean(prop, "FastLighting", true);
            show_clouds = Utils.getPropertyBoolean(prop, "ShowClouds", true);
            show_rain = Utils.getPropertyBoolean(prop, "ShowRain", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!start_server && renderdistance > 20) {
            savedrenderdistance = renderdistance;
            renderdistance = 20;
        }
    }

    private static void writeConfig(boolean pld) {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream("DangerZone.properties");
            prop.setProperty("ScreenWidth", String.format("%d", screen_width));
            prop.setProperty("ScreenHeight", String.format("%d", screen_height));
            if (savedrenderdistance > renderdistance) {
                renderdistance = savedrenderdistance;
            }
            prop.setProperty("RenderDistance", String.format("%d", renderdistance));
            if (soundmangler != null) {
                prop.setProperty("Volume", String.format("%d", DangerZone.soundmangler.master_volume));
            }
            prop.setProperty("ServerAddress", server_address);
            prop.setProperty("ServerPort", String.format("%d", server_port));
            String strippedname = worldname;
            if (!start_server) {
                strippedname = origworldname;
            }
            if (strippedname.contains("/")) {
                int is = strippedname.lastIndexOf("/");
                strippedname = strippedname.substring(is + 1);
            }
            prop.setProperty("WorldName", strippedname);
            prop.setProperty("Playername", playername);
            prop.setProperty("FieldOfView", String.format("%d", fieldOfView));
            prop.setProperty("MouseSensitivity", String.format("%d", mouseSensitivity));
            prop.setProperty("RunFinalization", String.format("%s", keepitsqueakyclean ? "true" : "false"));
            prop.setProperty("MinDrawLevel", String.format("%d", mindrawlevel));
            prop.setProperty("AltTextureDir", alt_texture_path);
            prop.setProperty("MaxGraphics", String.format("%s", all_sides ? "true" : "false"));
            prop.setProperty("FastLighting", String.format("%s", light_speed ? "true" : "false"));
            prop.setProperty("ShowClouds", String.format("%s", show_clouds ? "true" : "false"));
            prop.setProperty("ShowRain", String.format("%s", show_rain ? "true" : "false"));
            prop.setProperty("PlayerDied", String.format("%s", pld ? "true" : "false"));
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadWorld(World w) {
        FileInputStream input = null;
        Properties worldprop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/world.dat", worldname);
        generatecaves = true;
        w.timetimer = 0;
        playnicely = false;
        try {
            input = new FileInputStream(filepath);
            worldprop.load(input);
            w.timetimer = Utils.getPropertyInt(worldprop, "TimeOfDay", 0, Integer.MAX_VALUE, 0);
            generatecaves = Utils.getPropertyBoolean(worldprop, "CaveGeneration", true);
            playnicely = Utils.getPropertyBoolean(worldprop, "PlayNicely", false);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void saveWorld(World w) {
        Properties worldprop = new Properties();
        OutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/world.dat", worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            worldprop.setProperty("TimeOfDay", String.format("%d", w.timetimer));
            worldprop.setProperty("CaveGeneration", String.format("%s", generatecaves ? "true" : "false"));
            worldprop.setProperty("PlayNicely", String.format("%s", playnicely ? "true" : "false"));
            output = new FileOutputStream(filepath);
            worldprop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getWorldDirectoryPath() {
        return String.format("worlds/%s/", worldname);
    }

    public static String getAltTexturePath() {
        return alt_texture_path;
    }

    private static void doStartSinglePlayer() {
        soundmangler = new SoundManager();
        DangerZone.soundmangler.master_volume = volume_temp;
        client_chunk_cache = new ChunkCache();
        DangerZone.client_chunk_cache.passthru = true;
        server_chunk_cache = new ServerChunkCache();
        chunkwriter = new ChunkWriterThread();
        Thread cwt = new Thread(chunkwriter);
        cwt.start();
        wds = new WorldDecorators();
        player = new Player(null);
        DangerZone.player.model = new ModelHumanoid();
        DangerZone.player.myname = playername;
        player.setPetName(playername);
        DangerZone.player.world = world = new World(client_chunk_cache, null);
        server_world = new World(null, server_chunk_cache);
        DangerZone.server_world.isServer = true;
        DangerZone.server_world.timetimer = 0;
        DangerZone.loadWorld(server_world);
        wr = new WorldRenderer();
        all_the_blocks = new Blocks();
        Blocks.load();
        all_the_items = new Items();
        Items.load();
        all_the_dimensions = new Dimensions();
        Dimensions.load();
        all_the_custompackets = new CustomPackets();
        all_the_recipies = new Crafting();
        all_the_cooking = new Cooking();
        all_the_ores = new Ores();
        all_the_spawns = new Spawnlist();
        all_the_handlers = new CommandHandlers();
        all_the_particles = new Particles();
        all_the_entities = new Entities();
        blockitem = new EntityBlockItem(world);
        Entities.registerEntity(EntityBlockItem.class, DangerZone.blockitem.uniquename, new ModelEntityBlockItem());
        Entities.registerEntity(Player.class, DangerZone.player.uniquename, new ModelHumanoid());
        Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());
        base = new BaseMod();
        base.registerThings();
        modloader = new ModLoader();
        modloader.loadmods();
        base.postLoadProcessing();
        Blocks.save();
        Items.save();
        Dimensions.save();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        entityManager = new EntityUpdateLoop();
        Thread it = new Thread(entityManager);
        it.start();
        particleManager = new ParticleUpdateLoop();
        Thread pit = new Thread(particleManager);
        pit.start();
        commandhandler = new DZCommandHandler();
        server = new Server();
        Thread st = new Thread(server);
        st.start();
        while (DangerZone.server.entityManager == null) {
            Thread.yield();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        player.getTexture();
        server_connection = new ServerConnection(player, false);
        Thread ct = new Thread(server_connection);
        ct.setPriority(10);
        ct.start();
        escapegui = new PlayerEscapeGUI();
        inventorygui = new PlayerInventoryGUI();
        chatgui = new PlayerChatGUI();
        helpgui = new PlayerHelpGUI();
        commandgui = new PlayerCommandGUI();
        int i = 0;
        while (DangerZone.server_connection.connected == 0 && i < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (i >= 10) {
            System.exit(1);
        }
        lto = new LightingThread();
        Thread lt = new Thread(lto);
        lt.start();
        tidyup = new CleanerThread();
        Thread clt = new Thread(tidyup);
        clt.setPriority(10);
        clt.start();
        wr.loadBlockTextures();
        i = 0;
        while (i < 10) {
            player.setHotbarChanged(i);
            ++i;
        }
        i = 0;
        while (i < 50) {
            player.setInventoryChanged(i);
            ++i;
        }
        i = 0;
        while (i < 4) {
            player.setArmorChanged(i);
            ++i;
        }
        server_connection.inventoryUpdate(2, player.gethotbarindex(), null);
        server_connection.sendPlayerEntityUpdate(player);
        Chunk c = null;
        while (c == null) {
            c = DangerZone.player.world.chunkcache.getDecoratedChunk(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
            if (c != null) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        c = null;
        DangerZone.wr.lastplayerdimension = DangerZone.player.dimension;
        Mouse.setGrabbed((boolean)true);
        mouse_grabbed = true;
        Thread thisthread = Thread.currentThread();
        thisthread.setPriority(10);
    }

    private static void doStartServer() {
        soundmangler = new SoundManager();
        DangerZone.soundmangler.master_volume = volume_temp;
        server_chunk_cache = new ServerChunkCache();
        chunkwriter = new ChunkWriterThread();
        Thread cwt = new Thread(chunkwriter);
        cwt.start();
        wds = new WorldDecorators();
        player = new Player(null);
        server_world = new World(null, server_chunk_cache);
        DangerZone.server_world.isServer = true;
        DangerZone.server_world.timetimer = 0;
        DangerZone.player.world = server_world;
        DangerZone.loadWorld(server_world);
        all_the_blocks = new Blocks();
        Blocks.load();
        all_the_items = new Items();
        Items.load();
        all_the_dimensions = new Dimensions();
        Dimensions.load();
        all_the_custompackets = new CustomPackets();
        all_the_recipies = new Crafting();
        all_the_cooking = new Cooking();
        all_the_ores = new Ores();
        all_the_spawns = new Spawnlist();
        all_the_handlers = new CommandHandlers();
        all_the_particles = new Particles();
        all_the_entities = new Entities();
        blockitem = new EntityBlockItem(world);
        Entities.registerEntity(EntityBlockItem.class, DangerZone.blockitem.uniquename, new ModelEntityBlockItem());
        Entities.registerEntity(Player.class, DangerZone.player.uniquename, new ModelHumanoid());
        Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());
        base = new BaseMod();
        base.registerThings();
        modloader = new ModLoader();
        modloader.loadmods();
        base.postLoadProcessing();
        Blocks.save();
        Items.save();
        Dimensions.save();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        commandhandler = new DZCommandHandler();
        server = new Server();
        Thread st = new Thread(server);
        st.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        tidyup = new CleanerThread();
        Thread clt = new Thread(tidyup);
        clt.setPriority(10);
        clt.start();
    }

    private static void doStartClient() {
        soundmangler = new SoundManager();
        DangerZone.soundmangler.master_volume = volume_temp;
        client_chunk_cache = new ChunkCache();
        player = new Player(null);
        DangerZone.player.model = new ModelHumanoid();
        DangerZone.player.myname = playername;
        player.setPetName(playername);
        DangerZone.player.world = world = new World(client_chunk_cache, null);
        wr = new WorldRenderer();
        all_the_blocks = new Blocks();
        all_the_items = new Items();
        all_the_dimensions = new Dimensions();
        all_the_custompackets = new CustomPackets();
        all_the_recipies = new Crafting();
        all_the_cooking = new Cooking();
        all_the_ores = new Ores();
        all_the_spawns = new Spawnlist();
        all_the_handlers = new CommandHandlers();
        all_the_particles = new Particles();
        all_the_entities = new Entities();
        blockitem = new EntityBlockItem(world);
        Entities.registerEntity(EntityBlockItem.class, DangerZone.blockitem.uniquename, new ModelEntityBlockItem());
        Entities.registerEntity(Player.class, DangerZone.player.uniquename, new ModelHumanoid());
        Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());
        escapegui = new PlayerEscapeGUI();
        inventorygui = new PlayerInventoryGUI();
        chatgui = new PlayerChatGUI();
        helpgui = new PlayerHelpGUI();
        commandgui = new PlayerCommandGUI();
        entityManager = new EntityUpdateLoop();
        Thread it = new Thread(entityManager);
        it.start();
        particleManager = new ParticleUpdateLoop();
        Thread pit = new Thread(particleManager);
        pit.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        player.getTexture();
        server_connection = new ServerConnection(player, true);
        Thread ct = new Thread(server_connection);
        ct.setPriority(10);
        ct.start();
        int i = 0;
        while (!DangerZone.server_connection.connectionInProgress && i < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (i >= 10) {
            System.exit(1);
        }
        worldname = DangerZone.server_connection.worldname;
        base = new BaseMod();
        base.registerThings();
        modloader = new ModLoader();
        if (!modloader.loadmods(DangerZone.server_connection.modnames)) {
            System.out.printf("Failed to load mods specified by server.\n", new Object[0]);
            System.exit(1);
        }
        base.postLoadProcessing();
        DangerZone.server_connection.waitformodstoload = false;
        i = 0;
        while (DangerZone.server_connection.connected == 0 && i < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (i >= 10) {
            System.exit(1);
        }
        wr.loadBlockTextures();
        i = 0;
        while (i < 10) {
            player.setHotbarChanged(i);
            ++i;
        }
        i = 0;
        while (i < 50) {
            player.setInventoryChanged(i);
            ++i;
        }
        i = 0;
        while (i < 4) {
            player.setArmorChanged(i);
            ++i;
        }
        server_connection.inventoryUpdate(2, player.gethotbarindex(), null);
        server_connection.sendPlayerEntityUpdate(player);
        Chunk c = null;
        while (c == null) {
            c = DangerZone.player.world.chunkcache.getDecoratedChunk(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
            if (c != null) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        c = null;
        lto = new LightingThread();
        Thread lt = new Thread(lto);
        lt.start();
        tidyup = new CleanerThread();
        Thread clt = new Thread(tidyup);
        clt.setPriority(10);
        clt.start();
        DangerZone.wr.lastplayerdimension = DangerZone.player.dimension;
        Mouse.setGrabbed((boolean)true);
        mouse_grabbed = true;
        Thread thisthread = Thread.currentThread();
        thisthread.setPriority(10);
    }

    public static void show_selection(int i) {
        player.sethotbarindex(i);
        InventoryContainer ic = player.getHotbar(i);
        if (ic != null && ic.count > 0) {
            String hotstring = null;
            String[] hss = null;
            if (ic.bid != 0) {
                hotstring = Blocks.getUniqueName(ic.bid);
            }
            if (ic.iid != 0) {
                hotstring = Items.getUniqueName(ic.iid);
            }
            if (hotstring != null && (hss = hotstring.split(":")).length >= 2) {
                hotmessagestring = hss[1];
                hotmessagetimer = 60;
            }
        } else {
            hotmessagestring = null;
            hotmessagetimer = 0;
        }
    }
}

