/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class WorldRendererUtils {
    private static boolean square_compiled = false;
    private static int squareid;
    private static final int blockrenderwidth = 16;
    public static Texture hotbarbackground;

    static {
        hotbarbackground = null;
    }

    public static void textAt(TrueTypeFont ff, float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef(xpos, ypos, 0.0f);
        GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
        ff.drawString(0.0f, 0.0f, text, Color.lightGray);
        GL11.glPopMatrix();
    }

    public static void drawSquare() {
        if (!square_compiled) {
            squareid = DangerZone.wr.getNextRenderID();
            GL11.glNewList(squareid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(8.0f, 8.0f, 0.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-8.0f, 8.0f, 0.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-8.0f, -8.0f, 0.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(8.0f, -8.0f, 0.0f);
            GL11.glEnd();
            GL11.glEndList();
            square_compiled = true;
        }
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glCallList(squareid);
        GL11.glDisable(3042);
    }

    public static float getLightMapValue(World w, int d, int x, int y, int z) {
        float[] lightmap = null;
        lightmap = w.chunkcache.getDecoratedChunkLightmap(d, x, y, z);
        if (lightmap == null) {
            return 0.0f;
        }
        return lightmap[(x & 0xF) * 16 + (z & 0xF)];
    }

    public static float getTotalLightAt(World w, int d, int x, int y, int z) {
        float[] lightmap = null;
        float lt = WorldRendererUtils.getBrightnessForLevel(y);
        lightmap = w.chunkcache.getDecoratedChunkLightmap(d, x, y, z);
        if (lightmap == null) {
            return lt;
        }
        return lightmap[(x & 0xF) * 16 + (z & 0xF)] + lt;
    }

    public static float getBrightnessForLevel(int yp) {
        float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
        float fsin = (float)Math.sin(Math.toRadians(tod / (float)DangerZone.world.lengthOfDay * 360.0f));
        float f = 0.5f + 0.45f * fsin;
        if (yp < 50) {
            if (yp < 0) {
                yp = 0;
            }
            float f2 = (float)yp / 50.0f;
            f *= f2;
        }
        return f;
    }

    private static void drawhotbarbackground() {
        if (hotbarbackground == null) {
            try {
                hotbarbackground = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("res/menus/bkg1.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GL11.glScalef(3.25f, 3.25f, 3.25f);
        DangerZone.wr.loadtexture(hotbarbackground);
        WorldRendererUtils.drawSquare();
        GL11.glScalef(0.30769232f, 0.30769232f, 0.30769232f);
    }

    public static void drawHotbar(World world) {
        if (DangerZone.current_gui != null) {
            return;
        }
        InventoryContainer ic = null;
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        GL11.glTranslatef(DangerZone.screen_width / 2 - 30 * world.player.hotbar.length, 30.0f, 0.0f);
        int i = 0;
        while (i < world.player.hotbar.length) {
            DangerZone.wr.last_texture = -1;
            if (i == world.player.current_hotbar_index) {
                DangerZone.wr.setBrightnessFocus();
            }
            WorldRendererUtils.drawhotbarbackground();
            ic = world.player.hotbar[i];
            if (ic != null) {
                if (ic.bid != 0) {
                    GL11.glScalef(2.0f, 2.0f, 2.0f);
                    DangerZone.wr.drawTexturedCube(8, Blocks.isSolidForRender(world.player.hotbar[i].bid), world.player.hotbar[i].bid, 0, false);
                    GL11.glScalef(0.5f, 0.5f, 0.5f);
                }
                if (ic.iid != 0) {
                    int md;
                    Item it;
                    GL11.glScalef(2.0f, 2.0f, 2.0f);
                    DangerZone.wr.loadtexture(Items.getTexture(world.player.hotbar[i].iid));
                    WorldRendererUtils.drawSquare();
                    GL11.glScalef(0.5f, 0.5f, 0.5f);
                    if (ic.count == 1 && ic.currentuses > 0 && ic.getMaxStack() == 1 && (it = ic.getItem()) != null && (md = it.maxuses) > 0) {
                        float xs;
                        float pu = (float)ic.currentuses / (float)md;
                        if (pu > 1.0f) {
                            pu = 1.0f;
                        }
                        if (pu < 0.0f) {
                            pu = 0.0f;
                        }
                        if ((xs = 32.0f * (1.0f - pu)) < 1.0f) {
                            xs = 1.0f;
                        }
                        GL11.glPushMatrix();
                        GL11.glDisable(3553);
                        GL11.glTranslatef(-16.0f, -18.0f, 0.0f);
                        GL11.glScalef(1.0f, 1.0f, 1.0f);
                        GL11.glBegin(7);
                        GL11.glColor3f(pu, 1.0f - pu, 0.0f);
                        GL11.glVertex3f(xs, 2.0f, 0.0f);
                        GL11.glColor3f(pu, 1.0f - pu, 0.0f);
                        GL11.glVertex3f(0.0f, 2.0f, 0.0f);
                        GL11.glColor3f(pu, 1.0f - pu, 0.0f);
                        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
                        GL11.glColor3f(pu, 1.0f - pu, 0.0f);
                        GL11.glVertex3f(xs, 0.0f, 0.0f);
                        GL11.glEnd();
                        GL11.glEnable(3553);
                        GL11.glPopMatrix();
                    }
                }
                if (world.player.hotbar[i].count > 1) {
                    if (world.player.hotbar[i].count > 9) {
                        WorldRendererUtils.textAt(DangerZone.wr.font, -12.0f, 10.0f, String.format("%d", world.player.hotbar[i].count));
                    } else {
                        WorldRendererUtils.textAt(DangerZone.wr.font, -6.0f, 10.0f, String.format("%d", world.player.hotbar[i].count));
                    }
                }
                DangerZone.wr.setBrightnessNonFocus();
            }
            DangerZone.wr.setBrightnessNonFocus();
            GL11.glTranslatef(60.0f, 0.0f, 0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawHealth(World world) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (WorldRenderer.heart_texture == null || WorldRenderer.unheart_texture == null) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        GL11.glTranslatef(DangerZone.screen_width / 2 - 300 - 14, 65.0f, 0.0f);
        float h = DangerZone.player.getHealth() / DangerZone.player.getMaxHealth();
        h *= 20.0f;
        int i = 0;
        while (i < 20) {
            if (h >= (float)i) {
                DangerZone.wr.loadtexture(WorldRenderer.heart_texture);
            } else {
                DangerZone.wr.loadtexture(WorldRenderer.unheart_texture);
            }
            WorldRendererUtils.drawSquare();
            GL11.glTranslatef(30.0f, 0.0f, 0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }
}

