/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class WorldRenderer {
    public List<long[]> VBO_delete_list;
    private Lock VBOlistlock = new ReentrantLock();
    public static Texture heart_texture = null;
    public static Texture unheart_texture = null;
    public int last_texture = -1;
    public static StitchedTextureFile[] stitches = null;
    public static int next_stitch = 0;
    public int blockrenderwidth = 16;
    public int focus_x;
    public int focus_y;
    public int focus_z;
    public int focus_side;
    public int focus_xpos;
    public int focus_ypos;
    public int focus_zpos;
    public int focus_bid;
    public int focus_meta;
    public float focus_damage = 0.0f;
    public float focus_maxdamage = 0.0f;
    public float linewidth = 3.0f;
    private static boolean compiled = false;
    int topid;
    int bottomid;
    int leftid;
    int rightid;
    int frontid;
    int backid;
    private Font awtfont = null;
    public TrueTypeFont font = null;
    private float brightness_red;
    private float brightness_green;
    private float brightness_blue;
    private float sky_red;
    private float sky_green;
    private float sky_blue;
    private Entity ent;
    private Lock lock = new ReentrantLock();
    private long lasttime = 0L;
    private long nowtime = 0L;
    public int fps = 0;
    private int fpscounter = 0;
    private int pps = 0;
    private int cps = 0;
    private float bounce = 0.0f;
    private int hit_cycles = 7;
    private int hit_cycle_count = 0;
    private int hit_cycle_dir = 1;
    private float hitx = -20.0f;
    private float hity = 10.0f;
    private float hitz = -25.0f;
    private float hitp = 62.0f;
    private float hitw = 34.0f;
    private float hitr = -147.0f;
    boolean washurt = false;
    float ouch = 1.0f;
    private float f5x;
    private float f5y;
    private float f5z;
    private float f5yaw;
    private float f5pitch;
    private float cdir;
    private float tdir;
    private float pdiff;
    private float ydiff;
    private float rdiff;
    public float cbr;
    public float cbg;
    public float cbb;
    private long nextVBOid;
    private long nextDeleteVBOid;
    Map<Long, VBOBuffer> VBOmap = null;
    private StitchedTexture[] rot_st = new StitchedTexture[6];
    private float[][] tcoords = new float[6][8];
    public List<VBOBuffer> translucentVBOs;
    private int[][] checkers;

    WorldRenderer() {
        try {
            heart_texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("res/menus/heart.png"));
        }
        catch (IOException e) {
            heart_texture = null;
        }
        try {
            unheart_texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("res/menus/unheart.png"));
        }
        catch (IOException e) {
            unheart_texture = null;
        }
        stitches = new StitchedTextureFile[20];
        this.nextVBOid = 1L;
        this.nextDeleteVBOid = 1L;
        this.VBOmap = new HashMap<Long, VBOBuffer>();
        this.VBO_delete_list = new ArrayList<long[]>();
        this.translucentVBOs = new ArrayList<VBOBuffer>();
        this.checkers = new int[33][33];
        int i = 0;
        while (i < 33) {
            int j = 0;
            while (j < 33) {
                this.checkers[i][j] = (int)((double)(i * 33 + j) % (30.0 + Math.sqrt(i * i + j * j) * 5.0));
                ++j;
            }
            ++i;
        }
    }

    public void renderWorld(World world) {
        float velocity;
        double rdd;
        double pi = 3.1415926545;
        int torender = 6;
        int rendermax = 16;
        float dist = 0.0f;
        ++this.fpscounter;
        this.nowtime = System.currentTimeMillis();
        if (this.nowtime - this.lasttime > 1000L) {
            this.fps = this.fpscounter;
            this.fpscounter = 0;
            this.lasttime = this.nowtime;
            this.pps = DangerZone.packets_per_second;
            DangerZone.packets_per_second = 0;
            this.cps = DangerZone.chunks_per_second;
            DangerZone.chunks_per_second = 0;
        }
        this.VBOlistlock.lock();
        if (!this.VBO_delete_list.isEmpty()) {
            Iterator<long[]> ii = this.VBO_delete_list.iterator();
            while (ii.hasNext()) {
                long[] lArray = ii.next();
                if (lArray != null) {
                    int vdx = 0;
                    while (vdx < 20) {
                        if (lArray[vdx] == 0L) break;
                        VBOBuffer v = this.VBOmap.get(lArray[vdx]);
                        if (v != null) {
                            this.VBOmap.remove(v.VBOid);
                            v.free();
                        }
                        lArray[vdx] = 0L;
                        ++vdx;
                    }
                }
                ii.remove();
            }
        }
        this.VBOlistlock.unlock();
        if (this.nextVBOid - this.nextDeleteVBOid > 1200L) {
            VBOBuffer v = this.VBOmap.get(this.nextDeleteVBOid);
            if (v != null) {
                this.VBOmap.remove(v.VBOid);
                v.free();
            }
            ++this.nextDeleteVBOid;
        }
        if (world.player.getGameMode() != 2) {
            rdd = Math.sqrt(world.player.motionx * world.player.motionx + world.player.motionz * world.player.motionz);
            this.bounce = DangerZone.gofast != 0 ? (float)(rdd * Math.cos(Math.toRadians((float)world.player.lifetimeticker * 25.3f))) : (float)((rdd /= 20.0) * Math.cos(Math.toRadians((float)world.player.lifetimeticker * 15.3f)));
            if (!world.player.isOnGround) {
                this.bounce = 0.0f;
            }
        } else {
            this.bounce = 0.0f;
        }
        world.player.rotation_pitch_head %= 360.0f;
        world.player.rotation_yaw_head %= 360.0f;
        world.player.rotation_roll_head %= 360.0f;
        this.find_focus(world);
        this.cbb = 0.0f;
        this.cbg = 0.0f;
        this.cbr = 0.0f;
        this.recalcSkyBrightness();
        GL11.glClearColor(this.sky_red, this.sky_green, this.sky_blue, 0.0f);
        GL11.glClear(16640);
        GL11.glLoadIdentity();
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        this.recalcBrightness(60);
        this.setBrightness();
        this.last_texture = -1;
        this.f5pitch = 0.0f;
        this.f5yaw = 0.0f;
        this.f5z = 0.0f;
        this.f5y = 0.0f;
        this.f5x = 0.0f;
        if (DangerZone.f5_front) {
            float f = 8.0f;
            float t = (float)Math.cos(Math.toRadians(world.player.rotation_pitch_head));
            this.f5y = (float)Math.sin(Math.toRadians(world.player.rotation_pitch_head)) * f * (float)this.blockrenderwidth;
            this.f5x = (float)Math.cos(Math.toRadians(world.player.rotation_yaw_head + 90.0f)) * f * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = (float)Math.sin(Math.toRadians(world.player.rotation_yaw_head + 90.0f)) * f * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 180.0f;
            this.f5pitch = -world.player.rotation_pitch_head * 2.0f;
        }
        if (DangerZone.f5_back) {
            float f = 8.0f;
            float t = (float)Math.cos(Math.toRadians(world.player.rotation_pitch_head));
            this.f5y = -((float)Math.sin(Math.toRadians(world.player.rotation_pitch_head))) * f * (float)this.blockrenderwidth;
            this.f5x = -((float)Math.cos(Math.toRadians(world.player.rotation_yaw_head + 90.0f))) * f * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = -((float)Math.sin(Math.toRadians(world.player.rotation_yaw_head + 90.0f))) * f * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 0.0f;
            this.f5pitch = 0.0f;
        }
        GL11.glPushMatrix();
        GL11.glRotatef(world.player.rotation_pitch_head + this.f5pitch, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(world.player.rotation_yaw_head + this.f5yaw, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(-(world.player.posx * (float)this.blockrenderwidth % (float)(16 * this.blockrenderwidth)) + (float)(this.blockrenderwidth / 2) + this.f5x, -((world.player.posy + world.player.eyeheight + this.bounce - 0.5f) * (float)this.blockrenderwidth) + this.f5y, -(world.player.posz * (float)this.blockrenderwidth % (float)(16 * this.blockrenderwidth)) + (float)(this.blockrenderwidth / 2) + this.f5z);
        torender = world.player.rotation_pitch_head < 45.0f || world.player.rotation_pitch_head > 315.0f ? DangerZone.renderdistance : DangerZone.renderdistance - 2;
        if (torender < 3) {
            torender = 3;
        }
        int i = -rendermax;
        while (i <= rendermax) {
            int j = -rendermax;
            while (j <= rendermax) {
                if (Math.sqrt(i * i + j * j) <= (double)torender) {
                    double rhdir;
                    dist = (float)Math.sqrt(i * i + j * j);
                    double rr = (float)Math.atan2(j * 16, i * 16);
                    rdd = Math.abs(rr - (rhdir = Math.toRadians((world.player.rotation_yaw_head + this.f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                    if (rdd > pi) {
                        rdd -= pi * 2.0;
                    }
                    rdd = Math.abs(rdd);
                    if (!((world.player.rotation_pitch_head < 45.0f || world.player.rotation_pitch_head > 315.0f) && (dist > 8.0f && rdd > pi / 4.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 4.0f && rdd > pi / 3.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 1.0f && rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0))) {
                        int should_check = 0;
                        int[] nArray = this.checkers[i + 16];
                        int n = j + 16;
                        nArray[n] = nArray[n] + 1;
                        if ((double)this.checkers[i + 16][j + 16] >= 30.0 + Math.sqrt(i * i + j * j) * 5.0) {
                            this.checkers[i + 16][j + 16] = 0;
                            should_check = 1;
                        }
                        this.renderChunk(world, i, j, torender, should_check);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!this.translucentVBOs.isEmpty()) {
            Iterator<VBOBuffer> ii = this.translucentVBOs.iterator();
            while (ii.hasNext()) {
                VBOBuffer vBOBuffer = ii.next();
                GL11.glPushMatrix();
                GL11.glTranslatef(vBOBuffer.xoff, 0.0f, vBOBuffer.zoff);
                vBOBuffer.draw();
                GL11.glPopMatrix();
                ii.remove();
            }
        }
        if (this.focus_x != 0 && this.focus_z != 0 && this.focus_bid != 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef(this.focus_xpos, this.focus_ypos, this.focus_zpos);
            if (this.focus_damage != 0.0f && this.focus_maxdamage > 0.0f) {
                GL11.glScalef(1.0f - 0.75f * this.focus_damage / this.focus_maxdamage, 1.0f - 0.75f * this.focus_damage / this.focus_maxdamage, 1.0f - 0.75f * this.focus_damage / this.focus_maxdamage);
                GL11.glRotatef((float)((double)(45.0f * this.focus_damage / this.focus_maxdamage) * Math.cos(Math.toRadians(world.player.lifetimeticker * 3L))), 1.0f, 0.0f, 0.0f);
                GL11.glRotatef((float)((double)(45.0f * this.focus_damage / this.focus_maxdamage) * Math.cos(Math.toRadians(world.player.lifetimeticker * 7L))), 0.0f, 1.0f, 0.0f);
                GL11.glRotatef((float)((double)(45.0f * this.focus_damage / this.focus_maxdamage) * Math.cos(Math.toRadians(world.player.lifetimeticker * 5L))), 0.0f, 0.0f, 1.0f);
            }
            this.setBrightnessFocus();
            if (Blocks.hasOwnRenderer(this.focus_bid)) {
                Blocks.renderMe(this, world, world.player.dimension, this.focus_x, this.focus_y, this.focus_z, this.focus_bid, this.focus_meta, 255, true);
            } else {
                this.drawTexturedCube(255, Blocks.isSolidForRender(this.focus_bid), this.focus_bid, this.focus_meta, true);
            }
            this.setBrightness();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef(world.player.rotation_pitch_head + this.f5pitch, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(world.player.rotation_yaw_head + this.f5yaw, 0.0f, 1.0f, 0.0f);
        DangerZone.entityManager.entity_list_lock.lock();
        for (ListInt listInt : DangerZone.entityManager.entity_list) {
            if (DangerZone.entityManager.entities[listInt.index] == null) continue;
            this.ent = DangerZone.entityManager.entities[listInt.index];
            if (this.ent.dimension != world.player.dimension || this.ent.entityID == DangerZone.player.entityID || !(this.ent.getDistanceFromEntity(world.player) <= (float)this.ent.maxrenderdist) || !(this.ent.getDistanceFromEntity(world.player) <= (float)(torender * 16)) || this.ent.model == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef(-((world.player.posx - this.ent.posx) * (float)this.blockrenderwidth) + this.f5x, -((world.player.posy + world.player.eyeheight + this.bounce - this.ent.posy) * (float)this.blockrenderwidth) + this.f5y, -((world.player.posz - this.ent.posz) * (float)this.blockrenderwidth) + this.f5z);
            GL11.glRotatef(this.ent.rotation_roll, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(this.ent.rotation_yaw, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.ent.rotation_pitch, 1.0f, 0.0f, 0.0f);
            this.recalcBrightness((int)(this.ent.posy + this.ent.height / 2.0f));
            this.setBrightness(WorldRendererUtils.getLightMapValue(this.ent.world, this.ent.dimension, (int)this.ent.posx, (int)(this.ent.posy + this.ent.height / 2.0f), (int)this.ent.posz));
            this.loadtexture(this.ent.model.getTexture(this.ent));
            this.ent.model.doScale(this.ent);
            this.ouch = 1.0f;
            this.washurt = this.ent.isHurt();
            if (this.washurt) {
                this.ouch = 1.1f;
                GL11.glColor3f(1.0f, 0.15f, 0.15f);
            }
            if (this.ent.getDeathFactor() > 0.1f) {
                this.ouch = this.ent.getDeathFactor();
            }
            velocity = (float)Math.sqrt(this.ent.motionx * this.ent.motionx + this.ent.motiony * this.ent.motiony + this.ent.motionz * this.ent.motionz);
            this.cdir = (float)Math.toRadians(this.ent.rotation_pitch);
            this.tdir = (float)Math.toRadians(this.ent.rotation_pitch_head);
            this.pdiff = this.tdir - this.cdir;
            while ((double)this.pdiff > Math.PI) {
                this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
            }
            while ((double)this.pdiff < -Math.PI) {
                this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
            }
            this.pdiff = (float)Math.toDegrees(this.pdiff);
            this.cdir = (float)Math.toRadians(this.ent.rotation_yaw);
            this.tdir = (float)Math.toRadians(this.ent.rotation_yaw_head);
            this.ydiff = this.tdir - this.cdir;
            while ((double)this.ydiff > Math.PI) {
                this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
            }
            while ((double)this.ydiff < -Math.PI) {
                this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
            }
            this.ydiff = (float)Math.toDegrees(this.ydiff);
            this.cdir = (float)Math.toRadians(this.ent.rotation_roll);
            this.tdir = (float)Math.toRadians(this.ent.rotation_roll_head);
            this.rdiff = this.tdir - this.cdir;
            while ((double)this.rdiff > Math.PI) {
                this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
            }
            while ((double)this.rdiff < -Math.PI) {
                this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
            }
            this.rdiff = (float)Math.toDegrees(this.rdiff);
            this.ent.model.render(this.ent, this.ent.lifetimeticker, velocity, this.pdiff, this.ydiff, this.rdiff, this.ouch);
            if (this.washurt) {
                this.setBrightness();
            }
            GL11.glPopMatrix();
        }
        DangerZone.entityManager.entity_list_lock.unlock();
        DangerZone.particleManager.particle_list_lock.lock();
        for (Particle pst : DangerZone.particleManager.particle_list) {
            if (pst.dimension != world.player.dimension || !(pst.getDistanceFromEntity(world.player) <= (float)pst.maxrenderdist) || !(pst.getDistanceFromEntity(world.player) <= (float)(torender * 16)) || pst.model == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef(-((world.player.posx - pst.posx) * (float)this.blockrenderwidth) + this.f5x, -((world.player.posy + world.player.eyeheight + this.bounce - pst.posy) * (float)this.blockrenderwidth) + this.f5y, -((world.player.posz - pst.posz) * (float)this.blockrenderwidth) + this.f5z);
            GL11.glRotatef(pst.rotation_roll, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(pst.rotation_yaw, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(pst.rotation_pitch, 1.0f, 0.0f, 0.0f);
            this.recalcBrightness((int)pst.posy);
            this.setBrightness(pst.brightness + WorldRendererUtils.getLightMapValue(DangerZone.player.world, pst.dimension, (int)pst.posx, (int)pst.posy, (int)pst.posz));
            GL11.glScalef(pst.scale, pst.scale, pst.scale);
            this.loadtexture(pst.model.getTexture(pst));
            pst.model.renderParticle(pst);
            GL11.glPopMatrix();
        }
        DangerZone.particleManager.particle_list_lock.unlock();
        if (DangerZone.f5_front || DangerZone.f5_back) {
            this.ent = DangerZone.player;
            GL11.glPushMatrix();
            GL11.glTranslatef(-((world.player.posx - this.ent.posx) * (float)this.blockrenderwidth) + this.f5x, -((world.player.posy + world.player.eyeheight + this.bounce - this.ent.posy) * (float)this.blockrenderwidth) + this.f5y, -((world.player.posz - this.ent.posz) * (float)this.blockrenderwidth) + this.f5z);
            float fyw = 360.0f - (this.ent.rotation_yaw + 180.0f) % 360.0f;
            GL11.glRotatef(fyw, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.ent.rotation_pitch, 1.0f, 0.0f, 0.0f);
            this.recalcBrightness((int)(world.player.posy + world.player.height / 2.0f));
            this.setBrightness(WorldRendererUtils.getLightMapValue(world, world.player.dimension, (int)world.player.posx, (int)(world.player.posy + this.ent.height / 2.0f), (int)world.player.posz));
            this.loadtexture(this.ent.model.getTexture(this.ent));
            this.ent.model.doScale(this.ent);
            this.ouch = 1.0f;
            this.washurt = this.ent.isHurt();
            if (this.washurt) {
                this.ouch = 1.1f;
                GL11.glColor3f(1.0f, 0.15f, 0.15f);
            }
            if (this.ent.getDeathFactor() > 0.1f) {
                this.ouch = this.ent.getDeathFactor();
            }
            velocity = (float)Math.sqrt(this.ent.motionx * this.ent.motionx + this.ent.motiony * this.ent.motiony + this.ent.motionz * this.ent.motionz);
            this.cdir = (float)Math.toRadians(this.ent.rotation_pitch);
            this.tdir = (float)Math.toRadians(this.ent.rotation_pitch_head);
            this.pdiff = this.tdir - this.cdir;
            while ((double)this.pdiff > Math.PI) {
                this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
            }
            while ((double)this.pdiff < -Math.PI) {
                this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
            }
            this.pdiff = (float)Math.toDegrees(this.pdiff);
            this.cdir = (float)Math.toRadians(this.ent.rotation_yaw);
            this.tdir = (float)Math.toRadians(this.ent.rotation_yaw_head);
            this.ydiff = this.tdir - this.cdir;
            while ((double)this.ydiff > Math.PI) {
                this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
            }
            while ((double)this.ydiff < -Math.PI) {
                this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
            }
            this.ydiff = (float)Math.toDegrees(this.ydiff);
            this.cdir = (float)Math.toRadians(this.ent.rotation_roll);
            this.tdir = (float)Math.toRadians(this.ent.rotation_roll_head);
            this.rdiff = this.tdir - this.cdir;
            while ((double)this.rdiff > Math.PI) {
                this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
            }
            while ((double)this.rdiff < -Math.PI) {
                this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
            }
            this.rdiff = (float)Math.toDegrees(this.rdiff);
            this.ent.model.render(this.ent, this.ent.lifetimeticker, velocity, this.pdiff, -this.ydiff, this.rdiff, this.ouch);
            if (this.washurt) {
                this.setBrightness();
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (this.hit_cycle_count != 0) {
            i = this.fps / 10;
            if (i < 1) {
                i = 1;
            }
            if (i > 6) {
                i = 6;
            }
            this.hit_cycles = i + 1;
            this.hit_cycle_count += this.hit_cycle_dir;
            if (this.hit_cycle_count >= this.hit_cycles) {
                world.player.leftclick(world, this.focus_x, this.focus_y, this.focus_z, 0);
                this.hit_cycle_dir = -1;
                this.hit_cycle_count = this.hit_cycles;
            }
        } else if (DangerZone.do_hit_cycle != 0) {
            this.hit_cycle_count = 1;
            this.hit_cycle_dir = 1;
        }
        if (world.player.hotbar[world.player.current_hotbar_index] != null && !DangerZone.f5_front && !DangerZone.f5_back) {
            InventoryContainer ic = world.player.hotbar[world.player.current_hotbar_index];
            GL11.glPushMatrix();
            GL11.glTranslatef(6.0f, -(4.0f + this.bounce * 2.0f), -540.0f / (float)DangerZone.fieldOfView);
            GL11.glRotatef(-15.0f, 1.0f, 3.0f, 0.0f);
            this.recalcBrightness((int)(world.player.posy + world.player.height / 2.0f));
            this.setBrightness(WorldRendererUtils.getLightMapValue(world, world.player.dimension, (int)world.player.posx, (int)(world.player.posy + this.ent.height / 2.0f), (int)world.player.posz));
            if (ic.bid != 0) {
                if (this.hit_cycle_count != 0) {
                    GL11.glTranslatef(this.hitx * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f, this.hity * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f, this.hitz * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f);
                    GL11.glRotatef(-this.hitp * ((float)this.hit_cycle_count / (float)this.hit_cycles), 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(this.hitw * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 1.0f, 0.0f);
                    GL11.glRotatef(-this.hitr * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 0.0f, 1.0f);
                }
                GL11.glScalef(0.2f, 0.2f, 0.2f);
                if (Blocks.hasOwnRenderer(ic.bid)) {
                    Blocks.renderMe(this, world, world.player.dimension, (int)world.player.posx, (int)world.player.posy, (int)world.player.posz, ic.bid, 0, 255, false);
                } else {
                    DangerZone.wr.drawTexturedCube(255, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
                }
            } else if (ic.iid != 0) {
                GL11.glScalef(0.35f, 0.35f, 0.35f);
                GL11.glTranslatef(1.0f + DangerZone.testx + this.hitx * ((float)this.hit_cycle_count / (float)this.hit_cycles), 3.0f + DangerZone.testy + this.hity * ((float)this.hit_cycle_count / (float)this.hit_cycles), 3.0f + DangerZone.testz + this.hitz * ((float)this.hit_cycle_count / (float)this.hit_cycles));
                GL11.glRotatef(-91.0f + DangerZone.testp + this.hitp * ((float)this.hit_cycle_count / (float)this.hit_cycles), 1.0f, 0.0f, 0.0f);
                GL11.glRotatef(102.0f + this.bounce * 4.0f + DangerZone.testw + this.hitw * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 1.0f, 0.0f);
                GL11.glRotatef(-124.0f + this.bounce * 4.0f + DangerZone.testr + this.hitr * ((float)this.hit_cycle_count / (float)this.hit_cycles), 0.0f, 0.0f, 1.0f);
                DangerZone.wr.loadtexture(Items.getTexture(ic.iid));
                Items.renderMe(DangerZone.wr, world, world.player.dimension, (int)world.player.posx, (int)world.player.posy, (int)world.player.posz, ic.iid, 0, 0, false);
            }
            GL11.glPopMatrix();
        }
        this.recalcBrightness(60);
        this.setBrightness();
        if (!DangerZone.f5_front && !DangerZone.f5_back) {
            GL11.glDisable(3553);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glLineWidth(1.0f);
            GL11.glBegin(3);
            GL11.glColor3f(0.65f, 0.65f, 0.65f);
            GL11.glVertex3f(-0.04f, 0.0f, -2.0f);
            GL11.glVertex3f(0.04f, 0.0f, -2.0f);
            GL11.glEnd();
            GL11.glBegin(3);
            GL11.glColor3f(0.65f, 0.65f, 0.65f);
            GL11.glVertex3f(0.0f, 0.04f, -2.0f);
            GL11.glVertex3f(0.0f, -0.04f, -2.0f);
            GL11.glEnd();
            GL11.glDisable(3042);
            GL11.glEnable(3553);
        }
        GL11.glDisable(2929);
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, DangerZone.screen_width, 0.0, DangerZone.screen_height, -320.0, 320.0);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable(3553);
        if (this.font == null) {
            this.awtfont = new Font("Times New Roman", 0, 24);
            this.font = new TrueTypeFont(this.awtfont, false);
        }
        WorldRendererUtils.drawHotbar(world);
        WorldRendererUtils.drawHealth(world);
        if (DangerZone.messagetimer > 0 && DangerZone.messagestring != null) {
            --DangerZone.messagetimer;
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2, DangerZone.screen_height / 2, DangerZone.messagestring);
        }
        if (DangerZone.hotmessagetimer > 0 && DangerZone.hotmessagestring != null) {
            --DangerZone.hotmessagetimer;
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2 - 5 * DangerZone.hotmessagestring.length() - 30, 115.0f, DangerZone.hotmessagestring);
        }
        if (DangerZone.f3_on && DangerZone.current_gui == null) {
            String s = String.format("Version: %s", DangerZone.versionstring);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 10, s);
            s = String.format("FPS: %d at Render Distance: %d", this.fps, DangerZone.renderdistance);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 50, s);
            s = String.format("XPOS: %d", (int)DangerZone.player.posx);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 90, s);
            s = String.format("YPOS: %d", (int)DangerZone.player.posy);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 130, s);
            s = String.format("ZPOS: %d", (int)DangerZone.player.posz);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 170, s);
            s = String.format("Packets: %d", this.pps);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 210, s);
            s = String.format("Chunks:  %d", this.cps);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 250, s);
        }
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glPopMatrix();
        GL11.glEnable(2929);
        GL11.glFlush();
    }

    private void find_focus(World w) {
        double delta = 0.0;
        int lz = 0;
        int ly = 0;
        int lx = 0;
        int lfx = this.focus_x;
        int lfy = this.focus_y;
        int lfz = this.focus_z;
        double dir = Math.toRadians((w.player.rotation_yaw_head - 90.0f) % 360.0f);
        double dx = Math.cos(dir);
        double dz = Math.sin(dir);
        double dy = Math.sin(Math.toRadians(w.player.rotation_pitch_head % 360.0f));
        double xzscale = Math.abs(Math.cos(Math.toRadians(w.player.rotation_pitch_head % 360.0f)));
        dx *= xzscale;
        dz *= xzscale;
        dy = -dy;
        int x = (int)w.player.posx;
        int y = (int)(w.player.posy + w.player.eyeheight);
        int z = (int)w.player.posz;
        while (delta < 6.0) {
            x = (int)((double)w.player.posx + dx * delta);
            y = (int)((double)(w.player.posy + w.player.eyeheight) + dy * delta);
            z = (int)((double)w.player.posz + dz * delta);
            if (x != lx || y != ly || z != lz) {
                lx = x;
                ly = y;
                lz = z;
                int bid = w.getblock(w.player.dimension, x, y, z);
                if (bid != 0) {
                    double delta2 = delta;
                    x = (int)((double)w.player.posx + dx * (delta -= (double)0.1f));
                    y = (int)((double)(w.player.posy + w.player.eyeheight) + dy * delta);
                    z = (int)((double)w.player.posz + dz * delta);
                    lx = x;
                    ly = y;
                    lz = z;
                    while (delta < delta2 + (double)0.01f) {
                        x = (int)((double)w.player.posx + dx * delta);
                        y = (int)((double)(w.player.posy + w.player.eyeheight) + dy * delta);
                        z = (int)((double)w.player.posz + dz * delta);
                        if (x != lx || y != ly || z != lz) {
                            lx = x;
                            ly = y;
                            lz = z;
                            bid = w.getblock(w.player.dimension, x, y, z);
                            if (bid != 0) {
                                dx = (float)((double)w.player.posx + dx * delta);
                                dy = (float)((double)(w.player.posy + w.player.eyeheight) + dy * delta);
                                dz = (float)((double)w.player.posz + dz * delta);
                                double dist = 2.0;
                                double lastdist = 2.0;
                                this.focus_side = 0;
                                double sx = (float)x + 0.5f;
                                double sy = (float)y + 1.0f;
                                double sz = (float)z + 0.5f;
                                dist = Math.sqrt((sx - dx) * (sx - dx) + (sy - dy) * (sy - dy) + (sz - dz) * (sz - dz));
                                if (dist < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 0;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.5f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.0f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 2;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.5f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 1.0f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 1;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.0f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.5f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 3;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 1.0f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.5f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 4;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.5f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.0f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.5f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 5;
                                }
                                this.focus_x = lx;
                                this.focus_y = ly;
                                this.focus_z = lz;
                                if (lfx != this.focus_x || lfy != this.focus_y || lfz != this.focus_z) {
                                    this.focus_damage = 0.0f;
                                    this.focus_maxdamage = Blocks.getMaxDamage(bid);
                                    if (this.focus_maxdamage < 1.0f) {
                                        this.focus_maxdamage = 1.0f;
                                    }
                                }
                                return;
                            }
                        }
                        delta += (double)0.01f;
                    }
                }
            }
            delta += 0.1;
        }
        this.focus_z = 0;
        this.focus_y = 0;
        this.focus_x = 0;
    }

    private void renderChunk(World world, int xrel, int zrel, int torender, int shouldcheck) {
        short[] leveldata = null;
        short[] levelmetadata = null;
        short[] prevleveldata = null;
        short[] nextleveldata = null;
        short[] cfrontleveldata = null;
        boolean cfrontleveldatavalid = false;
        short[] cbackleveldata = null;
        boolean cbackleveldatavalid = false;
        short[] cleftleveldata = null;
        boolean cleftleveldatavalid = false;
        short[] crightleveldata = null;
        boolean crightleveldatavalid = false;
        int starty = 0;
        float[] lightmap = null;
        boolean focused = false;
        boolean drew_something = false;
        boolean leveldatainvalid = true;
        short[] drawn = null;
        VBOBuffer v = null;
        boolean must_rebuild = false;
        boolean bidSolid = false;
        int xpos = xrel * 16 + (int)world.player.posx;
        int zpos = zrel * 16 + (int)world.player.posz;
        float dist = (float)Math.sqrt(xrel * xrel + zrel * zrel);
        long[] chunkvbos = world.chunkcache.getDecoratedChunkVBOids(world.player.dimension, xpos, 0, zpos);
        if (chunkvbos == null) {
            return;
        }
        int itemp = 0;
        while (itemp <= 20 && !must_rebuild) {
            if (chunkvbos[itemp] <= 0L) break;
            v = this.VBOmap.get(chunkvbos[itemp]);
            if (v == null) {
                int ivi = 0;
                while (ivi < 20) {
                    if (chunkvbos[itemp] > 0L) {
                        v = this.VBOmap.get(chunkvbos[ivi]);
                        if (v != null) {
                            this.VBOmap.remove(v.VBOid);
                            v.free();
                        }
                        chunkvbos[ivi] = 0L;
                    }
                    ++ivi;
                }
                must_rebuild = true;
            }
            ++itemp;
        }
        if (shouldcheck != 0) {
            must_rebuild = true;
        }
        if (!must_rebuild && (itemp = (int)dist) > 1 && world.rand.nextInt(itemp + 5) != 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef(xrel * 16 * this.blockrenderwidth, 0.0f, zrel * 16 * this.blockrenderwidth);
            itemp = 0;
            while (itemp <= 20) {
                if (chunkvbos[itemp] <= 0L) break;
                v = this.VBOmap.get(chunkvbos[itemp]);
                if (v != null) {
                    if (!v.isTranslucent) {
                        this.loadStitchedtexture(v.textureindex);
                        v.draw();
                    } else {
                        v.xoff = xrel * 16 * this.blockrenderwidth;
                        v.zoff = zrel * 16 * this.blockrenderwidth;
                        this.translucentVBOs.add(v);
                    }
                }
                ++itemp;
            }
            GL11.glPopMatrix();
            return;
        }
        itemp = 0;
        while (itemp <= 20) {
            if (chunkvbos[itemp] <= 0L) break;
            v = this.VBOmap.get(chunkvbos[itemp]);
            if (v != null) {
                v.reset();
            }
            ++itemp;
        }
        if ((drawn = world.chunkcache.getDecoratedChunkDrawn(world.player.dimension, xpos, 0, zpos)) == null) {
            return;
        }
        int chunkX = xpos >> 4;
        int chunkZ = zpos >> 4;
        int j = starty = 0;
        while (j < 256) {
            if (!(Math.sqrt(xrel * xrel + zrel * zrel + ((int)world.player.posy - j) / 16 * (((int)world.player.posy - j) / 16)) > (double)torender)) {
                this.recalcBrightness(j);
                this.setVBOBrightness(0.0f);
                cfrontleveldatavalid = false;
                cbackleveldatavalid = false;
                cleftleveldatavalid = false;
                crightleveldatavalid = false;
                if (shouldcheck == 0 && drawn[j] == 0) {
                    leveldatainvalid = true;
                } else {
                    if (!leveldatainvalid) {
                        if (j < 255) {
                            if (j > 0) {
                                prevleveldata = leveldata;
                                leveldata = nextleveldata;
                                nextleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, xpos, j + 1, zpos);
                            } else {
                                prevleveldata = null;
                                leveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, xpos, j, zpos);
                                nextleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, xpos, j + 1, zpos);
                            }
                        } else {
                            prevleveldata = leveldata;
                            leveldata = nextleveldata;
                            nextleveldata = null;
                        }
                    } else {
                        prevleveldata = null;
                        if (j > 0) {
                            prevleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, xpos, j - 1, zpos);
                        }
                        leveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, xpos, j, zpos);
                        nextleveldata = null;
                        if (j < 255) {
                            nextleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, xpos, j + 1, zpos);
                        }
                        leveldatainvalid = false;
                    }
                    if (leveldata != null) {
                        levelmetadata = world.chunkcache.getDecoratedChunkLevelMetaData(world.player.dimension, xpos, j, zpos);
                        lightmap = world.chunkcache.getDecoratedChunkLightmap(world.player.dimension, xpos, j, zpos);
                        drew_something = false;
                        int i = 0;
                        while (i < 16) {
                            int k = 0;
                            while (k < 16) {
                                int bid = leveldata[i * 16 + k];
                                if (bid != 0 && bid < 2048) {
                                    int meta = 0;
                                    if (levelmetadata != null) {
                                        meta = levelmetadata[i * 16 + k];
                                    }
                                    int sides = 0;
                                    bidSolid = Blocks.isSolidForRender(bid);
                                    int x = chunkX << 4;
                                    int z = chunkZ << 4;
                                    if (x + i > (int)world.player.posx - 2) {
                                        if (i > 0) {
                                            if (this.shouldRenderSide(bid, bidSolid, leveldata[(i - 1) * 16 + k])) {
                                                sides |= 1;
                                            }
                                        } else {
                                            if (!cleftleveldatavalid) {
                                                cleftleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, x + i - 1, j, z + k);
                                                cleftleveldatavalid = true;
                                            }
                                            if (cleftleveldata != null) {
                                                if (this.shouldRenderSide(bid, bidSolid, cleftleveldata[(i - 1 & 0xF) * 16 + k])) {
                                                    sides |= 1;
                                                }
                                            } else {
                                                sides |= 1;
                                            }
                                        }
                                    }
                                    if (x + i < (int)world.player.posx + 2) {
                                        if (i < 15) {
                                            if (this.shouldRenderSide(bid, bidSolid, leveldata[(i + 1) * 16 + k])) {
                                                sides |= 2;
                                            }
                                        } else {
                                            if (!crightleveldatavalid) {
                                                crightleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, x + i + 1, j, z + k);
                                                crightleveldatavalid = true;
                                            }
                                            if (crightleveldata != null) {
                                                if (this.shouldRenderSide(bid, bidSolid, crightleveldata[(i + 1 & 0xF) * 16 + k])) {
                                                    sides |= 2;
                                                }
                                            } else {
                                                sides |= 2;
                                            }
                                        }
                                    }
                                    if (z + k > (int)world.player.posz - 2) {
                                        if (k > 0) {
                                            if (this.shouldRenderSide(bid, bidSolid, leveldata[i * 16 + (k - 1)])) {
                                                sides |= 4;
                                            }
                                        } else {
                                            if (!cbackleveldatavalid) {
                                                cbackleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, x + i, j, z + k - 1);
                                                cbackleveldatavalid = true;
                                            }
                                            if (cbackleveldata != null) {
                                                if (this.shouldRenderSide(bid, bidSolid, cbackleveldata[i * 16 + (k - 1 & 0xF)])) {
                                                    sides |= 4;
                                                }
                                            } else {
                                                sides |= 4;
                                            }
                                        }
                                    }
                                    if (z + k < (int)world.player.posz + 2) {
                                        if (k < 15) {
                                            if (this.shouldRenderSide(bid, bidSolid, leveldata[i * 16 + (k + 1)])) {
                                                sides |= 8;
                                            }
                                        } else {
                                            if (!cfrontleveldatavalid) {
                                                cfrontleveldata = world.chunkcache.getDecoratedChunkLevelData(world.player.dimension, x + i, j, z + k + 1);
                                                cfrontleveldatavalid = true;
                                            }
                                            if (cfrontleveldata != null) {
                                                if (this.shouldRenderSide(bid, bidSolid, cfrontleveldata[i * 16 + (k + 1 & 0xF)])) {
                                                    sides |= 8;
                                                }
                                            } else {
                                                sides |= 8;
                                            }
                                        }
                                    }
                                    if (j > (int)world.player.posy) {
                                        if (prevleveldata == null) {
                                            sides |= 0x10;
                                        } else if (this.shouldRenderSide(bid, bidSolid, prevleveldata[i * 16 + k])) {
                                            sides |= 0x10;
                                        }
                                    }
                                    if (j < 255) {
                                        if (j < (int)world.player.posy + 3) {
                                            if (nextleveldata == null) {
                                                sides |= 0x20;
                                            } else if (this.shouldRenderSide(bid, bidSolid, nextleveldata[i * 16 + k])) {
                                                sides |= 0x20;
                                            }
                                        }
                                    } else {
                                        sides |= 0x20;
                                    }
                                    if (x + i > this.focus_x - 3 && x + i < this.focus_x + 3 && z + k > this.focus_z - 3 && z + k < this.focus_z + 3 && j > this.focus_y - 3 && j < this.focus_y + 3 && this.focus_damage != 0.0f) {
                                        sides = 255;
                                    }
                                    if (DangerZone.view_ores && Ores.isOre(bid)) {
                                        sides = 255;
                                    }
                                    if (sides != 0) {
                                        drew_something = true;
                                        focused = false;
                                        if (j == this.focus_y && x + i == this.focus_x && z + k == this.focus_z) {
                                            focused = true;
                                        }
                                        if (lightmap != null) {
                                            this.setVBOBrightness(lightmap[i * 16 + k]);
                                        } else {
                                            this.setVBOBrightness(0.0f);
                                        }
                                        if (!focused) {
                                            if (Blocks.hasOwnRenderer(bid)) {
                                                Blocks.renderMeToVBO(chunkvbos, this, world, world.player.dimension, x + i, j, z + k, bid, meta, sides, focused, i * this.blockrenderwidth, j * this.blockrenderwidth, k * this.blockrenderwidth);
                                            } else {
                                                this.drawTexturedCubeToVBO(chunkvbos, sides, bid, meta, i * this.blockrenderwidth, j * this.blockrenderwidth, k * this.blockrenderwidth);
                                            }
                                        } else if (!Blocks.isTranslucentForRender(bid)) {
                                            GL11.glPushMatrix();
                                            GL11.glTranslatef(xrel * 16 * this.blockrenderwidth, j * this.blockrenderwidth, zrel * 16 * this.blockrenderwidth);
                                            GL11.glTranslatef(i * this.blockrenderwidth, 0.0f, k * this.blockrenderwidth);
                                            if (this.focus_damage != 0.0f && this.focus_maxdamage > 0.0f) {
                                                GL11.glScalef(1.0f - 0.75f * this.focus_damage / this.focus_maxdamage, 1.0f - 0.75f * this.focus_damage / this.focus_maxdamage, 1.0f - 0.75f * this.focus_damage / this.focus_maxdamage);
                                                GL11.glRotatef((float)((double)(45.0f * this.focus_damage / this.focus_maxdamage) * Math.cos(Math.toRadians(world.player.lifetimeticker * 3L))), 1.0f, 0.0f, 0.0f);
                                                GL11.glRotatef((float)((double)(45.0f * this.focus_damage / this.focus_maxdamage) * Math.cos(Math.toRadians(world.player.lifetimeticker * 7L))), 0.0f, 1.0f, 0.0f);
                                                GL11.glRotatef((float)((double)(45.0f * this.focus_damage / this.focus_maxdamage) * Math.cos(Math.toRadians(world.player.lifetimeticker * 5L))), 0.0f, 0.0f, 1.0f);
                                            }
                                            this.setBrightnessFocus();
                                            if (Blocks.hasOwnRenderer(bid)) {
                                                Blocks.renderMe(this, world, world.player.dimension, x + i, j, z + k, bid, meta, sides, focused);
                                            } else {
                                                this.drawTexturedCube(sides, Blocks.isSolidForRender(bid), bid, meta, focused);
                                            }
                                            this.setBrightness();
                                            GL11.glPopMatrix();
                                            this.focus_bid = 0;
                                        } else {
                                            this.focus_bid = bid;
                                            this.focus_meta = meta;
                                            this.focus_xpos = xrel * 16 * this.blockrenderwidth + i * this.blockrenderwidth;
                                            this.focus_ypos = j * this.blockrenderwidth;
                                            this.focus_zpos = zrel * 16 * this.blockrenderwidth + k * this.blockrenderwidth;
                                        }
                                    }
                                }
                                ++k;
                            }
                            ++i;
                        }
                        drawn[j] = drew_something ? (short)1 : 0;
                    }
                }
            }
            ++j;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(xrel * 16 * this.blockrenderwidth, 0.0f, zrel * 16 * this.blockrenderwidth);
        itemp = 0;
        while (itemp <= 20) {
            if (chunkvbos[itemp] <= 0L) break;
            v = this.VBOmap.get(chunkvbos[itemp]);
            if (v != null) {
                v.sendNewData();
                if (!v.isTranslucent) {
                    this.loadStitchedtexture(v.textureindex);
                    v.draw();
                } else {
                    v.xoff = xrel * 16 * this.blockrenderwidth;
                    v.zoff = zrel * 16 * this.blockrenderwidth;
                    this.translucentVBOs.add(v);
                }
            }
            ++itemp;
        }
        GL11.glPopMatrix();
    }

    private boolean shouldRenderSide(int bid, boolean thisIsSolid, int thatbid) {
        if (thatbid == 0) {
            return true;
        }
        boolean thatIsSolid = Blocks.isSolidForRender(thatbid);
        if (thisIsSolid && thatIsSolid) {
            return false;
        }
        if (thisIsSolid && !thatIsSolid) {
            return true;
        }
        if (!thisIsSolid && !thatIsSolid && bid == thatbid) {
            return false;
        }
        return thisIsSolid || !thatIsSolid;
    }

    public void drawTexturedCube(int sides, boolean isSolid, int bid, int meta, boolean focus) {
        if (!isSolid) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        }
        if ((meta & 0xFC00) != 0) {
            GL11.glPushMatrix();
            if ((meta & 0xC000) == 16384) {
                GL11.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0xC000) == 32768) {
                GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0xC000) == 49152) {
                GL11.glRotatef(270.0f, 1.0f, 0.0f, 0.0f);
            }
            if ((meta & 0x3000) == 4096) {
                GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0x3000) == 8192) {
                GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0x3000) == 12288) {
                GL11.glRotatef(270.0f, 0.0f, 1.0f, 0.0f);
            }
            if ((meta & 0xC00) == 1024) {
                GL11.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            }
            if ((meta & 0xC00) == 2048) {
                GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            }
            if ((meta & 0xC00) == 3072) {
                GL11.glRotatef(270.0f, 0.0f, 0.0f, 1.0f);
            }
            sides = 255;
        }
        if (!compiled) {
            this.topid = this.getNextRenderID();
            GL11.glNewList(this.topid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glEnd();
            GL11.glEndList();
            this.bottomid = this.getNextRenderID();
            GL11.glNewList(this.bottomid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glEnd();
            GL11.glEndList();
            this.frontid = this.getNextRenderID();
            GL11.glNewList(this.frontid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glEnd();
            GL11.glEndList();
            this.backid = this.getNextRenderID();
            GL11.glNewList(this.backid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glEnd();
            GL11.glEndList();
            this.leftid = this.getNextRenderID();
            GL11.glNewList(this.leftid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glEnd();
            GL11.glEndList();
            this.rightid = this.getNextRenderID();
            GL11.glNewList(this.rightid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glEnd();
            GL11.glEndList();
            compiled = true;
        }
        if ((sides & 0x20) != 0 && this.loadtextureforblockside(0, bid, isSolid)) {
            GL11.glCallList(this.topid);
        }
        if ((sides & 0x10) != 0 && this.loadtextureforblockside(5, bid, isSolid)) {
            GL11.glCallList(this.bottomid);
        }
        if ((sides & 8) != 0 && this.loadtextureforblockside(1, bid, isSolid)) {
            GL11.glCallList(this.frontid);
        }
        if ((sides & 4) != 0 && this.loadtextureforblockside(2, bid, isSolid)) {
            GL11.glCallList(this.backid);
        }
        if ((sides & 1) != 0 && this.loadtextureforblockside(3, bid, isSolid)) {
            GL11.glCallList(this.leftid);
        }
        if ((sides & 2) != 0 && this.loadtextureforblockside(4, bid, isSolid)) {
            GL11.glCallList(this.rightid);
        }
        if (focus && this.focus_side == 0) {
            GL11.glLineWidth(this.linewidth);
            GL11.glBegin(3);
            GL11.glColor3f(0.0f, 0.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glEnd();
        }
        if (focus && this.focus_side == 5) {
            GL11.glLineWidth(this.linewidth);
            GL11.glBegin(3);
            GL11.glColor3f(0.0f, 0.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glEnd();
        }
        if (focus && this.focus_side == 1) {
            GL11.glLineWidth(this.linewidth);
            GL11.glBegin(3);
            GL11.glColor3f(0.0f, 0.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glEnd();
        }
        if (focus && this.focus_side == 2) {
            GL11.glLineWidth(this.linewidth);
            GL11.glBegin(3);
            GL11.glColor3f(0.0f, 0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glEnd();
        }
        if (focus && this.focus_side == 3) {
            GL11.glLineWidth(this.linewidth);
            GL11.glBegin(3);
            GL11.glColor3f(0.0f, 0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(-this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glEnd();
        }
        if (focus && this.focus_side == 4) {
            GL11.glLineWidth(this.linewidth);
            GL11.glBegin(3);
            GL11.glColor3f(0.0f, 0.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, -this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glVertex3f(this.blockrenderwidth / 2, this.blockrenderwidth / 2, -this.blockrenderwidth / 2);
            GL11.glEnd();
        }
        if ((meta & 0xFC00) != 0) {
            GL11.glPopMatrix();
        }
        if (!isSolid) {
            GL11.glDisable(3042);
        }
    }

    public void drawTexturedCubeToVBO(long[] chunkvbos, int sides, int bid, int meta, int xo, int yo, int zo) {
        boolean tr = Blocks.isTranslucentForRender(bid);
        if (Blocks.isLiquid(bid)) {
            this.drawLiquidTexturedCubeToVBO(chunkvbos, sides, bid, meta, xo, yo, zo, tr);
            return;
        }
        if ((meta & 0xFC00) != 0) {
            this.drawRotatedTexturedCubeToVBO(chunkvbos, sides, bid, meta, xo, yo, zo, tr);
            return;
        }
        VBOBuffer v = null;
        StitchedTexture st = null;
        int brw = this.blockrenderwidth / 2;
        if ((sides & 0x20) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(0, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 0x10) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(5, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 8) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(1, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 4) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(2, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 1) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(3, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 2) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(4, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
    }

    public void drawLiquidTexturedCubeToVBO(long[] chunkvbos, int sides, int bid, int meta, int xo, int yo, int zo, boolean tr) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        int brw = this.blockrenderwidth / 2;
        int brfl = meta >> 12 & 0xF;
        int brfr = meta >> 8 & 0xF;
        int brbl = meta >> 4 & 0xF;
        int brbr = meta & 0xF;
        brfl = brw - brfl;
        brfr = brw - brfr;
        brbl = brw - brbl;
        brbr = brw - brbr;
        if ((sides & 0x20) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(0, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brbr + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brbl + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brfl + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, brfr + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 0x10) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(5, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 8) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(1, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brfr + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brfl + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 4) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(2, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + xo, brbl + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, brbr + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 1) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(3, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + xo, brfl + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, brbl + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 2) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, st = this.findVBOtextureforblockside(4, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brbr + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, brfr + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, this.cbr, this.cbg, this.cbb);
        }
    }

    private void rotate90(float[] coords) {
        float tmp1 = coords[7];
        float tmp2 = coords[6];
        coords[7] = coords[5];
        coords[6] = coords[4];
        coords[5] = coords[3];
        coords[4] = coords[2];
        coords[3] = coords[1];
        coords[2] = coords[0];
        coords[1] = tmp1;
        coords[0] = tmp2;
    }

    private void rotate180(float[] coords) {
        this.rotate90(coords);
        this.rotate90(coords);
    }

    private void rotate270(float[] coords) {
        float tmp1 = coords[0];
        float tmp2 = coords[1];
        coords[0] = coords[2];
        coords[1] = coords[3];
        coords[2] = coords[4];
        coords[3] = coords[5];
        coords[4] = coords[6];
        coords[5] = coords[7];
        coords[6] = tmp1;
        coords[7] = tmp2;
    }

    public void drawRotatedTexturedCubeToVBO(long[] chunkvbos, int sides, int bid, int meta, int xo, int yo, int zo, boolean tr) {
        VBOBuffer v = null;
        int stp = 0;
        int sbm = 5;
        int sf = 1;
        int sb = 2;
        int sl = 3;
        int sr = 4;
        int tmp = 0;
        while (tmp < 6) {
            this.rot_st[tmp] = this.findVBOtextureforblockside(tmp, bid);
            this.tcoords[tmp][0] = this.rot_st[tmp].xoffsetmax;
            this.tcoords[tmp][1] = this.rot_st[tmp].yoffsetmin;
            this.tcoords[tmp][2] = this.rot_st[tmp].xoffsetmin;
            this.tcoords[tmp][3] = this.rot_st[tmp].yoffsetmin;
            this.tcoords[tmp][4] = this.rot_st[tmp].xoffsetmin;
            this.tcoords[tmp][5] = this.rot_st[tmp].yoffsetmax;
            this.tcoords[tmp][6] = this.rot_st[tmp].xoffsetmax;
            this.tcoords[tmp][7] = this.rot_st[tmp].yoffsetmax;
            ++tmp;
        }
        if ((meta & 0xC000) == 0) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) != 0) {
                    if ((meta & 0xC00) == 1024) {
                        stp = 4;
                        sbm = 3;
                        sf = 1;
                        sb = 2;
                        sr = 5;
                        sl = 0;
                        this.rotate90(this.tcoords[1]);
                        this.rotate270(this.tcoords[2]);
                        this.rotate90(this.tcoords[0]);
                        this.rotate90(this.tcoords[5]);
                        this.rotate90(this.tcoords[3]);
                        this.rotate90(this.tcoords[4]);
                    } else if ((meta & 0xC00) == 2048) {
                        stp = 5;
                        sbm = 0;
                        sf = 1;
                        sb = 2;
                        sr = 3;
                        sl = 4;
                        this.rotate180(this.tcoords[1]);
                        this.rotate180(this.tcoords[2]);
                        this.rotate180(this.tcoords[0]);
                        this.rotate180(this.tcoords[5]);
                        this.rotate180(this.tcoords[3]);
                        this.rotate180(this.tcoords[4]);
                    } else if ((meta & 0xC00) == 3072) {
                        stp = 3;
                        sbm = 4;
                        sf = 1;
                        sb = 2;
                        sr = 0;
                        sl = 5;
                        this.rotate270(this.tcoords[1]);
                        this.rotate90(this.tcoords[2]);
                        this.rotate270(this.tcoords[0]);
                        this.rotate270(this.tcoords[5]);
                        this.rotate270(this.tcoords[3]);
                        this.rotate270(this.tcoords[4]);
                    }
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                    this.rotate180(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 0;
                    sbm = 5;
                    sf = 2;
                    sb = 1;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 4;
                    sbm = 3;
                    sf = 2;
                    sb = 1;
                    sr = 0;
                    sl = 5;
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 5;
                    sbm = 0;
                    sf = 2;
                    sb = 1;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 3;
                    sbm = 4;
                    sf = 2;
                    sb = 1;
                    sr = 5;
                    sl = 0;
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 3;
                    sbm = 0;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 3;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[5]);
                }
            }
        } else if ((meta & 0xC000) == 16384) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) == 0) {
                    stp = 2;
                    sbm = 1;
                    sf = 0;
                    sb = 5;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 2;
                    sbm = 1;
                    sf = 4;
                    sb = 3;
                    sr = 5;
                    sl = 0;
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 2;
                    sbm = 1;
                    sf = 5;
                    sb = 0;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[1]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 2;
                    sbm = 1;
                    sf = 3;
                    sb = 4;
                    sr = 0;
                    sl = 5;
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 1;
                    sbm = 2;
                    sf = 0;
                    sb = 5;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 1;
                    sbm = 2;
                    sf = 4;
                    sb = 3;
                    sr = 0;
                    sl = 5;
                    this.rotate180(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 1;
                    sbm = 2;
                    sf = 5;
                    sb = 0;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 1;
                    sbm = 2;
                    sf = 3;
                    sb = 4;
                    sr = 5;
                    sl = 0;
                    this.rotate180(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 3;
                    sbm = 4;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            }
        } else if ((meta & 0xC000) == 32768) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 2;
                    sb = 1;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 2;
                    sb = 1;
                    sr = 5;
                    sl = 0;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 2;
                    sb = 1;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 2;
                    sb = 1;
                    sr = 0;
                    sl = 5;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 1;
                    sb = 2;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 1;
                    sb = 2;
                    sr = 0;
                    sl = 5;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 1;
                    sb = 2;
                    sr = 4;
                    sl = 3;
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 1;
                    sb = 2;
                    sr = 5;
                    sl = 0;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                }
            }
        } else if ((meta & 0xC000) == 49152) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) == 0) {
                    stp = 1;
                    sbm = 2;
                    sf = 5;
                    sb = 0;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 1;
                    sbm = 2;
                    sf = 3;
                    sb = 4;
                    sr = 5;
                    sl = 0;
                    this.rotate180(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 1;
                    sbm = 2;
                    sf = 0;
                    sb = 5;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 1;
                    sbm = 2;
                    sf = 4;
                    sb = 3;
                    sr = 0;
                    sl = 5;
                    this.rotate180(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 2;
                    sbm = 1;
                    sf = 5;
                    sb = 0;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[1]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 2;
                    sbm = 1;
                    sf = 3;
                    sb = 4;
                    sr = 0;
                    sl = 5;
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 2;
                    sbm = 1;
                    sf = 0;
                    sb = 5;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 2;
                    sbm = 1;
                    sf = 4;
                    sb = 3;
                    sr = 5;
                    sl = 0;
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 3;
                    sbm = 4;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                }
            }
        }
        if ((sides & 0x20) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, this.rot_st[stp], tr)) != null) {
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[stp][0], this.tcoords[stp][1], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[stp][2], this.tcoords[stp][3], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[stp][4], this.tcoords[stp][5], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[stp][6], this.tcoords[stp][7], this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 0x10) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sbm], tr)) != null) {
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sbm][0], this.tcoords[sbm][1], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sbm][2], this.tcoords[sbm][3], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sbm][4], this.tcoords[sbm][5], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sbm][6], this.tcoords[sbm][7], this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 8) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sf], tr)) != null) {
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sf][0], this.tcoords[sf][1], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sf][2], this.tcoords[sf][3], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sf][4], this.tcoords[sf][5], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sf][6], this.tcoords[sf][7], this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 4) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sb], tr)) != null) {
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sb][0], this.tcoords[sb][1], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sb][2], this.tcoords[sb][3], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sb][4], this.tcoords[sb][5], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sb][6], this.tcoords[sb][7], this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 1) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sl], tr)) != null) {
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sl][0], this.tcoords[sl][1], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sl][2], this.tcoords[sl][3], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sl][4], this.tcoords[sl][5], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sl][6], this.tcoords[sl][7], this.cbr, this.cbg, this.cbb);
        }
        if ((sides & 2) != 0 && (v = this.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sr], tr)) != null) {
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sr][0], this.tcoords[sr][1], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sr][2], this.tcoords[sr][3], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, this.blockrenderwidth / 2 + zo, this.tcoords[sr][4], this.tcoords[sr][5], this.cbr, this.cbg, this.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2 + xo, -this.blockrenderwidth / 2 + yo, -this.blockrenderwidth / 2 + zo, this.tcoords[sr][6], this.tcoords[sr][7], this.cbr, this.cbg, this.cbb);
        }
    }

    public VBOBuffer findOrMakeVBOForTexture(long[] cvs, StitchedTexture st, boolean translucent) {
        VBOBuffer v = null;
        int i = 0;
        while (i < 20) {
            if (cvs[i] <= 0L) break;
            v = this.VBOmap.get(cvs[i]);
            if (v != null && v.textureindex == st.texturesindex && translucent == v.isTranslucent) {
                return v;
            }
            ++i;
        }
        if (i >= 20) {
            return null;
        }
        v = new VBOBuffer();
        v.textureindex = st.texturesindex;
        v.VBOid = this.getNextVBOid();
        v.isTranslucent = translucent;
        this.VBOmap.put(v.VBOid, v);
        cvs[i] = v.VBOid;
        return v;
    }

    public StitchedTexture findVBOtextureforblockside(int side, int bid) {
        StitchedTexture st = Blocks.BlockArray[bid].getStitchedTexture(side);
        if (st.texturesindex < 0) {
            StitchedTextureFile stf = stitches[next_stitch];
            if (stf == null) {
                WorldRenderer.stitches[WorldRenderer.next_stitch] = new StitchedTextureFile();
            }
            stf = stitches[next_stitch];
            if (stf.nexty >= 32) {
                WorldRenderer.stitches[++WorldRenderer.next_stitch] = new StitchedTextureFile();
            }
            st.texturesindex = next_stitch;
            StitchedTexture stnew = stitches[next_stitch].addTexture(Blocks.BlockArray[bid].getStitchedTextureName(side));
            if (stnew != null) {
                st.yoffsetmax = stnew.yoffsetmax;
                st.yoffsetmin = stnew.yoffsetmin;
                st.xoffsetmax = stnew.xoffsetmax;
                st.xoffsetmin = stnew.xoffsetmin;
            }
        }
        return st;
    }

    public void loadStitchedtexture(int which) {
        if (stitches[which] != null && this.last_texture != WorldRenderer.stitches[which].textureID) {
            stitches[which].bind();
            this.last_texture = WorldRenderer.stitches[which].textureID;
        }
    }

    public boolean loadtextureforblockside(int side, int bid, boolean solid) {
        Texture lt = Blocks.BlockArray[bid].getTexture(side);
        if (lt == null) {
            return false;
        }
        if (this.last_texture != lt.getTextureID()) {
            TextureImpl.unbind();
            lt.bind();
            this.last_texture = lt.getTextureID();
            GL11.glTexParameteri(3553, 10241, 9728);
            GL11.glTexParameteri(3553, 10240, 9728);
        }
        return true;
    }

    public boolean loadtexture(Texture lt) {
        if (lt == null) {
            return false;
        }
        this.last_texture = -1;
        TextureImpl.unbind();
        lt.bind();
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        return true;
    }

    public void recalcBrightness(int yp) {
        float f = WorldRendererUtils.getBrightnessForLevel(yp);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.brightness_green = this.brightness_blue = f;
        this.brightness_red = this.brightness_blue;
    }

    public void recalcSkyBrightness() {
        float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
        float fsin = (float)Math.sin(Math.toRadians(tod / (float)DangerZone.world.lengthOfDay * 360.0f));
        float fsky = 0.5f + 0.45f * fsin;
        this.sky_red = 0.2f * fsky;
        this.sky_green = 0.4f * fsky;
        this.sky_blue = 1.0f * fsky;
    }

    public void setBrightness() {
        GL11.glColor3f(this.brightness_red, this.brightness_green, this.brightness_blue);
    }

    public void setBrightness(float m) {
        float flb;
        float flg;
        float flr = this.brightness_red + m;
        if (flr < 0.0f) {
            flr = 0.0f;
        }
        if (flr > 1.0f) {
            flr = 1.0f;
        }
        if ((flg = this.brightness_green + m) < 0.0f) {
            flg = 0.0f;
        }
        if (flg > 1.0f) {
            flg = 1.0f;
        }
        if ((flb = this.brightness_blue + m) < 0.0f) {
            flb = 0.0f;
        }
        if (flb > 1.0f) {
            flb = 1.0f;
        }
        GL11.glColor3f(flr, flg, flb);
    }

    public void setVBOBrightness(float m) {
        float flb;
        float flg;
        float flr = this.brightness_red + m;
        if (flr < 0.0f) {
            flr = 0.0f;
        }
        if (flr > 1.0f) {
            flr = 1.0f;
        }
        if ((flg = this.brightness_green + m) < 0.0f) {
            flg = 0.0f;
        }
        if (flg > 1.0f) {
            flg = 1.0f;
        }
        if ((flb = this.brightness_blue + m) < 0.0f) {
            flb = 0.0f;
        }
        if (flb > 1.0f) {
            flb = 1.0f;
        }
        this.cbr = flr;
        this.cbg = flg;
        this.cbb = flb;
    }

    public void setBrightnessFocus() {
        float bval = 1.0f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.5f;
        }
        GL11.glColor3f(bval, bval, bval);
    }

    public void setBrightnessNonFocus() {
        float bval = 0.75f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.25f;
        }
        GL11.glColor3f(bval, bval, bval);
    }

    public int getNextRenderID() {
        this.lock.lock();
        int i = GL11.glGenLists(1);
        this.lock.unlock();
        return i;
    }

    public long getNextVBOid() {
        this.lock.lock();
        long i = this.nextVBOid++;
        this.lock.unlock();
        return i;
    }

    public void deleteVBOlist(long[] vboids) {
        this.VBOlistlock.lock();
        this.VBO_delete_list.add(vboids);
        this.VBOlistlock.unlock();
    }
}

