/*
 * Decompiled with CFR 0.152.
 */
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class VBOBuffer {
    public FloatBuffer vbodata = null;
    public int vcount = 0;
    public int vmax = 0;
    public int stride = 0;
    public int vertexoff = 0;
    public int textureoff = this.stride = 12;
    public int coloroff = 0;
    public int glvboID = 0;
    public int textureindex = 0;
    public long VBOid = 0L;
    public boolean isTranslucent = false;
    public int xoff;
    public int zoff;

    public VBOBuffer() {
        this.stride += 8;
        this.coloroff = this.stride;
        this.stride += 12;
        this.vmax = 4096;
        this.vbodata = BufferUtils.createFloatBuffer(this.vmax * this.stride);
        this.glvboID = GL15.glGenBuffers();
        this.isTranslucent = false;
        this.zoff = 0;
        this.xoff = 0;
    }

    public void addVertexInfoToVBO(float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        if (this.vcount >= this.vmax) {
            this.vmax += 4096;
            FloatBuffer newvbodata = BufferUtils.createFloatBuffer(this.vmax * this.stride);
            this.vbodata.rewind();
            newvbodata.put(this.vbodata);
            this.vbodata = newvbodata;
            this.vbodata.limit(this.vbodata.capacity());
        }
        this.vbodata.put(vx);
        this.vbodata.put(vy);
        this.vbodata.put(vz);
        this.vbodata.put(tx);
        this.vbodata.put(ty);
        this.vbodata.put(br);
        this.vbodata.put(bg);
        this.vbodata.put(bb);
        ++this.vcount;
    }

    public void draw() {
        if (this.vcount <= 0) {
            return;
        }
        this.vbodata.position(0);
        this.vbodata.limit(this.stride * this.vcount);
        GL11.glEnableClientState(32884);
        GL11.glEnableClientState(32888);
        GL11.glEnableClientState(32886);
        GL15.glBindBuffer(34962, this.glvboID);
        GL11.glVertexPointer(3, 5126, this.stride, 0L);
        GL11.glColorPointer(3, 5126, this.stride, this.coloroff);
        GL11.glTexCoordPointer(2, 5126, this.stride, this.textureoff);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glDrawArrays(7, 0, this.vcount);
        GL11.glDisable(3042);
        GL15.glBindBuffer(34962, 0);
        GL11.glDisableClientState(32886);
        GL11.glDisableClientState(32888);
        GL11.glDisableClientState(32884);
        this.vbodata.limit(this.vbodata.capacity());
    }

    public void sendNewData() {
        GL15.glBindBuffer(34962, this.glvboID);
        this.vbodata.position(0);
        this.vbodata.limit(this.stride * this.vcount);
        GL15.glBufferData(34962, this.vbodata, 35048);
        GL15.glBindBuffer(34962, 0);
        this.vbodata.limit(this.vbodata.capacity());
    }

    public void reset() {
        this.vbodata.position(0);
        this.vbodata.limit(this.vbodata.capacity());
        this.vcount = 0;
    }

    public void free() {
        GL15.glBindBuffer(34962, 0);
        GL15.glDeleteBuffers(this.glvboID);
    }
}

