/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Utils {
    public static void screenshot(int width, int height) {
        GL11.glReadBuffer(1028);
        int bpp = 4;
        ByteBuffer buffer = BufferUtils.createByteBuffer(width * height * bpp);
        GL11.glReadPixels(0, 0, width, height, 6408, 5121, buffer);
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HHmmss");
        String filepath = new String();
        filepath = String.format("screenshots\\DZimage_%s.png", df.format(date));
        File file = new File(filepath);
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (IOException e1) {
            return;
        }
        String format = "PNG";
        BufferedImage image = new BufferedImage(width, height, 1);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int i = (x + width * y) * bpp;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                image.setRGB(x, height - (y + 1), 0xFF000000 | r << 16 | g << 8 | b);
                ++y;
            }
            ++x;
        }
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        image.flush();
    }

    public static float getDistanceBetweenEntities(Entity e, Entity p) {
        float d1 = p.posx - e.posx;
        float d2 = p.posy - e.posy;
        float d3 = p.posz - e.posz;
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public static int getPropertyInt(Properties prop, String propname, int min, int max, int dflt) {
        int retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Integer.parseInt(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static long getPropertyLong(Properties prop, String propname, long min, long max, long dflt) {
        long retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Long.parseLong(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt) {
        float retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Float.parseFloat(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt) {
        double retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Double.parseDouble(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static boolean getPropertyBoolean(Properties prop, String propname, boolean dflt) {
        boolean retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Boolean.parseBoolean(s);
        }
        return retval;
    }

    public static String getPropertyString(Properties prop, String propname, String dflt) {
        String retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = s;
        }
        return retval;
    }

    public static void spawnParticlesFromServer(World w, String name, int howmany, int d, float x, float y, float z) {
        if (w.isServer) {
            DangerZone.server.sendSpawnParticleToAllExcept(null, name, howmany, d, x, y, z);
        }
    }

    public static void spawnParticles(World w, String name, int howmany, int d, float x, float y, float z, boolean forwardtoserver) {
        if (!w.isServer) {
            int i = 0;
            while (i < howmany) {
                Particle eb = w.createParticleByName(name, d, x, y, z);
                if (eb != null) {
                    w.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        if (forwardtoserver) {
            DangerZone.player.server_connection.sendSpawnParticles(name, howmany, d, x, y, z);
        }
    }

    public static void spawnDeathParticles(World w, int d, float x, float y, float z, float width, float height) {
        if (!w.isServer) {
            float mf;
            int howmany = (int)(3.0f * (width + height));
            if (howmany < 1) {
                howmany = 1;
            }
            if (howmany > 200) {
                howmany = 200;
            }
            if ((mf = width + height / 2.0f) < 0.5f) {
                mf = 0.5f;
            }
            if (mf > 10.0f) {
                mf = 10.0f;
            }
            int i = 0;
            while (i < howmany) {
                Particle eb = w.createParticleByName("DangerZone:ParticleDeath", d, x, y, z);
                if (eb != null) {
                    eb.motionx *= mf;
                    eb.motiony *= mf;
                    eb.motionz *= mf;
                    w.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
    }

    public static void spitInventoryOut(InventoryContainer ic) {
        if (ic != null) {
            int i = 0;
            while (i < ic.count) {
                EntityBlockItem e = (EntityBlockItem)DangerZone.player.world.createEntityByName(DangerZone.blockitemname, DangerZone.player.dimension, DangerZone.player.posx + (float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)), DangerZone.player.posy + DangerZone.player.height * 7.0f / 8.0f - (float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f, DangerZone.player.posz + (float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)));
                if (e != null) {
                    e.setBID(ic.bid);
                    e.setIID(ic.iid);
                    e.setItemDamage(ic.currentuses);
                    e.rotation_pitch = DangerZone.world.rand.nextInt(360);
                    e.rotation_yaw = DangerZone.world.rand.nextInt(360);
                    e.rotation_roll = DangerZone.world.rand.nextInt(360);
                    e.motionx = (float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f;
                    e.motiony = -((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)));
                    e.motionz = (float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f;
                    DangerZone.player.world.spawnEntityInWorld(e);
                }
                ++i;
            }
        }
    }
}

