/*
 * Decompiled with CFR 0.152.
 */
public class Trees {
    public void addWoodTrees(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        if (world.rand.nextInt(5) != 0) {
            return;
        }
        int howmany = 0;
        int what = world.rand.nextInt(5);
        howmany = world.rand.nextInt(5);
        if (what != 0) {
            howmany *= 2;
        }
        int i = 0;
        while (i < howmany) {
            int posX = 4 + chunkX + world.rand.nextInt(12);
            int posZ = 4 + chunkZ + world.rand.nextInt(12);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (what == 0) {
                        this.TallWoodTree(world, d, posX, posY, posZ);
                        break;
                    }
                    if (what == 1) {
                        this.TallWillowTree(world, d, posX, posY, posZ);
                        break;
                    }
                    this.ScragglyRedwoodTree(world, d, posX, posY, posZ);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addTrees(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        if (world.rand.nextInt(5) != 0) {
            return;
        }
        int howmany = 0;
        int what = world.rand.nextInt(5);
        howmany = world.rand.nextInt(5);
        if (what != 0) {
            howmany *= 2;
        }
        int i = 0;
        while (i < howmany) {
            int posX = 4 + chunkX + world.rand.nextInt(12);
            int posZ = 4 + chunkZ + world.rand.nextInt(12);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (what == 0) {
                        this.ScragglyTreeWithBranches(world, d, posX, posY, posZ);
                        break;
                    }
                    if (what == 1) {
                        this.ScragglyTreeWithBranches(world, d, posX, posY, posZ);
                        break;
                    }
                    if (world.rand.nextInt(20) == 0) {
                        this.MakeBigRoundTree(world, d, posX, posY, posZ, Blocks.redwoodlog.blockID, Blocks.redwoodleaves.blockID, 6);
                    }
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addGrass(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        int howmany = 0;
        howmany = 5 + world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    world.setblock(d, posX, posY, posZ, Blocks.grass.blockID);
                    break;
                }
                --posY;
            }
            ++i;
        }
    }

    public void makeScragglyRedwoodTreeBranch(World world, int d, int x, int y, int z, int len, int biasx, int biasz) {
        int k = 0;
        while (k < len) {
            int iy;
            int bid;
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2) + biasx;
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2) + biasz;
            if (ix > 1) {
                ix = 1;
            }
            if (ix < -1) {
                ix = -1;
            }
            if (iz > 1) {
                iz = 1;
            }
            if (iz < -1) {
                iz = -1;
            }
            if ((bid = world.getblock(d, x += ix, y += (iy = world.rand.nextInt(3) > 0 ? 1 : 0), z += iz)) != 0 && bid != Blocks.redwoodlog.blockID && bid != Blocks.redwoodleaves.blockID) {
                return;
            }
            world.setblock(d, x, y, z, Blocks.redwoodlog.blockID);
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblock(d, x + m, y, z + n, Blocks.redwoodleaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblock(d, x, y + 1, z, Blocks.redwoodleaves.blockID);
            }
            ++k;
        }
    }

    public void ScragglyRedwoodTree(World world, int d, int x, int y, int z) {
        int bid;
        int i = 1 + world.rand.nextInt(2);
        int j = i + world.rand.nextInt(8);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.redwoodlog.blockID && bid != Blocks.redwoodleaves.blockID) {
                return;
            }
            world.setblock(d, x, y + k, z, Blocks.redwoodlog.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iy = world.rand.nextInt(4) > 0 ? 1 : 0;
            bid = world.getblock(d, x += ix, y += iy, z += iz);
            if (bid != 0 && bid != Blocks.redwoodlog.blockID && bid != Blocks.redwoodleaves.blockID) break;
            world.setblock(d, x, y, z, Blocks.redwoodlog.blockID);
            if (world.rand.nextInt(4) == 1) {
                this.makeScragglyRedwoodTreeBranch(world, d, x, y, z, world.rand.nextInt(1 + j - k), world.rand.nextInt(2) - world.rand.nextInt(2), world.rand.nextInt(2) - world.rand.nextInt(2));
            }
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblock(d, x + m, y, z + n, Blocks.redwoodleaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblock(d, x, y + 1, z, Blocks.redwoodleaves.blockID);
            }
            ++k;
        }
    }

    public void TallWillowTree(World world, int d, int x, int y, int z) {
        int n;
        int m;
        int bid;
        int i = 10 + world.rand.nextInt(12);
        int j = i + world.rand.nextInt(18);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.willowlog.blockID && bid != Blocks.willowleaves.blockID) {
                return;
            }
            world.setblock(d, x, y + k, z, Blocks.willowlog.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            if ((bid = world.getblock(d, x, ++y, z)) != 0 && bid != Blocks.willowlog.blockID && bid != Blocks.willowleaves.blockID) break;
            world.setblock(d, x, y, z, Blocks.willowlog.blockID);
            if (k % 4 == 0) {
                m = -1;
                while (m < 2) {
                    n = -1;
                    while (n < 2) {
                        if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                            world.setblock(d, x + m, y, z + n, Blocks.willowleaves.blockID);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++k;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                    world.setblock(d, x + m, y, z + n, Blocks.willowlog.blockID);
                }
                ++n;
            }
            ++m;
        }
        m = -3;
        while (m < 4) {
            n = -3;
            while (n < 4) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblock(d, x + m, y, z + n, Blocks.willowleaves.blockID);
                }
                ++n;
            }
            ++m;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblock(d, x + m, y, z + n, Blocks.willowleaves.blockID);
                }
                ++n;
            }
            ++m;
        }
    }

    public void TallWoodTree(World world, int d, int x, int y, int z) {
        int n;
        int m;
        int bid;
        int i = 5 + world.rand.nextInt(6);
        int j = 2 + i + world.rand.nextInt(12);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) {
                return;
            }
            world.setblock(d, x, y + k, z, Blocks.log.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            if ((bid = world.getblock(d, x, ++y, z)) != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) break;
            world.setblock(d, x, y, z, Blocks.log.blockID);
            if (k % 4 == 0) {
                m = -1;
                while (m < 2) {
                    n = -1;
                    while (n < 2) {
                        if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                            world.setblock(d, x + m, y, z + n, Blocks.leaves.blockID);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++k;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                    world.setblock(d, x + m, y, z + n, Blocks.log.blockID);
                }
                ++n;
            }
            ++m;
        }
        m = -3;
        while (m < 4) {
            n = -3;
            while (n < 4) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblock(d, x + m, y, z + n, Blocks.leaves.blockID);
                }
                ++n;
            }
            ++m;
        }
        ++y;
        m = -1;
        while (m < 2) {
            n = -1;
            while (n < 2) {
                bid = world.getblock(d, x + m, y, z + n);
                if (bid == 0) {
                    world.setblock(d, x + m, y, z + n, Blocks.leaves.blockID);
                }
                ++n;
            }
            ++m;
        }
    }

    public void ScragglyTreeWithBranches(World world, int d, int x, int y, int z) {
        int bid;
        int i = 1 + world.rand.nextInt(2);
        int j = i + world.rand.nextInt(8);
        int k = 0;
        while (k < i) {
            bid = world.getblock(d, x, y + k, z);
            if (k >= 1 && bid != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) {
                return;
            }
            world.setblock(d, x, y + k, z, Blocks.log.blockID);
            ++k;
        }
        y += i - 1;
        k = i;
        while (k < j) {
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2);
            int iy = world.rand.nextInt(4) > 0 ? 1 : 0;
            bid = world.getblock(d, x += ix, y += iy, z += iz);
            if (bid != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) break;
            world.setblock(d, x, y, z, Blocks.log.blockID);
            if (world.rand.nextInt(4) == 1) {
                this.makeScragglyBranch(world, d, x, y, z, world.rand.nextInt(1 + j - k), world.rand.nextInt(2) - world.rand.nextInt(2), world.rand.nextInt(2) - world.rand.nextInt(2));
            }
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblock(d, x + m, y, z + n, Blocks.leaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblock(d, x, y + 1, z, Blocks.leaves.blockID);
            }
            ++k;
        }
    }

    public void makeScragglyBranch(World world, int d, int x, int y, int z, int len, int biasx, int biasz) {
        int k = 0;
        while (k < len) {
            int iy;
            int bid;
            int ix = world.rand.nextInt(2) - world.rand.nextInt(2) + biasx;
            int iz = world.rand.nextInt(2) - world.rand.nextInt(2) + biasz;
            if (ix > 1) {
                ix = 1;
            }
            if (ix < -1) {
                ix = -1;
            }
            if (iz > 1) {
                iz = 1;
            }
            if (iz < -1) {
                iz = -1;
            }
            if ((bid = world.getblock(d, x += ix, y += (iy = world.rand.nextInt(3) > 0 ? 1 : 0), z += iz)) != 0 && bid != Blocks.log.blockID && bid != Blocks.leaves.blockID) {
                return;
            }
            world.setblock(d, x, y, z, Blocks.log.blockID);
            int m = -1;
            while (m < 2) {
                int n = -1;
                while (n < 2) {
                    if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x + m, y, z + n)) == 0) {
                        world.setblock(d, x + m, y, z + n, Blocks.leaves.blockID);
                    }
                    ++n;
                }
                ++m;
            }
            if (world.rand.nextInt(2) == 1 && (bid = world.getblock(d, x, y + 1, z)) == 0) {
                world.setblock(d, x, y + 1, z, Blocks.leaves.blockID);
            }
            ++k;
        }
    }

    public boolean isBoringBaseBlock(World world, int d, int x, int y, int z) {
        int b = world.getblock(d, x, y, z);
        if (b == 0) {
            return true;
        }
        if (b == Blocks.dirt.blockID) {
            return true;
        }
        if (b == Blocks.grassblock.blockID) {
            return true;
        }
        if (b == Blocks.stone.blockID) {
            return false;
        }
        return false;
    }

    public boolean isBoringBlock(World world, int d, int x, int y, int z) {
        int b = world.getblock(d, x, y, z);
        if (b == 0) {
            return true;
        }
        if (b == Blocks.redwoodleaves.blockID) {
            return true;
        }
        if (b == Blocks.leaves.blockID) {
            return true;
        }
        return b == Blocks.willowleaves.blockID;
    }

    public void MakeBigRoundTree(World world, int dimension, int inx, int y, int inz, int ID, int leafID, int t_radius) {
        float fcurz;
        float fcurx;
        double dt;
        double rad = t_radius;
        int cury = 0;
        int ibranch = 0;
        float fx = inx;
        fx += 0.5f;
        float fz = inz;
        fz += 0.5f;
        cury = y;
        int i = 0;
        while (i < 360) {
            dt = rad * Math.sin(Math.toRadians(i));
            fcurx = (float)dt;
            fcurz = (float)(dt = rad * Math.cos(Math.toRadians(i)));
            if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), cury, (int)(fz + fcurz))) {
                int j = 0;
                while (j < 20) {
                    if (cury - j > 0) {
                        if (!this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), cury - j, (int)(fz + fcurz))) break;
                        world.setblock(dimension, (int)(fx + fcurx), cury - j, (int)(fz + fcurz), ID);
                    }
                    ++j;
                }
            }
            ++i;
        }
        cury = 1;
        while (rad > 0.0) {
            i = 0;
            while (i < 360) {
                dt = rad * Math.sin(Math.toRadians(i));
                fcurx = (float)dt;
                fcurz = (float)(dt = rad * Math.cos(Math.toRadians(i)));
                if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz))) {
                    world.setblock(dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz), ID);
                }
                ++i;
            }
            if (cury > (int)rad) {
                if ((ibranch += 80 + world.rand.nextInt(80)) > 360) {
                    ibranch -= 360;
                }
                int ibranchlen = (int)(rad * 5.0) + world.rand.nextInt((int)rad + 2);
                dt = rad * Math.sin(Math.toRadians(ibranch));
                fcurx = (float)dt;
                dt = rad * Math.cos(Math.toRadians(ibranch));
                fcurz = (float)dt;
                this.MakeRoundBranch(world, dimension, ibranch, ibranchlen, (int)rad + 1, fx + fcurx, y + cury, fz + fcurz, Blocks.redwoodlog.blockID, leafID);
            }
            if (cury % 6 == 0 && rad > 3.0) {
                double dr = rad - 0.25;
                while (dr > 0.0) {
                    i = 0;
                    while (i < 360) {
                        dt = dr * Math.sin(Math.toRadians(i));
                        fcurx = (float)dt;
                        fcurz = (float)(dt = dr * Math.cos(Math.toRadians(i)));
                        if (this.isBoringBaseBlock(world, dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz))) {
                            world.setblock(dimension, (int)(fx + fcurx), y + cury, (int)(fz + fcurz), ID);
                        }
                        ++i;
                    }
                    dr -= 0.25;
                }
            }
            ++cury;
            rad -= 0.01 * (double)world.rand.nextInt(15);
        }
    }

    private void MakeRoundBranch(World world, int dimension, int iangle, int branchlen, int width, float startx, int starty, float startz, int ID, int leafID) {
        double deltadir = 0.06283185200000001;
        double deltamag = 0.35f;
        int ixlast = 0;
        int izlast = 0;
        int radius = branchlen / 2;
        float centerx = (float)((double)startx + (double)radius * Math.sin(Math.toRadians(iangle)));
        float centerz = (float)((double)startz + (double)radius * Math.cos(Math.toRadians(iangle)));
        izlast = 0;
        ixlast = 0;
        double curdir = -3.1415926;
        while (curdir < 3.1415926) {
            double h = 0.75;
            while (h < (double)radius) {
                int ix = (int)((double)centerx + Math.cos(curdir) * h);
                int iz = (int)((double)centerz + Math.sin(curdir) * h);
                if (ix != ixlast || iz != izlast) {
                    ixlast = ix;
                    izlast = iz;
                    int id = ID;
                    if ((double)radius - h < 2.0) {
                        id = leafID;
                    }
                    if (this.isBoringBlock(world, dimension, ix, starty, iz)) {
                        world.setblock(dimension, ix, starty, iz, id);
                    }
                }
                h += deltamag;
            }
            curdir += deltadir;
        }
    }
}

