/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class StitchedTextureFile {
    public int textureID = -1;
    public int nextx = 0;
    public int nexty = 0;
    public Texture blankfile = null;
    public ByteBuffer texturedata = BufferUtils.createByteBuffer(this.total_size);
    public int total_size = 0x100000;
    public int total_sizemip1 = 262144;
    public ByteBuffer texturedatamip1 = BufferUtils.createByteBuffer(this.total_sizemip1);
    public int total_sizemip2 = 65536;
    public ByteBuffer texturedatamip2 = BufferUtils.createByteBuffer(this.total_sizemip2);
    public int total_sizemip3 = 16384;
    public ByteBuffer texturedatamip3 = BufferUtils.createByteBuffer(this.total_sizemip3);
    public int total_sizemip4 = 4096;
    public ByteBuffer texturedatamip4 = BufferUtils.createByteBuffer(this.total_sizemip4);

    public StitchedTexture addTexture(String texturename) {
        int i;
        int j;
        int k;
        Texture temp = null;
        if (this.nexty > 31) {
            return null;
        }
        if (texturename == null) {
            return null;
        }
        if (texturename.equals("")) {
            return null;
        }
        try {
            temp = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("res/blocks/" + texturename));
        }
        catch (IOException e1) {
            return null;
        }
        byte[] b = temp.getTextureData();
        if (b.length < 768) {
            return null;
        }
        this.texturedata.position(0);
        if (b.length > 768) {
            k = 0;
            j = 0;
            while (j < 16) {
                i = 0;
                while (i < 64) {
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i, b[k]);
                    ++k;
                    ++i;
                }
                ++j;
            }
        } else {
            k = 0;
            j = 0;
            while (j < 16) {
                i = 0;
                while (i < 16) {
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4, b[k]);
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 1, b[++k]);
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 2, b[++k]);
                    ++k;
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 3, (byte)-1);
                    ++i;
                }
                ++j;
            }
        }
        this.texturedata.position(0);
        this.texturedatamip1.position(0);
        i = 0;
        while (i < 256) {
            j = 0;
            while (j < 256) {
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8));
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8 + 1));
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8 + 2));
                this.texturedatamip1.put(this.texturedata.get(i * 2 * 2048 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedatamip1.position(0);
        this.texturedatamip2.position(0);
        i = 0;
        while (i < 128) {
            j = 0;
            while (j < 128) {
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8));
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8 + 1));
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8 + 2));
                this.texturedatamip2.put(this.texturedatamip1.get(i * 2 * 1024 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedatamip2.position(0);
        this.texturedatamip3.position(0);
        i = 0;
        while (i < 64) {
            j = 0;
            while (j < 64) {
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8));
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8 + 1));
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8 + 2));
                this.texturedatamip3.put(this.texturedatamip2.get(i * 2 * 512 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedatamip3.position(0);
        this.texturedatamip4.position(0);
        i = 0;
        while (i < 32) {
            j = 0;
            while (j < 32) {
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8));
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8 + 1));
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8 + 2));
                this.texturedatamip4.put(this.texturedatamip3.get(i * 2 * 256 + j * 8 + 3));
                ++j;
            }
            ++i;
        }
        this.texturedata.position(0);
        this.texturedata.limit(this.total_size);
        this.texturedatamip1.position(0);
        this.texturedatamip1.limit(this.total_sizemip1);
        this.texturedatamip2.position(0);
        this.texturedatamip2.limit(this.total_sizemip2);
        this.texturedatamip3.position(0);
        this.texturedatamip3.limit(this.total_sizemip3);
        this.texturedatamip4.position(0);
        this.texturedatamip4.limit(this.total_sizemip4);
        temp.release();
        if (this.textureID >= 0) {
            IntBuffer texBuf = BufferUtils.createIntBuffer(1);
            texBuf.put(this.textureID);
            texBuf.flip();
            GL11.glDeleteTextures(texBuf);
        }
        this.textureID = this.createTextureID();
        GL11.glEnable(3553);
        GL11.glBindTexture(3553, this.textureID);
        GL11.glTexParameteri(3553, 10241, 9984);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexImage2D(3553, 0, 6408, StitchedTextureFile.getPow2(512), StitchedTextureFile.getPow2(512), 0, 6408, 5121, this.texturedata);
        GL11.glTexImage2D(3553, 1, 6408, StitchedTextureFile.getPow2(256), StitchedTextureFile.getPow2(256), 0, 6408, 5121, this.texturedatamip1);
        GL11.glTexImage2D(3553, 2, 6408, StitchedTextureFile.getPow2(128), StitchedTextureFile.getPow2(128), 0, 6408, 5121, this.texturedatamip2);
        GL11.glTexImage2D(3553, 3, 6408, StitchedTextureFile.getPow2(64), StitchedTextureFile.getPow2(64), 0, 6408, 5121, this.texturedatamip3);
        GL11.glTexImage2D(3553, 4, 6408, StitchedTextureFile.getPow2(32), StitchedTextureFile.getPow2(32), 0, 6408, 5121, this.texturedatamip4);
        GL11.glTexParameteri(3553, 33085, 4);
        StitchedTexture st = new StitchedTexture();
        st.yoffsetmin = (float)this.nexty / 32.0f;
        st.yoffsetmax = ((float)this.nexty + 1.0f) / 32.0f;
        st.xoffsetmin = (float)this.nextx / 32.0f;
        st.xoffsetmax = ((float)this.nextx + 1.0f) / 32.0f;
        ++this.nextx;
        if (this.nextx >= 32) {
            ++this.nexty;
            this.nextx = 0;
        }
        return st;
    }

    public void bind() {
        GL11.glEnable(3553);
        GL11.glBindTexture(3553, this.textureID);
        GL11.glTexParameteri(3553, 10241, 9984);
        GL11.glTexParameteri(3553, 10240, 9728);
    }

    public int createTextureID() {
        IntBuffer tmp = BufferUtils.createIntBuffer(1);
        GL11.glGenTextures(tmp);
        return tmp.get(0);
    }

    public static int getPow2(int i) {
        int ret = 2;
        while (ret < i) {
            ret *= 2;
        }
        return ret;
    }
}

