/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.util.ResourceLoader;

public class SoundManager {
    Map<String, Soundinfo> soundmap = new HashMap<String, Soundinfo>();
    public int master_volume = 10;

    public void registerSound(String soundname, String filepath) {
        this.soundmap.put(soundname, new Soundinfo(filepath));
    }

    public void playSound(String soundname, float vol, float freq, int d, float px, float py, float pz) {
        Soundinfo s = this.soundmap.get(soundname);
        if (s != null) {
            if (s.sound == null) {
                try {
                    s.sound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream(s.filepath));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    s.sound = null;
                    this.soundmap.remove(soundname);
                }
            }
            if (s.sound != null && this.master_volume > 0 && DangerZone.start_client && d == DangerZone.player.dimension) {
                float mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz);
                float mv = this.master_volume;
                mv /= 10.0f;
                if ((mx /= 5.0f) < 1.0f) {
                    mx = 1.0f;
                }
                if (mx < 64.0f) {
                    mx = vol / mx;
                    s.sound.playAsSoundEffect(freq, mx *= mv, false);
                }
            }
        }
    }

    private class Soundinfo {
        public String filepath;
        public Audio sound;

        Soundinfo(String f) {
            this.filepath = f;
            this.sound = null;
        }
    }
}

