/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServerThread
implements Runnable {
    public Player p;
    ObjectInputStream objectInput = null;
    ObjectOutputStream objectOutput = null;
    private int blockcount = 0;
    private Lock lock = new ReentrantLock();
    private Lock lightinglock = new ReentrantLock();
    private int fatal_error = 0;
    private int updatecount = 0;
    private volatile int ready = 0;
    private volatile boolean lightready = false;
    private volatile float lightvalue = 0.0f;

    ServerThread(Player pl) {
        this.p = pl;
        this.p.server_thread = this;
    }

    @Override
    public void run() {
        int id;
        String name = null;
        boolean forceall = false;
        int packettype = 0;
        this.lock.lock();
        try {
            this.p.toClient.setReceiveBufferSize(131072);
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        try {
            this.p.toClient.setSendBufferSize(262144);
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        try {
            this.objectInput = new ObjectInputStream(this.p.toClient.getInputStream());
            packettype = this.objectInput.readInt();
            if (packettype != 85) {
                this.objectInput.close();
                return;
            }
            this.objectOutput = new ObjectOutputStream(this.p.toClient.getOutputStream());
            String clientversion = (String)this.objectInput.readObject();
            if (clientversion.equals(DangerZone.versionstring)) {
                this.objectOutput.writeObject(DangerZone.versionstring);
                this.sendServerIDs();
                this.getSkin();
                this.p.myname = (String)this.objectInput.readObject();
                id = DangerZone.server.entityManager.addEntity(this.p);
                if (id <= 0) {
                    this.fatal_error = 1;
                } else {
                    this.objectOutput.writeInt(this.p.entityID);
                    this.objectOutput.flush();
                }
            } else {
                this.objectOutput.writeObject(DangerZone.versionstring);
                this.objectOutput.flush();
                this.fatal_error = 1;
            }
        }
        catch (IOException e) {
            System.out.printf("ServerThread client connection failed...\n", new Object[0]);
            this.fatal_error = 1;
        }
        catch (ClassNotFoundException e) {
            System.out.printf("ServerThread client connection failed...\n", new Object[0]);
            this.fatal_error = 1;
        }
        this.ready = 1;
        this.lock.unlock();
        try {
            while (DangerZone.gameover == 0 && this.fatal_error == 0) {
                Entity e;
                int pd;
                float pz;
                float py;
                float px;
                String s;
                int which;
                int z;
                int y;
                int x;
                int d;
                Chunk c;
                packettype = this.objectInput.readInt();
                if (packettype == 135 && (c = DangerZone.server_world.serverchunkcache.getDecoratedChunk(d = this.objectInput.readInt(), x = this.objectInput.readInt(), y = this.objectInput.readInt(), z = this.objectInput.readInt())) != null && !DangerZone.start_client) {
                    if (c.isChanged == 0) {
                        this.sendChunkToPlayer(c);
                    } else {
                        DangerZone.server.sendChunkToAll(c);
                    }
                    c.isChanged = 0;
                }
                if (packettype == 133) {
                    d = this.objectInput.readInt();
                    x = this.objectInput.readInt();
                    y = this.objectInput.readInt();
                    z = this.objectInput.readInt();
                    id = this.objectInput.readInt();
                    int meta = this.objectInput.readInt();
                    DangerZone.server_world.setblockandmeta(d, x, y, z, id, meta);
                    DangerZone.server.sendBlockToAllExcept(this, d, x, y, z, id, meta);
                }
                if (packettype == 152) {
                    this.lightvalue = this.objectInput.readFloat();
                    this.lightready = true;
                }
                if (packettype == 147) {
                    InventoryContainer ic;
                    which = this.objectInput.readInt();
                    int slot = this.objectInput.readInt();
                    int bid = this.objectInput.readInt();
                    int iid = this.objectInput.readInt();
                    int count = this.objectInput.readInt();
                    int uses = this.objectInput.readInt();
                    if (count == 0) {
                        ic = null;
                    } else {
                        ic = new InventoryContainer();
                        ic.bid = bid;
                        ic.iid = iid;
                        ic.count = count;
                        ic.currentuses = uses;
                    }
                    if (which == 0) {
                        this.p.hotbar[slot] = ic;
                    }
                    if (which == 1) {
                        this.p.inventory[slot] = ic;
                    }
                }
                if (packettype == 148) {
                    which = this.objectInput.readInt();
                    int what = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    if (which == 0) {
                        DangerZone.server.sendPlayerActionToAllExcept(this.p, which, what);
                        if (what == 0) {
                            this.p.leftclick(DangerZone.server_world, 0, 0, 0, d);
                        }
                        if (what == 1) {
                            this.p.rightclick(DangerZone.server_world, 0, 0, 0, 0, d);
                        }
                    }
                }
                if (packettype == 153) {
                    s = (String)this.objectInput.readObject();
                    DangerZone.server.sendChatToAll(s);
                }
                if (packettype == 156) {
                    s = (String)this.objectInput.readObject();
                    CommandHandler.doCommand(this.p, s);
                    DangerZone.server.sendCommandToAll(s);
                }
                if (packettype == 154) {
                    s = (String)this.objectInput.readObject();
                    which = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readFloat();
                    py = this.objectInput.readFloat();
                    pz = this.objectInput.readFloat();
                    DangerZone.server.sendSpawnParticleToAllExcept(this.p, s, which, d, px, py, pz);
                }
                if (packettype == 144) {
                    d = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    forceall = false;
                    if (d != this.p.dimension) {
                        forceall = true;
                    }
                    this.p.dimension = d;
                    this.p.posx = this.objectInput.readFloat();
                    this.p.posy = this.objectInput.readFloat();
                    this.p.posz = this.objectInput.readFloat();
                    this.p.motionx = this.objectInput.readFloat();
                    this.p.motiony = this.objectInput.readFloat();
                    this.p.motionz = this.objectInput.readFloat();
                    this.p.rotation_pitch = this.objectInput.readFloat();
                    this.p.rotation_yaw = this.objectInput.readFloat();
                    this.p.rotation_roll = this.objectInput.readFloat();
                    this.p.rotation_pitch_head = this.objectInput.readFloat();
                    this.p.rotation_yaw_head = this.objectInput.readFloat();
                    this.p.rotation_roll_head = this.objectInput.readFloat();
                    this.p.rotation_pitch_motion = this.objectInput.readFloat();
                    this.p.rotation_yaw_motion = this.objectInput.readFloat();
                    this.p.rotation_roll_motion = this.objectInput.readFloat();
                    d = this.objectInput.readInt();
                    this.p.deadflag = d != 0;
                    this.readVarsIntoEntity(this.p);
                    DangerZone.server.sendPlayerUpdateToAllExcept(this.p, this.p, forceall);
                }
                if (packettype == 146) {
                    float mz;
                    float my;
                    float mx;
                    float roll;
                    float yaw;
                    float pitch;
                    name = (String)this.objectInput.readObject();
                    e = this.doSpawnEntity(name, pd = this.objectInput.readInt(), px = this.objectInput.readFloat(), py = this.objectInput.readFloat(), pz = this.objectInput.readFloat(), pitch = this.objectInput.readFloat(), yaw = this.objectInput.readFloat(), roll = this.objectInput.readFloat(), mx = this.objectInput.readFloat(), my = this.objectInput.readFloat(), mz = this.objectInput.readFloat());
                    if (e != null) {
                        this.readVarsIntoEntity(e);
                        DangerZone.server.sendSpawnEntityToAll(e);
                    } else {
                        this.readVarsIntoNull();
                    }
                }
                if (packettype == 150) {
                    name = (String)this.objectInput.readObject();
                    pd = this.objectInput.readInt();
                    px = this.objectInput.readFloat();
                    py = this.objectInput.readFloat();
                    pz = this.objectInput.readFloat();
                    float vol = this.objectInput.readFloat();
                    float freq = this.objectInput.readFloat();
                    DangerZone.server.sendSoundToAllExcept(this.p, name, pd, px, py, pz, vol, freq);
                }
                if (packettype == 137 && (e = DangerZone.server.entityManager.findEntityByID(id = this.objectInput.readInt())) != null) {
                    this.sendSpawnEntityToPlayer(e);
                    if (e instanceof Player) {
                        this.sendSkinToPlayer(e);
                    }
                }
                if (packettype != 155 || (e = DangerZone.server.entityManager.findEntityByID(id = this.objectInput.readInt())) == null) continue;
                int ieid = DangerZone.server.entityManager.removeEntityByID(id);
                e.deadflag = true;
                if (ieid != id) continue;
                DangerZone.server.sendEntityDeathToAll(e);
            }
        }
        catch (ClassNotFoundException e1) {
            this.fatal_error = 1;
        }
        catch (IOException e1) {
            this.fatal_error = 1;
        }
        DangerZone.server.sendEntityRemoveToAllExcept(this.p, this.p);
        DangerZone.server.entityManager.removeEntityByID(this.p.entityID);
        DangerZone.server.removeMe(this);
        try {
            if (this.objectInput != null) {
                this.objectInput.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.objectOutput != null) {
                this.objectOutput.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.p.toClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkReady() {
        while (this.ready == 0) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.fatal_error = 1;
                continue;
            }
            break;
        }
        return;
    }

    public void sendSpawnEntityToPlayer(Entity e) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        try {
            int pt = 146;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(e.uniquename);
            this.objectOutput.writeInt(e.entityID);
            this.objectOutput.writeInt(e.dimension);
            this.objectOutput.writeFloat(e.posx);
            this.objectOutput.writeFloat(e.posy);
            this.objectOutput.writeFloat(e.posz);
            this.objectOutput.writeFloat(e.rotation_pitch);
            this.objectOutput.writeFloat(e.rotation_yaw);
            this.objectOutput.writeFloat(e.rotation_roll);
            this.objectOutput.writeFloat(e.rotation_pitch_head);
            this.objectOutput.writeFloat(e.rotation_yaw_head);
            this.objectOutput.writeFloat(e.rotation_roll_head);
            this.objectOutput.writeFloat(e.motionx);
            this.objectOutput.writeFloat(e.motiony);
            this.objectOutput.writeFloat(e.motionz);
            int i = 0;
            while (i < e.maxvars) {
                if (e.entity_ints[i] != 0) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeInt(e.entity_ints[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            i = 0;
            while (i < e.maxvars) {
                if (e.entity_floats[i] != 0.0f) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeFloat(e.entity_floats[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            i = 0;
            while (i < e.maxvars) {
                if (e.entity_strings[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeObject(e.entity_strings[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            pt = -2;
            this.objectOutput.writeInt(pt);
            this.flushSendLocked();
        }
        catch (IOException err) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendChunkToPlayer(Chunk c) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        ++DangerZone.chunks_per_second;
        this.lock.lock();
        int pt = 134;
        try {
            int separator = -1;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(c.chunkX);
            this.objectOutput.writeInt(c.chunkZ);
            this.objectOutput.writeInt(c.dimension);
            this.objectOutput.writeInt(c.isDecorated);
            this.objectOutput.writeInt(c.isChanged);
            this.objectOutput.writeInt(c.isValid);
            this.objectOutput.writeInt(c.must_be_written);
            this.objectOutput.writeInt(separator);
            int i = 0;
            while (i < 256) {
                if (c.blockdata[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeObject(c.blockdata[i]);
                }
                ++i;
            }
            this.objectOutput.writeInt(separator);
            i = 0;
            while (i < 256) {
                if (c.metadata[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeObject(c.metadata[i]);
                }
                ++i;
            }
            this.objectOutput.writeInt(separator);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendBlockToPlayer(int d, int x, int y, int z, int id, int meta) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        if (this.blockcount > 200) {
            this.flushSendLocked();
        }
        ++this.blockcount;
        int pt = 133;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(d);
            this.objectOutput.writeInt(x);
            this.objectOutput.writeInt(y);
            this.objectOutput.writeInt(z);
            this.objectOutput.writeInt(id);
            this.objectOutput.writeInt(meta);
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendEntityDeathToPlayer(int eid) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 145;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(eid);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendChatToPlayer(String s) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 153;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(s);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendCommandToPlayer(String s) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 156;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(s);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendSpawnParticleToPlayer(String s, int hm, int d, float x, float y, float z) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 154;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(s);
            this.objectOutput.writeInt(hm);
            this.objectOutput.writeInt(d);
            this.objectOutput.writeFloat(x);
            this.objectOutput.writeFloat(y);
            this.objectOutput.writeFloat(z);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendVelocityUpdateToPlayer(float newx, float newy, float newz) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 151;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeFloat(newx);
            this.objectOutput.writeFloat(newy);
            this.objectOutput.writeFloat(newz);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendEntityRemoveToPlayer(int eid) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 138;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(eid);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public float doLightingRequest(int d, int x, int y, int z) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lightinglock.lock();
        this.lightready = false;
        this.lightvalue = DangerZone.server_world.rand.nextFloat();
        this.lock.lock();
        int pt = 152;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(d);
            this.objectOutput.writeInt(x);
            this.objectOutput.writeInt(y);
            this.objectOutput.writeInt(z);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
        int tries = 2000;
        while (tries > 0 && !this.lightready) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            --tries;
        }
        float lv = this.lightvalue;
        this.lightready = false;
        this.lightinglock.unlock();
        return lv;
    }

    public void sendEntityHitToPlayer(int eid, float newhealth) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 149;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(eid);
            this.objectOutput.writeFloat(newhealth);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendPlayerAction(Player p, int which, int what) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        try {
            int pt = 148;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(p.entityID);
            this.objectOutput.writeInt(which);
            this.objectOutput.writeInt(what);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendInventoryUpdateToPlayer(int which, int slot, InventoryContainer ic) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 147;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(which);
            this.objectOutput.writeInt(slot);
            this.objectOutput.writeInt(ic.bid);
            this.objectOutput.writeInt(ic.iid);
            this.objectOutput.writeInt(ic.count);
            this.objectOutput.writeInt(ic.currentuses);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendEntityUpdateToPlayer(Entity e) {
        this.checkReady();
        if (e.entityID == this.p.entityID) {
            return;
        }
        ++DangerZone.packets_per_second;
        this.lock.lock();
        if (this.updatecount > 20) {
            this.flushSendLocked();
        }
        ++this.updatecount;
        int pt = 144;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(e.entityID);
            this.objectOutput.writeInt(e.dimension);
            this.objectOutput.writeFloat(e.posx);
            this.objectOutput.writeFloat(e.posy);
            this.objectOutput.writeFloat(e.posz);
            this.objectOutput.writeFloat(e.motionx);
            this.objectOutput.writeFloat(e.motiony);
            this.objectOutput.writeFloat(e.motionz);
            this.objectOutput.writeFloat(e.rotation_pitch);
            this.objectOutput.writeFloat(e.rotation_yaw);
            this.objectOutput.writeFloat(e.rotation_roll);
            this.objectOutput.writeFloat(e.rotation_pitch_head);
            this.objectOutput.writeFloat(e.rotation_yaw_head);
            this.objectOutput.writeFloat(e.rotation_roll_head);
            this.objectOutput.writeFloat(e.rotation_pitch_motion);
            this.objectOutput.writeFloat(e.rotation_yaw_motion);
            this.objectOutput.writeFloat(e.rotation_roll_motion);
            if (e.deadflag) {
                pt = 1;
                this.objectOutput.writeInt(pt);
            } else {
                pt = 0;
                this.objectOutput.writeInt(pt);
            }
            if (e.changed != 0) {
                int i = 0;
                while (i < e.maxvars) {
                    if ((e.changes[i] & 1) == 1) {
                        this.objectOutput.writeInt(i);
                        this.objectOutput.writeInt(e.entity_ints[i]);
                    }
                    ++i;
                }
                pt = -1;
                this.objectOutput.writeInt(pt);
                i = 0;
                while (i < e.maxvars) {
                    if ((e.changes[i] & 2) == 2) {
                        this.objectOutput.writeInt(i);
                        this.objectOutput.writeFloat(e.entity_floats[i]);
                    }
                    ++i;
                }
                pt = -1;
                this.objectOutput.writeInt(pt);
                i = 0;
                while (i < e.maxvars) {
                    if ((e.changes[i] & 4) == 4) {
                        this.objectOutput.writeInt(i);
                        this.objectOutput.writeObject(e.entity_strings[i]);
                    }
                    ++i;
                }
                pt = -1;
                this.objectOutput.writeInt(pt);
            }
            pt = -2;
            this.objectOutput.writeInt(pt);
        }
        catch (IOException ex) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendTimeToPlayer(int t, int l) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 128;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(t);
            this.objectOutput.writeInt(l);
            this.flushSendLocked();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void flushSend() {
        this.checkReady();
        this.lock.lock();
        try {
            this.blockcount = 0;
            this.updatecount = 0;
            this.objectOutput.flush();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void flushSendLocked() {
        try {
            this.blockcount = 0;
            this.updatecount = 0;
            this.objectOutput.flush();
        }
        catch (IOException e) {
            this.fatal_error = 1;
        }
    }

    public Entity doSpawnEntity(String name, int pd, float px, float py, float pz, float pitch, float yaw, float roll, float mx, float my, float mz) {
        Entity e = Entities.spawnEntityByName(name, DangerZone.server_world);
        if (e != null) {
            e.posx = px;
            e.posy = py;
            e.posz = pz;
            e.rotation_pitch = pitch;
            e.rotation_yaw = yaw;
            e.rotation_roll = roll;
            e.rotation_pitch_head = pitch;
            e.rotation_yaw_head = yaw;
            e.rotation_roll_head = roll;
            e.motionx = mx;
            e.motiony = my;
            e.motionz = mz;
            e.dimension = pd;
            e.init();
            if (DangerZone.server.entityManager.addEntity(e) <= 0) {
                return null;
            }
        }
        return e;
    }

    private void readVarsIntoEntity(Entity ent) {
        try {
            int index = this.objectInput.readInt();
            if (index != -2) {
                while (index >= 0) {
                    if (index < ent.maxvars) {
                        ent.entity_ints[index] = this.objectInput.readInt();
                        ent.changed = 1;
                        int n = index;
                        ent.changes[n] = (short)(ent.changes[n] | 1);
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    if (index < ent.maxvars) {
                        ent.entity_floats[index] = this.objectInput.readFloat();
                        ent.changed = 1;
                        int n = index;
                        ent.changes[n] = (short)(ent.changes[n] | 2);
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    try {
                        if (index < ent.maxvars) {
                            ent.entity_strings[index] = (String)this.objectInput.readObject();
                            ent.changed = 1;
                            int n = index;
                            ent.changes[n] = (short)(ent.changes[n] | 4);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        this.fatal_error = 1;
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
            }
            if (index != -2) {
                System.out.printf("packet terminator failure on enitity update!\n", new Object[0]);
                this.fatal_error = 1;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.fatal_error = 1;
        }
    }

    private void readVarsIntoNull() {
        int index;
        block8: {
            index = 0;
            try {
                index = this.objectInput.readInt();
                if (index == -2) break block8;
                while (index >= 0) {
                    this.objectInput.readInt();
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    this.objectInput.readFloat();
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    try {
                        this.objectInput.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.fatal_error = 1;
            }
        }
        if (index != -2) {
            System.out.printf("packet terminator failure on enitity update!\n", new Object[0]);
            this.fatal_error = 1;
        }
    }

    public void sendSound(String name, int pd, float px, float py, float pz, float vol, float freq) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        try {
            int pt = 150;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(name);
            this.objectOutput.writeInt(pd);
            this.objectOutput.writeFloat(px);
            this.objectOutput.writeFloat(py);
            this.objectOutput.writeFloat(pz);
            this.objectOutput.writeFloat(vol);
            this.objectOutput.writeFloat(freq);
            this.flushSendLocked();
        }
        catch (IOException err) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }

    public void sendServerIDs() {
        try {
            int i = 1;
            while (i < 2048) {
                if (Items.ItemArray[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeObject(Items.ItemArray[i].uniquename);
                }
                ++i;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            i = 1;
            while (i < 2048) {
                if (Blocks.BlockArray[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeObject(Blocks.BlockArray[i].uniquename);
                }
                ++i;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            i = 1;
            while (i < 256) {
                if (Dimensions.DimensionArray[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeObject(Dimensions.DimensionArray[i].uniquename);
                }
                ++i;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            this.objectOutput.flush();
        }
        catch (IOException err) {
            this.fatal_error = 1;
        }
    }

    private void getSkin() {
        try {
            byte[] b;
            int seq = this.objectInput.readInt();
            if (seq != -3) {
                this.fatal_error = 1;
                return;
            }
            int len = this.objectInput.readInt();
            if (len != (b = (byte[])this.objectInput.readObject()).length) {
                this.fatal_error = 1;
                return;
            }
            if (len < 8192) {
                this.fatal_error = 1;
                return;
            }
            this.p.tdata = b;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void sendSkinToPlayer(Entity e) {
        Player pe = (Player)e;
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        try {
            int pt = pe.tdata.length;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(pe.tdata);
            this.flushSendLocked();
        }
        catch (IOException err) {
            this.fatal_error = 1;
        }
        this.lock.unlock();
    }
}

