/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServerConnection
implements Runnable {
    Socket sock;
    ObjectInputStream objectInput = null;
    ObjectOutputStream objectOutput = null;
    public volatile int connected = 0;
    public List<Coords> requested_list;
    public static Lock requested_list_lock = new ReentrantLock();
    private Player p;
    public static Lock output_lock = new ReentrantLock();

    ServerConnection(Player pl) {
        this.p = pl;
    }

    @Override
    public void run() {
        int id;
        Entity ent = null;
        String name = null;
        int packettype = 0;
        boolean j = false;
        this.requested_list = new ArrayList<Coords>();
        try {
            this.sock = DangerZone.start_server ? new Socket("127.0.0.1", DangerZone.server_port) : new Socket(DangerZone.server_address, DangerZone.server_port);
        }
        catch (UnknownHostException e) {
            System.out.printf("Client failed to make socket 1\n", new Object[0]);
            return;
        }
        catch (IOException e) {
            System.out.printf("Client failed to make socket 2\n", new Object[0]);
            return;
        }
        try {
            this.sock.setReceiveBufferSize(131072);
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        try {
            this.sock.setSendBufferSize(131072);
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        output_lock.lock();
        try {
            this.objectOutput = new ObjectOutputStream(this.sock.getOutputStream());
            packettype = 85;
            this.objectOutput.writeInt(packettype);
            this.objectOutput.writeObject(DangerZone.versionstring);
            this.objectOutput.flush();
            this.objectInput = new ObjectInputStream(this.sock.getInputStream());
            String vs = (String)this.objectInput.readObject();
            if (!vs.equals(DangerZone.versionstring)) {
                DangerZone.messagestring = String.format("Game version mismatch. Server is version: %s", vs);
                DangerZone.messagetimer = 200;
                DangerZone.gameover = 1;
                return;
            }
            this.reSyncIDs();
            this.sendSkin();
            this.objectOutput.writeObject(this.p.myname);
            id = this.objectInput.readInt();
            if (id <= 0 || id >= DangerZone.max_entities) {
                System.out.printf("Client failed connect.\n", new Object[0]);
                DangerZone.gameover = 1;
                return;
            }
        }
        catch (IOException e) {
            System.out.printf("Client failed connect.\n", new Object[0]);
            DangerZone.gameover = 1;
            return;
        }
        catch (ClassNotFoundException e) {
            System.out.printf("Client failed connect.\n", new Object[0]);
            DangerZone.gameover = 1;
            return;
        }
        this.p.toServer = this.sock;
        this.p.server_connection = this;
        this.p.entityID = id;
        this.connected = 1;
        output_lock.unlock();
        DangerZone.entityManager.addEntity(this.p, id);
        int i = 0;
        while (i < this.p.hotbar.length) {
            if (this.p.hotbar[i] != null) {
                this.inventoryUpdate(0, i, this.p.hotbar[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.p.inventory.length) {
            if (this.p.inventory[i] != null) {
                this.inventoryUpdate(1, i, this.p.inventory[i]);
            }
            ++i;
        }
        try {
            while (DangerZone.gameover == 0) {
                float rrh;
                float ryh;
                float rph;
                float rr;
                float ry;
                float rp;
                float mz;
                float my;
                float mx;
                int eid;
                float pz;
                float py;
                float px;
                int which;
                int z;
                int y;
                int x;
                int d;
                packettype = this.objectInput.readInt();
                if (packettype == 134) {
                    Chunk c = new Chunk(0, 0, 0, 0);
                    this.receiveChunk(c);
                    DangerZone.world.chunkcache.addCacheChunk(c);
                    requested_list_lock.lock();
                    Iterator<Coords> ii = this.requested_list.iterator();
                    while (ii.hasNext()) {
                        Coords cl = ii.next();
                        if (cl.d != c.dimension || cl.x != c.chunkX || cl.z != c.chunkZ) continue;
                        ii.remove();
                        break;
                    }
                    requested_list_lock.unlock();
                }
                if (packettype == 133) {
                    d = this.objectInput.readInt();
                    x = this.objectInput.readInt();
                    y = this.objectInput.readInt();
                    z = this.objectInput.readInt();
                    id = this.objectInput.readInt();
                    int meta = this.objectInput.readInt();
                    DangerZone.world.chunkcache.setBlockSilent(d, x, y, z, id, meta);
                }
                if (packettype == 128) {
                    DangerZone.world.timetimer = d = this.objectInput.readInt();
                    DangerZone.world.lengthOfDay = d = this.objectInput.readInt();
                }
                if (packettype == 153) {
                    String s = (String)this.objectInput.readObject();
                    DangerZone.chatgui.receiveMessage(s);
                    DangerZone.messagestring = s;
                    DangerZone.messagetimer = 180;
                }
                if (packettype == 156) {
                    String s = (String)this.objectInput.readObject();
                    DangerZone.commandgui.receiveMessage(s);
                    DangerZone.messagestring = s;
                    DangerZone.messagetimer = 180;
                }
                if (packettype == 154) {
                    String s = (String)this.objectInput.readObject();
                    which = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readFloat();
                    py = this.objectInput.readFloat();
                    pz = this.objectInput.readFloat();
                    Utils.spawnParticles(DangerZone.player.world, s, which, d, px, py, pz, false);
                }
                if (packettype == 145 && (ent = DangerZone.entityManager.findEntityByID(d = this.objectInput.readInt())) != null) {
                    ent.deadflag = true;
                    ent.doDeathAnimation();
                    Utils.spawnDeathParticles(ent.world, ent.dimension, ent.posx, ent.posy, ent.posz, ent.width, ent.height);
                }
                if (packettype == 138 && (d = this.objectInput.readInt()) != this.p.entityID && (ent = DangerZone.entityManager.findEntityByID(d)) != null && !ent.deadflag && !ent.isDying()) {
                    DangerZone.entityManager.removeEntityByID(d);
                }
                if (packettype == 149) {
                    d = this.objectInput.readInt();
                    px = this.objectInput.readFloat();
                    ent = DangerZone.entityManager.findEntityByID(d);
                    if (ent != null) {
                        ent.setHealth(px);
                        ent.doHurtAnimation();
                    }
                }
                if (packettype == 151) {
                    px = this.objectInput.readFloat();
                    py = this.objectInput.readFloat();
                    pz = this.objectInput.readFloat();
                    this.p.motionx = px;
                    this.p.motiony = py;
                    this.p.motionz = pz;
                }
                if (packettype == 147) {
                    InventoryContainer ic;
                    which = this.objectInput.readInt();
                    int slot = this.objectInput.readInt();
                    int bid = this.objectInput.readInt();
                    int iid = this.objectInput.readInt();
                    int count = this.objectInput.readInt();
                    int uses = this.objectInput.readInt();
                    if (count == 0) {
                        ic = null;
                    } else {
                        ic = new InventoryContainer();
                        ic.bid = bid;
                        ic.iid = iid;
                        ic.count = count;
                        ic.currentuses = uses;
                    }
                    if (which == 0) {
                        this.p.hotbar[slot] = ic;
                    } else {
                        this.p.inventory[slot] = ic;
                    }
                }
                if (packettype == 148) {
                    eid = this.objectInput.readInt();
                    which = this.objectInput.readInt();
                    int what = this.objectInput.readInt();
                    ent = DangerZone.entityManager.findEntityByID(eid);
                    if (ent != null && ent instanceof Player && which == 0 && what == 0 && ent != DangerZone.player) {
                        Player pp = (Player)ent;
                        pp.armdir = 1;
                    }
                }
                if (packettype == 144) {
                    eid = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readFloat();
                    py = this.objectInput.readFloat();
                    pz = this.objectInput.readFloat();
                    mx = this.objectInput.readFloat();
                    my = this.objectInput.readFloat();
                    mz = this.objectInput.readFloat();
                    rp = this.objectInput.readFloat();
                    ry = this.objectInput.readFloat();
                    rr = this.objectInput.readFloat();
                    rph = this.objectInput.readFloat();
                    ryh = this.objectInput.readFloat();
                    rrh = this.objectInput.readFloat();
                    float rpm = this.objectInput.readFloat();
                    float rym = this.objectInput.readFloat();
                    float rrm = this.objectInput.readFloat();
                    int dead = this.objectInput.readInt();
                    ent = DangerZone.entityManager.findEntityByID(eid);
                    if (ent != null) {
                        if (eid != DangerZone.player.entityID) {
                            ent.dimension = d;
                            ent.posx = px;
                            ent.posy = py;
                            ent.posz = pz;
                            ent.motionx = mx;
                            ent.motiony = my;
                            ent.motionz = mz;
                            ent.rotation_pitch = rp;
                            ent.rotation_yaw = ry;
                            ent.rotation_roll = rr;
                            ent.rotation_pitch_head = rph;
                            ent.rotation_yaw_head = ryh;
                            ent.rotation_roll_head = rrh;
                            ent.rotation_pitch_motion = rpm;
                            ent.rotation_yaw_motion = rym;
                            ent.rotation_roll_motion = rrm;
                            ent.deadflag = dead != 0;
                            this.readVarsIntoEntity(ent);
                        } else {
                            this.readVarsIntoNull();
                        }
                    } else {
                        this.readVarsIntoNull();
                        if (d == DangerZone.player.dimension) {
                            float d1 = DangerZone.player.posx - px;
                            float d2 = DangerZone.player.posy - py;
                            float d3 = DangerZone.player.posz - pz;
                            if ((d1 = (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3)) < (float)DangerZone.entityupdatedist) {
                                if (eid == DangerZone.player.entityID) {
                                    System.out.printf("??update for self\n", new Object[0]);
                                } else {
                                    this.whatIsThisEntity(eid);
                                }
                            }
                        }
                    }
                }
                if (packettype == 146) {
                    name = (String)this.objectInput.readObject();
                    id = this.objectInput.readInt();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readFloat();
                    py = this.objectInput.readFloat();
                    pz = this.objectInput.readFloat();
                    rp = this.objectInput.readFloat();
                    ry = this.objectInput.readFloat();
                    rr = this.objectInput.readFloat();
                    rph = this.objectInput.readFloat();
                    ryh = this.objectInput.readFloat();
                    rrh = this.objectInput.readFloat();
                    mx = this.objectInput.readFloat();
                    my = this.objectInput.readFloat();
                    mz = this.objectInput.readFloat();
                    ent = Entities.spawnEntityByName(name, DangerZone.world);
                    if (ent != null) {
                        ent.entityID = id;
                        ent.dimension = d;
                        ent.posx = px;
                        ent.posy = py;
                        ent.posz = pz;
                        ent.rotation_pitch = rp;
                        ent.rotation_yaw = ry;
                        ent.rotation_roll = rr;
                        ent.rotation_pitch_head = rph;
                        ent.rotation_yaw_head = ryh;
                        ent.rotation_roll_head = rrh;
                        ent.motionx = mx;
                        ent.motiony = my;
                        ent.motionz = mz;
                        this.readVarsIntoEntity(ent);
                        if (ent instanceof Player) {
                            this.getSkinData(ent);
                        }
                        ent.init();
                        DangerZone.entityManager.addEntity(ent, id);
                        if (id == DangerZone.player.entityID) {
                            System.out.printf("??spawn entity for self\n", new Object[0]);
                        }
                    } else {
                        this.readVarsIntoNull();
                    }
                }
                if (packettype == 150) {
                    name = (String)this.objectInput.readObject();
                    d = this.objectInput.readInt();
                    px = this.objectInput.readFloat();
                    py = this.objectInput.readFloat();
                    pz = this.objectInput.readFloat();
                    float vol = this.objectInput.readFloat();
                    float freq = this.objectInput.readFloat();
                    DangerZone.soundmangler.playSound(name, vol, freq, d, px, py, pz);
                }
                if (packettype != 152) continue;
                d = this.objectInput.readInt();
                x = this.objectInput.readInt();
                y = this.objectInput.readInt();
                z = this.objectInput.readInt();
                float lv = WorldRendererUtils.getTotalLightAt(DangerZone.world, d, x, y, z);
                this.sendLightResponse(lv);
            }
        }
        catch (IOException e) {
            DangerZone.gameover = 1;
            return;
        }
        catch (ClassNotFoundException e) {
            DangerZone.gameover = 1;
            return;
        }
    }

    public void getDecoratedChunk(int d, int x, int y, int z) {
        if (this.connected == 0) {
            return;
        }
        requested_list_lock.lock();
        for (Coords c : this.requested_list) {
            if (c.d != d || c.x != x >> 4 || c.z != z >> 4) continue;
            requested_list_lock.unlock();
            return;
        }
        ++DangerZone.packets_per_second;
        Coords newc = new Coords();
        newc.d = d;
        newc.x = x >> 4;
        newc.y = y;
        newc.z = z >> 4;
        this.requested_list.add(newc);
        requested_list_lock.unlock();
        try {
            int pt = 135;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(d);
            this.objectOutput.writeInt(x);
            this.objectOutput.writeInt(y);
            this.objectOutput.writeInt(z);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client getDecoratedChunk send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void blockChanged(int d, int x, int y, int z, int id, int meta) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 133;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(d);
            this.objectOutput.writeInt(x);
            this.objectOutput.writeInt(y);
            this.objectOutput.writeInt(z);
            this.objectOutput.writeInt(id);
            this.objectOutput.writeInt(meta);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client blockChanged send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void whatIsThisEntity(int id) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 137;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(id);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client entity query send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendKillMe(int id) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 155;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(id);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client killme send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendLightResponse(float lv) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 152;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeFloat(lv);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client lightvalue send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendChatMessage(String s) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 153;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(s);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client chat send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendCommandMessage(String s) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 156;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(s);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client command send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendSpawnParticles(String s, int hm, int d, float x, float y, float z) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 154;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(s);
            this.objectOutput.writeInt(hm);
            this.objectOutput.writeInt(d);
            this.objectOutput.writeFloat(x);
            this.objectOutput.writeFloat(y);
            this.objectOutput.writeFloat(z);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client spawn particles failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void inventoryUpdate(int which, int slot, InventoryContainer ic) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 147;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(which);
            this.objectOutput.writeInt(slot);
            if (ic != null) {
                this.objectOutput.writeInt(ic.bid);
                this.objectOutput.writeInt(ic.iid);
                this.objectOutput.writeInt(ic.count);
                this.objectOutput.writeInt(ic.currentuses);
            } else {
                pt = 0;
                this.objectOutput.writeInt(pt);
                this.objectOutput.writeInt(pt);
                this.objectOutput.writeInt(pt);
                this.objectOutput.writeInt(pt);
            }
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client entity query send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void playerActionToServer(int which, int what, int eid) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        try {
            int pt = 148;
            output_lock.lock();
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(which);
            this.objectOutput.writeInt(what);
            this.objectOutput.writeInt(eid);
            this.objectOutput.flush();
            output_lock.unlock();
        }
        catch (IOException e) {
            System.out.printf("Client entity playeraction send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendPlayerEntityUpdate(Entity e) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        output_lock.lock();
        int pt = 144;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(e.entityID);
            this.objectOutput.writeInt(e.dimension);
            this.objectOutput.writeFloat(e.posx);
            this.objectOutput.writeFloat(e.posy);
            this.objectOutput.writeFloat(e.posz);
            this.objectOutput.writeFloat(e.motionx);
            this.objectOutput.writeFloat(e.motiony);
            this.objectOutput.writeFloat(e.motionz);
            this.objectOutput.writeFloat(e.rotation_pitch);
            this.objectOutput.writeFloat(360.0f - (e.rotation_yaw + 180.0f) % 360.0f);
            this.objectOutput.writeFloat(e.rotation_roll);
            this.objectOutput.writeFloat(e.rotation_pitch_head);
            this.objectOutput.writeFloat(360.0f - (e.rotation_yaw_head + 180.0f) % 360.0f);
            this.objectOutput.writeFloat(e.rotation_roll_head);
            this.objectOutput.writeFloat(e.rotation_pitch_motion);
            this.objectOutput.writeFloat(e.rotation_yaw_motion);
            this.objectOutput.writeFloat(e.rotation_roll_motion);
            if (e.deadflag) {
                pt = 1;
                this.objectOutput.writeInt(pt);
            } else {
                pt = 0;
                this.objectOutput.writeInt(pt);
            }
            if (e.changed != 0) {
                e.changed = 0;
                int i = 0;
                while (i < e.maxvars) {
                    if ((e.changes[i] & 1) == 1) {
                        int n = i;
                        e.changes[n] = (short)(e.changes[n] & 0xFFFE);
                        this.objectOutput.writeInt(i);
                        this.objectOutput.writeInt(e.entity_ints[i]);
                    }
                    ++i;
                }
                pt = -1;
                this.objectOutput.writeInt(pt);
                i = 0;
                while (i < e.maxvars) {
                    if ((e.changes[i] & 2) == 2) {
                        int n = i;
                        e.changes[n] = (short)(e.changes[n] & 0xFFFD);
                        this.objectOutput.writeInt(i);
                        this.objectOutput.writeFloat(e.entity_floats[i]);
                    }
                    ++i;
                }
                pt = -1;
                this.objectOutput.writeInt(pt);
                i = 0;
                while (i < e.maxvars) {
                    if ((e.changes[i] & 4) == 4) {
                        int n = i;
                        e.changes[n] = (short)(e.changes[n] & 0xFFFB);
                        this.objectOutput.writeInt(i);
                        this.objectOutput.writeObject(e.entity_strings[i]);
                    }
                    ++i;
                }
                pt = -1;
                this.objectOutput.writeInt(pt);
            }
            pt = -2;
            this.objectOutput.writeInt(pt);
            this.objectOutput.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.printf("Client entity update send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
        output_lock.unlock();
    }

    private void receiveChunk(Chunk c) throws ClassNotFoundException {
        try {
            c.chunkX = this.objectInput.readInt();
            c.chunkZ = this.objectInput.readInt();
            c.dimension = this.objectInput.readInt();
            c.isDecorated = this.objectInput.readInt();
            c.isChanged = this.objectInput.readInt();
            c.isValid = this.objectInput.readInt();
            c.must_be_written = this.objectInput.readInt();
            int separator = this.objectInput.readInt();
            if (separator != -1) {
                System.out.printf("Big oops!\n", new Object[0]);
                DangerZone.gameover = 1;
            }
            while ((separator = this.objectInput.readInt()) >= 0) {
                c.blockdata[separator] = (short[])this.objectInput.readObject();
            }
            while ((separator = this.objectInput.readInt()) >= 0) {
                c.metadata[separator] = (short[])this.objectInput.readObject();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            DangerZone.gameover = 1;
        }
    }

    public void spawnEntity(Entity e) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        output_lock.lock();
        try {
            int pt = 146;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(e.uniquename);
            this.objectOutput.writeInt(e.dimension);
            this.objectOutput.writeFloat(e.posx);
            this.objectOutput.writeFloat(e.posy);
            this.objectOutput.writeFloat(e.posz);
            this.objectOutput.writeFloat(e.rotation_pitch);
            this.objectOutput.writeFloat(e.rotation_yaw);
            this.objectOutput.writeFloat(e.rotation_roll);
            this.objectOutput.writeFloat(e.motionx);
            this.objectOutput.writeFloat(e.motiony);
            this.objectOutput.writeFloat(e.motionz);
            int i = 0;
            while (i < e.maxvars) {
                if (e.entity_ints[i] != 0) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeInt(e.entity_ints[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            i = 0;
            while (i < e.maxvars) {
                if (e.entity_floats[i] != 0.0f) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeFloat(e.entity_floats[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            i = 0;
            while (i < e.maxvars) {
                if (e.entity_strings[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeObject(e.entity_strings[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            pt = -2;
            this.objectOutput.writeInt(pt);
            this.objectOutput.flush();
        }
        catch (IOException err) {
            System.out.printf("Client spawnEntity send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
        output_lock.unlock();
    }

    private void readVarsIntoEntity(Entity ent) {
        try {
            int index = this.objectInput.readInt();
            if (index != -2) {
                while (index >= 0) {
                    if (index < ent.maxvars) {
                        ent.entity_ints[index] = this.objectInput.readInt();
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    if (index < ent.maxvars) {
                        ent.entity_floats[index] = this.objectInput.readFloat();
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    try {
                        if (index < ent.maxvars) {
                            ent.entity_strings[index] = (String)this.objectInput.readObject();
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        DangerZone.gameover = 1;
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
            }
            if (index != -2) {
                System.out.printf("packet terminator failure on enitity update!\n", new Object[0]);
                DangerZone.gameover = 1;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            DangerZone.gameover = 1;
        }
    }

    private void readVarsIntoNull() {
        int index;
        block8: {
            index = 0;
            try {
                index = this.objectInput.readInt();
                if (index == -2) break block8;
                while (index >= 0) {
                    this.objectInput.readInt();
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    this.objectInput.readFloat();
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
                while (index >= 0) {
                    try {
                        this.objectInput.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        DangerZone.gameover = 1;
                    }
                    index = this.objectInput.readInt();
                }
                index = this.objectInput.readInt();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (index != -2) {
            System.out.printf("packet terminator failure on enitity update!\n", new Object[0]);
            DangerZone.gameover = 1;
        }
    }

    public void sendSound(String name, int dimension, float posx, float posy, float posz, float volume, float frequency) {
        if (this.connected == 0) {
            return;
        }
        ++DangerZone.packets_per_second;
        output_lock.lock();
        try {
            int pt = 150;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeObject(name);
            this.objectOutput.writeInt(dimension);
            this.objectOutput.writeFloat(posx);
            this.objectOutput.writeFloat(posy);
            this.objectOutput.writeFloat(posz);
            this.objectOutput.writeFloat(volume);
            this.objectOutput.writeFloat(frequency);
            this.objectOutput.flush();
        }
        catch (IOException err) {
            System.out.printf("Client playsound send failed.\n", new Object[0]);
            DangerZone.gameover = 1;
        }
        output_lock.unlock();
    }

    public void reSyncIDs() {
        String name = null;
        try {
            int i = this.objectInput.readInt();
            while (i > 0) {
                try {
                    name = (String)this.objectInput.readObject();
                }
                catch (ClassNotFoundException e) {
                    DangerZone.gameover = 1;
                    e.printStackTrace();
                    return;
                }
                Items.reRegisterItemAt(name, i);
                i = this.objectInput.readInt();
            }
            i = this.objectInput.readInt();
            while (i > 0) {
                try {
                    name = (String)this.objectInput.readObject();
                }
                catch (ClassNotFoundException e) {
                    DangerZone.gameover = 1;
                    e.printStackTrace();
                    return;
                }
                Blocks.reRegisterBlockAt(name, i);
                i = this.objectInput.readInt();
            }
            i = this.objectInput.readInt();
            while (i > 0) {
                try {
                    name = (String)this.objectInput.readObject();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    DangerZone.gameover = 1;
                    return;
                }
                Dimensions.reRegisterDimensionAt(name, i);
                i = this.objectInput.readInt();
            }
        }
        catch (IOException e1) {
            System.out.printf("Client barfed on read. \n", new Object[0]);
            DangerZone.gameover = 1;
            return;
        }
    }

    private void sendSkin() {
        int pt = -3;
        byte[] b = this.p.tdata;
        int len = b.length;
        try {
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(len);
            this.objectOutput.writeObject(b);
            this.objectOutput.flush();
        }
        catch (IOException e) {
            System.out.printf("Client barfed on sendSkin. \n", new Object[0]);
            DangerZone.gameover = 1;
            e.printStackTrace();
        }
    }

    private void getSkinData(Entity e) {
        Player pe = (Player)e;
        try {
            int len = this.objectInput.readInt();
            byte[] b = (byte[])this.objectInput.readObject();
            if (len != b.length) {
                return;
            }
            pe.tdata = b;
            pe.donewtexture = true;
        }
        catch (IOException | ClassNotFoundException e1) {
            System.out.printf("Client barfed on getSkinData. \n", new Object[0]);
            DangerZone.gameover = 1;
            e1.printStackTrace();
        }
    }
}

