/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Server
implements Runnable {
    ServerSocket myServerSocket;
    public List<ListInt> server_thread_list;
    public ServerThread[] players;
    public int max_players = 256;
    public Lock player_list_lock = new ReentrantLock();
    private Player plyr;
    public ServerEntityUpdateLoop entityManager;

    @Override
    public void run() {
        this.server_thread_list = new ArrayList<ListInt>();
        try {
            this.myServerSocket = new ServerSocket(DangerZone.server_port);
        }
        catch (IOException e) {
            return;
        }
        this.entityManager = new ServerEntityUpdateLoop();
        Thread it = new Thread(this.entityManager);
        it.start();
        this.players = new ServerThread[this.max_players];
        int i = 0;
        while (i < this.max_players) {
            this.players[i] = null;
            ++i;
        }
        Thread itb = new Thread(new BlockTickerThread());
        itb.start();
        Thread its = new Thread(new SpawnerThread());
        its.start();
        while (DangerZone.gameover == 0) {
            ServerThread st;
            Socket sock;
            try {
                sock = this.myServerSocket.accept();
            }
            catch (IOException e) {
                return;
            }
            this.player_list_lock.lock();
            i = this.find_player_slot();
            if (i < 0) {
                try {
                    sock.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.player_list_lock.unlock();
                continue;
            }
            this.plyr = new Player(DangerZone.server_world);
            this.plyr.toClient = sock;
            this.players[i] = st = new ServerThread(this.plyr);
            this.server_thread_list.add(new ListInt(i));
            this.player_list_lock.unlock();
            Thread pit = new Thread(st);
            pit.start();
        }
    }

    private int find_player_slot() {
        int i = 0;
        while (i < this.max_players) {
            if (this.players[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void sendChunkToAll(Chunk c) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != c.dimension) continue;
            this.players[st.index].sendChunkToPlayer(c);
        }
        this.player_list_lock.unlock();
    }

    public void sendBlockToAll(int d, int x, int y, int z, int id, int meta) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != d) continue;
            this.players[st.index].sendBlockToPlayer(d, x, y, z, id, meta);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityDeathToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendEntityDeathToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityDeathToAllExcept(Player pl, Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendEntityDeathToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendSpawnParticleToAllExcept(Player pl, String s, int hm, int d, float x, float y, float z) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl || this.players[st.index].p.dimension != d || !(this.players[st.index].p.getDistanceFromEntityCenter(x, y, z) < 32.0f)) continue;
            this.players[st.index].sendSpawnParticleToPlayer(s, hm, d, x, y, z);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityRemoveToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendEntityRemoveToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityRemoveToAllExcept(Player pl, Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl) continue;
            this.players[st.index].sendEntityRemoveToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityHitToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendEntityHitToPlayer(e.entityID, e.getHealth());
        }
        this.player_list_lock.unlock();
    }

    public void sendChatToAll(String s) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendChatToPlayer(s);
        }
        this.player_list_lock.unlock();
    }

    public void sendCommandToAll(String s) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendCommandToPlayer(s);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityUpdateToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendEntityUpdateToPlayer(e);
        }
        this.player_list_lock.unlock();
        if (e.changed != 0) {
            e.changed = 0;
            int i = 0;
            while (i < e.maxvars) {
                e.changes[i] = 0;
                ++i;
            }
        }
    }

    public void sendPlayerUpdateToAllExcept(Entity e, Player p, boolean forceall) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (!forceall) {
                if (this.players[st.index] == null || this.players[st.index].p == p || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
                this.players[st.index].sendEntityUpdateToPlayer(e);
                this.players[st.index].flushSend();
                continue;
            }
            if (this.players[st.index] == null || this.players[st.index].p == p) continue;
            this.players[st.index].sendEntityUpdateToPlayer(e);
            this.players[st.index].flushSend();
        }
        this.player_list_lock.unlock();
        if (e.changed != 0) {
            e.changed = 0;
            int i = 0;
            while (i < e.maxvars) {
                e.changes[i] = 0;
                ++i;
            }
        }
    }

    public void sendPlayerActionToAllExcept(Player p, int which, int what) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == p || this.players[st.index].p.dimension != p.dimension || !(p.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendPlayerAction(p, which, what);
        }
        this.player_list_lock.unlock();
    }

    public void sendSpawnEntityToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendSpawnEntityToPlayer(e);
        }
        this.player_list_lock.unlock();
    }

    public void sendTimeToAll(int t, int l) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendTimeToPlayer(t, l);
        }
        this.player_list_lock.unlock();
    }

    public void sendBlockToAllExcept(ServerThread stp, int d, int x, int y, int z, int id, int meta) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index] == stp || this.players[st.index].p.dimension != d) continue;
            this.players[st.index].sendBlockToPlayer(d, x, y, z, id, meta);
        }
        this.player_list_lock.unlock();
    }

    public void flushAll() {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        while (ii.hasNext()) {
            int i = ii.next().index;
            if (this.players[i] == null) continue;
            this.players[i].flushSend();
        }
        this.player_list_lock.unlock();
    }

    public Player getRandomPlayer(Random rand) {
        Player p = null;
        this.player_list_lock.lock();
        if (this.server_thread_list.size() != 0) {
            if (this.server_thread_list.size() == 1) {
                p = this.players[this.server_thread_list.get((int)0).index].p;
            } else {
                int i = rand.nextInt(this.server_thread_list.size());
                p = this.players[this.server_thread_list.get((int)i).index].p;
            }
        }
        this.player_list_lock.unlock();
        return p;
    }

    public boolean isAPlayerInDimension(int d) {
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index].p.dimension != d) continue;
            this.player_list_lock.unlock();
            return true;
        }
        this.player_list_lock.unlock();
        return false;
    }

    public boolean isPlayerCloseInDimension(Entity e) {
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.player_list_lock.unlock();
            return true;
        }
        this.player_list_lock.unlock();
        return false;
    }

    public void removeMe(ServerThread stp) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.players[st.index] != stp) continue;
            ii.remove();
            this.players[st.index] = null;
            break;
        }
        this.player_list_lock.unlock();
    }

    public Player findNearestPlayer(Entity e) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        float dist = 999.0f;
        Player p = null;
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < dist)) continue;
            p = this.players[st.index].p;
            dist = e.getDistanceFromEntity(this.players[st.index].p);
        }
        this.player_list_lock.unlock();
        return p;
    }

    public Player findNearestPlayerToHere(int d, int x, int y, int z) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        float dist = 999.0f;
        Player p = null;
        while (ii.hasNext()) {
            float dz;
            float dy;
            float dx;
            float curdist;
            ListInt st = ii.next();
            if (this.players[st.index].p.dimension != d || !((curdist = (float)Math.sqrt((dx = this.players[st.index].p.posx - (float)x) * dx + (dy = this.players[st.index].p.posy - (float)y) * dy + (dz = this.players[st.index].p.posz - (float)z) * dz)) < dist)) continue;
            p = this.players[st.index].p;
            dist = curdist;
        }
        this.player_list_lock.unlock();
        return p;
    }

    public float findNearestPlayerDistToHere(int d, int x, int z) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        float dist = 999.0f;
        while (ii.hasNext()) {
            float dz;
            float dx;
            float curdist;
            ListInt st = ii.next();
            if (this.players[st.index].p.dimension != d || !((curdist = (float)Math.sqrt((dx = this.players[st.index].p.posx - (float)x) * dx + (dz = this.players[st.index].p.posz - (float)z) * dz)) < dist)) continue;
            dist = curdist;
        }
        this.player_list_lock.unlock();
        return dist;
    }

    public void sendSoundToAllExcept(Player pl, String name, int pd, float px, float py, float pz, float vol, float freq) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl || this.players[st.index].p.dimension != pl.dimension || !(pl.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendSound(name, pd, px, py, pz, vol, freq);
        }
        this.player_list_lock.unlock();
    }

    public void sendSoundToAll(String name, int pd, float px, float py, float pz, float vol, float freq) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != pd || !(this.players[st.index].p.getDistanceFromEntityCenter(px, py, pz) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendSound(name, pd, px, py, pz, vol, freq);
        }
        this.player_list_lock.unlock();
    }
}

