/*
 * Decompiled with CFR 0.152.
 */
public class LightingThread
implements Runnable {
    public int tickmax = 12;

    @Override
    public void run() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.tickmax = DangerZone.renderdistance;
        while (DangerZone.gameover == 0) {
            int i = -this.tickmax;
            while (i <= this.tickmax && DangerZone.gameover == 0) {
                int j = -this.tickmax;
                while (j <= this.tickmax && DangerZone.gameover == 0) {
                    int chance;
                    if ((int)Math.sqrt(i * i + j * j) <= this.tickmax && DangerZone.world.rand.nextInt(chance = (int)Math.sqrt(i * i + j * j) + 1) == 0) {
                        this.tickChunk(DangerZone.world, i, j);
                        try {
                            long sleeper = 3L;
                            if (DangerZone.wr.fps < 40) {
                                sleeper = 6L;
                            }
                            Thread.sleep(sleeper);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void tickChunk(World w, int xrel, int zrel) {
        short[] leveldata = null;
        float[] lightmap = null;
        short[] drawn = null;
        boolean active = false;
        Player p = DangerZone.player;
        if (p == null) {
            return;
        }
        Chunk c = w.chunkcache.getDecoratedChunk(p.dimension, (xrel << 4) + (int)p.posx, 0, (zrel << 4) + (int)p.posz);
        if (c == null) {
            return;
        }
        drawn = c.drawn;
        if (drawn == null) {
            return;
        }
        int j = 0;
        while (j < 256) {
            int idown;
            int iup;
            float currentlight;
            int k;
            int i;
            active = false;
            lightmap = w.chunkcache.getDecoratedChunkLightmap(p.dimension, c.chunkX << 4, j, c.chunkZ << 4);
            if (lightmap != null) {
                i = 0;
                while (i < 16) {
                    k = 0;
                    while (k < 16) {
                        if (lightmap[i * 16 + k] != 0.0f) {
                            currentlight = lightmap[i * 16 + k];
                            lightmap[i * 16 + k] = currentlight *= 0.98f;
                            if ((double)Math.abs(currentlight) > 0.001) {
                                active = true;
                            }
                        }
                        ++k;
                    }
                    ++i;
                }
                if (!active) {
                    w.chunkcache.clearDecoratedChunkLightmap(p.dimension, c.chunkX << 4, j, c.chunkZ << 4);
                    lightmap = null;
                }
            }
            if ((iup = j + 1) > 255) {
                iup = 255;
            }
            if ((idown = j - 1) < 0) {
                idown = 0;
            }
            if ((drawn == null || drawn[j] != 0 || drawn[iup] != 0 || drawn[idown] != 0) && (leveldata = c.blockdata[j]) != null) {
                i = 0;
                while (i < 16) {
                    k = 0;
                    while (k < 16) {
                        short bid = leveldata[i * 16 + k];
                        if (bid != 0 && (currentlight = Blocks.getLightLevel(bid)) != 0.0f) {
                            LightingThread.updateLightMaps(w, currentlight, p.dimension, (c.chunkX << 4) + i, j, (c.chunkZ << 4) + k);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static void updateLightMaps(World w, float lv, int d, int x, int y, int z) {
        int updist = 16;
        float newv = 0.0f;
        int j = -updist;
        while (j <= updist) {
            if (y + j >= 0 && y + j <= 255) {
                int i = -updist;
                while (i <= updist) {
                    int k = -updist;
                    while (k <= updist) {
                        float cdist = (float)Math.sqrt(i * i + j * j + k * k);
                        if (cdist < (float)updist) {
                            float cval = lv * ((float)updist - cdist) / (float)updist;
                            float prev = LightingThread.getLightMapValue(w, d, x + i, y + j, z + k);
                            if (prev >= 0.0f && cval > 0.0f) {
                                newv = prev;
                                if (cval > newv) {
                                    newv = cval;
                                }
                            } else if (prev <= 0.0f && cval < 0.0f) {
                                newv = prev;
                                if (cval < newv) {
                                    newv = cval;
                                }
                            } else {
                                newv = prev + cval * cval * Math.signum(cval);
                            }
                            w.chunkcache.setDecoratedChunkLightValue(d, x + i, y + j, z + k, newv);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static float getLightMapValue(World w, int d, int x, int y, int z) {
        float[] lightmap = null;
        lightmap = w.chunkcache.getDecoratedChunkLightmap(d, x, y, z);
        if (lightmap == null) {
            return 0.0f;
        }
        return lightmap[(x & 0xF) * 16 + (z & 0xF)];
    }
}

