/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.opengl.GL11;

public class LightStick
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    LightStick(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.brightness = 0.75f;
        this.maxdamage = 1;
        this.randomtick = true;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        int meta = w.getblockmeta(d, x, y, z);
        switch (meta >> 8) {
            case 1: {
                bid = w.getblock(d, x, y, z - 1);
                break;
            }
            case 2: {
                bid = w.getblock(d, x, y, z + 1);
                break;
            }
            case 3: {
                bid = w.getblock(d, x + 1, y, z);
                break;
            }
            case 4: {
                bid = w.getblock(d, x - 1, y, z);
                break;
            }
            case 5: {
                bid = w.getblock(d, x, y + 1, z);
                break;
            }
            default: {
                bid = w.getblock(d, x, y - 1, z);
            }
        }
        if (!Blocks.isSolid(bid)) {
            w.setblock(d, x, y, z, 0);
            EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
            if (e != null) {
                e.setBID(this.blockID);
                e.setIID(0);
                DangerZone.player.world.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        Utils.spawnParticlesFromServer(w, "DangerZone:ParticleFire", w.rand.nextInt(3) + 2, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        int brw = (int)(this.blockrenderwidth / 2.0f);
        st = DangerZone.wr.findVBOtextureforblockside(0, bid);
        v = DangerZone.wr.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            switch (meta >> 8) {
                case 1: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    break;
                }
                case 2: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    break;
                }
                case 3: {
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    break;
                }
                case 4: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    break;
                }
                case 5: {
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    break;
                }
                default: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, DangerZone.wr.cbr, DangerZone.wr.cbg, DangerZone.wr.cbb);
                }
            }
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList(this.myrenderid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        switch (meta >> 8) {
            case 1: {
                GL11.glPushMatrix();
                GL11.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                GL11.glPushMatrix();
                GL11.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
                break;
            }
            case 3: {
                GL11.glPushMatrix();
                GL11.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case 4: {
                GL11.glPushMatrix();
                GL11.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case 5: {
                GL11.glPushMatrix();
                GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            }
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glCallList(this.myrenderid);
        GL11.glDisable(3042);
        switch (meta >> 8) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        if (!Blocks.isSolid(focusbid)) {
            return;
        }
        if (Blocks.isLeaves(focusbid)) {
            return;
        }
        switch (side) {
            case 0: {
                w.setblockandmeta(dimension, x, y + 1, z, this.blockID, side << 8);
                break;
            }
            case 1: {
                w.setblockandmeta(dimension, x, y, z + 1, this.blockID, side << 8);
                break;
            }
            case 2: {
                w.setblockandmeta(dimension, x, y, z - 1, this.blockID, side << 8);
                break;
            }
            case 3: {
                w.setblockandmeta(dimension, x - 1, y, z, this.blockID, side << 8);
                break;
            }
            case 4: {
                w.setblockandmeta(dimension, x + 1, y, z, this.blockID, side << 8);
                break;
            }
            case 5: {
                w.setblockandmeta(dimension, x, y - 1, z, this.blockID, side << 8);
            }
        }
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, x, y, z, 0.5f, 1.0f);
        if (p == null) {
            return;
        }
        if (p.getGameMode() == 0) {
            --p.hotbar[p.current_hotbar_index].count;
            p.sendInventoryUpdate(0, p.current_hotbar_index, p.hotbar[p.current_hotbar_index]);
            if (p.hotbar[p.current_hotbar_index].count <= 0) {
                p.hotbar[p.current_hotbar_index] = null;
            }
        }
    }
}

