/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Items {
    public static Item twobyfour = new Item("DangerZone:Two-by-four", "2by4.png");
    public static Item eggbutterfly = new ItemSpawnEgg("DangerZone:Spawn Butterfly", "eggbutterfly.png", "DangerZone:Butterfly");
    public static Item eggdanger = new ItemSpawnEgg("DangerZone:Spawn TheyCallMeDanger", "eggdanger.png", "DangerZone:TheyCallMeDanger");
    public static Item eggghost = new ItemSpawnEgg("DangerZone:Spawn Ghost", "eggghost.png", "DangerZone:Ghost");
    public static Item eggghostskelly = new ItemSpawnEgg("DangerZone:Spawn Ghost Skelly", "eggghostskelly.png", "DangerZone:GhostSkelly");
    public static Item eggrat = new ItemSpawnEgg("DangerZone:Spawn Rat", "eggrat.png", "DangerZone:Rat");
    public static Item eggcockroach = new ItemSpawnEgg("DangerZone:Spawn Cockroach", "eggcockroach.png", "DangerZone:Cockroach");
    public static Item lumpsilver = new Item("DangerZone:Silver", "lumpsilver.png");
    public static Item lumpplatinum = new Item("DangerZone:Platinum", "lumpplatinum.png");
    public static Item woodensword = new ItemSword("DangerZone:Wooden Sword", "woodensword.png", 200, 6);
    public static Item woodenpickaxe = new ItemPickAxe("DangerZone:Wooden Pickaxe", "woodenpickaxe.png", 400, 5, 8);
    public static Item woodenaxe = new ItemAxe("DangerZone:Wooden Axe", "woodenaxe.png", 200, 5, 3);
    public static Item woodenshovel = new ItemShovel("DangerZone:Wooden Shovel", "woodenshovel.png", 300, 3, 3);
    public static Item woodenhoe = new ItemHoe("DangerZone:Wooden Hoe", "woodenhoe.png", 200, 1, 3);
    public static Item stonesword = new ItemSword("DangerZone:Stone Sword", "stonesword.png", 400, 8);
    public static Item stonepickaxe = new ItemPickAxe("DangerZone:Stone Pickaxe", "stonepickaxe.png", 800, 8, 12);
    public static Item stoneaxe = new ItemAxe("DangerZone:Stone Axe", "stoneaxe.png", 400, 8, 6);
    public static Item stoneshovel = new ItemShovel("DangerZone:Stone Shovel", "stoneshovel.png", 60, 4, 5);
    public static Item stonehoe = new ItemHoe("DangerZone:Stone Hoe", "stonehoe.png", 400, 1, 6);
    public static Item silversword = new ItemSword("DangerZone:Silver Sword", "silversword.png", 800, 12);
    public static Item silverpickaxe = new ItemPickAxe("DangerZone:Silver Pickaxe", "silverpickaxe.png", 1600, 10, 16);
    public static Item silveraxe = new ItemAxe("DangerZone:Silver Axe", "silveraxe.png", 800, 10, 12);
    public static Item silvershovel = new ItemShovel("DangerZone:Silver Shovel", "silvershovel.png", 1400, 5, 10);
    public static Item silverhoe = new ItemHoe("DangerZone:Silver Hoe", "silverhoe.png", 800, 2, 10);
    public static Item platinumsword = new ItemSword("DangerZone:Platinum Sword", "platinumsword.png", 1600, 24);
    public static Item platinumpickaxe = new ItemPickAxe("DangerZone:Platinum Pickaxe", "platinumpickaxe.png", 2000, 16, 24);
    public static Item platinumaxe = new ItemAxe("DangerZone:Platinum Axe", "platinumaxe.png", 1600, 16, 20);
    public static Item platinumshovel = new ItemShovel("DangerZone:Platinum Shovel", "platinumshovel.png", 1600, 10, 20);
    public static Item platinumhoe = new ItemHoe("DangerZone:Platinum Hoe", "platinumhoe.png", 1000, 5, 20);
    public static Item dark = new ItemLight("DangerZone:Darkness", "dark.png");
    public static Item light = new ItemDark("DangerZone:Lightness", "light.png");
    public static Item corn = new ItemCorn("DangerZone:Corn", "corn_seed.png");
    public static Item[] ItemArray;
    public static final int itemsMAX = 2048;
    public static Properties prop;

    static {
        prop = null;
    }

    Items() {
        ItemArray = new Item[2048];
        int i = 0;
        while (i < 2048) {
            Items.ItemArray[i] = null;
            ++i;
        }
    }

    public static int registerItem(Item b) {
        int i = Utils.getPropertyInt(prop, b.uniquename, 0, 2047, 0);
        if (i == 0) {
            i = 1;
            while (i < 2048) {
                if (ItemArray[i] == null) {
                    Items.ItemArray[i] = b;
                    b.itemID = i;
                    prop.setProperty(b.uniquename, String.format("%d", i));
                    return i;
                }
                ++i;
            }
        } else {
            if (ItemArray[i] == null) {
                Items.ItemArray[i] = b;
                b.itemID = i;
                return i;
            }
            Item intruder = ItemArray[i];
            int isave = i;
            Items.ItemArray[i] = b;
            b.itemID = i;
            i = 1;
            while (i < 2048) {
                if (ItemArray[i] == null) {
                    Items.ItemArray[i] = intruder;
                    intruder.itemID = i;
                    prop.setProperty(intruder.uniquename, String.format("%d", i));
                }
                ++i;
            }
            return isave;
        }
        return 0;
    }

    public static void reRegisterItemAt(String s, int loc) {
        if (loc <= 0 || loc >= 2048) {
            return;
        }
        if (s == null || s.equals("")) {
            return;
        }
        if (ItemArray[loc] != null) {
            if (s.equals(Items.ItemArray[loc].uniquename)) {
                return;
            }
            int i = 1;
            while (i < 2048) {
                if (ItemArray[i] != null && s.equals(Items.ItemArray[i].uniquename)) {
                    Item me = ItemArray[i];
                    Item intruder = ItemArray[loc];
                    Items.ItemArray[loc] = me;
                    Items.ItemArray[loc].itemID = loc;
                    Items.ItemArray[i] = intruder;
                    Items.ItemArray[i].itemID = i;
                    return;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < 2048) {
                if (ItemArray[i] != null && s.equals(Items.ItemArray[i].uniquename)) {
                    Items.ItemArray[loc] = ItemArray[i];
                    Items.ItemArray[loc].itemID = loc;
                    Items.ItemArray[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static void load() {
        FileInputStream input = null;
        prop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds\\%s\\itemIDs.dat", DangerZone.worldname);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void save() {
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds\\%s\\itemIDs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            output = new FileOutputStream(filepath);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean alwaystick(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].alwaystick;
    }

    public static boolean randomtick(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].randomtick;
    }

    public static boolean shouldShow(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].showInInventory;
    }

    public static Texture getTexture(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        if (ItemArray[itemid] == null) {
            return null;
        }
        return ItemArray[itemid].getTexture();
    }

    public static void doitemtick(World w, int d, int x, int y, int z, int itemid) {
        if (itemid <= 0) {
            return;
        }
        if (itemid >= 2048) {
            return;
        }
        if (ItemArray[itemid] == null) {
            return;
        }
        ItemArray[itemid].tickMe(w, d, x, y, z);
    }

    public static void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int itemid, int meta, int sides, boolean focused) {
        if (itemid <= 0) {
            return;
        }
        if (itemid >= 2048) {
            return;
        }
        if (ItemArray[itemid] == null) {
            return;
        }
        ItemArray[itemid].renderMe(wr, w, d, x, y, z, itemid, meta, sides, focused);
    }

    public static int getMaxStack(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].maxstack;
    }

    public static int getAttackStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].attackstrength;
    }

    public static int getWoodStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].woodstrength;
    }

    public static int getStoneStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].stonestrength;
    }

    public static int getDirtStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].dirtstrength;
    }

    public static int getMaxUses(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].maxuses;
    }

    public static boolean rightClickOnBlock(int itemid, Player p, int d, int x, int y, int z) {
        if (itemid <= 0) {
            return true;
        }
        if (itemid >= 2048) {
            return true;
        }
        if (ItemArray[itemid] == null) {
            return true;
        }
        return ItemArray[itemid].rightClickOnBlock(p, d, x, y, z);
    }

    public static Item getItem(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        return ItemArray[itemid];
    }

    public static String getUniqueName(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        if (ItemArray[itemid] == null) {
            return null;
        }
        return Items.ItemArray[itemid].uniquename;
    }

    public static int findByName(String name) {
        if (name == null) {
            return 0;
        }
        int i = 1;
        while (i < 2048) {
            if (ItemArray[i] != null && Items.ItemArray[i].uniquename != null && name.equals(Items.ItemArray[i].uniquename)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static float getLightLevel(int itemid) {
        if (itemid <= 0) {
            return 0.0f;
        }
        if (itemid >= 2048) {
            return 0.0f;
        }
        if (ItemArray[itemid] == null) {
            return 0.0f;
        }
        return Items.ItemArray[itemid].brightness;
    }
}

