/*
 * Decompiled with CFR 0.152.
 */
import org.newdawn.slick.opengl.Texture;

public class Ghost
extends EntityLiving {
    float myspeed = 0.15f;

    public Ghost(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 1.5f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Ghost";
        this.setMaxHealth(2.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.25f);
        this.takesFallDamage = false;
        this.isGhost = true;
    }

    @Override
    public void doEntityCollisions(float deltaT) {
    }

    @Override
    public void doEntityAction(float deltaT) {
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            if (this.world.isDaytime() && this.world.rand.nextInt(100) == 1) {
                float dist = 0.0f;
                Player p = DangerZone.server.findNearestPlayer(this);
                if (p == null) {
                    this.deadflag = true;
                } else {
                    dist = Utils.getDistanceBetweenEntities(this, p);
                    if (dist > (float)(this.maxrenderdist / 2)) {
                        this.deadflag = true;
                    }
                }
            }
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(40) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0f) {
                Player p = DangerZone.server.findNearestPlayer(this);
                if (p != null && this.getDistanceFromEntity(p) < 12.0f && p.getGameMode() == 0) {
                    this.target.setTarget(p.posx, p.posy, p.posz);
                    if (this.getDistanceFromEntity(p) < 2.0f && this.world.rand.nextInt(10) == 1) {
                        p.doAttackFrom(this, 4, this.getAttackDamage());
                    }
                } else {
                    int i = 0;
                    while (i < 3) {
                        bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + i, (int)this.posz);
                        if (bid == 0) break;
                        ++i;
                    }
                    int j = -1;
                    while (j >= -3) {
                        bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + j, (int)this.posz);
                        if (bid != 0) break;
                        --j;
                    }
                    this.target.setTarget((int)this.posx + this.world.rand.nextInt(10) - this.world.rand.nextInt(10), (int)this.posy + i + j + this.world.rand.nextInt(4) + 1, (int)this.posz + this.world.rand.nextInt(10) - this.world.rand.nextInt(10));
                }
            }
            float dy = this.target.targety - this.posy;
            this.motiony += dy / 30.0f;
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            this.motionx = (float)((double)this.motionx + (double)this.myspeed * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)this.myspeed * Math.cos(tdir) * (double)deltaT);
        } else if (WorldRendererUtils.getTotalLightAt(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) > 0.55f && this.world.rand.nextInt(50) == 1) {
            DangerZone.server_connection.sendKillMe(this.entityID);
        }
        super.update(deltaT);
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 0) {
            return null;
        }
        return "DangerZone:ghost_sound";
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (w.isDaytime()) {
            return false;
        }
        return !(this.getLightAtLocation(w, dimension, x, y, z) > 0.35f);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Ghosttexture.png");
        }
        return this.texture;
    }
}

