/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;

public class Chunk {
    public int chunkX;
    public int chunkZ;
    public int dimension;
    public int isDecorated;
    public short[][] blockdata = new short[256][];
    public short[][] metadata = new short[256][];
    public int isChanged;
    public int isValid = 0;
    public int must_be_written = 0;
    private int chunkDiskVersion = 101;
    public short[] drawn = new short[256];
    public float[][] lightmap = null;
    public long[] VBOids = null;
    private boolean amGenerating = false;
    private boolean amDecorating = false;
    public List<ListCoords> tickblocks = null;

    public Chunk(int d, int x, int y, int z) {
        this.chunkX = x >> 4;
        this.chunkZ = z >> 4;
        this.isDecorated = 0;
        this.isChanged = 0;
        this.dimension = d;
        int i = 0;
        while (i < 256) {
            this.blockdata[i] = null;
            this.metadata[i] = null;
            this.drawn[i] = i > 50 ? (short)1 : 0;
            ++i;
        }
        this.isValid = 0;
        this.VBOids = new long[20];
        this.amGenerating = false;
        this.amDecorating = false;
        this.tickblocks = null;
    }

    public int getblock(int x, int y, int z) {
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        if (this.blockdata[j] == null) {
            return 0;
        }
        return this.blockdata[j][i * 16 + k] & 0xFFFF;
    }

    public int getblockmeta(int x, int y, int z) {
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        if (this.metadata[j] == null) {
            return 0;
        }
        return this.metadata[j][i * 16 + k] & 0xFFFF;
    }

    public void setblock(int x, int y, int z, int type) {
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        this.tickblocks = null;
        if (this.blockdata[j] == null) {
            if (type == 0) {
                return;
            }
            this.blockdata[j] = new short[256];
        }
        this.drawn[j] = 1;
        this.drawn[j + 1 & 0xFF] = 1;
        this.drawn[j - 1 & 0xFF] = 1;
        short d = this.blockdata[j][i * 16 + k];
        this.blockdata[j][i * 16 + k] = (short)(type & 0xFFFF);
        if (d != type) {
            this.isChanged = 1;
            this.must_be_written = 1;
        }
    }

    public void setblockmeta(int x, int y, int z, int meta) {
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        this.tickblocks = null;
        if (this.metadata[j] == null) {
            if (meta == 0) {
                return;
            }
            this.metadata[j] = new short[256];
        }
        this.drawn[j] = 1;
        this.drawn[j + 1 & 0xFF] = 1;
        this.drawn[j - 1 & 0xFF] = 1;
        short d = this.metadata[j][i * 16 + k];
        this.metadata[j][i * 16 + k] = (short)(meta & 0xFFFF);
        if (d != meta) {
            this.isChanged = 1;
            this.must_be_written = 1;
        }
    }

    public void generate(World w, int d, int x, int y, int z) {
        if (this.isValid != 0 || this.isDecorated != 0 || this.amGenerating) {
            return;
        }
        this.amGenerating = true;
        this.chunkX = x >> 4;
        this.chunkZ = z >> 4;
        this.dimension = d;
        this.isChanged = 0;
        Biome b = w.getBiome(d, x, y, z);
        if (b != null) {
            b.generate(w, d, this, this.chunkX, this.chunkZ);
        }
        this.isChanged = 0;
        this.isDecorated = 0;
        this.isValid = 1;
        this.must_be_written = 1;
        this.amGenerating = false;
    }

    public void decorate(World w, int d, int x, int y, int z) {
        if (this.isValid == 0 || this.isDecorated != 0 || this.amDecorating) {
            return;
        }
        this.amDecorating = true;
        Biome b = w.getBiome(d, x, y, z);
        if (b != null) {
            b.decorate(w, d, this, this.chunkX, this.chunkZ);
        }
        w.decorate(w, d, this.chunkX, this.chunkZ);
        this.isDecorated = 1;
        this.must_be_written = 1;
        DangerZone.server.flushAll();
        this.amDecorating = false;
    }

    public void saveToDisk() {
        int i;
        if (this.must_be_written == 0 && !DangerZone.server.entityManager.areEntitiesInChunk(this.dimension, this.chunkX, this.chunkZ)) {
            return;
        }
        int separator = -1;
        String filepath = new String();
        filepath = String.format("worlds\\%s\\Dimension-%d\\Hash-%2x\\%d_%d.dat", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
        File f = new File(filepath);
        FileOutputStream os = null;
        ObjectOutputStream oos = null;
        f.getParentFile().mkdirs();
        try {
            os = new FileOutputStream(filepath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            oos = new ObjectOutputStream(os);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            oos.writeInt(this.chunkDiskVersion);
            oos.writeInt(this.chunkX);
            oos.writeInt(this.chunkZ);
            oos.writeInt(this.dimension);
            oos.writeInt(this.isDecorated);
            this.isChanged = 0;
            oos.writeInt(this.isChanged);
            oos.writeInt(this.isValid);
            this.must_be_written = 0;
            oos.writeInt(this.must_be_written);
            oos.writeInt(separator);
            i = 0;
            while (i < 256) {
                if (this.blockdata[i] != null) {
                    oos.writeInt(i);
                    oos.writeObject(this.blockdata[i]);
                }
                ++i;
            }
            oos.writeInt(separator);
            i = 0;
            while (i < 256) {
                if (this.metadata[i] != null) {
                    oos.writeInt(i);
                    oos.writeObject(this.metadata[i]);
                }
                ++i;
            }
            oos.writeInt(separator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            oos.flush();
            oos.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Properties prop = new Properties();
        FileOutputStream output = null;
        filepath = String.format("worlds\\%s\\Dimension-%d\\Hash-%2x\\%d_%d.properties", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
        if (!DangerZone.server.entityManager.areEntitiesInChunk(this.dimension, this.chunkX, this.chunkZ)) {
            f = new File(filepath);
            f.delete();
            return;
        }
        try {
            output = new FileOutputStream(filepath);
            Entity[] entlist = DangerZone.server.entityManager.getEntitiesInChunk(this.dimension, this.chunkX, this.chunkZ);
            int elen = entlist.length;
            int entcount = 0;
            i = 0;
            while (i < elen) {
                if (entlist[i] != null) {
                    if (!(entlist[i] instanceof Player)) {
                        String s = String.format("Entity_%d:", entcount);
                        prop.setProperty(String.format("%s%s", s, "uniquename"), entlist[i].uniquename);
                        entlist[i].writeSelf(prop, s);
                        ++entcount;
                    }
                    DangerZone.server.sendEntityRemoveToAll(entlist[i]);
                    DangerZone.server.entityManager.removeEntityByID(entlist[i].entityID);
                }
                ++i;
            }
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean readFromDisk() {
        int separator;
        ObjectInputStream oos;
        FileInputStream os;
        String filepath;
        block31: {
            block30: {
                filepath = new String();
                filepath = String.format("worlds\\%s\\Dimension-%d\\Hash-%2x\\%d_%d.dat", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
                os = null;
                oos = null;
                try {
                    os = new FileInputStream(filepath);
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                try {
                    oos = new ObjectInputStream(os);
                }
                catch (FileNotFoundException e) {
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.printf("IO Excpetion on file %s\n", filepath);
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return false;
                }
                separator = oos.readInt();
                if (separator == this.chunkDiskVersion) break block30;
                System.out.printf("Wrong chunk file format version!\n", new Object[0]);
                oos.close();
                os.close();
                return false;
            }
            this.chunkX = oos.readInt();
            this.chunkZ = oos.readInt();
            this.dimension = oos.readInt();
            this.isDecorated = oos.readInt();
            this.isChanged = oos.readInt();
            this.isValid = oos.readInt();
            this.must_be_written = oos.readInt();
            separator = oos.readInt();
            if (separator == -1) break block31;
            System.out.printf("Big oops!\n", new Object[0]);
            oos.close();
            os.close();
            return false;
        }
        try {
            while ((separator = oos.readInt()) >= 0) {
                this.blockdata[separator] = (short[])oos.readObject();
            }
            while ((separator = oos.readInt()) >= 0) {
                this.metadata[separator] = (short[])oos.readObject();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                oos.close();
                os.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            try {
                oos.close();
                os.close();
            }
            catch (IOException ez) {
                ez.printStackTrace();
            }
            return false;
        }
        try {
            oos.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Properties prop = new Properties();
        FileInputStream input = null;
        filepath = String.format("worlds\\%s\\Dimension-%d\\Hash-%2x\\%d_%d.properties", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            return true;
        }
        int entcount = 0;
        while (true) {
            String s = String.format("Entity_%d:", entcount);
            if ((s = prop.getProperty(String.format("%s%s", s, "uniquename"))) == null) break;
            this.must_be_written = 1;
            Entity ent = Entities.spawnEntityByName(s, DangerZone.server_world);
            if (ent != null) {
                s = String.format("Entity_%d:", entcount);
                ent.readSelf(prop, s);
                ent.init();
                if (DangerZone.server.entityManager.addEntity(ent) > 0) {
                    DangerZone.server.sendSpawnEntityToAll(ent);
                }
            }
            ++entcount;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

