/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Blocks {
    public static Block stone = new BlockStone("DangerZone:Stone", "stone.png", 100);
    public static Block dirt = new BlockDirt("DangerZone:Dirt", "dirt.png");
    public static Block stopblock = new StopBlock("DangerZone:Stop Block", "stopblock.png");
    public static Block redwoodlog = new BlockLog("DangerZone:Redwood Log", "redwood.png", "redwood_top.png");
    public static Block willowlog = new BlockLog("DangerZone:Willow Log", "willowwood.png", "willowwood_top.png");
    public static Block log = new BlockLog("DangerZone:Log", "wood.png", "wood_top.png");
    public static Block lightplywood = new BlockWood("DangerZone:Light Plywood", "lightplywood.png");
    public static Block plywood = new BlockWood("DangerZone:Plywood", "plywood.png");
    public static Block darkplywood = new BlockWood("DangerZone:Dark Plywood", "darkplywood.png");
    public static Block leaves = new BlockLeaves("DangerZone:Leaves", "leaves.png");
    public static Block redwoodleaves = new BlockLeaves("DangerZone:Redwood Leaves", "redwoodleaves.png");
    public static Block willowleaves = new BlockLeaves("DangerZone:Willow Leaves", "willowleaves.png");
    public static Block grassblock = new GrassBlock("DangerZone:Grass Block", "grasstop.png", "grassbottom.png", "grassside.png");
    public static Block grass = new Grass("DangerZone:Grass", "grass.png");
    public static Block oresilver = new BlockStone("DangerZone:Silver Ore", "oresilver.png", 150);
    public static Block oreplatinum = new BlockOrePlatinum("DangerZone:Platinum Ore", "oreplatinum.png", 175);
    public static Block workbench = new BlockWorkBench("DangerZone:Workbench");
    public static Block lightstick = new LightStick("DangerZone:Lightstick", "torch.png");
    public static Block darkstick = new DarkStick("DangerZone:Darkstick", "darkstick.png");
    public static Block oredark = new BlockDark("DangerZone:Dark Ore", "oredark.png", 200);
    public static Block orelight = new BlockLight("DangerZone:Light Ore", "orelight.png", 50);
    public static Block water = new BlockWater("DangerZone:Water", "water.png");
    public static Block watersource = new BlockWaterSource("DangerZone:Water Source", "water.png");
    public static Block MyCornPlant1 = new BlockCorn("DangerZone:Baby Corn Plant", "corn_0.png");
    public static Block MyCornPlant2 = new BlockCorn("DangerZone:Corn Plant", "corn_1.png");
    public static Block MyCornPlant3 = new BlockCorn("DangerZone:Flowering Corn Plant", "corn_2.png");
    public static Block MyCornPlant4 = new BlockCorn("DangerZone:Ripe Corn Plant", "corn_3.png");
    public static Block roachnest = new RoachBlock("DangerZone:Cockroach Nest", "roachnest.png", "grassbottom.png", "grassside.png");
    public static Block[] BlockArray;
    public static final int blocksMAX = 2048;
    public static Properties prop;

    static {
        prop = null;
    }

    Blocks() {
        BlockArray = new Block[2048];
        int i = 0;
        while (i < 2048) {
            Blocks.BlockArray[i] = null;
            ++i;
        }
    }

    public static int registerBlock(Block b) {
        int i = Utils.getPropertyInt(prop, b.uniquename, 0, 2047, 0);
        if (i == 0) {
            i = 1;
            while (i < 2048) {
                if (BlockArray[i] == null) {
                    Blocks.BlockArray[i] = b;
                    b.blockID = i;
                    prop.setProperty(b.uniquename, String.format("%d", i));
                    return i;
                }
                ++i;
            }
        } else {
            if (BlockArray[i] == null) {
                Blocks.BlockArray[i] = b;
                b.blockID = i;
                return i;
            }
            Block intruder = BlockArray[i];
            int isave = i;
            Blocks.BlockArray[i] = b;
            b.blockID = i;
            i = 1;
            while (i < 2048) {
                if (BlockArray[i] == null) {
                    Blocks.BlockArray[i] = intruder;
                    intruder.blockID = i;
                    prop.setProperty(intruder.uniquename, String.format("%d", i));
                }
                ++i;
            }
            return isave;
        }
        return 0;
    }

    public static void reRegisterBlockAt(String s, int loc) {
        if (loc <= 0 || loc >= 2048) {
            return;
        }
        if (s == null || s.equals("")) {
            return;
        }
        if (BlockArray[loc] != null) {
            if (s.equals(Blocks.BlockArray[loc].uniquename)) {
                return;
            }
            int i = 1;
            while (i < 2048) {
                if (BlockArray[i] != null && s.equals(Blocks.BlockArray[i].uniquename)) {
                    Block me = BlockArray[i];
                    Block intruder = BlockArray[loc];
                    Blocks.BlockArray[loc] = me;
                    Blocks.BlockArray[loc].blockID = loc;
                    Blocks.BlockArray[i] = intruder;
                    Blocks.BlockArray[i].blockID = i;
                    return;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < 2048) {
                if (BlockArray[i] != null && s.equals(Blocks.BlockArray[i].uniquename)) {
                    Blocks.BlockArray[loc] = BlockArray[i];
                    Blocks.BlockArray[loc].blockID = loc;
                    Blocks.BlockArray[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static void load() {
        FileInputStream input = null;
        prop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds\\%s\\blockIDs.dat", DangerZone.worldname);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds\\%s\\blockIDs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            output = new FileOutputStream(filepath);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isSolid(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isSolid;
    }

    public static boolean isLiquid(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isLiquid;
    }

    public static boolean isSolidForRender(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isSolidForRendering;
    }

    public static boolean shouldShow(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].showInInventory;
    }

    public static boolean isTranslucentForRender(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isTranslucent;
    }

    public static boolean hasOwnRenderer(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].hasOwnRenderer;
    }

    public static boolean alwaystick(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].alwaystick;
    }

    public static boolean randomtick(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].randomtick;
    }

    public static boolean isWood(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isWood;
    }

    public static boolean isStone(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isStone;
    }

    public static boolean isDirt(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isDirt;
    }

    public static boolean isLeaves(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isLeaves;
    }

    public static boolean canLeavesGrow(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].canLeavesGrow;
    }

    public static void doblocktick(World w, int d, int x, int y, int z, int blockid) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].tickMe(w, d, x, y, z);
    }

    public static void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].renderMe(wr, w, d, x, y, z, blockid, meta, sides, focused);
    }

    public static void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused, int xo, int yo, int zo) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].renderMeToVBO(chunkvbos, wr, w, d, x, y, z, blockid, meta, sides, focused, xo, yo, zo);
    }

    public static String getBreakSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getBreakSound();
    }

    public static String getPlaceSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getPlaceSound();
    }

    public static String getHitSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getHitSound();
    }

    public static String getParticleName(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getParticleName();
    }

    public static int getMaxStack(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].maxstack;
    }

    public static int getMinDamage(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].mindamage;
    }

    public static Texture getTexture(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getTexture(1);
    }

    public static void notifyNeighborChanged(int blockid, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].notifyNeighborChanged(w, d, x, y, z);
    }

    public static String getUniqueName(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return Blocks.BlockArray[blockid].uniquename;
    }

    public static int findByName(String name) {
        if (name == null) {
            return 0;
        }
        int i = 1;
        while (i < 2048) {
            if (BlockArray[i] != null && Blocks.BlockArray[i].uniquename != null && name.equals(Blocks.BlockArray[i].uniquename)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static boolean rightClickOnBlock(int blockid, Player p, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].rightClickOnBlock(p, d, x, y, z);
    }

    public static boolean leftClickOnBlock(int blockid, Player p, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].leftClickOnBlock(p, d, x, y, z);
    }

    public static void onBlockBroken(int blockid, Player p, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].onBlockBroken(p, d, x, y, z);
    }

    public static int getMaxDamage(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].maxdamage;
    }

    public static int getBlockDrop(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getBlockDrop(p, w, d, x, y, z);
    }

    public static int getItemDrop(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getItemDrop(p, w, d, x, y, z);
    }

    public static float getFriction(int blockid) {
        if (blockid <= 0) {
            return 0.0f;
        }
        if (blockid >= 2048) {
            return 0.0f;
        }
        if (BlockArray[blockid] == null) {
            return 0.0f;
        }
        return Blocks.BlockArray[blockid].friction;
    }

    public static float getLightLevel(int blockid) {
        if (blockid <= 0) {
            return 0.0f;
        }
        if (blockid >= 2048) {
            return 0.0f;
        }
        if (BlockArray[blockid] == null) {
            return 0.0f;
        }
        return Blocks.BlockArray[blockid].brightness;
    }

    public static void doSteppedOn(int blockid, Entity e, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].doSteppedOn(e, w, d, x, y, z);
    }

    public static void doPlaceBlock(int blockid, int focusblockid, Player p, World w, int d, int x, int y, int z, int side) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].doPlaceBlock(focusblockid, p, w, d, x, y, z, side);
    }

    public static void doBreakBlock(int blockid, World w, int d, int x, int y, int z) {
        EntityBlockItem eb;
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        int bid = BlockArray[blockid].getBlockDrop(null, w, d, x, y, z);
        int iid = BlockArray[blockid].getItemDrop(null, w, d, x, y, z);
        if ((bid != 0 || iid != 0) && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f)) != null) {
            eb.setBID(bid);
            eb.setIID(iid);
            w.spawnEntityInWorld(eb);
        }
    }
}

