/*
 * Decompiled with CFR 0.152.
 */
public class BlockWaterSource
extends Block {
    BlockWaterSource(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.isTranslucent = true;
        this.friction = 0.25f;
        this.maxdamage = 2;
        this.maxstack = 16;
        this.showInInventory = false;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        boolean change = false;
        int i = -1;
        while (i <= 1) {
            int j = 0;
            while (j >= -1) {
                int k = -1;
                while (k <= 1) {
                    int bid = w.getblock(d, x + i, y + j, z + k);
                    int meta = w.getblockmeta(d, x + i, y + j, z + k);
                    if (bid == 0) {
                        change = true;
                    } else if (bid == Blocks.water.blockID) {
                        if (meta != 0) {
                            change = true;
                        }
                    } else if (bid != Blocks.watersource.blockID && !Blocks.isSolid(bid)) {
                        change = true;
                    }
                    ++k;
                }
                --j;
            }
            ++i;
        }
        if (change) {
            w.setblockandmeta(d, x, y, z, Blocks.water.blockID, 0);
        }
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return Blocks.water.blockID;
    }
}

