/*
 * Decompiled with CFR 0.152.
 */
public class BlockLiquid
extends Block {
    BlockLiquid(String n, String txt) {
        super(n, txt);
        this.alwaystick = true;
        this.isSolidForRendering = false;
        this.isTranslucent = true;
        this.isSolid = false;
        this.isLiquid = true;
        this.friction = 0.2f;
        this.maxstack = 16;
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        int meta = w.getblockmeta(dimension, x, y, z);
        if (meta != 0) {
            return 0;
        }
        return super.getBlockDrop(p, w, dimension, x, y, z);
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        int i;
        int meta = w.getblockmeta(d, x, y, z);
        int bid = w.getblock(d, x, y - 1, z);
        if (bid == 0 || Blocks.isLeaves(bid)) {
            Blocks.doBreakBlock(bid, w, d, x, y, z);
            w.setblockandmeta(d, x, y - 1, z, this.blockID, meta);
            w.setblock(d, x, y, z, 0);
            return;
        }
        if (meta != 0) {
            switch (w.rand.nextInt(4)) {
                case 0: {
                    i = meta >> 12 & 0xF;
                    if (i < 15) {
                        ++i;
                    }
                    meta = meta & 0xFFF | i << 12;
                    break;
                }
                case 1: {
                    i = meta >> 8 & 0xF;
                    if (i < 15) {
                        ++i;
                    }
                    meta = meta & 0xF0FF | i << 8;
                    break;
                }
                case 2: {
                    i = meta >> 4 & 0xF;
                    if (i < 15) {
                        ++i;
                    }
                    meta = meta & 0xFF0F | i << 4;
                    break;
                }
                case 3: {
                    i = meta & 0xF;
                    if (i < 15) {
                        ++i;
                    }
                    meta = meta & 0xFFF0 | i;
                }
            }
            w.setblockandmeta(d, x, y, z, this.blockID, meta);
        }
        if (meta == 65535) {
            w.setblockandmeta(d, x, y, z, 0, 0);
            return;
        }
        i = meta >> 12 & 0xF;
        i += meta >> 8 & 0xF;
        i += meta >> 4 & 0xF;
        int metaave = (i += meta & 0xF) / 4;
        bid = w.getblock(d, x, y - 1, z);
        if (bid != this.blockID && metaave < 14) {
            int j = 0;
            while (j >= -1) {
                i = -1;
                while (i <= 1) {
                    int k = -1;
                    while (k <= 1) {
                        bid = w.getblock(d, x + i, y + j, z + k);
                        if (bid == this.blockID) {
                            int nm = w.getblockmeta(d, x + i, y + j, z + k);
                            int nma = nm >> 12 & 0xF;
                            nma += nm >> 8 & 0xF;
                            nma += nm >> 4 & 0xF;
                            nma += nm & 0xF;
                            if ((nma /= 4) > metaave + 1) {
                                int tv = nm >> 12 & 0xF;
                                if (tv > 0) {
                                    --tv;
                                }
                                nm &= 0xFFF;
                                if ((tv = (nm |= tv << 12) >> 8 & 0xF) > 0) {
                                    --tv;
                                }
                                nm &= 0xF0FF;
                                if ((tv = (nm |= tv << 8) >> 4 & 0xF) > 0) {
                                    --tv;
                                }
                                nm &= 0xFF0F;
                                if ((tv = (nm |= tv << 4) & 0xF) > 0) {
                                    --tv;
                                }
                                nm &= 0xFFF0;
                                w.setblockandmeta(d, x + i, y + j, z + k, this.blockID, nm |= tv);
                            }
                        }
                        if (bid == 0 || Blocks.isLeaves(bid)) {
                            Blocks.doBreakBlock(bid, w, d, x + i, y + j, z + k);
                            w.setblockandmeta(d, x + i, y + j, z + k, this.blockID, 61166);
                        }
                        ++k;
                    }
                    ++i;
                }
                --j;
            }
        }
    }
}

