/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class Block {
    public int blockID = 0;
    public String texturepath;
    public String uniquename;
    public int maxstack = 64;
    Texture texture = null;
    StitchedTexture stitchedtexture = new StitchedTexture();
    public boolean randomtick = false;
    public boolean alwaystick = false;
    public boolean hasOwnRenderer = false;
    public boolean isSolidForRendering = true;
    public boolean isTranslucent = false;
    public boolean isSolid = true;
    public boolean isLiquid = false;
    public String breaksound = null;
    public String placesound = null;
    public String hitsound = null;
    public boolean isWood = false;
    public boolean canLeavesGrow = false;
    public boolean isLeaves = false;
    public boolean isStone = false;
    public boolean isDirt = false;
    public boolean showInInventory = true;
    public int maxdamage = 20;
    public float friction = 0.1f;
    public float brightness = 0.0f;
    public String particlename = null;
    public int mindamage = 0;

    Block(String n, String txt) {
        this.texturepath = txt;
        this.uniquename = n;
        this.breaksound = "DangerZone:blockbreak";
        this.placesound = "DangerZone:blockplace";
        this.hitsound = "DangerZone:blockhit";
        this.maxstack = 64;
        this.maxdamage = 20;
    }

    public String getBreakSound() {
        return this.breaksound;
    }

    public String getPlaceSound() {
        return this.placesound;
    }

    public String getHitSound() {
        return this.hitsound;
    }

    public String getParticleName() {
        return this.particlename;
    }

    public void tickMe(World w, int d, int x, int y, int z) {
    }

    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
    }

    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int side, boolean focused) {
    }

    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int side, boolean focused, int xo, int yo, int zo) {
    }

    public Texture getTexture(int side) {
        if (this.texture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
        }
        return this.texture;
    }

    public StitchedTexture getStitchedTexture(int side) {
        return this.stitchedtexture;
    }

    public String getStitchedTextureName(int side) {
        return this.texturepath;
    }

    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z) {
        return true;
    }

    public boolean leftClickOnBlock(Player p, int dimension, int x, int y, int z) {
        return true;
    }

    public void onBlockBroken(Player p, int dimension, int x, int y, int z) {
    }

    public void doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        int newx = x;
        int newy = y;
        int newz = z;
        if (Blocks.isLiquid(focusbid) || Blocks.isLeaves(focusbid) && !Blocks.isLeaves(this.blockID) || !Blocks.isSolid(focusbid)) {
            EntityBlockItem eb;
            if (this.entityInBlock(w, dimension, x, y, z)) {
                return;
            }
            int bbid = Blocks.getBlockDrop(focusbid, p, w, dimension, x, y, z);
            int biid = Blocks.getItemDrop(focusbid, p, w, dimension, x, y, z);
            w.setblockandmeta(dimension, x, y, z, this.blockID, 0);
            if (bbid > 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, dimension, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f)) != null) {
                eb.setBID(bbid);
                eb.setIID(0);
                w.spawnEntityInWorld(eb);
            }
            if (biid > 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, dimension, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f)) != null) {
                eb.setBID(0);
                eb.setIID(biid);
                w.spawnEntityInWorld(eb);
            }
        } else {
            switch (side) {
                case 0: {
                    ++newy;
                    break;
                }
                case 1: {
                    ++newz;
                    break;
                }
                case 2: {
                    --newz;
                    break;
                }
                case 3: {
                    --newx;
                    break;
                }
                case 4: {
                    ++newx;
                    break;
                }
                case 5: {
                    --newy;
                }
            }
            if (this.entityInBlock(w, dimension, newx, newy, newz)) {
                return;
            }
            w.setblockandmeta(dimension, newx, newy, newz, this.blockID, 0);
        }
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, newx, newy, newz, 0.5f, 1.0f);
        if (p == null) {
            return;
        }
        if (p.getGameMode() == 0) {
            --p.hotbar[p.current_hotbar_index].count;
            p.sendInventoryUpdate(0, p.current_hotbar_index, p.hotbar[p.current_hotbar_index]);
            if (p.hotbar[p.current_hotbar_index].count <= 0) {
                p.hotbar[p.current_hotbar_index] = null;
            }
        }
    }

    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return this.blockID;
    }

    public int getItemDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    public void doSteppedOn(Entity e, World w, int d, int x, int y, int z) {
    }

    public Texture initBlockTexture(String tp) {
        Texture ltexture = null;
        try {
            ltexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("res/blocks/" + tp));
        }
        catch (IOException e) {
            System.out.printf("Failed to load block texture %s\n", "res/blocks/" + tp);
            e.printStackTrace();
        }
        return ltexture;
    }

    private boolean entityInBlock(World w, int d, int x, int y, int z) {
        List<Entity> nearby_list = null;
        nearby_list = w.isServer ? DangerZone.server.entityManager.findEntitiesInRange(16.0f, d, x, y, z) : DangerZone.entityManager.findEntitiesInRange(16.0f, d, x, y, z);
        if (nearby_list != null) {
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                Entity e = li.next();
                if (e instanceof EntityBlockItem) continue;
                if (x == (int)e.posx && y == (int)e.posy && z == (int)e.posz) {
                    return true;
                }
                if (!(e instanceof EntityLiving)) continue;
                EntityLiving el = (EntityLiving)e;
                int intheight = (int)(el.height + 0.995f);
                int k = 0;
                while (k < intheight) {
                    float dz;
                    float dx;
                    if ((int)el.posy + k == y && Math.sqrt((dx = el.posx - ((float)x + 0.5f)) * dx + (dz = el.posz - ((float)z + 0.5f)) * dz) < (double)(0.5f + el.width / 2.0f)) {
                        return true;
                    }
                    ++k;
                }
            }
        }
        return false;
    }
}

