/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class World {
    public ChunkCache chunkcache = null;
    public ServerChunkCache serverchunkcache = null;
    public Player player = null;
    public Random rand;
    public boolean isServer = false;
    public int timetimer;
    public int lengthOfDay = 360;

    World(ChunkCache c, ServerChunkCache s, Player p) {
        this.chunkcache = c;
        this.serverchunkcache = s;
        this.player = p;
        this.rand = new Random(System.currentTimeMillis());
        this.isServer = false;
        this.timetimer = 0;
    }

    public Biome getBiome(int d, int x, int y, int z) {
        if (Dimensions.getBiomeManager(d) == null) {
            return null;
        }
        return Dimensions.getBiomeManager(d).getBiomeForChunk(d, x, y, z);
    }

    public int getblock(int d, int x, int y, int z) {
        if (this.isServer) {
            return this.serverchunkcache.getBlock(this, d, x, y, z);
        }
        return this.chunkcache.getBlock(this, d, x, y, z);
    }

    public int getblockmeta(int d, int x, int y, int z) {
        if (this.isServer) {
            return this.serverchunkcache.getBlockmeta(this, d, x, y, z);
        }
        return this.chunkcache.getBlockmeta(this, d, x, y, z);
    }

    public void setblock(int d, int x, int y, int z, int id) {
        block10: {
            block9: {
                if (!this.isServer) break block9;
                this.serverchunkcache.setBlock(this, d, x, y, z, id, 0);
                if (!this.serverchunkcache.isDecorated(d, x, y, z)) break block10;
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        int k = -1;
                        while (k <= 1) {
                            if (k != 0 || j != 0 || i != 0) {
                                Blocks.notifyNeighborChanged(this.serverchunkcache.getBlock(this, d, x + i, y + j, z + k), this, d, x + i, y + j, z + k);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break block10;
            }
            this.chunkcache.setBlock(this, d, x, y, z, id, 0);
            if (DangerZone.start_server) {
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        int k = -1;
                        while (k <= 1) {
                            if (k != 0 || j != 0 || i != 0) {
                                Blocks.notifyNeighborChanged(this.chunkcache.getBlock(this, d, x + i, y + j, z + k), this, d, x + i, y + j, z + k);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void setblockandmeta(int d, int x, int y, int z, int id, int meta) {
        block10: {
            block9: {
                if (!this.isServer) break block9;
                this.serverchunkcache.setBlock(this, d, x, y, z, id, meta);
                if (!this.serverchunkcache.isDecorated(d, x, y, z)) break block10;
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        int k = -1;
                        while (k <= 1) {
                            if (k != 0 || j != 0 || i != 0) {
                                Blocks.notifyNeighborChanged(this.serverchunkcache.getBlock(this, d, x + i, y + j, z + k), this, d, x + i, y + j, z + k);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break block10;
            }
            this.chunkcache.setBlock(this, d, x, y, z, id, meta);
            if (DangerZone.start_server) {
                int i = -1;
                while (i <= 1) {
                    int j = -1;
                    while (j <= 1) {
                        int k = -1;
                        while (k <= 1) {
                            if (k != 0 || j != 0 || i != 0) {
                                Blocks.notifyNeighborChanged(this.chunkcache.getBlock(this, d, x + i, y + j, z + k), this, d, x + i, y + j, z + k);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void decorate(World world, int dimension, int chunkx, int chunkz) {
        if (!this.isServer) {
            return;
        }
        int i = 0;
        while (i < 512) {
            if (WorldDecorators.WorldDecoratorArray[i] == null) break;
            WorldDecorators.WorldDecoratorArray[i].decorate(world, dimension, chunkx, chunkz);
            ++i;
        }
    }

    public Entity createEntityByName(String name, int dimension, float x, float y, float z) {
        Entity e = Entities.spawnEntityByName(name, this);
        if (e == null) {
            return null;
        }
        e.dimension = dimension;
        e.posx = x;
        e.posy = y;
        e.posz = z;
        e.rotation_yaw = e.rotation_yaw_head = (float)this.rand.nextInt(360);
        return e;
    }

    public void spawnEntityInWorld(Entity e) {
        if (this.isServer) {
            if (DangerZone.server.entityManager.addEntity(e) > 0) {
                DangerZone.server.sendSpawnEntityToAll(e);
            }
        } else {
            DangerZone.server_connection.spawnEntity(e);
        }
    }

    public Particle createParticleByName(String name, int dimension, float x, float y, float z) {
        if (this.isServer) {
            return null;
        }
        Particle e = Particles.spawnParticleByName(name);
        if (e == null) {
            return null;
        }
        e.dimension = dimension;
        e.posx = x;
        e.posy = y;
        e.posz = z;
        return e;
    }

    public void spawnParticleInWorld(Particle e) {
        if (this.isServer) {
            return;
        }
        DangerZone.particleManager.addParticle(e);
    }

    public void playSound(String name, int dimension, float posx, float posy, float posz, float volume, float frequency) {
        if (name == null) {
            return;
        }
        if (name.equals("")) {
            return;
        }
        if (this.isServer) {
            DangerZone.server.sendSoundToAll(name, dimension, posx, posy, posz, volume, frequency);
        } else {
            DangerZone.server_connection.sendSound(name, dimension, posx, posy, posz, volume, frequency);
            DangerZone.soundmangler.playSound(name, volume, frequency, dimension, posx, posy, posz);
        }
    }

    public boolean isDaytime() {
        return this.timetimer < this.lengthOfDay / 2;
    }

    public int getTimeOfDay() {
        return this.timetimer;
    }

    public int getLengthOfDay() {
        return this.lengthOfDay;
    }
}

