/*
 * Decompiled with CFR 0.152.
 */
public class SpawnerThread
implements Runnable {
    public int spawnmax = 8;
    public int spawnmin = 2;

    @Override
    public void run() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (DangerZone.gameover == 0) {
            Player p;
            int i = DangerZone.server_world.rand.nextInt(this.spawnmax - this.spawnmin);
            int j = DangerZone.server_world.rand.nextInt(this.spawnmax - this.spawnmin);
            i += this.spawnmin;
            j += this.spawnmin;
            if (DangerZone.server_world.rand.nextInt(2) == 0) {
                i = -i;
            }
            if (DangerZone.server_world.rand.nextInt(2) == 0) {
                j = -j;
            }
            if ((p = DangerZone.server.getRandomPlayer(DangerZone.server_world.rand)) == null) {
                return;
            }
            this.tickChunk(DangerZone.server_world, p.dimension, (i << 4) + (int)p.posx, (j << 4) + (int)p.posz, CreatureTypes.TRANSIENT);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void tickChunk(World w, int dim, int xrel, int zrel, int perm) {
        Chunk c = w.serverchunkcache.getDecoratedChunk(dim, xrel, 0, zrel);
        if (c == null) {
            return;
        }
        SpawnerThread.doSpawnChunk(c, w, dim, xrel, zrel, perm);
    }

    public static void doSpawnChunk(Chunk c, World w, int dim, int xrel, int zrel, int perm) {
        for (SpawnlistEntry st : Spawnlist.spawnlist) {
            if (st.permanence != perm || st.chance < w.rand.nextInt(1000) || st.dimensionname != null && !st.dimensionname.equals(Dimensions.getName(c.dimension)) || st.biomename != null && !st.biomename.equals(Dimensions.getBiomeManager((int)c.dimension).getBiomeForChunk((int)c.dimension, (int)xrel, (int)0, (int)zrel).uniquename)) continue;
            int tries = 0;
            while (tries < st.tries) {
                int bid;
                Entity eb;
                int j;
                boolean fits;
                int iy;
                int ih;
                int xpos = 2 + w.rand.nextInt(14);
                int zpos = 2 + w.rand.nextInt(14);
                if (st.type == CreatureTypes.LAND) {
                    ih = (int)(st.whatToSpawn.height + 1.0f);
                    iy = w.rand.nextInt(st.maxy - st.miny + 1);
                    iy += st.miny;
                    while (iy < st.maxy) {
                        if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy, (c.chunkZ << 4) + zpos, st.whatToSpawn.width) && !SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + 1, (c.chunkZ << 4) + zpos, st.whatToSpawn.width)) {
                            fits = true;
                            if (ih > 1) {
                                j = 2;
                                while (j <= ih && fits) {
                                    if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + j, (c.chunkZ << 4) + zpos, st.whatToSpawn.width)) {
                                        fits = false;
                                    }
                                    ++j;
                                }
                            }
                            if (fits && st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((float)((c.chunkX << 4) + xpos) + 0.5f), (int)((float)iy + 1.01f), (int)((float)((c.chunkZ << 4) + zpos) + 0.5f)) && (eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (float)((c.chunkX << 4) + xpos) + 0.5f, (float)iy + 1.01f, (float)((c.chunkZ << 4) + zpos) + 0.5f)) != null) {
                                eb.init();
                                w.spawnEntityInWorld(eb);
                            }
                        }
                        ++iy;
                    }
                } else if (st.type == CreatureTypes.AIR) {
                    Entity eb2;
                    iy = w.rand.nextInt(st.maxy - st.miny + 1);
                    iy += st.miny;
                    int iw = (int)(st.whatToSpawn.width / 2.0f + 0.5f);
                    int ih2 = (int)(st.whatToSpawn.height + 1.0f);
                    boolean fits2 = true;
                    int i = -iw;
                    while (i <= iw && fits2) {
                        int k = -iw;
                        while (k <= iw && fits2) {
                            j = 0;
                            while (j <= ih2 && fits2) {
                                bid = w.getblock(c.dimension, (c.chunkX << 4) + xpos + i, iy + j, (c.chunkZ << 4) + zpos + k);
                                if (Blocks.isSolid(bid)) {
                                    fits2 = false;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (fits2 && st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((float)((c.chunkX << 4) + xpos) + 0.5f), (int)((float)iy + 0.5f), (int)((float)((c.chunkZ << 4) + zpos) + 0.5f)) && (eb2 = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (float)((c.chunkX << 4) + xpos) + 0.5f, (float)iy + 0.5f, (float)((c.chunkZ << 4) + zpos) + 0.5f)) != null) {
                        eb2.init();
                        w.spawnEntityInWorld(eb2);
                    }
                } else if (st.type == CreatureTypes.WATER) {
                    ih = (int)(st.whatToSpawn.height + 1.0f);
                    iy = w.rand.nextInt(st.maxy - st.miny + 1);
                    iy += st.miny;
                    while (iy < st.maxy) {
                        bid = w.getblock(c.dimension, (c.chunkX << 4) + xpos, iy, (c.chunkZ << 4) + zpos);
                        if ((bid == Blocks.water.blockID || bid == Blocks.watersource.blockID) && w.getblock(c.dimension, (c.chunkX << 4) + xpos, iy + 1, (c.chunkZ << 4) + zpos) == 0) {
                            fits = true;
                            if (ih > 1) {
                                j = 2;
                                while (j <= ih && fits) {
                                    if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + j, (c.chunkZ << 4) + zpos, st.whatToSpawn.width)) {
                                        fits = false;
                                    }
                                    ++j;
                                }
                            }
                            if (fits && st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((float)((c.chunkX << 4) + xpos) + 0.5f), (int)((float)iy + 1.01f), (int)((float)((c.chunkZ << 4) + zpos) + 0.5f)) && (eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (float)((c.chunkX << 4) + xpos) + 0.5f, (float)iy + 1.01f, (float)((c.chunkZ << 4) + zpos) + 0.5f)) != null) {
                                eb.init();
                                w.spawnEntityInWorld(eb);
                            }
                        }
                        ++iy;
                    }
                } else if (st.type == CreatureTypes.UNDERGROUND) {
                    ih = (int)(st.whatToSpawn.height + 1.0f);
                    iy = st.miny;
                    while (iy < st.maxy) {
                        if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy, (c.chunkZ << 4) + zpos, st.whatToSpawn.width) && !SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + 1, (c.chunkZ << 4) + zpos, st.whatToSpawn.width)) {
                            fits = true;
                            if (ih > 1) {
                                j = 2;
                                while (j <= ih && fits) {
                                    if (SpawnerThread.isSolidAtLevel(w, c.dimension, (c.chunkX << 4) + xpos, iy + j, (c.chunkZ << 4) + zpos, st.whatToSpawn.width)) {
                                        fits = false;
                                    }
                                    ++j;
                                }
                            }
                            if (fits && st.whatToSpawn.getCanSpawnHereNow(w, c.dimension, (int)((float)((c.chunkX << 4) + xpos) + 0.5f), (int)((float)iy + 1.01f), (int)((float)((c.chunkZ << 4) + zpos) + 0.5f)) && (eb = w.createEntityByName(st.whatToSpawn.uniquename, c.dimension, (float)((c.chunkX << 4) + xpos) + 0.5f, (float)iy + 1.01f, (float)((c.chunkZ << 4) + zpos) + 0.5f)) != null) {
                                eb.init();
                                w.spawnEntityInWorld(eb);
                            }
                        }
                        ++iy;
                    }
                }
                ++tries;
            }
        }
    }

    public static boolean isSolidAtLevel(World w, int d, float x, float y, float z, float width) {
        int intwidth = (int)(width / 2.0f + 0.5f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(w.getblock(d, (int)x + i, (int)y, (int)z + j))) {
                    int itemp = (int)x + i;
                    float dx = x - ((float)itemp + 0.5f);
                    if ((dx = Math.abs(dx)) < 0.49f + width / 2.0f) {
                        itemp = (int)z + j;
                        float dz = z - ((float)itemp + 0.5f);
                        if ((dz = Math.abs(dz)) < 0.49f + width / 2.0f) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

