/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServerChunkCache {
    public Lock lock = new ReentrantLock();
    public Lock slowlock = new ReentrantLock();
    private int hashwidth = 512;
    private int hashmask = 511;
    private int[] sizes = new int[this.hashwidth];
    private int startsize = 128;
    private Chunk[][] chunkhash = new Chunk[this.hashwidth][];
    private Chunk lastchunk = null;
    private int lastd;
    private int lastchunkx;
    private int lastchunkz;
    public int nextclean = 0;

    public ServerChunkCache() {
        int i = 0;
        while (i < this.hashwidth) {
            this.sizes[i] = this.startsize;
            this.chunkhash[i] = new Chunk[this.startsize];
            int j = 0;
            while (j < this.startsize) {
                this.chunkhash[i][j] = null;
                ++j;
            }
            ++i;
        }
        this.lastd = -1;
        this.lastchunkz = 0;
        this.lastchunkx = 0;
    }

    private Chunk findChunk(int dimension, int x, int y, int z) {
        int i = x >> 4;
        int j = z >> 4;
        if (this.lastchunk != null && dimension == this.lastd && i == this.lastchunkx && j == this.lastchunkz) {
            return this.lastchunk;
        }
        int h = i * 16 + j & this.hashmask;
        int k = 0;
        while (k < this.sizes[h]) {
            if (this.chunkhash[h][k] == null) {
                return null;
            }
            if (this.chunkhash[h][k].dimension == dimension && this.chunkhash[h][k].chunkX == i && this.chunkhash[h][k].chunkZ == j) {
                this.lastchunk = this.chunkhash[h][k];
                this.lastd = dimension;
                this.lastchunkx = i;
                this.lastchunkz = j;
                if (k > 0) {
                    this.chunkhash[h][k] = this.chunkhash[h][k - 1];
                    this.chunkhash[h][k - 1] = this.lastchunk;
                }
                return this.lastchunk;
            }
            ++k;
        }
        return null;
    }

    public void releaseAllVBOs() {
        Chunk c = null;
        this.lock.lock();
        int i = 0;
        while (i < this.hashwidth) {
            int j = 0;
            while (j < this.sizes[i]) {
                c = this.chunkhash[i][j];
                if (c == null) break;
                DangerZone.wr.deleteVBOlist(c.VBOids);
                c.VBOids = new long[20];
                ++j;
            }
            ++i;
        }
        this.lock.unlock();
    }

    public Chunk getChunk(World w, int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(dimension, x, y, z);
        this.lock.unlock();
        return t;
    }

    public Chunk getDecoratedChunkForRenderer(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        return t;
    }

    public Chunk getDecoratedChunk(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isDecorated != 0) {
                this.lock.unlock();
                return t;
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            if (t.isDecorated == 0) {
                t.decorate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            return t;
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        if (t.isDecorated == 0) {
            t.decorate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        return t;
    }

    public short[] getDecoratedChunkLevelData(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isDecorated != 0) {
                this.lock.unlock();
                return t.blockdata[y];
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            if (t.isDecorated == 0) {
                t.decorate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            return t.blockdata[y];
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        if (t.isDecorated == 0) {
            t.decorate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        return t.blockdata[y];
    }

    public long[] getDecoratedChunkVBOids(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return null;
        }
        if (t.isDecorated != 0) {
            return t.VBOids;
        }
        return null;
    }

    public short[] getDecoratedChunkMetaData(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isDecorated != 0) {
                this.lock.unlock();
                return t.metadata[y];
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            if (t.isDecorated == 0) {
                t.decorate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            return t.metadata[y];
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        if (t.isDecorated == 0) {
            t.decorate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        return t.metadata[y];
    }

    public short[] getDecoratedChunkDrawn(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return null;
        }
        if (t.isDecorated != 0) {
            return t.drawn;
        }
        return null;
    }

    public float[] getDecoratedChunkLightmap(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return null;
        }
        if (t.isDecorated != 0) {
            if (t.lightmap == null) {
                return null;
            }
            return t.lightmap[y];
        }
        return null;
    }

    public void clearDecoratedChunkLightmap(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return;
        }
        if (t.isDecorated != 0) {
            if (t.lightmap == null) {
                return;
            }
            t.lightmap[y] = null;
            return;
        }
    }

    public void setDecoratedChunkLightmap(int d, int x, int y, int z, float v) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return;
        }
        if (t.isDecorated != 0) {
            if (t.lightmap == null) {
                t.lightmap = new float[256][];
            }
            if (t.lightmap[y] == null) {
                t.lightmap[y] = new float[256];
            }
            int m = x & 0xF;
            int n = z & 0xF;
            t.lightmap[y][m * 16 + n] = v;
            return;
        }
    }

    public void addCacheChunk(Chunk c) {
        Chunk t = this.findChunk(c.dimension, c.chunkX << 4, 0, c.chunkZ << 4);
        if (t != null) {
            return;
        }
        int h = c.chunkX * 16 + c.chunkZ & this.hashmask;
        int i = 0;
        while (i < this.sizes[h]) {
            if (i == this.sizes[h] - 1) {
                int oldsize = this.sizes[h];
                int newsize = oldsize + 100;
                Chunk[] newlist = new Chunk[newsize];
                int k = 0;
                while (k < newsize) {
                    newlist[k] = null;
                    ++k;
                }
                k = 0;
                while (k < oldsize) {
                    newlist[k] = this.chunkhash[h][k];
                    ++k;
                }
                k = 0;
                while (k < oldsize) {
                    this.chunkhash[h][k] = null;
                    ++k;
                }
                this.chunkhash[h] = newlist;
                this.sizes[h] = newsize;
            }
            if (this.chunkhash[h][i] == null) {
                this.chunkhash[h][i] = c;
                return;
            }
            ++i;
        }
    }

    public void cleanCacheRow() {
        this.lock.lock();
        this.lastchunk = null;
        this.lastd = -1;
        int i = 0;
        while (i < this.sizes[this.nextclean]) {
            if (this.chunkhash[this.nextclean][i] == null) break;
            if (DangerZone.server.findNearestPlayerDistToHere(this.chunkhash[this.nextclean][i].dimension, this.chunkhash[this.nextclean][i].chunkX << 4, this.chunkhash[this.nextclean][i].chunkZ << 4) > (float)((DangerZone.renderdistance + 4) * 16)) {
                int h = i;
                DangerZone.chunkwriter.addChunk(this.chunkhash[this.nextclean][h]);
                if (DangerZone.wr != null) {
                    DangerZone.wr.deleteVBOlist(this.chunkhash[this.nextclean][h].VBOids);
                }
                while (h + 1 < this.sizes[this.nextclean]) {
                    this.chunkhash[this.nextclean][h] = this.chunkhash[this.nextclean][h + 1];
                    if (this.chunkhash[this.nextclean][h] == null) break;
                    ++h;
                }
            }
            ++i;
        }
        ++this.nextclean;
        if (this.nextclean > this.hashmask) {
            this.nextclean = 0;
        }
        this.lock.unlock();
    }

    public int getBlock(World w, int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isValid != 0) {
                int b = t.getblock(x, y, z);
                this.lock.unlock();
                return b;
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            int b = t.getblock(x, y, z);
            return b;
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        int b = t.getblock(x, y, z);
        return b;
    }

    public int getBlockmeta(World w, int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isValid != 0) {
                int b = t.getblockmeta(x, y, z);
                this.lock.unlock();
                return b;
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            int b = t.getblockmeta(x, y, z);
            return b;
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        int b = t.getblockmeta(x, y, z);
        return b;
    }

    public void setBlock(World w, int d, int x, int y, int z, int id, int meta) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isValid != 0) {
                this.lock.unlock();
                int b = t.getblock(x, y, z);
                int m = t.getblockmeta(x, y, z);
                if (id == b && meta == m) {
                    return;
                }
                if (id != b) {
                    t.setblock(x, y, z, id);
                }
                if (meta != m) {
                    t.setblockmeta(x, y, z, meta);
                }
                if (!DangerZone.start_client) {
                    DangerZone.server.sendBlockToAll(d, x, y, z, id, meta);
                }
                return;
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            int b = t.getblock(x, y, z);
            int m = t.getblockmeta(x, y, z);
            if (id == b && meta == m) {
                return;
            }
            if (id != b) {
                t.setblock(x, y, z, id);
            }
            if (meta != m) {
                t.setblockmeta(x, y, z, meta);
            }
            if (!DangerZone.start_client) {
                DangerZone.server.sendBlockToAll(d, x, y, z, id, meta);
            }
            return;
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        int b = t.getblock(x, y, z);
        int m = t.getblockmeta(x, y, z);
        if (id == b && meta == m) {
            return;
        }
        if (id != b) {
            t.setblock(x, y, z, id);
        }
        if (meta != m) {
            t.setblockmeta(x, y, z, meta);
        }
        if (!DangerZone.start_client) {
            DangerZone.server.sendBlockToAll(d, x, y, z, id, meta);
        }
    }

    public boolean isDecorated(int d, int x, int y, int z) {
        boolean retflag = false;
        if (x < 0 || y < 0 || z < 0) {
            return retflag;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null && t.isValid != 0 && t.isDecorated != 0) {
            retflag = true;
        }
        this.lock.unlock();
        return retflag;
    }

    public void shutdown() {
        this.lock.lock();
        int i = 0;
        while (i < this.hashwidth) {
            int j = 0;
            while (j < this.sizes[i]) {
                Chunk t = this.chunkhash[i][j];
                if (t != null && t.isValid != 0) {
                    t.saveToDisk();
                }
                ++j;
            }
            ++i;
        }
        this.lock.unlock();
    }
}

