/*
 * Decompiled with CFR 0.152.
 */
import org.newdawn.slick.opengl.Texture;

public class Rat
extends EntityHostile {
    public Rat(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.35f;
        this.width = 0.45f;
        this.uniquename = "DangerZone:Rat";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(1.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 1.5f;
        this.movefrequency = 25;
        this.setExperience(20);
        this.canSwim = true;
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:ratlive";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:rathit";
    }

    @Override
    public String getDeathSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ratdead1";
        }
        if (i == 1) {
            return "DangerZone:ratdead2";
        }
        return "DangerZone:ratdead3";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.trophyrat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Rattexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (y > 30) {
            if (this.daytimecheck) {
                if (w.isDaytime()) {
                    return false;
                }
                if (this.getLightAtLocation(w, dimension, x, y, z) > 0.35f) {
                    return false;
                }
            }
        } else if (this.getLightAtLocation(w, dimension, x, y, z) > 0.35f) {
            return false;
        }
        return true;
    }
}

