/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class Player
extends EntityLiving {
    public Socket toServer;
    public Socket toClient;
    public ServerThread server_thread;
    public ServerConnection server_connection;
    public float eyeheight = 1.75f;
    public InventoryContainer[] hotbar;
    public InventoryContainer[] inventory;
    public int current_hotbar_index;
    public float armangle = 0.0f;
    public int armdir = 0;
    public float hit_x;
    public float hit_y;
    public float hit_z;
    public byte[] tdata = null;
    public boolean donewtexture = false;
    public String myname = null;
    public int starthealth = 50;
    public int swimdelay = 0;
    public int jump_delay = 0;
    public int lightupdatecounter = 0;

    public Player(World w) {
        super(w);
        this.width = 0.65f;
        this.height = 1.75f;
        this.eyeheight = 1.75f;
        this.uniquename = "DangerZone:Player";
        this.hotbar = new InventoryContainer[10];
        int i = 0;
        while (i < 10) {
            this.hotbar[i] = null;
            ++i;
        }
        this.inventory = new InventoryContainer[50];
        i = 0;
        while (i < 50) {
            this.inventory[i] = null;
            ++i;
        }
        this.current_hotbar_index = 0;
        this.setMaxHealth(this.starthealth);
        this.setHealth(this.starthealth);
        this.setDefense(1.0f);
        this.setMaxHunger(50.0f);
        this.setHunger(50.0f);
        this.setAttackDamage(1.0f);
        this.setMaxAir(50.0f);
        this.setAir(50.0f);
    }

    @Override
    public void init() {
        super.init();
        this.eyeheight = 1.75f;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (this.getGameMode() != 0) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
    }

    @Override
    public String getHurtSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ouch1";
        }
        if (i == 1) {
            return "DangerZone:ouch2";
        }
        return "DangerZone:ouch3";
    }

    @Override
    public float getRightArmAngle() {
        return -this.armangle;
    }

    @Override
    public void update(float deltaT) {
        if (this.jump_delay > 0) {
            --this.jump_delay;
        }
        if (!this.world.isServer) {
            this.setMaxHealth(this.starthealth + this.getExperience() / 1000);
            this.setDefense(1.0f + (float)this.getExperience() / 100000.0f);
            this.setAttackDamage(1.0f + (float)this.getExperience() / 10000.0f);
            if ((this.getHealth() < 0.0f || this.deadflag) && this == DangerZone.player) {
                DangerZone.gameover = 1;
            }
            if (this == DangerZone.player && this.getGameMode() == 0) {
                if (this.getHunger() > 0.0f) {
                    this.setHunger(this.getHunger() - 2.0E-4f);
                }
                if (this.getHealth() >= 0.0f && this.getHealth() < this.getMaxHealth() && this.getHunger() > this.getMaxHunger() / 2.0f) {
                    this.setHealth(0.002f + this.getHealth());
                }
                if (this.getHunger() <= 0.0f) {
                    this.setHealth(this.getHealth() - 0.001f);
                }
            }
            if (this.armdir != 0) {
                if (this.armdir > 0) {
                    this.armangle += 22.0f * deltaT;
                    if (this.armangle > 150.0f) {
                        this.armdir = -1;
                    }
                }
                if (this.armdir < 0) {
                    this.armangle -= 22.0f * deltaT;
                    if (this.armangle <= 0.0f) {
                        this.armdir = 0;
                        this.armangle = 0.0f;
                    }
                }
            }
            ++this.lightupdatecounter;
            if (this.lightupdatecounter > 5) {
                int bid = this.getBID();
                int iid = this.getIID();
                float lvl = 0.0f;
                if (bid != 0) {
                    lvl = Blocks.getLightLevel(bid);
                }
                if (iid != 0) {
                    lvl = Items.getLightLevel(iid);
                }
                if (lvl != 0.0f) {
                    LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + 1.25f), (int)this.posz, lvl);
                }
                this.lightupdatecounter = 0;
            }
        }
        boolean wasOnGround = this.getOnGround();
        super.update(deltaT);
        if (!this.world.isServer && !wasOnGround && this.getOnGround() && this.steppedOnCockroach()) {
            int i = 0;
            while (i < 256) {
                int id = (this.dimension + i + 1) % 256;
                if (Dimensions.DimensionArray[id] != null) {
                    Dimensions.DimensionArray[id].teleportToDimension(this, this.world, id, (int)this.posx, (int)this.posy, (int)this.posz);
                    this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                    Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, this.posx, this.posy, this.posz, true);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void jump() {
        if (this.getInLiquid() && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 1.5f), (int)this.posz))) {
            ++this.swimdelay;
            if (this.swimdelay > 40) {
                this.swimdelay = 0;
            }
            if (this.swimdelay > 15) {
                this.motiony += 0.035f;
                if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.35f, this.posz)) {
                    this.motiony += 0.55f;
                }
                if (!this.world.isServer && this.getHunger() > 0.0f && this.getGameMode() == 0) {
                    this.setHunger(this.getHunger() - 0.002f);
                }
            }
        }
        if (this.jump_delay > 0) {
            return;
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.02f, this.posz)) {
            return;
        }
        if (Math.abs(this.motiony) > 0.05f) {
            return;
        }
        this.motiony += 0.95f;
        this.jump_delay = 5;
        if (!this.world.isServer && this.getHunger() > 0.0f && this.getGameMode() == 0) {
            this.setHunger(this.getHunger() - 0.08f);
        }
    }

    public void leftclick(World world, int focus_x, int focus_y, int focus_z, int eid) {
        Entity e = null;
        boolean do_uses = false;
        if (world.isServer) {
            e = DangerZone.server.entityManager.findEntityByID(eid);
            if (e != null) {
                InventoryContainer ic;
                int dt = 0;
                float damage = 1.0f;
                int hbi = this.gethotbarindex();
                if (hbi < 0 || hbi >= this.hotbar.length) {
                    hbi = 0;
                }
                if ((ic = this.hotbar[hbi]) != null) {
                    if (ic.bid != 0) {
                        dt = 3;
                    } else if (ic.iid > 0 && ic.iid < 2048) {
                        damage = Items.getAttackStrength(ic.iid);
                        Item it = ic.getItem();
                        if (it != null) {
                            if (it instanceof ItemSword) {
                                dt = 1;
                            }
                            if (it instanceof ItemPickAxe) {
                                dt = 2;
                            }
                            if (it instanceof ItemAxe) {
                                dt = 2;
                            }
                            if (it instanceof ItemShovel) {
                                dt = 2;
                            }
                        }
                    }
                }
                e.doAttackFrom(this, dt, damage);
            }
        } else {
            this.armdir = 1;
            e = this.findHitEntity();
            this.server_connection.playerActionToServer(0, 0, e == null ? 0 : e.entityID);
            InventoryContainer ic = this.hotbar[this.current_hotbar_index];
            if (e == null) {
                int bid;
                if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) > 0) {
                    do_uses = true;
                    if (Blocks.leftClickOnBlock(bid, this, this.dimension, focus_x, focus_y, focus_z) || this.getGameMode() != 0) {
                        String particlename;
                        int dmg = 1;
                        if (ic != null && ic.iid != 0) {
                            if (Blocks.isWood(bid) || Blocks.isLeaves(bid)) {
                                dmg = Items.getWoodStrength(ic.iid);
                            }
                            if (Blocks.isStone(bid)) {
                                dmg = Items.getStoneStrength(ic.iid);
                            }
                            if (Blocks.isDirt(bid)) {
                                dmg = Items.getDirtStrength(ic.iid);
                            }
                            if (ic.getItem() instanceof ItemSword && !Blocks.isLeaves(bid)) {
                                dmg = 0;
                            }
                            if (ic.getItem() instanceof ItemSword && Blocks.isLeaves(bid)) {
                                dmg = Items.getAttackStrength(ic.iid);
                            }
                        }
                        if ((particlename = Blocks.getParticleName(bid)) == null || particlename.equals("")) {
                            particlename = "DangerZone:ParticleBreak";
                        }
                        Utils.spawnParticles(this.world, particlename, 10, this.dimension, (float)focus_x + 0.5f, (float)focus_y + 0.5f, (float)focus_z + 0.5f, true);
                        int md = Blocks.getMinDamage(bid);
                        if (dmg >= md) {
                            WorldRenderer.focus_damage += (float)dmg;
                        }
                        if (dmg != 0 && (WorldRenderer.focus_damage >= WorldRenderer.focus_maxdamage || this.getGameMode() != 0)) {
                            world.playSound(Blocks.getBreakSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
                            Blocks.onBlockBroken(bid, this, this.dimension, focus_x, focus_y, focus_z);
                            int dbid = Blocks.getBlockDrop(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                            int diid = Blocks.getItemDrop(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                            int howmany = Blocks.getDropCount(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                            world.setblockandmeta(this.dimension, focus_x, focus_y, focus_z, 0, 0);
                            if (howmany > 0) {
                                int i = 0;
                                while (i < howmany) {
                                    EntityBlockItem eb;
                                    if (dbid > 0 && (eb = (EntityBlockItem)world.createEntityByName(DangerZone.blockitemname, this.dimension, (float)focus_x + 0.5f, (float)focus_y + 0.5f, (float)focus_z + 0.5f)) != null) {
                                        eb.setBID(dbid);
                                        eb.setIID(0);
                                        world.spawnEntityInWorld(eb);
                                    }
                                    if (diid > 0 && (eb = (EntityBlockItem)world.createEntityByName(DangerZone.blockitemname, this.dimension, (float)focus_x + 0.5f, (float)focus_y + 0.5f, (float)focus_z + 0.5f)) != null) {
                                        eb.setBID(0);
                                        eb.setIID(diid);
                                        world.spawnEntityInWorld(eb);
                                    }
                                    ++i;
                                }
                            }
                        } else {
                            world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
                        }
                    }
                }
            } else {
                do_uses = true;
                Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, this.hit_x, this.hit_y, this.hit_z, true);
                if (this.getHunger() > 0.0f && this.getGameMode() == 0) {
                    this.setHunger(this.getHunger() - 0.25f);
                }
            }
            if (do_uses && this.getGameMode() == 0 && ic != null && ic.iid > 0 && ic.iid < 2048 && ic.count == 1) {
                ++ic.currentuses;
                if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                    this.hotbar[this.current_hotbar_index] = null;
                    DangerZone.server_connection.inventoryUpdate(0, this.current_hotbar_index, null);
                    this.setBID(0);
                    this.setIID(0);
                }
            }
        }
    }

    public void middleclick(World world, int focus_x, int focus_y, int focus_z, int eid) {
        int bid;
        if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) != 0) {
            world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
            DangerZone.messagetimer = 100;
            DangerZone.messagestring = Blocks.BlockArray[bid].uniquename;
        }
    }

    public void rightclick(World world, int focus_x, int focus_y, int focus_z, int side, int eid) {
        Entity e = null;
        if (world.isServer) {
            if (eid != 0 && (e = DangerZone.server.entityManager.findEntityByID(eid)) != null) {
                e.rightClickedByPlayer(this, this.hotbar[this.current_hotbar_index]);
            }
        } else {
            e = this.findHitEntity();
            this.server_connection.playerActionToServer(0, 1, e == null ? 0 : e.entityID);
            if (e == null) {
                int fbid;
                boolean cont;
                int bid = 0;
                int iid = 0;
                InventoryContainer ic = null;
                if (this.hotbar[this.current_hotbar_index] != null && this.hotbar[this.current_hotbar_index].count >= 1) {
                    bid = this.hotbar[this.current_hotbar_index].bid;
                    iid = this.hotbar[this.current_hotbar_index].iid;
                    ic = this.hotbar[this.current_hotbar_index];
                }
                if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (cont = Blocks.rightClickOnBlock(fbid = world.getblock(this.dimension, focus_x, focus_y, focus_z), this, this.dimension, focus_x, focus_y, focus_z))) {
                    if (bid != 0) {
                        Blocks.doPlaceBlock(bid, fbid, this, world, this.dimension, focus_x, focus_y, focus_z, side);
                    } else if (ic != null && iid != 0) {
                        boolean delme = Items.rightClickOnBlock(iid, this, this.dimension, focus_x, focus_y, focus_z);
                        world.playSound(Blocks.getHitSound(fbid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
                        if (this.getGameMode() == 0 && delme) {
                            if (ic.count == 1) {
                                ++ic.currentuses;
                                if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                                    this.hotbar[this.current_hotbar_index] = null;
                                    this.setBID(0);
                                    this.setIID(0);
                                    this.sendInventoryUpdate(0, this.current_hotbar_index, this.hotbar[this.current_hotbar_index]);
                                }
                            } else {
                                --ic.count;
                                this.sendInventoryUpdate(0, this.current_hotbar_index, this.hotbar[this.current_hotbar_index]);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        String s;
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "currenthotbarindex"), String.format("%d", this.current_hotbar_index));
        int i = 0;
        while (i < this.hotbar.length) {
            s = String.format("%sHotbar_%d:", tag, i);
            if (this.hotbar[i] != null) {
                prop.setProperty(String.format("%s%s", s, "data"), "valid");
                this.hotbar[i].writeSelf(prop, s);
            } else {
                prop.setProperty(String.format("%s%s", s, "data"), "null");
            }
            ++i;
        }
        i = 0;
        while (i < this.inventory.length) {
            s = String.format("%sInventory_%d:", tag, i);
            if (this.inventory[i] != null) {
                prop.setProperty(String.format("%s%s", s, "data"), "valid");
                this.inventory[i].writeSelf(prop, s);
            } else {
                prop.setProperty(String.format("%s%s", s, "data"), "null");
            }
            ++i;
        }
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        String n;
        String s;
        super.readSelf(prop, tag);
        this.current_hotbar_index = Utils.getPropertyInt(prop, String.format("%s%s", tag, "currenthotbarindex"), 0, this.hotbar.length - 1, 0);
        int i = 0;
        while (i < this.hotbar.length) {
            this.hotbar[i] = null;
            s = String.format("%sHotbar_%d:", tag, i);
            n = prop.getProperty(String.format("%s%s", s, "data"));
            if (n != null && !n.equals("null")) {
                this.hotbar[i] = new InventoryContainer();
                this.hotbar[i].readSelf(prop, s);
            }
            ++i;
        }
        i = 0;
        while (i < this.inventory.length) {
            this.inventory[i] = null;
            s = String.format("%sInventory_%d:", tag, i);
            n = prop.getProperty(String.format("%s%s", s, "data"));
            if (n != null && !n.equals("null")) {
                this.inventory[i] = new InventoryContainer();
                this.inventory[i].readSelf(prop, s);
            }
            ++i;
        }
    }

    public boolean putMeInASlot(int bid, int iid, int uses) {
        int i = 0;
        while (i < this.hotbar.length) {
            if (this.hotbar[i] != null && this.hotbar[i].bid == bid && this.hotbar[i].iid == iid) {
                if (this.hotbar[i].bid != 0 && this.hotbar[i].count < Blocks.getMaxStack(bid)) {
                    ++this.hotbar[i].count;
                    this.sendInventoryUpdate(0, i, this.hotbar[i]);
                    return true;
                }
                if (this.hotbar[i].iid != 0 && this.hotbar[i].count < Items.getMaxStack(iid)) {
                    ++this.hotbar[i].count;
                    this.sendInventoryUpdate(0, i, this.hotbar[i]);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.inventory.length) {
            if (this.inventory[i] != null && this.inventory[i].bid == bid && this.inventory[i].iid == iid) {
                if (this.inventory[i].bid != 0 && this.inventory[i].count < Blocks.getMaxStack(bid)) {
                    ++this.inventory[i].count;
                    this.sendInventoryUpdate(1, i, this.inventory[i]);
                    return true;
                }
                if (this.inventory[i].iid != 0 && this.inventory[i].count < Items.getMaxStack(iid)) {
                    ++this.inventory[i].count;
                    this.sendInventoryUpdate(1, i, this.inventory[i]);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.hotbar.length) {
            if (this.hotbar[i] == null) {
                this.hotbar[i] = new InventoryContainer();
                this.hotbar[i].bid = bid;
                this.hotbar[i].iid = iid;
                this.hotbar[i].count = 1;
                this.hotbar[i].currentuses = uses;
                this.sendInventoryUpdate(0, i, this.hotbar[i]);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.inventory.length) {
            if (this.inventory[i] == null) {
                this.inventory[i] = new InventoryContainer();
                this.inventory[i].bid = bid;
                this.inventory[i].iid = iid;
                this.inventory[i].count = 1;
                this.inventory[i].currentuses = uses;
                this.sendInventoryUpdate(1, i, this.inventory[i]);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void sendInventoryUpdate(int which, int slot, InventoryContainer ic) {
        if (this.world.isServer) {
            this.server_thread.sendInventoryUpdateToPlayer(which, slot, ic);
        } else {
            this.server_connection.inventoryUpdate(which, slot, ic);
        }
    }

    private Entity findHitEntity() {
        List<Entity> nearby_list = null;
        nearby_list = this.world.isServer ? DangerZone.server.entityManager.findEntitiesInRange(16.0f, this.dimension, this.posx, this.posy, this.posz) : DangerZone.entityManager.findEntitiesInRange(16.0f, this.dimension, this.posx, this.posy, this.posz);
        this.hit_z = 0.0f;
        this.hit_y = 0.0f;
        this.hit_x = 0.0f;
        if (nearby_list != null && !nearby_list.isEmpty()) {
            double delta = 0.0;
            Entity e = null;
            double dir = Math.toRadians((this.rotation_yaw_head - 90.0f) % 360.0f);
            double dx = Math.cos(dir);
            double dz = Math.sin(dir);
            double dy = Math.sin(Math.toRadians(this.rotation_pitch_head % 360.0f));
            double xzscale = Math.abs(Math.cos(Math.toRadians(this.rotation_pitch_head % 360.0f)));
            dx *= xzscale;
            dz *= xzscale;
            dy = -dy;
            while (delta < 5.0) {
                float x = (float)((double)this.posx + dx * delta);
                float y = (float)((double)(this.posy + this.eyeheight) + dy * delta);
                float z = (float)((double)this.posz + dz * delta);
                double mindist = 10.0;
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = li.next();
                    if (e == this || e.canthitme) continue;
                    double dist = e.getDistanceFromEntityCenter(x, y, z);
                    dist -= 0.125;
                    if ((dist -= (double)(e.width / 2.0f)) < mindist) {
                        mindist = dist;
                    }
                    if (!(dist < 0.0)) continue;
                    this.hit_x = x;
                    this.hit_y = y;
                    this.hit_z = z;
                    return e;
                }
                if (mindist < 0.1) {
                    mindist = 0.1;
                }
                delta += mindist;
            }
        }
        return null;
    }

    private boolean steppedOnCockroach() {
        List<Entity> nearby_list = null;
        if (this.world.isServer) {
            return false;
        }
        nearby_list = DangerZone.entityManager.findEntitiesInRange(4.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                float dist;
                e = li.next();
                if (!(e instanceof Cockroach) || !((dist = this.getDistanceFromEntity(e)) < 0.75f)) continue;
                Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, e.posx, e.posy, e.posz, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public Texture getTexture() {
        if (this.donewtexture) {
            File file = null;
            try {
                file = File.createTempFile("TmpSkin", ".tmp");
                file.deleteOnExit();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int width = 64;
            int height = 32;
            String format = "PNG";
            BufferedImage image = new BufferedImage(width, height, 1);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int i = (x + width * y) * 4;
                    int r = this.tdata[i] & 0xFF;
                    int g = this.tdata[i + 1] & 0xFF;
                    int b = this.tdata[i + 2] & 0xFF;
                    int a = this.tdata[i + 3] & 0xFF;
                    image.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                    ++y;
                }
                ++x;
            }
            try {
                ImageIO.write((RenderedImage)image, format, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            image.flush();
            if (this.texture != null) {
                this.texture.release();
                this.texture = null;
            }
            try {
                this.texture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)file.getPath()));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
            this.donewtexture = false;
        }
        if (this.texture == null) {
            try {
                this.texture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)"res/skins/Player.png"));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
        }
        return this.texture;
    }
}

