/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Particles {
    public static List<PlistInfo> particles = new ArrayList<PlistInfo>();
    public static Lock Particle_list_lock = new ReentrantLock();
    public static ModelParticle mp = new ModelParticle();

    public static void registerParticle(Class<? extends Particle> ParticleClass, String name) {
        Particle_list_lock.lock();
        PlistInfo el = new PlistInfo();
        el.uniquename = name;
        el.entclass = ParticleClass;
        el.model = mp;
        particles.add(el);
        Particle_list_lock.unlock();
    }

    public static void registerParticle(Class<? extends Particle> ParticleClass, String name, ModelBase model) {
        Particle_list_lock.lock();
        PlistInfo el = new PlistInfo();
        el.uniquename = name;
        el.entclass = ParticleClass;
        el.model = model;
        particles.add(el);
        Particle_list_lock.unlock();
    }

    public static Class<? extends Particle> findParticleByName(String name) {
        Particle_list_lock.lock();
        for (PlistInfo st : particles) {
            if (!st.uniquename.equals(name)) continue;
            Particle_list_lock.unlock();
            return st.entclass;
        }
        Particle_list_lock.unlock();
        return null;
    }

    public static PlistInfo findPlistInfoByName(String name) {
        Particle_list_lock.lock();
        for (PlistInfo st : particles) {
            if (!st.uniquename.equals(name)) continue;
            Particle_list_lock.unlock();
            return st;
        }
        Particle_list_lock.unlock();
        return null;
    }

    public static Particle spawnParticleByName(String name) {
        Particle ent = null;
        PlistInfo st = Particles.findPlistInfoByName(name);
        if (st != null && st.entclass != null) {
            try {
                ent = st.entclass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return null;
            }
            ent.model = st.model;
        }
        return ent;
    }

    public static class PlistInfo {
        public Class<? extends Particle> entclass;
        public ModelBase model;
        public String uniquename;
    }
}

