/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ParticleUpdateLoop
implements Runnable {
    public List<Particle> particle_list;
    public Lock particle_list_lock = new ReentrantLock();

    @Override
    public void run() {
        long lasttime = System.currentTimeMillis();
        long loop_interval = DangerZone.entityupdaterate;
        this.particle_list = new ArrayList<Particle>();
        Particle ent = null;
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        while (DangerZone.gameover == 0) {
            long currtime = System.currentTimeMillis();
            long tlong = currtime - lasttime;
            if ((tlong = loop_interval - tlong) < 0L) {
                tlong = 0L;
            }
            if (tlong > loop_interval) {
                tlong = loop_interval;
            }
            if (tlong > 0L) {
                try {
                    Thread.sleep(tlong);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                currtime = System.currentTimeMillis();
            }
            tlong = currtime - lasttime;
            lasttime = currtime;
            float deltaT = tlong;
            if (deltaT < 16.0f) {
                deltaT = 16.0f;
            }
            if (deltaT > 200.0f) {
                deltaT = 200.0f;
            }
            deltaT /= (float)loop_interval;
            this.particle_list_lock.lock();
            Iterator<Particle> it = this.particle_list.iterator();
            while (it.hasNext()) {
                ent = it.next();
                ent.update(deltaT);
                if (ent.lifetimeticker <= ent.maxlifetime && ent.dimension == DangerZone.player.dimension) continue;
                it.remove();
            }
            this.particle_list_lock.unlock();
        }
        return;
    }

    public void addParticle(Particle e) {
        this.particle_list_lock.lock();
        this.particle_list.add(e);
        this.particle_list_lock.unlock();
    }
}

