/*
 * Decompiled with CFR 0.152.
 */
import org.newdawn.slick.opengl.Texture;

public class Moose
extends EntityHostile {
    private int closest = 99999;
    private int tx = 0;
    private int ty = 0;
    private int tz = 0;

    public Moose(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 3.33f;
        this.width = 1.33f;
        this.uniquename = "DangerZone:Moose";
        this.moveSpeed = 0.33f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 10.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 65;
        this.setExperience(99);
        this.canSwim = true;
        this.daytimecheck = false;
        this.canDespawn = false;
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        if (this.target == null && this.world.isDaytime() && this.world.rand.nextInt(60) == 1) {
            this.closest = 99999;
            this.tz = 0;
            this.ty = 0;
            this.tx = 0;
            int i = 1;
            while (i < 13) {
                int j = i;
                if (j > 3) {
                    j = 3;
                }
                if (this.scan_it((int)this.posx, (int)this.posy + 1, (int)this.posz, i, j, i)) break;
                if (i >= 6) {
                    ++i;
                }
                ++i;
            }
            if (this.closest < 99999) {
                this.target = new TargetHelper(this.tx, this.ty - 1, this.tz);
                if (this.closest < 12) {
                    this.world.setblockandmeta(this.dimension, this.tx, this.ty, this.tz, 0, 0);
                    this.heal(1.0f);
                    if (this.world.rand.nextInt(4) == 1) {
                        this.world.playSound("DangerZone:burp", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                    }
                    this.target = null;
                }
            }
        }
    }

    private boolean scan_it(int x, int y, int z, int dx, int dy, int dz) {
        int d;
        int bid;
        int j;
        int found = 0;
        int i = -dy;
        while (i <= dy) {
            j = -dz;
            while (j <= dz) {
                bid = this.world.getblock(this.dimension, x + dx, y + i, z + j);
                if (bid == Blocks.grass.blockID && (d = dx * dx + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + dx;
                    this.ty = y + i;
                    this.tz = z + j;
                    ++found;
                }
                if ((bid = this.world.getblock(this.dimension, x - dx, y + i, z + j)) == Blocks.grass.blockID && (d = dx * dx + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x - dx;
                    this.ty = y + i;
                    this.tz = z + j;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        i = -dx;
        while (i <= dx) {
            j = -dz;
            while (j <= dz) {
                bid = this.world.getblock(this.dimension, x + i, y + dy, z + j);
                if (bid == Blocks.grass.blockID && (d = dy * dy + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + dy;
                    this.tz = z + j;
                    ++found;
                }
                if ((bid = this.world.getblock(this.dimension, x + i, y - dy, z + j)) == Blocks.grass.blockID && (d = dy * dy + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y - dy;
                    this.tz = z + j;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        i = -dx;
        while (i <= dx) {
            j = -dy;
            while (j <= dy) {
                bid = this.world.getblock(this.dimension, x + i, y + j, z + dz);
                if (bid == Blocks.grass.blockID && (d = dz * dz + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + j;
                    this.tz = z + dz;
                    ++found;
                }
                if ((bid = this.world.getblock(this.dimension, x + i, y + j, z - dz)) == Blocks.grass.blockID && (d = dz * dz + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + j;
                    this.tz = z - dz;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        return found != 0;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:moose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:moose_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 5 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        Utils.doDropRand(this.world, 0, Items.trophymoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Moose) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Moosetexture.png");
        }
        return this.texture;
    }
}

