/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.opengl.GL11;

public class ModelRenderer {
    public float textureWidth;
    public float textureHeight;
    public float textureOffsetX;
    public float textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float sizeX;
    public float sizeY;
    public float sizeZ;
    public boolean mirror = true;
    public boolean compiled;
    public int displayList;

    public ModelRenderer(int par2, int par3) {
        this.textureOffsetX = par2;
        this.textureOffsetY = par3;
    }

    public ModelRenderer(ModelBase mb, int par2, int par3) {
        this.textureOffsetX = par2;
        this.textureOffsetY = par3;
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    public void setRotation(float x, float y, float z) {
        this.rotateAngleX = x;
        this.rotateAngleY = y;
        this.rotateAngleZ = z;
    }

    public void addCube(float par1, float par2, float par3, int par4, int par5, int par6) {
        this.offsetX = par1;
        this.offsetY = par2;
        this.offsetZ = par3;
        this.sizeX = par4;
        this.sizeY = par5;
        this.sizeZ = par6;
    }

    public void addBox(float par1, float par2, float par3, int par4, int par5, int par6) {
        this.offsetX = par1;
        this.offsetY = par2;
        this.offsetZ = par3;
        this.sizeX = par4;
        this.sizeY = par5;
        this.sizeZ = par6;
    }

    public void setTextureSize(int par1, int par2) {
        this.textureWidth = par1;
        this.textureHeight = par2;
    }

    public void render(float m) {
        if (!this.compiled) {
            this.compileDisplayList();
        }
        float my = -(this.rotationPointY * m - 24.0f);
        if (m >= 1.1f && my < 0.0f) {
            my = -my;
        }
        GL11.glTranslatef((float)(this.rotationPointX * m), (float)my, (float)(-this.rotationPointZ * m));
        GL11.glPushMatrix();
        if (this.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(-this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(-this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        my = -this.offsetY * m;
        if (m > 1.25f && my < 0.0f) {
            my = -my;
        }
        GL11.glTranslatef((float)(this.offsetX * m), (float)my, (float)(-this.offsetZ * m));
        GL11.glCallList((int)this.displayList);
        GL11.glPopMatrix();
        my = -(this.rotationPointY * m - 24.0f);
        if (m >= 1.1f && my < 0.0f) {
            my = -my;
        }
        GL11.glTranslatef((float)(-this.rotationPointX * m), (float)(-my), (float)(this.rotationPointZ * m));
    }

    private void compileDisplayList() {
        if (this.compiled) {
            return;
        }
        this.displayList = DangerZone.wr.getNextRenderID();
        GL11.glNewList((int)this.displayList, (int)4864);
        GL11.glBegin((int)7);
        if (this.mirror) {
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)(this.textureOffsetX / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)(this.textureOffsetX / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)(-this.sizeZ));
        } else {
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth), (float)(this.textureOffsetY / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)0.0f, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)(this.textureOffsetX / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)(-this.sizeZ));
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)((this.textureOffsetX + this.sizeZ) / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)0.0f);
            GL11.glTexCoord2f((float)(this.textureOffsetX / this.textureWidth), (float)((this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight));
            GL11.glVertex3f((float)this.sizeX, (float)(-this.sizeY), (float)(-this.sizeZ));
        }
        GL11.glEnd();
        GL11.glEndList();
        this.compiled = true;
    }
}

