/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Items {
    public static Item twobyfour = new ItemStick("DangerZone:Two-by-four", "res/items/2by4.png");
    public static Item eggbutterfly = new ItemSpawnEgg("DangerZone:Spawn Butterfly", "res/items/eggbutterfly.png", "DangerZone:Butterfly");
    public static Item eggghost = new ItemSpawnEgg("DangerZone:Spawn Ghost", "res/items/eggghost.png", "DangerZone:Ghost");
    public static Item eggghostskelly = new ItemSpawnEgg("DangerZone:Spawn Ghost Skelly", "res/items/eggghostskelly.png", "DangerZone:GhostSkelly");
    public static Item eggrat = new ItemSpawnEgg("DangerZone:Spawn Rat", "res/items/eggrat.png", "DangerZone:Rat");
    public static Item eggcockroach = new ItemSpawnEgg("DangerZone:Spawn Cockroach", "res/items/eggcockroach.png", "DangerZone:Cockroach");
    public static Item eggmoose = new ItemSpawnEgg("DangerZone:Spawn Moose", "res/items/eggmoose.png", "DangerZone:Moose");
    public static Item egggoose = new ItemSpawnEgg("DangerZone:Spawn Goose", "res/items/egggoose.png", "DangerZone:Goose");
    public static Item eggsparklemuffin = new ItemSpawnEgg("DangerZone:Spawn Sparklemuffin", "res/items/eggsparklemuffin.png", "DangerZone:Sparklemuffin");
    public static Item eggskeletorus = new ItemSpawnEgg("DangerZone:Spawn Skeletorus", "res/items/eggskeletorus.png", "DangerZone:Skeletorus");
    public static Item lumpsilver = new Item("DangerZone:Silver", "res/items/lumpsilver.png");
    public static Item lumpplatinum = new Item("DangerZone:Platinum", "res/items/lumpplatinum.png");
    public static Item woodensword = new ItemSword("DangerZone:Wooden Sword", "res/items/woodensword.png", 200, 6);
    public static Item woodenpickaxe = new ItemPickAxe("DangerZone:Wooden Pickaxe", "res/items/woodenpickaxe.png", 400, 5, 8);
    public static Item woodenaxe = new ItemAxe("DangerZone:Wooden Axe", "res/items/woodenaxe.png", 200, 5, 3);
    public static Item woodenshovel = new ItemShovel("DangerZone:Wooden Shovel", "res/items/woodenshovel.png", 300, 3, 3);
    public static Item woodenhoe = new ItemHoe("DangerZone:Wooden Hoe", "res/items/woodenhoe.png", 200, 1, 3);
    public static Item stonesword = new ItemSword("DangerZone:Stone Sword", "res/items/stonesword.png", 400, 8);
    public static Item stonepickaxe = new ItemPickAxe("DangerZone:Stone Pickaxe", "res/items/stonepickaxe.png", 800, 8, 12);
    public static Item stoneaxe = new ItemAxe("DangerZone:Stone Axe", "res/items/stoneaxe.png", 400, 8, 6);
    public static Item stoneshovel = new ItemShovel("DangerZone:Stone Shovel", "res/items/stoneshovel.png", 60, 4, 5);
    public static Item stonehoe = new ItemHoe("DangerZone:Stone Hoe", "res/items/stonehoe.png", 400, 1, 6);
    public static Item silversword = new ItemSword("DangerZone:Silver Sword", "res/items/silversword.png", 800, 12);
    public static Item silverpickaxe = new ItemPickAxe("DangerZone:Silver Pickaxe", "res/items/silverpickaxe.png", 1600, 10, 16);
    public static Item silveraxe = new ItemAxe("DangerZone:Silver Axe", "res/items/silveraxe.png", 800, 10, 12);
    public static Item silvershovel = new ItemShovel("DangerZone:Silver Shovel", "res/items/silvershovel.png", 1400, 5, 10);
    public static Item silverhoe = new ItemHoe("DangerZone:Silver Hoe", "res/items/silverhoe.png", 800, 2, 10);
    public static Item platinumsword = new ItemSword("DangerZone:Platinum Sword", "res/items/platinumsword.png", 1600, 24);
    public static Item platinumpickaxe = new ItemPickAxe("DangerZone:Platinum Pickaxe", "res/items/platinumpickaxe.png", 2000, 16, 24);
    public static Item platinumaxe = new ItemAxe("DangerZone:Platinum Axe", "res/items/platinumaxe.png", 1600, 16, 20);
    public static Item platinumshovel = new ItemShovel("DangerZone:Platinum Shovel", "res/items/platinumshovel.png", 1600, 10, 20);
    public static Item platinumhoe = new ItemHoe("DangerZone:Platinum Hoe", "res/items/platinumhoe.png", 1000, 5, 20);
    public static Item dark = new ItemLight("DangerZone:Darkness", "res/items/dark.png");
    public static Item light = new ItemDark("DangerZone:Lightness", "res/items/light.png");
    public static Item corn = new ItemCorn("DangerZone:Corn", "res/items/corn_seed.png");
    public static Item moosemeat = new ItemFood("DangerZone:Moose Meat", "res/items/moosemeat.png", 5);
    public static Item moosemeat_cooked = new ItemFood("DangerZone:Cooked Moose Meat", "res/items/moosemeat_cooked.png", 20);
    public static Item moosebone = new Item("DangerZone:Moose Bone", "res/items/moosebone.png");
    public static Item trophycockroach = new ItemTrophy("DangerZone:Cockroach Trophy", "DangerZone:CockroachTrophy");
    public static Item trophybutterfly = new ItemTrophy("DangerZone:Butterfly Trophy", "DangerZone:ButterflyTrophy");
    public static Item trophyrat = new ItemTrophy("DangerZone:Rat Trophy", "DangerZone:RatTrophy");
    public static Item trophymoose = new ItemTrophy("DangerZone:Moose Trophy", "DangerZone:MooseTrophy");
    public static Item trophyghost = new ItemTrophy("DangerZone:Ghost Trophy", "DangerZone:GhostTrophy");
    public static Item trophyghostskelly = new ItemTrophy("DangerZone:Ghost Skelly Trophy", "DangerZone:GhostSkellyTrophy");
    public static Item trophygoose = new ItemTrophy("DangerZone:Goose Trophy", "DangerZone:GooseTrophy");
    public static Item trophysparklemuffin = new ItemTrophy("DangerZone:Sparklemuffin Trophy", "DangerZone:SparklemuffinTrophy");
    public static Item trophyskeletorus = new ItemTrophy("DangerZone:Skeletorus Trophy", "DangerZone:SkeletorusTrophy");
    public static Item goosemeat = new ItemFood("DangerZone:Raw Goose", "res/items/goose_raw.png", 3);
    public static Item goosemeat_cooked = new ItemFood("DangerZone:Cooked Goose", "res/items/goose_cooked.png", 15);
    public static Item feather = new Item("DangerZone:Feather", "res/items/feather.png");
    public static Item radish = new ItemRadish("DangerZone:Radish", "res/items/radish.png");
    public static Item rice = new ItemRice("DangerZone:Rice", "res/items/rice.png");
    public static Item[] ItemArray;
    public static final int itemsMAX = 2048;
    public static Properties prop;

    static {
        prop = null;
    }

    Items() {
        ItemArray = new Item[2048];
        int i = 0;
        while (i < 2048) {
            Items.ItemArray[i] = null;
            ++i;
        }
    }

    public static int registerItem(Item b) {
        int i = 0;
        if (prop != null) {
            i = Utils.getPropertyInt(prop, b.uniquename, 0, 2047, 0);
        }
        if (i == 0) {
            i = 1;
            while (i < 2048) {
                if (ItemArray[i] == null) {
                    Items.ItemArray[i] = b;
                    b.itemID = i;
                    if (prop != null) {
                        prop.setProperty(b.uniquename, String.format("%d", i));
                    }
                    return i;
                }
                ++i;
            }
        } else {
            if (ItemArray[i] == null) {
                Items.ItemArray[i] = b;
                b.itemID = i;
                return i;
            }
            Item intruder = ItemArray[i];
            int isave = i;
            Items.ItemArray[i] = b;
            b.itemID = i;
            i = 1;
            while (i < 2048) {
                if (ItemArray[i] == null) {
                    Items.ItemArray[i] = intruder;
                    intruder.itemID = i;
                    prop.setProperty(intruder.uniquename, String.format("%d", i));
                }
                ++i;
            }
            return isave;
        }
        return 0;
    }

    public static void reRegisterItemAt(String s, int loc) {
        if (loc <= 0 || loc >= 2048) {
            return;
        }
        if (s == null || s.equals("")) {
            return;
        }
        if (ItemArray[loc] != null) {
            if (s.equals(Items.ItemArray[loc].uniquename)) {
                return;
            }
            int i = 1;
            while (i < 2048) {
                if (ItemArray[i] != null && s.equals(Items.ItemArray[i].uniquename)) {
                    Item me = ItemArray[i];
                    Item intruder = ItemArray[loc];
                    Items.ItemArray[loc] = me;
                    Items.ItemArray[loc].itemID = loc;
                    Items.ItemArray[i] = intruder;
                    Items.ItemArray[i].itemID = i;
                    return;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < 2048) {
                if (ItemArray[i] != null && s.equals(Items.ItemArray[i].uniquename)) {
                    Items.ItemArray[loc] = ItemArray[i];
                    Items.ItemArray[loc].itemID = loc;
                    Items.ItemArray[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static void load() {
        FileInputStream input = null;
        prop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/itemIDs.dat", DangerZone.worldname);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void save() {
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/itemIDs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            output = new FileOutputStream(filepath);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean alwaystick(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].alwaystick;
    }

    public static boolean randomtick(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].randomtick;
    }

    public static boolean shouldShow(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].showInInventory;
    }

    public static Texture getTexture(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        if (ItemArray[itemid] == null) {
            return null;
        }
        return ItemArray[itemid].getTexture();
    }

    public static void doitemtick(World w, int d, int x, int y, int z, int itemid) {
        if (itemid <= 0) {
            return;
        }
        if (itemid >= 2048) {
            return;
        }
        if (ItemArray[itemid] == null) {
            return;
        }
        ItemArray[itemid].tickMe(w, d, x, y, z);
    }

    public static void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int itemid, int meta, int sides, boolean focused) {
        if (itemid <= 0) {
            return;
        }
        if (itemid >= 2048) {
            return;
        }
        if (ItemArray[itemid] == null) {
            return;
        }
        ItemArray[itemid].renderMe(wr, w, d, x, y, z, itemid, meta, sides, focused);
    }

    public static int getMaxStack(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].maxstack;
    }

    public static int getAttackStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].attackstrength;
    }

    public static int getWoodStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].woodstrength;
    }

    public static int getStoneStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].stonestrength;
    }

    public static int getDirtStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].dirtstrength;
    }

    public static int getMaxUses(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].maxuses;
    }

    public static boolean rightClickOnBlock(int itemid, Player p, int d, int x, int y, int z) {
        if (itemid <= 0) {
            return true;
        }
        if (itemid >= 2048) {
            return true;
        }
        if (ItemArray[itemid] == null) {
            return true;
        }
        return ItemArray[itemid].rightClickOnBlock(p, d, x, y, z);
    }

    public static Item getItem(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        return ItemArray[itemid];
    }

    public static String getUniqueName(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        if (ItemArray[itemid] == null) {
            return null;
        }
        return Items.ItemArray[itemid].uniquename;
    }

    public static int findByName(String name) {
        if (name == null) {
            return 0;
        }
        int i = 1;
        while (i < 2048) {
            if (ItemArray[i] != null && Items.ItemArray[i].uniquename != null && name.equals(Items.ItemArray[i].uniquename)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static float getLightLevel(int itemid) {
        if (itemid <= 0) {
            return 0.0f;
        }
        if (itemid >= 2048) {
            return 0.0f;
        }
        if (ItemArray[itemid] == null) {
            return 0.0f;
        }
        return Items.ItemArray[itemid].brightness;
    }

    public static float getFoodValue(int itemid) {
        if (itemid <= 0) {
            return 0.0f;
        }
        if (itemid >= 2048) {
            return 0.0f;
        }
        if (ItemArray[itemid] == null) {
            return 0.0f;
        }
        return Items.ItemArray[itemid].foodvalue;
    }

    public static boolean isFood(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].isfood;
    }

    public static int getBurnTime(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].burntime;
    }
}

