/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class InventoryContainer {
    int count;
    int bid;
    int iid;
    int currentuses = 0;

    InventoryContainer() {
        this.iid = 0;
        this.bid = 0;
        this.count = 0;
    }

    InventoryContainer(String uniquename, int incount) {
        this.bid = Blocks.findByName(uniquename);
        if (this.bid == 0) {
            this.iid = Items.findByName(uniquename);
        }
        this.count = 0;
        if (this.bid != 0 || this.iid != 0) {
            this.count = incount;
        }
    }

    public void writeSelf(Properties prop, String tag) {
        prop.setProperty(String.format("%s%s", tag, "BID"), String.format("%d", this.bid));
        prop.setProperty(String.format("%s%s", tag, "IID"), String.format("%d", this.iid));
        prop.setProperty(String.format("%s%s", tag, "count"), String.format("%d", this.count));
        prop.setProperty(String.format("%s%s", tag, "currentuses"), String.format("%d", this.currentuses));
    }

    public void readSelf(Properties prop, String tag) {
        this.bid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "BID"), 0, 2047, 0);
        this.iid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "IID"), 0, 2047, 0);
        this.count = Utils.getPropertyInt(prop, String.format("%s%s", tag, "count"), 0, 128, 1);
        this.currentuses = Utils.getPropertyInt(prop, String.format("%s%s", tag, "currentuses"), 0, Integer.MAX_VALUE, 0);
    }

    public Texture getTexture() {
        if (this.count <= 0) {
            return null;
        }
        if (this.bid != 0) {
            return Blocks.getTexture(this.bid);
        }
        if (this.iid != 0) {
            return Items.getTexture(this.iid);
        }
        return null;
    }

    public String getUniqueName() {
        if (this.count <= 0) {
            return null;
        }
        if (this.bid != 0) {
            return Blocks.getUniqueName(this.bid);
        }
        if (this.iid != 0) {
            return Items.getUniqueName(this.iid);
        }
        return null;
    }

    public int getMaxStack() {
        if (this.bid != 0) {
            return Blocks.getMaxStack(this.bid);
        }
        if (this.iid != 0) {
            return Items.getMaxStack(this.iid);
        }
        return 1;
    }

    public Item getItem() {
        if (this.bid != 0) {
            return null;
        }
        return Items.getItem(this.iid);
    }
}

