/*
 * Decompiled with CFR 0.152.
 */
import org.newdawn.slick.opengl.Texture;

public class Goose
extends EntityLiving {
    public Goose(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.35f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Goose";
        this.moveSpeed = 0.1f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 55;
        this.setExperience(14);
        this.canSwim = true;
        this.swimoffset = -0.75f;
        this.canDespawn = false;
        this.takesFallDamage = false;
        this.setOnGround(true);
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:goose_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:goose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:goose_death";
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.trophygoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        int i = 1 + this.world.rand.nextInt(4);
        int j = 0;
        while (j < i) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
            ++j;
        }
        if (this.world.rand.nextInt(1000) == 42) {
            j = 0;
            while (j < 1000) {
                Utils.doDropRand(this.world, 0, Items.feather.itemID, 3.5f, this.dimension, this.posx, this.posy, this.posz);
                ++j;
            }
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1 && this.world.rand.nextInt(10) == 5) {
            Utils.doDropRand(this.world, 0, Items.egggoose.itemID, 0.1f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Goosetexture.png");
        }
        return this.texture;
    }
}

