/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EntityUpdateLoop
implements Runnable {
    public List<ListInt> entity_list;
    public Entity[] entities;
    public Lock entity_list_lock = new ReentrantLock();

    @Override
    public void run() {
        long lasttime = System.currentTimeMillis();
        long loop_interval = DangerZone.entityupdaterate;
        int inext = 0;
        this.entities = new Entity[DangerZone.max_entities];
        this.entity_list = new ArrayList<ListInt>();
        Entity ent = null;
        block2: while (DangerZone.gameover == 0) {
            long currtime = System.currentTimeMillis();
            long tlong = currtime - lasttime;
            if ((tlong = loop_interval - tlong) < 0L) {
                tlong = 0L;
            }
            if (tlong > loop_interval) {
                tlong = loop_interval;
            }
            if (tlong > 0L) {
                try {
                    Thread.sleep(tlong);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                currtime = System.currentTimeMillis();
            }
            tlong = currtime - lasttime;
            lasttime = currtime;
            float deltaT = tlong;
            if (deltaT < 16.0f) {
                deltaT = 16.0f;
            }
            if (deltaT > 200.0f) {
                deltaT = 200.0f;
            }
            deltaT /= (float)loop_interval;
            inext = 0;
            while (true) {
                this.entity_list_lock.lock();
                if (inext >= this.entity_list.size()) {
                    this.entity_list_lock.unlock();
                    continue block2;
                }
                ListInt i = this.entity_list.get(inext);
                ent = this.entities[i.index];
                this.entity_list_lock.unlock();
                if (ent != null) {
                    if (ent.deadflag && !ent.isDying()) {
                        this.removeEntityByID(ent.entityID);
                    } else if (ent.dimension == DangerZone.world.player.dimension && ent.getDistanceFromEntity(DangerZone.world.player) < (float)DangerZone.entityupdatedist) {
                        if (ent.entityID != DangerZone.player.entityID) {
                            ent.update(deltaT);
                        }
                    } else {
                        this.removeEntityByID(ent.entityID);
                    }
                }
                Thread.yield();
                ++inext;
            }
            break;
        }
        return;
    }

    public void addEntity(Entity e, int entytid) {
        if (entytid < 0 || entytid >= DangerZone.max_entities) {
            return;
        }
        this.entity_list_lock.lock();
        if (this.entities[entytid] != null) {
            this.removeEntityByID(entytid);
        }
        this.entities[entytid] = e;
        e.entityID = entytid;
        this.entity_list.add(new ListInt(entytid));
        this.entity_list_lock.unlock();
    }

    public void removeEntityByID(int eid) {
        this.entity_list_lock.lock();
        Iterator<ListInt> ii = this.entity_list.iterator();
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.entities[st.index] == null || this.entities[st.index].entityID != eid) continue;
            ii.remove();
            this.entities[st.index] = null;
            break;
        }
        this.entity_list_lock.unlock();
    }

    public Entity findEntityByID(int eid) {
        return this.entities[eid];
    }

    public List<Entity> findEntitiesInRange(float range, int dim, float x, float y, float z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim) continue;
            float dx = x - this.entities[st.index].posx;
            float dy = y - this.entities[st.index].posy;
            float dz = z - this.entities[st.index].posz;
            if (!((dx = (float)Math.sqrt(dx * dx + dy * dy + dz * dz)) < range)) continue;
            retlist.add(this.entities[st.index]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }
}

