/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import java.util.ListIterator;

public class EntityLiving
extends Entity {
    private float deathfactor = 0.0f;
    public TargetHelper target = null;
    public float moveSpeed = 0.25f;
    public boolean newtargetnow = false;
    public int movefrequency = 100;
    public int damage_backoff = 0;
    public int fallcount = 0;
    public int lastbx;
    public int lastby;
    public int lastbz;
    public int lastbd;
    public boolean canSwim = true;
    public float eyeheight = 1.0f;
    public float swimoffset = 0.0f;

    public EntityLiving(World w) {
        super(w);
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(1.0f);
        this.deathfactor = 0.0f;
        this.takesFallDamage = true;
        this.canSwim = true;
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
    }

    @Override
    public void init() {
        this.eyeheight = this.height * 9.0f / 10.0f;
    }

    public void doSolidsPushback(int k, float deltaT) {
        int intwidth = (int)(this.width / 2.0f + 0.995f);
        float mx = this.motionx * deltaT;
        float mz = this.motionz * deltaT;
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx + i, (int)this.posy + k, (int)this.posz + j))) {
                    int itemp = (int)this.posx + i;
                    float dx = (float)itemp + 0.5f - this.posx;
                    itemp = (int)this.posz + j;
                    float dz = (float)itemp + 0.5f - this.posz;
                    if (Math.abs(dx) - (0.51f + this.width / 2.0f) < 0.0f && Math.abs(dz) - (0.51f + this.width / 2.0f) < 0.0f) {
                        this.posx = dx > 0.0f ? (this.posx -= 0.02f) : (this.posx += 0.02f);
                        this.posz = dz > 0.0f ? (this.posz -= 0.02f) : (this.posz += 0.02f);
                        itemp = (int)this.posx + i;
                        dx = (float)itemp + 0.5f - this.posx;
                        itemp = (int)this.posz + j;
                        dz = (float)itemp + 0.5f - this.posz;
                    }
                    float dxsave = dx;
                    if (dx < 0.0f && mx < 0.0f) {
                        if (Math.abs(dz) < 0.51f + this.width / 2.0f) {
                            dx += 0.51f;
                            if ((dx += this.width / 2.0f) > mx) {
                                this.motionx = dx / deltaT;
                            }
                        }
                    } else if (dx > 0.0f && mx > 0.0f && Math.abs(dz) < 0.51f + this.width / 2.0f) {
                        dx -= 0.51f;
                        if ((dx -= this.width / 2.0f) < mx) {
                            this.motionx = dx / deltaT;
                        }
                    }
                    dx = dxsave;
                    if (dz < 0.0f && mz < 0.0f) {
                        if (Math.abs(dx) < 0.51f + this.width / 2.0f) {
                            dz += 0.51f;
                            if ((dz += this.width / 2.0f) > mz) {
                                this.motionz = dz / deltaT;
                            }
                        }
                    } else if (dz > 0.0f && mz > 0.0f && Math.abs(dx) < 0.51f + this.width / 2.0f) {
                        dz -= 0.51f;
                        if ((dz -= this.width / 2.0f) < mz) {
                            this.motionz = dz / deltaT;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean wouldBump(float x, float y, float z) {
        int intwidth = (int)(this.width / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(this.world.getblock(this.dimension, (int)x + i, (int)y, (int)z + j))) {
                    int itemp = (int)this.posx + i;
                    float dx = x - ((float)itemp + 0.5f);
                    float dz = z - ((float)(itemp = (int)this.posz + j) + 0.5f);
                    if (Math.sqrt(dx * dx + dz * dz) < (double)(0.5f + this.width / 2.0f)) {
                        return true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isSolidAtLevel(int d, float x, float y, float z) {
        int intwidth = (int)(this.width / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(this.world.getblock(d, (int)x + i, (int)y, (int)z + j))) {
                    int itemp = (int)x + i;
                    float dx = x - ((float)itemp + 0.5f);
                    if ((dx = Math.abs(dx)) < 0.49f + this.width / 2.0f) {
                        itemp = (int)z + j;
                        float dz = z - ((float)itemp + 0.5f);
                        if ((dz = Math.abs(dz)) < 0.49f + this.width / 2.0f) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isDying() {
        return this.deathfactor > 0.0f && this.deathfactor < 8.0f;
    }

    @Override
    public void doDeathAnimation() {
        this.deathfactor = 0.9f;
        this.motionz = 0.0f;
        this.motionx = 0.0f;
        this.motiony = 0.0f;
    }

    @Override
    public float getDeathFactor() {
        return this.deathfactor;
    }

    @Override
    public void doEntityCollisions(float deltaT) {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.width / 2.0f + 10.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e == this || e.isGhost || !(e.posy > this.posy && e.posy < this.posy + this.height || e.posy + e.height > this.posy && e.posy + e.height < this.posy + this.height || this.posy > e.posy && this.posy < e.posy + e.height) && (!(this.posy + this.height > e.posy) || !(this.posy + this.height < e.posy + e.height))) continue;
                double dist = e.getHorizontalDistanceFromEntity(this);
                dist -= (double)(this.width / 2.0f);
                if (!((dist -= (double)(e.width / 2.0f)) < 0.0)) continue;
                double dir = Math.atan2(e.posz - this.posz, e.posx - this.posx);
                this.motionx = (float)((double)this.motionx + Math.cos(dir) * dist * (double)deltaT);
                this.motionz = (float)((double)this.motionz + Math.sin(dir) * dist * (double)deltaT);
            }
        }
    }

    @Override
    public void update(float deltaT) {
        float gravity = 0.045f * deltaT;
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (this.damage_backoff > 0) {
            --this.damage_backoff;
        }
        if (this.hurtanimationtimer > 0) {
            --this.hurtanimationtimer;
        }
        if (this.madtimer > 0) {
            --this.madtimer;
        }
        if (this.deadflag) {
            this.deathfactor += 0.11f;
        }
        if (this.deathfactor > 8.0f) {
            this.deadflag = true;
        }
        if (this.isDying()) {
            this.deadflag = true;
        }
        if (!(this.isHurt() || this.deadflag || this.world.isServer || this.world.rand.nextInt(600) != 1 || this.getLivingSound() == null)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + this.height / 2.0f, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
        }
        if (this.isGhost) {
            super.update(deltaT);
            return;
        }
        if (this.world.isServer) {
            gravity = 0.2f * deltaT;
            if (!(this instanceof Player)) {
                int bid;
                int startheight;
                int intheight = (int)this.height;
                ++intheight;
                int k = startheight = (int)this.height / 4;
                while (k < intheight) {
                    this.doSolidsPushback(k, deltaT);
                    ++k;
                }
                if (this.getInLiquid()) {
                    gravity /= 5.0f;
                }
                this.motiony -= gravity;
                if (this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz)) {
                    this.motiony += gravity * 2.0f;
                }
                float df = this.motiony * deltaT;
                int idf = (int)df;
                df -= (float)idf;
                if (this.motiony < 0.0f) {
                    int i = 0;
                    while (i >= idf) {
                        if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + (float)i, this.posz)) {
                            int imax = (int)(this.posy + df + (float)i) + 1;
                            this.motiony = 0.0f;
                            this.posy = (float)imax + 0.01f;
                            if (this.fallcount > 6) {
                                this.doAttackFrom(this, 5, this.fallcount - 6);
                            }
                            this.fallcount = 0;
                            break;
                        }
                        --i;
                    }
                }
                if (this.motiony >= 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz) && this.isSolidAtLevel(this.dimension, this.posx, this.posy + this.height + this.motiony * deltaT, this.posz)) {
                    this.motiony = -gravity;
                }
                if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.1f, this.posz)) {
                    this.setOnGround(false);
                    if (!this.takesFallDamage) {
                        this.fallcount = 0;
                    } else if (this.motiony < 0.0f) {
                        ++this.fallcount;
                    }
                    this.lastbd = 0;
                    this.lastbz = 0;
                    this.lastby = 0;
                    this.lastbx = 0;
                } else {
                    this.setOnGround(true);
                    this.fallcount = 0;
                    bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                    float ff = Blocks.getFriction(bid);
                    if (ff != 0.0f) {
                        this.motionx *= 1.0f - ff * deltaT;
                        this.motionz *= 1.0f - ff * deltaT;
                    }
                    if (this.dimension != this.lastbd || (int)this.posx != this.lastbx || (int)(this.posy - 0.25f) != this.lastby || (int)this.posz != this.lastbz) {
                        this.lastbd = this.dimension;
                        this.lastbx = (int)this.posx;
                        this.lastby = (int)(this.posy - 0.25f);
                        this.lastbz = (int)this.posz;
                        Blocks.doSteppedOn(bid, this, this.world, this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                    }
                }
                intheight = (int)this.height;
                ++intheight;
                boolean tmpb = false;
                int lbid = 0;
                k = 0;
                while (k < intheight) {
                    bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                    if (Blocks.isLiquid(bid)) {
                        tmpb = true;
                        lbid = bid;
                    }
                    ++k;
                }
                this.setInLiquid(tmpb);
                if (this.getInLiquid()) {
                    this.fallcount = 0;
                    float ff = Blocks.getFriction(lbid);
                    if (ff != 0.0f) {
                        this.motionx *= 1.0f - ff * deltaT * rate;
                        this.motionz *= 1.0f - ff * deltaT * rate;
                        this.motiony *= 1.0f - ff * deltaT * rate;
                    }
                }
                if (this.getInLiquid() && this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.height * 3.0f / 4.0f + this.swimoffset), (int)this.posz)) && this.world.rand.nextInt(9) != 0) {
                    this.motiony += 0.08f;
                }
                if (!Blocks.isLiquid(bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.eyeheight), (int)this.posz))) {
                    this.setAir(this.getMaxAir());
                } else {
                    this.setAir(this.getAir() - 0.06f * deltaT);
                }
                if (this.getAir() < 0.0f) {
                    this.doAttackFrom(null, 6, 2.5f * deltaT);
                }
            }
        } else if (this instanceof Player && this == DangerZone.player) {
            int bid;
            int startheight;
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.toRadians(this.rotation_yaw_head);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw = (float)((double)this.rotation_yaw + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            if (DangerZone.player.getGameMode() == 2) {
                int intheight = (int)this.height;
                ++intheight;
                boolean tmpb = false;
                int lbid = 0;
                int k = 0;
                while (k < intheight) {
                    int bid2 = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                    if (Blocks.isLiquid(bid2)) {
                        tmpb = true;
                        lbid = bid2;
                    }
                    ++k;
                }
                this.setInLiquid(tmpb);
                super.update(deltaT);
                return;
            }
            int intheight = (int)this.height;
            ++intheight;
            int k = startheight = (int)this.height / 4;
            while (k < intheight) {
                this.doSolidsPushback(k, deltaT);
                ++k;
            }
            if (this.getInLiquid()) {
                gravity /= 5.0f;
            }
            this.motiony -= gravity;
            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz)) {
                this.motiony += gravity * 2.0f;
            }
            float df = this.motiony * deltaT * rate;
            int idf = (int)df;
            df -= (float)idf;
            if (this.motiony < 0.0f) {
                int i = 0;
                while (i >= idf) {
                    if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + (float)i, this.posz)) {
                        int imax = (int)(this.posy + df + (float)i) + 1;
                        this.motiony = 0.0f;
                        this.posy = (float)imax + 0.001f;
                        if (this.fallcount > 40) {
                            this.doAttackFrom(this, 5, (float)(this.fallcount - 40) * rate);
                        }
                        this.fallcount = 0;
                        break;
                    }
                    --i;
                }
            }
            if (this.motiony > 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz) && this.isSolidAtLevel(this.dimension, this.posx, this.posy + this.height + 0.15f + this.motiony * deltaT * rate, this.posz)) {
                this.motiony /= 6.0f;
            }
            if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.1f, this.posz)) {
                this.setOnGround(false);
                if (this.motiony < 0.0f) {
                    ++this.fallcount;
                }
                if (this.getGameMode() != 0) {
                    this.fallcount = 0;
                }
                this.lastbd = 0;
                this.lastbz = 0;
                this.lastby = 0;
                this.lastbx = 0;
            } else {
                this.setOnGround(true);
                this.fallcount = 0;
                if (this.getGameMode() != 2) {
                    bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                    float ff = Blocks.getFriction(bid);
                    if (ff != 0.0f) {
                        this.motionx *= 1.0f - ff * deltaT * rate;
                        this.motionz *= 1.0f - ff * deltaT * rate;
                    }
                    if (this.dimension != this.lastbd || (int)this.posx != this.lastbx || (int)(this.posy - 0.25f) != this.lastby || (int)this.posz != this.lastbz) {
                        this.lastbd = this.dimension;
                        this.lastbx = (int)this.posx;
                        this.lastby = (int)(this.posy - 0.25f);
                        this.lastbz = (int)this.posz;
                        Blocks.doSteppedOn(bid, this, this.world, this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                    }
                }
            }
            intheight = (int)this.height;
            ++intheight;
            boolean tmpb = false;
            int lbid = 0;
            k = 0;
            while (k < intheight) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                if (Blocks.isLiquid(bid)) {
                    tmpb = true;
                    lbid = bid;
                }
                ++k;
            }
            this.setInLiquid(tmpb);
            if (this.getInLiquid()) {
                float ff;
                this.fallcount = 0;
                if (this.getGameMode() != 2 && (ff = Blocks.getFriction(lbid)) != 0.0f) {
                    this.motionx *= 1.0f - ff * deltaT * rate;
                    this.motionz *= 1.0f - ff * deltaT * rate;
                    this.motiony *= 1.0f - ff * deltaT * rate;
                }
            }
            if (!Blocks.isLiquid(bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.eyeheight), (int)this.posz))) {
                this.setAir(this.getMaxAir());
            } else if (this.getGameMode() == 0) {
                this.setAir(this.getAir() - 0.02f * deltaT);
            }
            if (this.getAir() < 0.0f && this.getGameMode() == 0) {
                this.doAttackFrom(null, 6, 1.5f * deltaT);
            }
        }
        super.update(deltaT);
    }

    @Override
    public void doHurtAnimation() {
        this.hurtanimationtimer = 30;
        this.madtimer = this.world.rand.nextInt(200) + 60;
        this.jump();
    }

    @Override
    public boolean isHurt() {
        return this.hurtanimationtimer > 0;
    }

    @Override
    public void jump() {
        if (this.getInLiquid() && this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.height * 3.0f / 4.0f + this.swimoffset), (int)this.posz)) && this.world.rand.nextInt(2) == 0) {
            this.motiony += 0.155f;
            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.35f, this.posz)) {
                this.motiony += 0.55f;
            }
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.1f, this.posz)) {
            return;
        }
        if (Math.abs(this.motiony) > 0.15f) {
            return;
        }
        this.motiony += 0.75f + 0.15f * this.height;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (this.damage_backoff > 0) {
            return;
        }
        float d = this.getDefense();
        if (d <= 0.1f) {
            d = 0.1f;
        }
        if (d > 1000.0f) {
            d = 1000.0f;
        }
        float td = pain * d;
        td = this.getHealth() - td;
        if (td > this.getMaxHealth()) {
            td = this.getMaxHealth();
        }
        this.setHealth(td);
        if (e != null) {
            float dir = (float)Math.atan2(this.posz - e.posz, this.posx - e.posx);
            float sf = e.height * e.width;
            if (sf < 0.25f) {
                sf = 0.25f;
            }
            if (sf > 100.0f) {
                sf = 100.0f;
            }
            this.motionx = (float)((double)this.motionx + Math.cos(dir) * (double)0.65f * (double)sf);
            this.motionz = (float)((double)this.motionz + Math.sin(dir) * (double)0.65f * (double)sf);
            this.motiony += 0.25f * sf;
            if (this instanceof Player && this.world.isServer) {
                Player pl = (Player)this;
                pl.server_thread.sendVelocityUpdateToPlayer(this.motionx, this.motiony, this.motionz);
            }
        }
        this.newtargetnow = true;
        this.damage_backoff = 5;
        if (!this.world.isServer) {
            this.damage_backoff = 30;
        }
        if (this.getHealth() >= 0.0f) {
            if (this.getHurtSound() != null) {
                this.world.playSound(this.getHurtSound(), this.dimension, this.posx, this.posy + this.height / 2.0f, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            }
            if (this.world.isServer) {
                DangerZone.server.sendEntityHitToAll(this);
            }
        } else {
            if (this.getDeathSound() != null) {
                this.world.playSound(this.getDeathSound(), this.dimension, this.posx, this.posy + this.height / 2.0f, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.1f);
            }
            if (this.world.isServer) {
                DangerZone.server.sendEntityDeathToAll(this);
                this.doDeathDrops();
            }
            this.deadflag = true;
            this.onDeath();
        }
    }

    @Override
    public void onDeath() {
        if (this.world.isServer) {
            EntityExp e;
            int iexp = this.getExperience();
            while (iexp >= 1000) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(1000);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 1000;
            }
            while (iexp >= 100) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(100);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 100;
            }
            while (iexp >= 10) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(10);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 10;
            }
            while (iexp >= 1) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(1);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                --iexp;
            }
        }
        super.onDeath();
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.world.rand.nextInt(this.movefrequency) == 0 || this.newtargetnow) {
            this.findNewTarget();
        }
        if (this.target != null && this.target.getDistanceToTarget(this.posx, this.posy, this.posz) > this.width / 2.0f) {
            this.moveTowardsTarget(deltaT);
        } else {
            this.target = null;
        }
        super.doEntityAction(deltaT);
    }

    public void moveTowardsTarget(float deltaT) {
        int startheight;
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        float factor = 1.0f;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float dist = this.target.getDistanceToTarget(this.posx, this.posy, this.posz);
        factor = dist / 4.0f;
        if (factor > 1.0f) {
            factor = 1.0f;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.moveSpeed * factor) * Math.sin(tdir));
        this.motionz = (float)((double)this.motionz + (double)(this.moveSpeed * factor) * Math.cos(tdir));
        if (!this.isSolidAtLevel(this.dimension, this.posx + this.motionx * deltaT, this.posy - 1.0f, this.posz + this.motionz * deltaT) && !this.isSolidAtLevel(this.dimension, this.posx + this.motionx * deltaT, this.posy - this.height / 4.0f - 2.0f, this.posz + this.motionz * deltaT)) {
            this.motionz = 0.0f;
            this.motionx = 0.0f;
            this.newtargetnow = true;
            return;
        }
        int intheight = (int)(this.height + 0.995f);
        int k = startheight = (int)this.height / 4;
        while (k < intheight) {
            if (this.wouldBump(this.posx + this.motionx * deltaT, this.posy + (float)k, this.posz + this.motionz * deltaT)) {
                if (k <= startheight + 1) {
                    if (this.world.rand.nextInt(3) == 0) {
                        this.jump();
                    }
                } else {
                    this.motionx /= 2.0f * deltaT;
                    this.motionz /= 2.0f * deltaT;
                    this.newtargetnow = true;
                    return;
                }
            }
            ++k;
        }
    }

    public void findNewTarget() {
        int i;
        float newy;
        float newz;
        float newx;
        int intdist;
        float newdist;
        float newdir;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        int tries = 4;
        block0: while (tries > 0) {
            --tries;
            newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 90.0f;
            newdist = 2.0f + this.world.rand.nextFloat() * this.width * this.height * 2.0f;
            intdist = (int)(newdist + 0.995f);
            newx = (float)((double)this.posx + Math.cos(newdir += this.rotation_yaw) * (double)newdist);
            newz = (float)((double)this.posz + Math.sin(newdir) * (double)newdist);
            newy = this.posy;
            i = intdist;
            while (i > -intdist) {
                newy = this.posy + (float)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0f, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0f, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block0;
                    newy += 1.0f;
                    newy = (int)newy;
                    this.target.setTarget(newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
        tries = 1;
        block2: while (tries > 0) {
            --tries;
            newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 90.0f;
            newdist = 2.0f + this.world.rand.nextFloat() * this.width * this.height * 4.0f;
            intdist = (int)(newdist + 0.995f);
            newx = (float)((double)this.posx + Math.cos(newdir += this.rotation_yaw + 180.0f) * (double)newdist);
            newz = (float)((double)this.posz + Math.sin(newdir) * (double)newdist);
            newy = this.posy;
            i = intdist;
            while (i > -intdist) {
                newy = this.posy + (float)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0f, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0f, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block2;
                    newy += 1.0f;
                    newy = (int)newy;
                    this.target.setTarget(newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
    }

    public boolean CanProbablySee(int d, float x, float y, float z, int distinblocks) {
        double xzoff = this.width / 2.0f;
        int nblks = distinblocks;
        double cx = (double)this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = (double)this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        float startx = (float)cx;
        float starty = this.posy + this.height * 7.0f / 8.0f;
        float startz = (float)cz;
        float dx = (x - startx) / (float)distinblocks;
        float dy = (y - starty) / (float)distinblocks;
        float dz = (z - startz) / (float)distinblocks;
        if ((double)Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((float)nblks * Math.abs(dx));
            if (dx > 1.0f) {
                dx = 1.0f;
            }
            if (dx < -1.0f) {
                dx = -1.0f;
            }
        }
        if ((double)Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((float)nblks * Math.abs(dy));
            if (dy > 1.0f) {
                dy = 1.0f;
            }
            if (dy < -1.0f) {
                dy = -1.0f;
            }
        }
        if ((double)Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((float)nblks * Math.abs(dz));
            if (dz > 1.0f) {
                dz = 1.0f;
            }
            if (dz < -1.0f) {
                dz = -1.0f;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(d, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean CanProbablySeeEntity(Entity e) {
        double xzoff = this.width / 2.0f;
        int nblks = (int)this.getDistanceFromEntity(e);
        if (nblks < 1) {
            return true;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if ((double)ddiff > 1.5707963267948966) {
            return false;
        }
        if ((double)ddiff < -1.5707963267948966) {
            return false;
        }
        double cx = (double)this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = (double)this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        float startx = (float)cx;
        float starty = this.posy + this.height * 7.0f / 8.0f;
        float startz = (float)cz;
        float dx = (e.posx - startx) / (float)nblks;
        float dy = (e.posy + e.height * 7.0f / 8.0f - starty) / (float)nblks;
        float dz = (e.posz - startz) / (float)nblks;
        if ((double)Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((float)nblks * Math.abs(dx));
            if (dx > 1.0f) {
                dx = 1.0f;
            }
            if (dx < -1.0f) {
                dx = -1.0f;
            }
        }
        if ((double)Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((float)nblks * Math.abs(dy));
            if (dy > 1.0f) {
                dy = 1.0f;
            }
            if (dy < -1.0f) {
                dy = -1.0f;
            }
        }
        if ((double)Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((float)nblks * Math.abs(dz));
            if (dz > 1.0f) {
                dz = 1.0f;
            }
            if (dz < -1.0f) {
                dz = -1.0f;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(this.dimension, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public float getLightAtLocation(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return WorldRendererUtils.getTotalLightAt(w, d, x, y, z);
        }
        Player p = DangerZone.server.findNearestPlayerToHere(d, x, y, z);
        if (p != null) {
            return p.server_thread.doLightingRequest(d, x, y, z);
        }
        return w.rand.nextFloat();
    }

    public void heal(float h) {
        float hval = h;
        float hmx = this.getMaxHealth() - this.getHealth();
        if (hval > hmx) {
            hval = hmx;
        }
        this.setHealth(this.getHealth() + hval);
    }
}

