/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class EntityHostile
extends EntityLiving {
    private GenericTargetSorter TargetSorter = null;
    public float searchDistance = 16.0f;
    public float attackRange = 2.0f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;
    boolean daytimecheck = true;

    public EntityHostile(World w) {
        super(w);
    }

    @Override
    public void init() {
        super.init();
        this.TargetSorter = new GenericTargetSorter(this);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        this.hurtMe = e;
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = 0;
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(10) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < this.attackRange + this.targetentity.width / 2.0f + this.width / 2.0f) {
            this.targetentity.doAttackFrom(this, 4, this.getAttackDamage());
        }
        super.doEntityAction(deltaT);
    }

    public Entity findSomethingToAttack() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.width / 2.0f + this.searchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!this.isSuitableTarget(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityHostile) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    public boolean isIgnorable(Entity e) {
        if (e == this) {
            return true;
        }
        if (!(e instanceof EntityLiving)) {
            return true;
        }
        if (e.deadflag) {
            return true;
        }
        if (e instanceof Butterfly) {
            return true;
        }
        if (e instanceof Ghost) {
            return true;
        }
        if (e instanceof GhostSkelly) {
            return true;
        }
        if (e instanceof Goose) {
            return true;
        }
        return e instanceof Player && e.getGameMode() != 0;
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (this.daytimecheck) {
            if (w.isDaytime()) {
                return false;
            }
            if (this.getLightAtLocation(w, dimension, x, y, z) > 0.35f) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void update(float deltaT) {
        if (this.canDespawn && this.world.isServer) {
            if (this.daytimecheck) {
                if (this.world.isDaytime() && this.world.rand.nextInt(100) == 1) {
                    float dist = 0.0f;
                    Player p = DangerZone.server.findNearestPlayer(this);
                    if (p == null) {
                        this.deadflag = true;
                    } else {
                        dist = Utils.getDistanceBetweenEntities(this, p);
                        if (dist > (float)this.maxrenderdist) {
                            this.deadflag = true;
                        }
                    }
                }
            } else if (this.world.rand.nextInt(1000) == 1) {
                float dist = 0.0f;
                Player p = DangerZone.server.findNearestPlayer(this);
                if (p == null) {
                    this.deadflag = true;
                } else {
                    dist = Utils.getDistanceBetweenEntities(this, p);
                    if (dist > (float)this.maxrenderdist) {
                        this.deadflag = true;
                    }
                }
            }
        }
        super.update(deltaT);
    }
}

