/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;

public class EntityFurnace
extends Entity {
    public InventoryContainer[] inventory;
    public boolean contents_requested = false;
    FurnaceInventoryPacket cip = null;

    public EntityFurnace(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityFurnace";
        this.inventory = new InventoryContainer[10];
        int i = 0;
        while (i < 10) {
            this.inventory[i] = null;
            ++i;
        }
        this.isGhost = true;
        this.width = 0.01f;
        this.height = 0.01f;
        this.contents_requested = false;
        this.cip = new FurnaceInventoryPacket();
        this.setVarFloat(4, 0.0f);
        this.setVarFloat(6, 0.0f);
        this.setVarFloat(8, 0.0f);
        this.setVarFloat(10, 0.0f);
        this.setVarFloat(5, 0.0f);
        this.setVarFloat(7, 0.0f);
        this.setVarFloat(9, 0.0f);
        this.setVarFloat(11, 0.0f);
    }

    @Override
    public void update(float deltaT) {
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        int meta = this.world.getblockmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != Blocks.furnace.blockID && bid != Blocks.furnaceOn.blockID) {
            if (this.world.isServer) {
                this.dumpInventory();
            }
            this.deadflag = true;
        }
        if (!(this.world.isServer || this.deadflag || this.contents_requested)) {
            this.contents_requested = true;
            FurnaceInventoryPacket cip = new FurnaceInventoryPacket();
            cip.requestContents(this.entityID);
        }
        if (!this.deadflag && this.world.isServer) {
            int i = 0;
            while (i < 2) {
                float fuel = this.getVarFloat(4 + i);
                if (fuel > 0.0f) {
                    fuel -= 0.1f;
                }
                if (fuel <= 0.0f) {
                    fuel = 0.0f;
                    if (this.inventory[2 + i * 3] != null) {
                        float newfuel = 0.0f;
                        if (this.inventory[2 + i * 3].bid != 0) {
                            newfuel = Blocks.getBurnTime(this.inventory[2 + i * 3].bid);
                        }
                        if (this.inventory[2 + i * 3].iid != 0) {
                            newfuel = Items.getBurnTime(this.inventory[2 + i * 3].iid);
                        }
                        if (newfuel > 0.0f && this.inventory[1 + i * 3] != null) {
                            --this.inventory[2 + i * 3].count;
                            if (this.inventory[2 + i * 3].count <= 0) {
                                this.inventory[2 + i * 3] = null;
                            }
                            this.cip.inventoryUpdateToAllClients(this.entityID, this.dimension, 2 + i * 3, this.inventory[2 + i * 3]);
                            fuel = newfuel;
                        }
                    }
                    this.setVarFloat(6 + i, fuel);
                }
                this.setVarFloat(4 + i, fuel);
                if (fuel > 0.0f) {
                    if (bid != Blocks.furnaceOn.blockID) {
                        this.world.setblockandmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, Blocks.furnaceOn.blockID, meta);
                    }
                    if (this.inventory[1 + i * 3] != null) {
                        InventoryContainer ic = this.inventory[1 + i * 3];
                        InventoryContainer ic2 = this.inventory[0 + i * 3];
                        boolean canadd = true;
                        int iid = 0;
                        int bbd = 0;
                        CookingRecipe r = null;
                        if (ic.bid != 0) {
                            r = Cooking.find(Blocks.getUniqueName(ic.bid));
                        }
                        if (ic.iid != 0) {
                            r = Cooking.find(Items.getUniqueName(ic.iid));
                        }
                        if (r != null) {
                            iid = Items.findByName(r.outname);
                            bbd = Blocks.findByName(r.outname);
                        } else {
                            canadd = false;
                        }
                        if (ic2 != null) {
                            if (bbd != ic2.bid || iid != ic2.iid) {
                                canadd = false;
                            }
                            if (ic2.count >= ic2.getMaxStack()) {
                                canadd = false;
                            }
                        }
                        if (canadd) {
                            if (this.getVarFloat(10 + i) != 0.0f) {
                                float te = this.getVarFloat(8 + i);
                                float tr = this.getVarFloat(10 + i) - te;
                                te += 0.1f;
                                if (tr > 3.999f && tr < 4.001f) {
                                    this.world.playSound("DangerZone:furnace_ding", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                                }
                                if (te >= this.getVarFloat(10 + i)) {
                                    if (ic2 == null) {
                                        ic2 = new InventoryContainer();
                                        ic2.iid = iid;
                                        ic2.bid = bbd;
                                        ic2.count = 0;
                                        this.inventory[0 + i * 3] = ic2;
                                    }
                                    ++ic2.count;
                                    this.cip.inventoryUpdateToAllClients(this.entityID, this.dimension, 0 + i * 3, this.inventory[0 + i * 3]);
                                    --ic.count;
                                    if (ic.count <= 0) {
                                        ic = null;
                                        this.inventory[1 + i * 3] = null;
                                    }
                                    this.cip.inventoryUpdateToAllClients(this.entityID, this.dimension, 1 + i * 3, this.inventory[1 + i * 3]);
                                    this.setVarFloat(8 + i, 0.0f);
                                    this.setVarFloat(10 + i, 0.0f);
                                    Utils.spawnExperience(1, this.world, this.dimension, this.posx, this.posy, this.posz);
                                } else {
                                    this.setVarFloat(8 + i, te);
                                }
                            } else {
                                this.setVarFloat(8 + i, 0.0f);
                                this.setVarFloat(10 + i, r.cooktime);
                            }
                        }
                    } else {
                        this.setVarFloat(8 + i, 0.0f);
                        this.setVarFloat(10 + i, 0.0f);
                    }
                } else {
                    this.setVarFloat(4 + i, 0.0f);
                    this.setVarFloat(6 + i, 0.0f);
                    this.setVarFloat(8 + i, 0.0f);
                    this.setVarFloat(10 + i, 0.0f);
                    if (bid != Blocks.furnace.blockID) {
                        this.world.setblockandmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, Blocks.furnace.blockID, meta);
                    }
                }
                ++i;
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        super.update(deltaT);
    }

    @Override
    public void rightClickedByPlayer(Player p, InventoryContainer ic) {
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != Blocks.furnace.blockID && bid != Blocks.furnaceOn.blockID) {
            if (this.world.isServer) {
                this.dumpInventory();
            }
            this.deadflag = true;
            return;
        }
        Blocks.rightClickOnBlock(Blocks.furnace.blockID, p, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
    }

    private void dumpInventory() {
        InventoryContainer ic = null;
        int i = 0;
        while (i < this.inventory.length) {
            ic = this.inventory[i];
            if (ic != null) {
                int j = 0;
                while (j < ic.count) {
                    EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx, this.posy, this.posz);
                    if (e != null) {
                        e.setBID(ic.bid);
                        e.setIID(ic.iid);
                        e.setItemDamage(ic.currentuses);
                        e.rotation_pitch = DangerZone.world.rand.nextInt(360);
                        e.rotation_yaw = DangerZone.world.rand.nextInt(360);
                        e.rotation_roll = DangerZone.world.rand.nextInt(360);
                        e.motionx = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                        e.motiony = this.world.rand.nextFloat() / 2.0f;
                        e.motionz = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                        this.world.spawnEntityInWorld(e);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        int i = 0;
        while (i < this.inventory.length) {
            String s = String.format("%sInventory_%d:", tag, i);
            if (this.inventory[i] != null) {
                prop.setProperty(String.format("%s%s", s, "data"), "valid");
                this.inventory[i].writeSelf(prop, s);
            } else {
                prop.setProperty(String.format("%s%s", s, "data"), "null");
            }
            ++i;
        }
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        int i = 0;
        while (i < this.inventory.length) {
            this.inventory[i] = null;
            String s = String.format("%sInventory_%d:", tag, i);
            String n = prop.getProperty(String.format("%s%s", s, "data"));
            if (n != null && !n.equals("null")) {
                this.inventory[i] = new InventoryContainer();
                this.inventory[i].readSelf(prop, s);
            }
            ++i;
        }
    }
}

