/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;

public class EntityChest
extends Entity {
    public InventoryContainer[] inventory;
    public boolean contents_requested = false;

    public EntityChest(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityChest";
        this.inventory = new InventoryContainer[50];
        int i = 0;
        while (i < 50) {
            this.inventory[i] = null;
            ++i;
        }
        this.isGhost = true;
        this.width = 0.01f;
        this.height = 0.01f;
        this.contents_requested = false;
    }

    @Override
    public void update(float deltaT) {
        if (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) != Blocks.chest.blockID) {
            if (this.world.isServer) {
                this.dumpInventory();
            }
            this.deadflag = true;
        }
        if (!this.world.isServer && !this.contents_requested) {
            this.contents_requested = true;
            ChestInventoryPacket cip = new ChestInventoryPacket();
            cip.requestContents(this.entityID);
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        super.update(deltaT);
    }

    @Override
    public void rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) != Blocks.chest.blockID) {
            if (this.world.isServer) {
                this.dumpInventory();
            }
            this.deadflag = true;
            return;
        }
        Blocks.rightClickOnBlock(Blocks.chest.blockID, p, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
    }

    private void dumpInventory() {
        InventoryContainer ic = null;
        int i = 0;
        while (i < this.inventory.length) {
            ic = this.inventory[i];
            if (ic != null) {
                int j = 0;
                while (j < ic.count) {
                    EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx, this.posy, this.posz);
                    if (e != null) {
                        e.setBID(ic.bid);
                        e.setIID(ic.iid);
                        e.setItemDamage(ic.currentuses);
                        e.rotation_pitch = DangerZone.world.rand.nextInt(360);
                        e.rotation_yaw = DangerZone.world.rand.nextInt(360);
                        e.rotation_roll = DangerZone.world.rand.nextInt(360);
                        e.motionx = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                        e.motiony = this.world.rand.nextFloat() / 2.0f;
                        e.motionz = this.world.rand.nextFloat() - this.world.rand.nextFloat() / 10.0f;
                        this.world.spawnEntityInWorld(e);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        int i = 0;
        while (i < this.inventory.length) {
            String s = String.format("%sInventory_%d:", tag, i);
            if (this.inventory[i] != null) {
                prop.setProperty(String.format("%s%s", s, "data"), "valid");
                this.inventory[i].writeSelf(prop, s);
            } else {
                prop.setProperty(String.format("%s%s", s, "data"), "null");
            }
            ++i;
        }
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        int i = 0;
        while (i < this.inventory.length) {
            this.inventory[i] = null;
            String s = String.format("%sInventory_%d:", tag, i);
            String n = prop.getProperty(String.format("%s%s", s, "data"));
            if (n != null && !n.equals("null")) {
                this.inventory[i] = new InventoryContainer();
                this.inventory[i].readSelf(prop, s);
            }
            ++i;
        }
    }
}

