/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;

public class EntityBlockItem
extends Entity {
    public int deathtimer = 1200;
    public int pickup_delay = 0;

    public EntityBlockItem(World w) {
        super(w);
        this.maxrenderdist = 40;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = DangerZone.blockitemname;
        this.pickup_delay = 10;
        this.canthitme = true;
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
    }

    @Override
    public void update(float deltaT) {
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        this.rotation_pitch_motion = 3.0f;
        this.rotation_yaw_motion = 5.0f;
        this.rotation_roll_motion = 7.0f;
        if (this.world.isServer) {
            Player p;
            int bbid;
            float f;
            if (this.world.rand.nextInt(60) == 1) {
                f = this.world.rand.nextFloat() * 0.12f;
                this.motiony += f;
            }
            if (this.world.rand.nextInt(20) == 1) {
                f = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.12f;
                this.motionx += f;
            }
            if (this.world.rand.nextInt(20) == 1) {
                f = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.12f;
                this.motionz += f;
            }
            this.motiony = Blocks.isSolid(bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - this.height), (int)this.posz)) ? (this.motiony += 0.25f * deltaT) : (this.motiony -= 0.05f * deltaT);
            this.motiony *= 1.0f - 0.05f * deltaT * rate;
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
            if (this.pickup_delay > 0) {
                --this.pickup_delay;
            }
            if (!this.deadflag && this.pickup_delay <= 0 && (p = DangerZone.server.findNearestPlayer(this)) != null && this.getDistanceFromEntity(p) < 5.0f) {
                if (this.getDistanceFromEntity(p) < p.width && p.putMeInASlot(this.getBID(), this.getIID(), this.getItemDamage())) {
                    this.deadflag = true;
                    this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                }
                float tdir = (float)Math.atan2(p.posx - this.posx, p.posz - this.posz);
                float factor = 1.0f;
                float dist = this.getDistanceFromEntity(p);
                factor = 6.0f / dist;
                if (factor > 1.0f) {
                    factor = 1.0f;
                }
                this.motionx = (float)((double)this.motionx + (double)(0.08f * factor) * Math.sin(tdir) * (double)deltaT);
                this.motionz = (float)((double)this.motionz + (double)(0.08f * factor) * Math.cos(tdir) * (double)deltaT);
                if (this.posy > p.posy) {
                    this.motiony -= 0.05f * deltaT;
                }
                if (this.posy < p.posy) {
                    this.motiony += 0.15f * deltaT;
                }
            }
        } else {
            this.motiony *= 1.0f - 0.05f * deltaT * rate;
        }
        super.update(deltaT);
    }
}

