/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Entity {
    public float posx;
    public float posy;
    public float posz;
    public int dimension;
    public float prevposx;
    public float prevposy;
    public float prevposz;
    public float rotation_yaw;
    public float rotation_pitch;
    public float rotation_roll;
    public float rotation_yaw_head;
    public float rotation_pitch_head;
    public float rotation_roll_head;
    public float prevrotation_yaw;
    public float prevrotation_pitch;
    public float prevrotation_roll;
    public float prevrotation_yaw_head;
    public float prevrotation_pitch_head;
    public float prevrotation_roll_head;
    public float rotation_yaw_motion;
    public float rotation_pitch_motion;
    public float rotation_roll_motion;
    public float motionx;
    public float motiony;
    public float motionz;
    public float width = 0.75f;
    public float height = 1.95f;
    public boolean deadflag = false;
    public boolean canDespawn = true;
    public int entityID = 0;
    public long lasttime = System.currentTimeMillis();
    public long currtime;
    private final long update_interval = 100L;
    public World world = null;
    public int maxrenderdist = 256;
    public String uniquename;
    public long lifetimeticker;
    public int hurtanimationtimer;
    public int madtimer = 0;
    public ModelBase model;
    public Texture texture;
    public final int maxvars = 32;
    public short changed;
    public short[] changes;
    public int[] entity_ints;
    public float[] entity_floats;
    public String[] entity_strings;
    boolean takesFallDamage = false;
    boolean isGhost = false;
    public boolean canthitme = false;

    public Entity(World w) {
        this.world = w;
        this.posx = 0.0f;
        this.posy = 0.0f;
        this.posz = 0.0f;
        this.rotation_yaw = 0.0f;
        this.rotation_pitch = 0.0f;
        this.rotation_roll = 0.0f;
        this.rotation_yaw_head = 0.0f;
        this.rotation_pitch_head = 0.0f;
        this.rotation_roll_head = 0.0f;
        this.dimension = 1;
        this.prevposz = 0.0f;
        this.prevposy = 0.0f;
        this.prevposx = 0.0f;
        this.prevrotation_roll = 0.0f;
        this.prevrotation_pitch = 0.0f;
        this.prevrotation_yaw = 0.0f;
        this.prevrotation_roll_head = 0.0f;
        this.prevrotation_pitch_head = 0.0f;
        this.prevrotation_yaw_head = 0.0f;
        this.deadflag = false;
        this.lifetimeticker = 0L;
        this.uniquename = "DangerZone:BaseEntity";
        this.changed = 0;
        this.changes = new short[32];
        this.entity_ints = new int[32];
        this.entity_floats = new float[32];
        this.entity_strings = new String[32];
        int i = 0;
        while (i < 32) {
            this.changes[i] = 0;
            this.entity_ints[i] = 0;
            this.entity_floats[i] = 0.0f;
            this.entity_strings[i] = null;
            ++i;
        }
        this.hurtanimationtimer = 0;
        this.texture = null;
        this.canthitme = false;
    }

    public void init() {
    }

    public int getVarInt(int index) {
        if (index < 0 || index >= 32) {
            return 0;
        }
        return this.entity_ints[index];
    }

    public float getVarFloat(int index) {
        if (index < 0 || index >= 32) {
            return 0.0f;
        }
        return this.entity_floats[index];
    }

    public String getVarString(int index) {
        if (index < 0 || index >= 32) {
            return null;
        }
        return this.entity_strings[index];
    }

    public void setVarInt(int index, int val) {
        if (index < 0 || index >= 32) {
            return;
        }
        if (this.entity_ints[index] != val) {
            this.entity_ints[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 1);
            this.changed = 1;
        }
    }

    public void setVarFloat(int index, float val) {
        if (index < 0 || index >= 32) {
            return;
        }
        if (this.entity_floats[index] != val) {
            this.entity_floats[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 2);
            this.changed = 1;
        }
    }

    public void setVarString(int index, String val) {
        if (index < 0 || index >= 32) {
            return;
        }
        if (this.entity_strings[index] != val) {
            this.entity_strings[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 4);
            this.changed = 1;
        }
    }

    public void setMaxHealth(float f) {
        this.setVarFloat(0, f);
    }

    public float getMaxHealth() {
        return this.getVarFloat(0);
    }

    public void setHealth(float f) {
        this.setVarFloat(1, f);
    }

    public float getHealth() {
        return this.getVarFloat(1);
    }

    public void setDefense(float f) {
        this.setVarFloat(2, f);
    }

    public float getDefense() {
        return this.getVarFloat(2);
    }

    public void setAttackDamage(float f) {
        this.setVarFloat(3, f);
    }

    public float getAttackDamage() {
        return this.getVarFloat(3);
    }

    public void setMaxHunger(float f) {
        this.setVarFloat(4, f);
    }

    public float getMaxHunger() {
        return this.getVarFloat(4);
    }

    public void setHunger(float f) {
        this.setVarFloat(5, f);
    }

    public float getHunger() {
        return this.getVarFloat(5);
    }

    public void setMaxAir(float f) {
        this.setVarFloat(6, f);
    }

    public float getMaxAir() {
        return this.getVarFloat(6);
    }

    public void setAir(float f) {
        this.setVarFloat(7, f);
    }

    public float getAir() {
        return this.getVarFloat(7);
    }

    public void setBID(int f) {
        this.setVarInt(0, f);
    }

    public int getBID() {
        return this.getVarInt(0);
    }

    public void setIID(int f) {
        this.setVarInt(1, f);
    }

    public int getIID() {
        return this.getVarInt(1);
    }

    public int getGameMode() {
        return this.getVarInt(2);
    }

    public void setGameMode(int f) {
        this.setVarInt(2, f);
    }

    public void sethotbarindex(int f) {
        this.setVarInt(3, f);
    }

    public int gethotbarindex() {
        return this.getVarInt(3);
    }

    public void setItemDamage(int f) {
        this.setVarInt(4, f);
    }

    public int getItemDamage() {
        return this.getVarInt(4);
    }

    public void setAttacking(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 1) : (f &= 0xFFFFFFFE);
        this.setVarInt(5, f);
    }

    public boolean getAttacking() {
        return (this.getVarInt(5) & 1) == 1;
    }

    public void setInLiquid(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 2) : (f &= 0xFFFFFFFD);
        this.setVarInt(5, f);
    }

    public boolean getInLiquid() {
        return (this.getVarInt(5) & 2) == 2;
    }

    public void setOnGround(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 4) : (f &= 0xFFFFFFFB);
        this.setVarInt(5, f);
    }

    public boolean getOnGround() {
        return (this.getVarInt(5) & 4) == 4;
    }

    public void setExperience(int f) {
        this.setVarInt(6, f);
    }

    public int getExperience() {
        return this.getVarInt(6);
    }

    public void doAttackFrom(Entity e, int dt, float ouch) {
    }

    public void doHurtAnimation() {
    }

    public void onDeath() {
    }

    public void jump() {
    }

    public float getRightArmAngle() {
        return 0.0f;
    }

    public boolean isHurt() {
        return false;
    }

    public boolean isMad() {
        return false;
    }

    public boolean isDying() {
        return false;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return null;
    }

    public String getDeathSound() {
        return null;
    }

    public String getAttackSound() {
        return null;
    }

    public void doDeathAnimation() {
    }

    public float getDeathFactor() {
        return 0.0f;
    }

    public void writeSelf(Properties prop, String tag) {
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_yaw %= 360.0f;
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_pitch %= 360.0f;
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_roll %= 360.0f;
        while (this.rotation_yaw_head < 0.0f) {
            this.rotation_yaw_head += 360.0f;
        }
        this.rotation_yaw_head %= 360.0f;
        while (this.rotation_pitch_head < 0.0f) {
            this.rotation_pitch_head += 360.0f;
        }
        this.rotation_pitch_head %= 360.0f;
        while (this.rotation_roll_head < 0.0f) {
            this.rotation_roll_head += 360.0f;
        }
        this.rotation_roll_head %= 360.0f;
        prop.setProperty(String.format("%s%s", tag, "posx"), String.format("%f", Float.valueOf(this.posx)));
        prop.setProperty(String.format("%s%s", tag, "posy"), String.format("%f", Float.valueOf(this.posy)));
        prop.setProperty(String.format("%s%s", tag, "posz"), String.format("%f", Float.valueOf(this.posz)));
        prop.setProperty(String.format("%s%s", tag, "dimension"), String.format("%d", this.dimension));
        prop.setProperty(String.format("%s%s", tag, "rotation_yaw"), String.format("%f", Float.valueOf(this.rotation_yaw)));
        prop.setProperty(String.format("%s%s", tag, "rotation_pitch"), String.format("%f", Float.valueOf(this.rotation_pitch)));
        prop.setProperty(String.format("%s%s", tag, "rotation_roll"), String.format("%f", Float.valueOf(this.rotation_roll)));
        prop.setProperty(String.format("%s%s", tag, "rotation_yaw_motion"), String.format("%f", Float.valueOf(this.rotation_yaw_motion)));
        prop.setProperty(String.format("%s%s", tag, "rotation_pitch_motion"), String.format("%f", Float.valueOf(this.rotation_pitch_motion)));
        prop.setProperty(String.format("%s%s", tag, "rotation_roll_motion"), String.format("%f", Float.valueOf(this.rotation_roll_motion)));
        prop.setProperty(String.format("%s%s", tag, "motionx"), String.format("%f", Float.valueOf(this.motionx)));
        prop.setProperty(String.format("%s%s", tag, "motiony"), String.format("%f", Float.valueOf(this.motiony)));
        prop.setProperty(String.format("%s%s", tag, "motionz"), String.format("%f", Float.valueOf(this.motionz)));
        prop.setProperty(String.format("%s%s", tag, "width"), String.format("%f", Float.valueOf(this.width)));
        prop.setProperty(String.format("%s%s", tag, "height"), String.format("%f", Float.valueOf(this.height)));
        prop.setProperty(String.format("%s%s", tag, "maxrenderdist"), String.format("%d", this.maxrenderdist));
        prop.setProperty(String.format("%s%s", tag, "lifetimeticker"), String.format("%d", this.lifetimeticker));
        prop.setProperty(String.format("%s%s", tag, "rotation_yaw_head"), String.format("%f", Float.valueOf(this.rotation_yaw_head)));
        prop.setProperty(String.format("%s%s", tag, "rotation_pitch_head"), String.format("%f", Float.valueOf(this.rotation_pitch_head)));
        prop.setProperty(String.format("%s%s", tag, "rotation_roll_head"), String.format("%f", Float.valueOf(this.rotation_roll_head)));
        int i = 0;
        while (i < 32) {
            if (this.entity_ints[i] != 0) {
                prop.setProperty(String.format("%s%s%d", tag, "varint", i), String.format("%d", this.entity_ints[i]));
            }
            if (this.entity_floats[i] != 0.0f) {
                prop.setProperty(String.format("%s%s%d", tag, "varfloat", i), String.format("%f", Float.valueOf(this.entity_floats[i])));
            }
            if (this.entity_strings[i] != null) {
                prop.setProperty(String.format("%s%s%d", tag, "varstring", i), this.entity_strings[i]);
            }
            ++i;
        }
    }

    public void readSelf(Properties prop, String tag) {
        this.posx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posx"), 0.0f, Float.MAX_VALUE, 10000.0f);
        this.posy = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posy"), 0.0f, 256.0f, 75.0f);
        this.posz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posz"), 0.0f, Float.MAX_VALUE, 10000.0f);
        this.dimension = Utils.getPropertyInt(prop, String.format("%s%s", tag, "dimension"), 1, 256, 1);
        this.rotation_yaw = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw"), 0.0f, 360.0f, 0.0f);
        this.rotation_pitch = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch"), 0.0f, 360.0f, 0.0f);
        this.rotation_roll = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll"), 0.0f, 360.0f, 0.0f);
        this.rotation_yaw_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_motion"), -300.0f, 300.0f, 0.0f);
        this.rotation_pitch_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_motion"), -300.0f, 300.0f, 0.0f);
        this.rotation_roll_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_motion"), -300.0f, 300.0f, 0.0f);
        this.motionx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionx"), -10.0f, 10.0f, 0.0f);
        this.motiony = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motiony"), -10.0f, 10.0f, 0.0f);
        this.motionz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionz"), -10.0f, 10.0f, 0.0f);
        this.width = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "width"), 0.1f, 30.0f, this.width);
        this.height = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "height"), 0.1f, 50.0f, this.height);
        this.maxrenderdist = Utils.getPropertyInt(prop, String.format("%s%s", tag, "maxrenderdist"), 2, 512, 16 * DangerZone.renderdistance);
        this.lifetimeticker = Utils.getPropertyLong(prop, String.format("%s%s", tag, "lifetimeticker"), 0L, Long.MAX_VALUE, 0L);
        this.rotation_yaw_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_head"), 0.0f, 360.0f, 0.0f);
        this.rotation_pitch_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_head"), 0.0f, 360.0f, 0.0f);
        this.rotation_roll_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_head"), 0.0f, 360.0f, 0.0f);
        int i = 0;
        while (i < 32) {
            this.entity_ints[i] = Utils.getPropertyInt(prop, String.format("%s%s%d", tag, "varint", i), Integer.MIN_VALUE, Integer.MAX_VALUE, this.entity_ints[i]);
            if (this.entity_ints[i] != 0) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 1);
            }
            this.entity_floats[i] = Utils.getPropertyFloat(prop, String.format("%s%s%d", tag, "varfloat", i), Float.MIN_VALUE, Float.MAX_VALUE, this.entity_floats[i]);
            if (this.entity_floats[i] != 0.0f) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 2);
            }
            this.entity_strings[i] = Utils.getPropertyString(prop, String.format("%s%s%d", tag, "varstring", i), this.entity_strings[i]);
            if (this.entity_strings[i] != null) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 4);
            }
            ++i;
        }
    }

    public void doEntityCollisions(float deltaT) {
    }

    public void doEntityAction(float deltaT) {
    }

    public void doDeathDrops() {
    }

    public void update(float deltaT) {
        int different = 0;
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        ++this.lifetimeticker;
        if (deltaT > 1.5f) {
            this.lifetimeticker += (long)((int)(deltaT + 0.5f - 1.0f));
        }
        if (!this.world.isServer) {
            Player p;
            if (this instanceof Player && (p = (Player)this).getGameMode() == 2) {
                this.motiony *= 1.0f - 0.15f * deltaT * rate;
            }
            this.motionx *= 1.0f - 0.35f * deltaT * rate;
            this.motiony *= 1.0f - 0.05f * deltaT * rate;
            this.motionz *= 1.0f - 0.35f * deltaT * rate;
            this.rotation_pitch_motion *= 1.0f - 0.25f * deltaT * rate;
            this.rotation_yaw_motion *= 1.0f - 0.25f * deltaT * rate;
            this.rotation_roll_motion *= 1.0f - 0.25f * deltaT * rate;
            this.posy += this.motiony * deltaT * rate;
            this.posx += this.motionx * deltaT * rate;
            this.posz += this.motionz * deltaT * rate;
            this.rotation_pitch += this.rotation_pitch_motion * deltaT * rate;
            if (this instanceof Player) {
                this.rotation_yaw_head += this.rotation_yaw_motion * deltaT * rate;
            } else {
                this.rotation_yaw += this.rotation_yaw_motion * deltaT * rate;
            }
            this.rotation_roll += this.rotation_roll_motion * deltaT * rate;
        } else {
            this.motionx = (float)((double)this.motionx * (1.0 - 0.35 * (double)deltaT));
            this.motiony *= 1.0f - 0.05f * deltaT;
            this.motionz *= 1.0f - 0.35f * deltaT;
            this.rotation_pitch_motion *= 1.0f - 0.25f * deltaT;
            this.rotation_yaw_motion *= 1.0f - 0.25f * deltaT;
            this.rotation_roll_motion *= 1.0f - 0.25f * deltaT;
            this.posy += this.motiony * deltaT;
            this.posx += this.motionx * deltaT;
            this.posz += this.motionz * deltaT;
            this.rotation_pitch += this.rotation_pitch_motion * deltaT;
            this.rotation_yaw += this.rotation_yaw_motion * deltaT;
            this.rotation_roll += this.rotation_roll_motion * deltaT;
        }
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_yaw %= 360.0f;
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_pitch %= 360.0f;
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_roll %= 360.0f;
        while (this.rotation_yaw_head < 0.0f) {
            this.rotation_yaw_head += 360.0f;
        }
        this.rotation_yaw_head %= 360.0f;
        while (this.rotation_pitch_head < 0.0f) {
            this.rotation_pitch_head += 360.0f;
        }
        this.rotation_pitch_head %= 360.0f;
        while (this.rotation_roll_head < 0.0f) {
            this.rotation_roll_head += 360.0f;
        }
        this.rotation_roll_head %= 360.0f;
        if (this.world.isServer && this instanceof Player) {
            return;
        }
        if (!this.world.isServer && this != DangerZone.player) {
            return;
        }
        this.currtime = System.currentTimeMillis();
        long too_long = this.currtime - this.lasttime;
        different = 0;
        if (too_long >= 100L) {
            if (this.changed != 0) {
                ++different;
            }
            if (too_long >= 1000L) {
                ++different;
            }
            if (this.prevposx != this.posx || this.prevposy != this.posy || this.prevposz != this.posz) {
                ++different;
            }
            if (this.prevrotation_yaw != this.rotation_yaw || this.prevrotation_pitch != this.rotation_pitch || this.prevrotation_roll != this.rotation_roll) {
                ++different;
            }
            if (this.prevrotation_yaw_head != this.rotation_yaw_head || this.prevrotation_pitch_head != this.rotation_pitch_head || this.prevrotation_roll_head != this.rotation_roll_head) {
                ++different;
            }
            if (different != 0) {
                this.lasttime = this.currtime;
                this.prevposy = this.posy;
                this.prevposx = this.posx;
                this.prevposz = this.posz;
                this.prevrotation_yaw = this.rotation_yaw;
                this.prevrotation_pitch = this.rotation_pitch;
                this.prevrotation_roll = this.rotation_roll;
                this.prevrotation_yaw_head = this.rotation_yaw_head;
                this.prevrotation_pitch_head = this.rotation_pitch_head;
                this.prevrotation_roll_head = this.rotation_roll_head;
                if (this instanceof Player) {
                    if (!this.world.isServer && this == DangerZone.player) {
                        DangerZone.server_connection.sendPlayerEntityUpdate(this);
                    }
                } else if (this.world.isServer) {
                    DangerZone.server.sendEntityUpdateToAll(this);
                }
            }
        }
    }

    public float getDistanceFromEntity(Entity p) {
        float d1 = p.posx - this.posx;
        float d2 = p.posy - this.posy;
        float d3 = p.posz - this.posz;
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public float getDistanceFromEntityCenter(Entity p) {
        float d1 = p.posx - this.posx;
        float d2 = p.posy + p.height / 2.0f - (this.posy + this.height / 2.0f);
        float d3 = p.posz - this.posz;
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public float getHorizontalDistanceFromEntity(Entity p) {
        float d1 = p.posx - this.posx;
        float d3 = p.posz - this.posz;
        return (float)Math.sqrt(d1 * d1 + d3 * d3);
    }

    public float getDistanceFromEntityCenter(float x, float y, float z) {
        float d1 = x - this.posx;
        float d2 = y - (this.posy + this.height / 2.0f);
        float d3 = z - this.posz;
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public void rightClickedByPlayer(Player p, InventoryContainer ic) {
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        return true;
    }
}

