/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class DangerZone {
    public static String versionstring = "0.0.7";
    public static int gameover = 0;
    static String windowTitle = "Welcome to the Danger Zone...";
    static float deltaT = 0.0f;
    public static String server_address = null;
    public static int server_port = 0;
    public static ChunkCache client_chunk_cache = null;
    public static ServerChunkCache server_chunk_cache = null;
    public static ChunkWriterThread chunkwriter = null;
    public static int screen_width = 1000;
    public static int screen_height = 600;
    public static Player player = null;
    public static World world = null;
    public static World server_world = null;
    public static String worldname = null;
    public static String origworldname = null;
    public static WorldRenderer wr = null;
    public static ServerConnection server_connection = null;
    public static Server server = null;
    public static WorldDecorators wds = null;
    public static Blocks all_the_blocks;
    public static Items all_the_items;
    public static Dimensions all_the_dimensions;
    public static Crafting all_the_recipies;
    public static Cooking all_the_cooking;
    public static Entities all_the_entities;
    public static Particles all_the_particles;
    public static Ores all_the_ores;
    public static Spawnlist all_the_spawns;
    public static CustomPackets all_the_custompackets;
    private static Texture logotexture;
    public static int messagetimer;
    public static String messagestring;
    public static int hotmessagetimer;
    public static String hotmessagestring;
    public static String ghost_string;
    public static String creative_string;
    public static String survival_string;
    public static int renderdistance;
    public static EntityUpdateLoop entityManager;
    public static ParticleUpdateLoop particleManager;
    public static int entityupdatedist;
    public static int max_entities;
    public static BaseMod base;
    public static int entityupdaterate;
    public static int serverentityupdaterate;
    public static boolean f3_on;
    public static boolean f5_front;
    public static boolean f5_back;
    public static boolean view_ores;
    public static String blockitemname;
    public static boolean escape_options_menu;
    public static boolean mouse_grabbed;
    public static GuiInterface current_gui;
    public static PlayerEscapeGUI escapegui;
    public static PlayerHelpGUI helpgui;
    public static PlayerChatGUI chatgui;
    public static PlayerCommandGUI commandgui;
    public static CommandHandler commandhandler;
    public static PlayerInventoryGUI inventorygui;
    public static PlayerChestGUI chestgui;
    public static PlayerFurnaceGUI furnacegui;
    public static EntityBlockItem blockitem;
    public static int packets_per_second;
    public static int chunks_per_second;
    public static int gofasttimer;
    public static int gofast;
    public static int do_hit_cycle;
    public static int do_food_cycle;
    private static int volume_temp;
    public static SoundManager soundmangler;
    public static boolean start_server;
    public static boolean start_client;
    private static long nowtime;
    private static long thentime;
    private static int pps;
    private static Font awtfont;
    private static TrueTypeFont font;
    public static LightingThread lto;
    public static CleanerThread tidyup;
    public static String playername;
    public static Random rand;
    public static TextureMapper texmap;
    public static int fieldOfView;
    public static int fieldOfViewLast;
    public static int mouseSensitivity;
    public static float accel;
    public static boolean doleftclick;
    public static boolean dorightclick;
    public static boolean keepitsqueakyclean;
    public static boolean generatecaves;
    public static int mindrawlevel;
    public static ModLoader modloader;
    public static String alt_texture_path;
    public static List<ModListEntry> all_the_mods;
    public static boolean all_sides;
    public static boolean light_speed;
    public static float testx;
    public static float testy;
    public static float testz;
    public static float testp;
    public static float testw;
    public static float testr;

    static {
        logotexture = null;
        messagetimer = 0;
        messagestring = null;
        hotmessagetimer = 0;
        hotmessagestring = null;
        ghost_string = "Game Mode Ghost";
        creative_string = "Game Mode Creative";
        survival_string = "Game Mode Survival";
        renderdistance = 24;
        entityupdatedist = 256;
        max_entities = 4096;
        entityupdaterate = 16;
        serverentityupdaterate = 100;
        f3_on = false;
        f5_front = false;
        f5_back = false;
        view_ores = false;
        blockitemname = "DangerZone:BlockItem";
        escape_options_menu = false;
        mouse_grabbed = false;
        current_gui = null;
        escapegui = null;
        helpgui = null;
        chatgui = null;
        commandgui = null;
        commandhandler = null;
        inventorygui = null;
        chestgui = null;
        furnacegui = null;
        blockitem = null;
        packets_per_second = 0;
        chunks_per_second = 0;
        gofasttimer = 0;
        gofast = 0;
        do_hit_cycle = 0;
        do_food_cycle = 0;
        volume_temp = 0;
        soundmangler = null;
        start_server = true;
        start_client = true;
        nowtime = 0L;
        thentime = 0L;
        pps = 0;
        awtfont = null;
        font = null;
        lto = null;
        tidyup = null;
        playername = "Player";
        rand = null;
        texmap = new TextureMapper();
        accel = 0.0f;
        doleftclick = false;
        dorightclick = false;
        keepitsqueakyclean = true;
        generatecaves = true;
        mindrawlevel = 0;
        modloader = null;
        alt_texture_path = "";
        all_the_mods = new ArrayList<ModListEntry>();
        all_sides = true;
        light_speed = true;
    }

    public static void initGL() {
        screen_width = Display.getWidth();
        screen_height = Display.getHeight();
        GL11.glViewport((int)0, (int)0, (int)screen_width, (int)screen_height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(fieldOfView, (float)screen_width / (float)screen_height, 1.0f, 256.0f * (float)renderdistance);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glHint((int)3152, (int)4353);
        GL11.glEnable((int)3553);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
    }

    public static void main(String[] args) throws InterruptedException {
        long lasttime = System.currentTimeMillis();
        String curdir = System.getProperty("user.dir");
        System.setProperty("org.lwjgl.librarypath", String.valueOf(curdir) + "/DangerZone_lib/native");
        if (args.length > 1) {
            int arglen = args.length;
            int i = 0;
            while (i < arglen) {
                if (args[i].contains("client")) {
                    start_server = false;
                }
                if (args[i].contains("server")) {
                    start_client = false;
                }
                ++i;
            }
            if (!start_client && !start_server) {
                System.out.printf("Bad args?\n", new Object[0]);
                System.exit(1);
            }
        } else {
            start_client = true;
            start_server = true;
        }
        rand = new Random(lasttime);
        DangerZone.readConfig();
        if (start_server && !start_client) {
            screen_width = 800;
            screen_height = 400;
        }
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(screen_width, screen_height));
            Display.setResizable((boolean)true);
            Display.setVSyncEnabled((boolean)false);
            Display.setTitle((String)windowTitle);
            Display.create();
            Keyboard.create();
            Mouse.create();
            SoundStore.get().init();
            DangerZone.initGL();
        }
        catch (LWJGLException e1) {
            System.out.printf("Something went horribly wrong with initialization!\n", new Object[0]);
            e1.printStackTrace();
            System.exit(1);
        }
        DangerZone.showLogo();
        Display.update();
        if (start_server) {
            if (start_client) {
                DangerZone.doStartSinglePlayer();
            } else {
                DangerZone.doStartServer();
            }
        } else if (start_client) {
            DangerZone.doStartClient();
        } else {
            System.out.printf("Hunh?\n", new Object[0]);
            System.exit(1);
        }
        lasttime = System.currentTimeMillis();
        while (gameover == 0) {
            if (start_client) {
                long currtime = System.currentTimeMillis();
                long tlong = currtime - lasttime;
                if ((tlong = 16L - tlong) > 0L) {
                    if (tlong > 16L) {
                        tlong = 16L;
                    }
                    Thread.sleep(tlong);
                } else {
                    Thread.yield();
                }
                currtime = System.currentTimeMillis();
                tlong = currtime - lasttime;
                lasttime = currtime;
                deltaT = tlong;
                if (deltaT < 8.0f) {
                    deltaT = 8.0f;
                }
                if (deltaT > 256.0f) {
                    deltaT = 256.0f;
                }
                player.update(deltaT /= 16.0f);
                if (gofasttimer > 0) {
                    --gofasttimer;
                }
                wr.renderWorld(world);
                if (current_gui != null) {
                    if (mouse_grabbed) {
                        Mouse.setGrabbed((boolean)false);
                        mouse_grabbed = false;
                    }
                    GL11.glDisable((int)2929);
                    GL11.glMatrixMode((int)5889);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-320.0, (double)320.0);
                    GL11.glMatrixMode((int)5888);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    GL11.glEnable((int)3553);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    current_gui.process();
                    GL11.glMatrixMode((int)5889);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5888);
                    GL11.glPopMatrix();
                    GL11.glEnable((int)2929);
                } else {
                    if (!mouse_grabbed) {
                        Mouse.setGrabbed((boolean)true);
                        mouse_grabbed = true;
                    }
                    DangerZone.doNormalInput();
                }
                Display.update();
                if (Display.isCloseRequested()) {
                    gameover = 1;
                }
                if (Display.wasResized() || fieldOfView != fieldOfViewLast) {
                    DangerZone.initGL();
                    fieldOfViewLast = fieldOfView;
                }
                SoundStore.get().poll(0);
                continue;
            }
            Thread.sleep(100L);
            nowtime = System.currentTimeMillis();
            if (nowtime - thentime > 1000L) {
                thentime = nowtime;
                pps = packets_per_second;
                packets_per_second = 0;
            }
            DangerZone.showLogo();
            GL11.glDisable((int)2929);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-320.0, (double)320.0);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glEnable((int)3553);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (font == null) {
                awtfont = new Font("Times New Roman", 0, 24);
                font = new TrueTypeFont(awtfont, false);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)10.0f, (float)(screen_height - 10), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            font.drawString(0.0f, 0.0f, String.format("Players: %d", DangerZone.server.server_thread_list.size()), Color.gray);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)10.0f, (float)(screen_height - 60), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            font.drawString(0.0f, 0.0f, String.format("Packets per Second: %d", pps), Color.gray);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)10.0f, (float)(screen_height - 110), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            font.drawString(0.0f, 0.0f, String.format("Entities: %d", DangerZone.server.entityManager.entity_list.size()), Color.gray);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
            Display.update();
            if (Display.isCloseRequested()) {
                gameover = 1;
            }
            if (Display.wasResized()) {
                DangerZone.initGL();
            }
            while (Keyboard.next()) {
                if (Keyboard.getEventKey() != 1 || !Keyboard.isKeyDown((int)1) || !Keyboard.getEventKeyState()) continue;
                gameover = 1;
            }
        }
        if (start_client) {
            DangerZone.showLogo();
            Display.update();
            DangerZone.writeConfig();
            DangerZone.savePlayer(player);
        }
        Thread.sleep(200L);
        if (start_server) {
            DangerZone.saveWorld(server_world);
            Thread.sleep(500L);
            DangerZone.server_world.serverchunkcache.shutdown();
            while (chunkwriter.getSize() > 0) {
                Thread.sleep(100L);
            }
            Thread.sleep(100L);
        }
        Thread.sleep(500L);
        Mouse.destroy();
        Keyboard.destroy();
        Display.destroy();
        AL.destroy();
        System.exit(0);
    }

    public static boolean K_next() {
        return Keyboard.next();
    }

    public static int K_getEventKey() {
        return Keyboard.getEventKey();
    }

    public static boolean K_getEventKeyState() {
        return Keyboard.getEventKeyState();
    }

    public static boolean K_isKeyDown(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    public static boolean M_next() {
        return Mouse.next();
    }

    public static int M_getEventButton() {
        return Mouse.getEventButton();
    }

    public static boolean M_getEventButtonState() {
        return Mouse.getEventButtonState();
    }

    public static int M_getEventX() {
        return Mouse.getEventX();
    }

    public static int M_getEventY() {
        return Mouse.getEventY();
    }

    public static int M_getX() {
        return Mouse.getX();
    }

    public static int M_getY() {
        return Mouse.getY();
    }

    public static void setActiveGui(GuiInterface g) {
        if (current_gui == null) {
            current_gui = g;
            do_hit_cycle = 0;
            do_food_cycle = 0;
            doleftclick = false;
            dorightclick = false;
        }
    }

    public static void clearActiveGui() {
        current_gui = null;
    }

    private static void doNormalInput() {
        int i;
        if ((accel -= 0.05f) < 0.1f) {
            accel = 0.1f;
        }
        while (Keyboard.next()) {
            int meta;
            int bid;
            if (Keyboard.getEventKey() == 1 && Keyboard.isKeyDown((int)1) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(escapegui);
            }
            if (Keyboard.getEventKey() == 35 && Keyboard.isKeyDown((int)35) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(helpgui);
            }
            if (Keyboard.getEventKey() == 18 && Keyboard.isKeyDown((int)18) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(inventorygui);
            }
            if (Keyboard.getEventKey() == 20 && Keyboard.isKeyDown((int)20) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(chatgui);
            }
            if (Keyboard.getEventKey() == 53 && Keyboard.isKeyDown((int)53) && Keyboard.getEventKeyState()) {
                DangerZone.setActiveGui(commandgui);
            }
            if (Keyboard.getEventKey() == 34 && Keyboard.isKeyDown((int)34)) {
                if (player.getGameMode() == 0) {
                    player.setGameMode(1);
                    messagetimer = 100;
                    messagestring = creative_string;
                } else if (player.getGameMode() == 1) {
                    player.setGameMode(2);
                    messagetimer = 100;
                    messagestring = ghost_string;
                } else {
                    player.setGameMode(0);
                    messagetimer = 100;
                    messagestring = survival_string;
                }
            }
            if (Keyboard.getEventKey() == 45 && Keyboard.isKeyDown((int)45) && WorldRenderer.focus_x != 0 && WorldRenderer.focus_y != 0 && WorldRenderer.focus_z != 0) {
                bid = world.getblock(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                meta = world.getblockmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                if (!Blocks.isLiquid(bid)) {
                    if ((meta & 0xC000) == 0) {
                        meta = meta & 0x3FFF | 0x4000;
                    } else if ((meta & 0xC000) == 16384) {
                        meta = meta & 0x3FFF | 0x8000;
                    } else if ((meta & 0xC000) == 32768) {
                        meta = meta & 0x3FFF | 0xC000;
                    } else if ((meta & 0xC000) == 49152) {
                        meta &= 0x3FFF;
                    }
                    world.setblockandmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, bid, meta);
                }
            }
            if (Keyboard.getEventKey() == 46 && Keyboard.isKeyDown((int)46) && WorldRenderer.focus_x != 0 && WorldRenderer.focus_y != 0 && WorldRenderer.focus_z != 0) {
                bid = world.getblock(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                meta = world.getblockmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                if (!Blocks.isLiquid(bid)) {
                    if ((meta & 0x3000) == 0) {
                        meta = meta & 0xCFFF | 0x1000;
                    } else if ((meta & 0x3000) == 4096) {
                        meta = meta & 0xCFFF | 0x2000;
                    } else if ((meta & 0x3000) == 8192) {
                        meta = meta & 0xCFFF | 0x3000;
                    } else if ((meta & 0x3000) == 12288) {
                        meta &= 0xCFFF;
                    }
                    world.setblockandmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, bid, meta);
                }
            }
            if (Keyboard.getEventKey() == 47 && Keyboard.isKeyDown((int)47) && WorldRenderer.focus_x != 0 && WorldRenderer.focus_y != 0 && WorldRenderer.focus_z != 0) {
                bid = world.getblock(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                meta = world.getblockmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z);
                if (!Blocks.isLiquid(bid)) {
                    if ((meta & 0xC00) == 0) {
                        meta = meta & 0xF3FF | 0x400;
                    } else if ((meta & 0xC00) == 1024) {
                        meta = meta & 0xF3FF | 0x800;
                    } else if ((meta & 0xC00) == 2048) {
                        meta = meta & 0xF3FF | 0xC00;
                    } else if ((meta & 0xC00) == 3072) {
                        meta &= 0xF3FF;
                    }
                    world.setblockandmeta(DangerZone.player.dimension, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, bid, meta);
                }
            }
            if (Keyboard.getEventKey() == 21 && Keyboard.isKeyDown((int)21) && player.getGameMode() != 0) {
                i = 0;
                while (i < 256) {
                    int id = (DangerZone.player.dimension + i + 1) % 256;
                    if (Dimensions.DimensionArray[id] != null) {
                        Dimensions.DimensionArray[id].teleportToDimension(player, world, id, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
                        break;
                    }
                    ++i;
                }
            }
            if (Keyboard.getEventKey() == 16 && Keyboard.isKeyDown((int)16) && DangerZone.player.hotbar[DangerZone.player.current_hotbar_index] != null) {
                if (DangerZone.player.hotbar[DangerZone.player.current_hotbar_index].count != 0) {
                    if (player.getGameMode() == 0) {
                        --DangerZone.player.hotbar[DangerZone.player.current_hotbar_index].count;
                    }
                    server_connection.inventoryUpdate(0, DangerZone.player.current_hotbar_index, DangerZone.player.hotbar[DangerZone.player.current_hotbar_index]);
                    EntityBlockItem e = (EntityBlockItem)DangerZone.player.world.createEntityByName(blockitemname, DangerZone.player.dimension, DangerZone.player.posx + (float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)), DangerZone.player.posy + DangerZone.player.height * 7.0f / 8.0f - (float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f, DangerZone.player.posz + (float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * 2.0f * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)));
                    if (e != null) {
                        e.setBID(DangerZone.player.hotbar[DangerZone.player.current_hotbar_index].bid);
                        e.setIID(DangerZone.player.hotbar[DangerZone.player.current_hotbar_index].iid);
                        e.setItemDamage(DangerZone.player.hotbar[DangerZone.player.current_hotbar_index].currentuses);
                        e.rotation_pitch = DangerZone.player.world.rand.nextInt(360);
                        e.rotation_yaw = DangerZone.player.world.rand.nextInt(360);
                        e.rotation_roll = DangerZone.player.world.rand.nextInt(360);
                        e.motionx = (float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f;
                        e.motiony = -((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)));
                        e.motionz = (float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head)) * 2.0f;
                        DangerZone.player.world.spawnEntityInWorld(e);
                    }
                }
                if (DangerZone.player.hotbar[DangerZone.player.current_hotbar_index].count <= 0) {
                    DangerZone.player.hotbar[DangerZone.player.current_hotbar_index] = null;
                    player.setBID(0);
                    player.setIID(0);
                }
            }
            if (Keyboard.getEventKey() == 60 && Keyboard.isKeyDown((int)60)) {
                Utils.screenshot(screen_width, screen_height);
                messagestring = "Screenshot!";
                messagetimer = 60;
            }
            if (Keyboard.getEventKey() == 61 && Keyboard.isKeyDown((int)61)) {
                f3_on = !f3_on;
            }
            if (Keyboard.getEventKey() == 64 && Keyboard.isKeyDown((int)64) && player.getGameMode() != 0) {
                view_ores = !view_ores;
            }
            if (Keyboard.getEventKey() == 63 && Keyboard.isKeyDown((int)63)) {
                if (f5_front) {
                    f5_front = false;
                    f5_back = true;
                } else if (f5_back) {
                    f5_back = false;
                } else {
                    f5_front = true;
                }
            }
            if (Keyboard.getEventKey() == 2 && Keyboard.isKeyDown((int)2)) {
                DangerZone.player.current_hotbar_index = 0;
            }
            if (Keyboard.getEventKey() == 3 && Keyboard.isKeyDown((int)3)) {
                DangerZone.player.current_hotbar_index = 1;
            }
            if (Keyboard.getEventKey() == 4 && Keyboard.isKeyDown((int)4)) {
                DangerZone.player.current_hotbar_index = 2;
            }
            if (Keyboard.getEventKey() == 5 && Keyboard.isKeyDown((int)5)) {
                DangerZone.player.current_hotbar_index = 3;
            }
            if (Keyboard.getEventKey() == 6 && Keyboard.isKeyDown((int)6)) {
                DangerZone.player.current_hotbar_index = 4;
            }
            if (Keyboard.getEventKey() == 7 && Keyboard.isKeyDown((int)7)) {
                DangerZone.player.current_hotbar_index = 5;
            }
            if (Keyboard.getEventKey() == 8 && Keyboard.isKeyDown((int)8)) {
                DangerZone.player.current_hotbar_index = 6;
            }
            if (Keyboard.getEventKey() == 9 && Keyboard.isKeyDown((int)9)) {
                DangerZone.player.current_hotbar_index = 7;
            }
            if (Keyboard.getEventKey() == 10 && Keyboard.isKeyDown((int)10)) {
                DangerZone.player.current_hotbar_index = 8;
            }
            if (Keyboard.getEventKey() == 11 && Keyboard.isKeyDown((int)11)) {
                DangerZone.player.current_hotbar_index = 9;
            }
            if (Keyboard.getEventKey() != 17 || !Keyboard.isKeyDown((int)17)) continue;
            if (gofasttimer != 0) {
                gofast = 1;
            }
            gofasttimer = 20;
        }
        if (Keyboard.isKeyDown((int)57)) {
            if (player.getGameMode() == 2) {
                DangerZone.player.motiony += 0.055f * deltaT * accel;
                if ((accel += 0.1f) > 1.0f) {
                    accel = 1.0f;
                }
            } else if (player.getOnGround() || player.getInLiquid()) {
                player.jump();
            }
        }
        if (Keyboard.isKeyDown((int)42) && player.getGameMode() == 2) {
            DangerZone.player.motiony -= 0.055f * deltaT * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
        }
        if (Keyboard.isKeyDown((int)17)) {
            float speed = 0.032f * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 4.0f;
            } else if (gofast != 0) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx + (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz + (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
        } else {
            gofast = 0;
        }
        if (Keyboard.isKeyDown((int)31)) {
            float speed = 0.03f * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx - (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz - (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 90.0f)) * (double)deltaT);
        }
        if (Keyboard.isKeyDown((int)30)) {
            float speed = 0.03f * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx + (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz + (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
        }
        if (Keyboard.isKeyDown((int)32)) {
            float speed = 0.03f * accel;
            if ((accel += 0.1f) > 1.0f) {
                accel = 1.0f;
            }
            if (player.getGameMode() == 2) {
                speed *= 2.5f;
            }
            DangerZone.player.motionx = (float)((double)DangerZone.player.motionx - (double)speed * Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
            DangerZone.player.motionz = (float)((double)DangerZone.player.motionz - (double)speed * Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head - 180.0f)) * (double)deltaT);
        }
        while (Mouse.next()) {
            float dx = Mouse.getDX();
            float dy = Mouse.getDY();
            DangerZone.player.rotation_yaw_head += (dx *= 0.1f + 0.01f * (float)mouseSensitivity);
            DangerZone.player.rotation_yaw_head %= 360.0f;
            DangerZone.player.rotation_pitch_head -= (dy *= 0.1f + 0.01f * (float)mouseSensitivity);
            DangerZone.player.rotation_pitch_head %= 360.0f;
            if (DangerZone.player.rotation_pitch_head > 180.0f) {
                if (DangerZone.player.rotation_pitch_head < 270.0f) {
                    DangerZone.player.rotation_pitch_head = 270.0f;
                }
            } else if (DangerZone.player.rotation_pitch_head > 90.0f) {
                DangerZone.player.rotation_pitch_head = 90.0f;
            }
            if (Mouse.getEventButtonState()) {
                if (player.getGameMode() == 0) {
                    player.setHunger(player.getHunger() - 0.01f);
                }
                doleftclick = false;
                dorightclick = false;
                if (Mouse.getEventButton() == 0) {
                    do_hit_cycle = 1;
                    doleftclick = true;
                }
                if (Mouse.getEventButton() == 1) {
                    InventoryContainer ic = DangerZone.player.hotbar[DangerZone.player.current_hotbar_index];
                    if (ic != null && Items.isFood(ic.iid) && WorldRenderer.focus_x == 0 && WorldRenderer.focus_z == 0) {
                        do_food_cycle = 1;
                    } else {
                        do_hit_cycle = 1;
                        dorightclick = true;
                    }
                }
                if (Mouse.getEventButton() == 2) {
                    player.middleclick(world, WorldRenderer.focus_x, WorldRenderer.focus_y, WorldRenderer.focus_z, 0);
                }
            } else if (Mouse.getEventButton() >= 0) {
                do_hit_cycle = 0;
                do_food_cycle = 0;
            }
            if ((i = Mouse.getDWheel()) == 0) continue;
            i = -i / 120;
            i += DangerZone.player.current_hotbar_index;
            while (i < 0) {
                i += DangerZone.player.hotbar.length;
            }
            DangerZone.player.current_hotbar_index = i %= DangerZone.player.hotbar.length;
            player.sethotbarindex(i);
            InventoryContainer ic = DangerZone.player.hotbar[i];
            if (ic != null && ic.count > 0) {
                player.setBID(ic.bid);
                player.setIID(ic.iid);
                String hotstring = null;
                String[] hss = null;
                if (ic.bid != 0) {
                    hotstring = Blocks.getUniqueName(ic.bid);
                }
                if (ic.iid != 0) {
                    hotstring = Items.getUniqueName(ic.iid);
                }
                if (hotstring == null || (hss = hotstring.split(":")).length < 2) continue;
                hotmessagestring = hss[1];
                hotmessagetimer = 60;
                continue;
            }
            player.setBID(0);
            player.setIID(0);
            hotmessagestring = null;
            hotmessagetimer = 0;
        }
    }

    private static void showLogo() {
        if (logotexture == null) {
            try {
                logotexture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)"res/menus/logo.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        logotexture.bind();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        float x = 200.0f;
        float y = 190.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-600.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-x), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-x), (float)(-y), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)(-y), (float)0.0f);
        GL11.glEnd();
    }

    private static void readConfig() {
        Properties prop = new Properties();
        FileInputStream input = null;
        server_address = "127.0.0.1";
        server_port = 18668;
        screen_width = 1024;
        screen_height = 600;
        renderdistance = 24;
        volume_temp = 10;
        worldname = "my_world";
        playername = "Player";
        fieldOfView = 45;
        mouseSensitivity = 0;
        mindrawlevel = 0;
        generatecaves = true;
        all_sides = true;
        light_speed = true;
        try {
            input = new FileInputStream("DangerZone.properties");
            prop.load(input);
            screen_width = Utils.getPropertyInt(prop, "ScreenWidth", 500, 4000, 1024);
            screen_height = Utils.getPropertyInt(prop, "ScreenHeight", 300, 3000, 600);
            renderdistance = Utils.getPropertyInt(prop, "RenderDistance", 4, 24, 16);
            volume_temp = Utils.getPropertyInt(prop, "Volume", 0, 10, 10);
            server_address = Utils.getPropertyString(prop, "ServerAddress", "127.0.0.1");
            server_port = Utils.getPropertyInt(prop, "ServerPort", 0, Integer.MAX_VALUE, 18668);
            origworldname = worldname = Utils.getPropertyString(prop, "WorldName", "my_world");
            playername = Utils.getPropertyString(prop, "Playername", "Player");
            fieldOfView = Utils.getPropertyInt(prop, "FieldOfView", 30, 80, 45);
            mouseSensitivity = Utils.getPropertyInt(prop, "MouseSensitivity", -9, 9, 0);
            keepitsqueakyclean = Utils.getPropertyBoolean(prop, "RunFinalization", true);
            generatecaves = Utils.getPropertyBoolean(prop, "CaveGeneration", true);
            mindrawlevel = Utils.getPropertyInt(prop, "MinDrawLevel", 0, 40, 0);
            alt_texture_path = Utils.getPropertyString(prop, "AltTextureDir", "");
            all_sides = Utils.getPropertyBoolean(prop, "MaxGraphics", true);
            light_speed = Utils.getPropertyBoolean(prop, "FastLighting", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void writeConfig() {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream("DangerZone.properties");
            prop.setProperty("ScreenWidth", String.format("%d", screen_width));
            prop.setProperty("ScreenHeight", String.format("%d", screen_height));
            prop.setProperty("RenderDistance", String.format("%d", renderdistance));
            if (soundmangler != null) {
                prop.setProperty("Volume", String.format("%d", DangerZone.soundmangler.master_volume));
            }
            prop.setProperty("ServerAddress", server_address);
            prop.setProperty("ServerPort", String.format("%d", server_port));
            String strippedname = worldname;
            if (!start_server) {
                strippedname = origworldname;
            }
            if (strippedname.contains("/")) {
                int is = strippedname.lastIndexOf("/");
                strippedname = strippedname.substring(is + 1);
            }
            prop.setProperty("WorldName", strippedname);
            prop.setProperty("Playername", playername);
            prop.setProperty("FieldOfView", String.format("%d", fieldOfView));
            prop.setProperty("MouseSensitivity", String.format("%d", mouseSensitivity));
            prop.setProperty("RunFinalization", String.format("%s", keepitsqueakyclean ? "true" : "false"));
            prop.setProperty("CaveGeneration", String.format("%s", generatecaves ? "true" : "false"));
            prop.setProperty("MinDrawLevel", String.format("%d", mindrawlevel));
            prop.setProperty("AltTextureDir", alt_texture_path);
            prop.setProperty("MaxGraphics", String.format("%s", all_sides ? "true" : "false"));
            prop.setProperty("FastLighting", String.format("%s", light_speed ? "true" : "false"));
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadPlayer(Player p) {
        FileInputStream input = null;
        Properties playerprop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/player.dat", worldname);
        try {
            input = new FileInputStream(filepath);
            playerprop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        p.readSelf(playerprop, "player:");
    }

    public static void savePlayer(Player p) {
        Properties playerprop = new Properties();
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/player.dat", worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        p.writeSelf(playerprop, "player:");
        try {
            output = new FileOutputStream(filepath);
            playerprop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadWorld(World w) {
        FileInputStream input = null;
        Properties worldprop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/world.dat", worldname);
        try {
            input = new FileInputStream(filepath);
            worldprop.load(input);
            w.timetimer = Utils.getPropertyInt(worldprop, "TimeOfDay", 0, Integer.MAX_VALUE, 0);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void saveWorld(World w) {
        Properties worldprop = new Properties();
        OutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/world.dat", worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            worldprop.setProperty("TimeOfDay", String.format("%d", w.timetimer));
            output = new FileOutputStream(filepath);
            worldprop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getWorldDirectoryPath() {
        return String.format("worlds/%s/", worldname);
    }

    public static String getAltTexturePath() {
        return alt_texture_path;
    }

    private static void doStartSinglePlayer() {
        soundmangler = new SoundManager();
        DangerZone.soundmangler.master_volume = volume_temp;
        client_chunk_cache = new ChunkCache();
        DangerZone.client_chunk_cache.passthru = true;
        server_chunk_cache = new ServerChunkCache();
        chunkwriter = new ChunkWriterThread();
        Thread cwt = new Thread(chunkwriter);
        cwt.start();
        wds = new WorldDecorators();
        player = new Player(null);
        DangerZone.player.model = new ModelHumanoid();
        DangerZone.loadPlayer(player);
        player.init();
        player.setHealth(player.getMaxHealth());
        DangerZone.player.myname = playername;
        DangerZone.player.world = world = new World(client_chunk_cache, null, player);
        server_world = new World(null, server_chunk_cache, player);
        DangerZone.server_world.isServer = true;
        DangerZone.server_world.timetimer = 0;
        DangerZone.loadWorld(server_world);
        wr = new WorldRenderer();
        all_the_blocks = new Blocks();
        Blocks.load();
        all_the_items = new Items();
        Items.load();
        all_the_dimensions = new Dimensions();
        Dimensions.load();
        all_the_custompackets = new CustomPackets();
        all_the_recipies = new Crafting();
        all_the_cooking = new Cooking();
        all_the_ores = new Ores();
        all_the_spawns = new Spawnlist();
        all_the_particles = new Particles();
        all_the_entities = new Entities();
        blockitem = new EntityBlockItem(world);
        Entities.registerEntity(EntityBlockItem.class, DangerZone.blockitem.uniquename, new ModelEntityBlockItem());
        Entities.registerEntity(Player.class, DangerZone.player.uniquename, new ModelHumanoid());
        Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());
        base = new BaseMod();
        base.registerThings();
        modloader = new ModLoader();
        modloader.loadmods();
        base.initializeThings();
        Blocks.save();
        Items.save();
        Dimensions.save();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        entityManager = new EntityUpdateLoop();
        Thread it = new Thread(entityManager);
        it.start();
        particleManager = new ParticleUpdateLoop();
        Thread pit = new Thread(particleManager);
        pit.start();
        commandhandler = new CommandHandler();
        server = new Server();
        Thread st = new Thread(server);
        st.start();
        while (DangerZone.server.entityManager == null) {
            Thread.yield();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        player.getTexture();
        server_connection = new ServerConnection(player, false);
        Thread ct = new Thread(server_connection);
        ct.start();
        escapegui = new PlayerEscapeGUI();
        inventorygui = new PlayerInventoryGUI();
        chatgui = new PlayerChatGUI();
        helpgui = new PlayerHelpGUI();
        commandgui = new PlayerCommandGUI();
        chestgui = new PlayerChestGUI();
        furnacegui = new PlayerFurnaceGUI();
        int i = 0;
        while (DangerZone.server_connection.connected == 0 && i < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (i >= 10) {
            System.exit(1);
        }
        lto = new LightingThread();
        Thread lt = new Thread(lto);
        lt.start();
        tidyup = new CleanerThread();
        Thread clt = new Thread(tidyup);
        clt.setPriority(10);
        clt.start();
        InventoryContainer ic = DangerZone.player.hotbar[DangerZone.player.current_hotbar_index];
        if (ic != null) {
            player.setBID(ic.bid);
            player.setIID(ic.iid);
        } else {
            player.setBID(0);
            player.setIID(0);
        }
        wr.loadBlockTextures();
        server_connection.sendPlayerEntityUpdate(player);
        Chunk c = null;
        while (c == null) {
            c = DangerZone.player.world.chunkcache.getDecoratedChunk(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
            if (c != null) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        c = null;
        DangerZone.wr.lastplayerdimension = DangerZone.player.dimension;
        Mouse.setGrabbed((boolean)true);
        mouse_grabbed = true;
        Thread thisthread = Thread.currentThread();
        thisthread.setPriority(10);
    }

    private static void doStartServer() {
        soundmangler = new SoundManager();
        DangerZone.soundmangler.master_volume = volume_temp;
        server_chunk_cache = new ServerChunkCache();
        chunkwriter = new ChunkWriterThread();
        Thread cwt = new Thread(chunkwriter);
        cwt.start();
        wds = new WorldDecorators();
        player = new Player(null);
        server_world = new World(null, server_chunk_cache, null);
        DangerZone.server_world.isServer = true;
        DangerZone.server_world.timetimer = 0;
        DangerZone.player.world = server_world;
        DangerZone.loadWorld(server_world);
        all_the_blocks = new Blocks();
        Blocks.load();
        all_the_items = new Items();
        Items.load();
        all_the_dimensions = new Dimensions();
        Dimensions.load();
        all_the_custompackets = new CustomPackets();
        all_the_recipies = new Crafting();
        all_the_cooking = new Cooking();
        all_the_ores = new Ores();
        all_the_spawns = new Spawnlist();
        all_the_particles = new Particles();
        all_the_entities = new Entities();
        blockitem = new EntityBlockItem(world);
        Entities.registerEntity(EntityBlockItem.class, DangerZone.blockitem.uniquename, new ModelEntityBlockItem());
        Entities.registerEntity(Player.class, DangerZone.player.uniquename, new ModelHumanoid());
        Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());
        base = new BaseMod();
        base.registerThings();
        modloader = new ModLoader();
        modloader.loadmods();
        base.initializeThings();
        Blocks.save();
        Items.save();
        Dimensions.save();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        commandhandler = new CommandHandler();
        server = new Server();
        Thread st = new Thread(server);
        st.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        tidyup = new CleanerThread();
        Thread clt = new Thread(tidyup);
        clt.setPriority(10);
        clt.start();
    }

    private static void doStartClient() {
        InventoryContainer ic;
        soundmangler = new SoundManager();
        DangerZone.soundmangler.master_volume = volume_temp;
        client_chunk_cache = new ChunkCache();
        player = new Player(null);
        DangerZone.player.model = new ModelHumanoid();
        DangerZone.player.myname = playername;
        DangerZone.player.world = world = new World(client_chunk_cache, null, player);
        wr = new WorldRenderer();
        all_the_blocks = new Blocks();
        all_the_items = new Items();
        all_the_dimensions = new Dimensions();
        all_the_custompackets = new CustomPackets();
        all_the_recipies = new Crafting();
        all_the_cooking = new Cooking();
        all_the_ores = new Ores();
        all_the_spawns = new Spawnlist();
        all_the_particles = new Particles();
        all_the_entities = new Entities();
        blockitem = new EntityBlockItem(world);
        Entities.registerEntity(EntityBlockItem.class, DangerZone.blockitem.uniquename, new ModelEntityBlockItem());
        Entities.registerEntity(Player.class, DangerZone.player.uniquename, new ModelHumanoid());
        Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());
        escapegui = new PlayerEscapeGUI();
        inventorygui = new PlayerInventoryGUI();
        chatgui = new PlayerChatGUI();
        helpgui = new PlayerHelpGUI();
        commandgui = new PlayerCommandGUI();
        chestgui = new PlayerChestGUI();
        furnacegui = new PlayerFurnaceGUI();
        entityManager = new EntityUpdateLoop();
        Thread it = new Thread(entityManager);
        it.start();
        particleManager = new ParticleUpdateLoop();
        Thread pit = new Thread(particleManager);
        pit.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        player.getTexture();
        server_connection = new ServerConnection(player, true);
        Thread ct = new Thread(server_connection);
        ct.start();
        int i = 0;
        while (!DangerZone.server_connection.connectionInProgress && i < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (i >= 10) {
            System.exit(1);
        }
        worldname = String.format("servers/%s", DangerZone.server_connection.worldname);
        DangerZone.loadPlayer(player);
        player.init();
        player.setHealth(player.getMaxHealth());
        base = new BaseMod();
        base.registerThings();
        modloader = new ModLoader();
        if (!modloader.loadmods(DangerZone.server_connection.modnames)) {
            System.out.printf("Failed to load mods specified by server.\n", new Object[0]);
            System.exit(1);
        }
        base.initializeThings();
        DangerZone.server_connection.waitformodstoload = false;
        i = 0;
        while (DangerZone.server_connection.connected == 0 && i < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (i >= 10) {
            System.exit(1);
        }
        if ((ic = DangerZone.player.hotbar[DangerZone.player.current_hotbar_index]) != null) {
            player.setBID(ic.bid);
            player.setIID(ic.iid);
        } else {
            player.setBID(0);
            player.setIID(0);
        }
        wr.loadBlockTextures();
        server_connection.sendPlayerEntityUpdate(player);
        Chunk c = null;
        while (c == null) {
            c = DangerZone.player.world.chunkcache.getDecoratedChunk(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
            if (c != null) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        c = null;
        lto = new LightingThread();
        Thread lt = new Thread(lto);
        lt.start();
        tidyup = new CleanerThread();
        Thread clt = new Thread(tidyup);
        clt.setPriority(10);
        clt.start();
        DangerZone.wr.lastplayerdimension = DangerZone.player.dimension;
        Mouse.setGrabbed((boolean)true);
        mouse_grabbed = true;
        Thread thisthread = Thread.currentThread();
        thisthread.setPriority(10);
    }
}

