/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Blocks {
    public static Block stone = new BlockStone("DangerZone:Stone", "res/blocks/stone.png", 100);
    public static Block dirt = new BlockDirt("DangerZone:Dirt", "res/blocks/dirt.png");
    public static Block stopblock = new StopBlock("DangerZone:Stop Block", "res/blocks/stopblock.png");
    public static Block redwoodlog = new BlockLog("DangerZone:Redwood Log", "res/blocks/redwood.png", "res/blocks/redwood_top.png");
    public static Block willowlog = new BlockLog("DangerZone:Willow Log", "res/blocks/willowwood.png", "res/blocks/willowwood_top.png");
    public static Block log = new BlockLog("DangerZone:Log", "res/blocks/wood.png", "res/blocks/wood_top.png");
    public static Block lightplywood = new BlockWood("DangerZone:Light Plywood", "res/blocks/lightplywood.png");
    public static Block plywood = new BlockWood("DangerZone:Plywood", "res/blocks/plywood.png");
    public static Block darkplywood = new BlockWood("DangerZone:Dark Plywood", "res/blocks/darkplywood.png");
    public static Block leaves = new BlockLeaves("DangerZone:Leaves", "res/blocks/leaves.png");
    public static Block redwoodleaves = new BlockLeaves("DangerZone:Redwood Leaves", "res/blocks/redwoodleaves.png");
    public static Block willowleaves = new BlockLeaves("DangerZone:Willow Leaves", "res/blocks/willowleaves.png");
    public static Block grassblock = new GrassBlock("DangerZone:Grass Block", "res/blocks/grasstop.png", "res/blocks/grassbottom.png", "res/blocks/grassside.png");
    public static Block grass = new Grass("DangerZone:Grass", "res/blocks/grass.png");
    public static Block oresilver = new BlockOreSilver("DangerZone:Silver Ore", "res/blocks/oresilver.png", 150);
    public static Block oreplatinum = new BlockOrePlatinum("DangerZone:Platinum Ore", "res/blocks/oreplatinum.png", 175);
    public static Block workbench = new BlockWorkBench("DangerZone:Workbench");
    public static Block furnace = new BlockFurnace("DangerZone:Furnace");
    public static Block furnaceOn = new BlockFurnaceOn("DangerZone:FurnaceOn");
    public static Block chest = new BlockChest("DangerZone:Chest");
    public static Block lightstick = new LightStick("DangerZone:Lightstick", "res/blocks/torch.png");
    public static Block darkstick = new DarkStick("DangerZone:Darkstick", "res/blocks/darkstick.png");
    public static Block oredark = new BlockDark("DangerZone:Dark Ore", "res/blocks/oredark.png", 200);
    public static Block orelight = new BlockLight("DangerZone:Light Ore", "res/blocks/orelight.png", 50);
    public static Block water = new BlockWater("DangerZone:Water", "res/blocks/water.png");
    public static Block watersource = new BlockWaterSource("DangerZone:Water Source", "res/blocks/water.png");
    public static Block MyCornPlant1 = new BlockCorn("DangerZone:Baby Corn Plant", "res/blocks/corn_0.png");
    public static Block MyCornPlant2 = new BlockCorn("DangerZone:Corn Plant", "res/blocks/corn_1.png");
    public static Block MyCornPlant3 = new BlockCorn("DangerZone:Flowering Corn Plant", "res/blocks/corn_2.png");
    public static Block MyCornPlant4 = new BlockCorn("DangerZone:Ripe Corn Plant", "res/blocks/corn_3.png");
    public static Block roachnest = new RoachBlock("DangerZone:Cockroach Nest", "res/blocks/roachnest.png", "res/blocks/grassbottom.png", "res/blocks/grassside.png");
    public static Block glass = new BlockGlass("DangerZone:Glass", "res/blocks/glass.png", 10);
    public static Block flower_red = new BlockFlower("DangerZone:Red Flower", "res/blocks/flower_red.png");
    public static Block flower_pink = new BlockFlower("DangerZone:Pink Flower", "res/blocks/flower_pink.png");
    public static Block flower_purple = new BlockFlower("DangerZone:Purple Flower", "res/blocks/flower_purple.png");
    public static Block flower_yellow = new BlockFlower("DangerZone:Yellow Flower", "res/blocks/flower_yellow.png");
    public static Block butterfly_plant = new ButterflyPlant("DangerZone:Butterfly Plant", "res/blocks/butterfly_0.png");
    public static Block butterfly_plant1 = new ButterflyPlant("DangerZone:Butterfly Plant 1", "res/blocks/butterfly_1.png");
    public static Block butterfly_plant2 = new ButterflyPlant("DangerZone:Butterfly Plant 2", "res/blocks/butterfly_2.png");
    public static Block butterfly_plant3 = new ButterflyPlant("DangerZone:Butterfly Plant 3", "res/blocks/butterfly_3.png");
    public static Block sand = new BlockDirt("DangerZone:Sand", "res/blocks/sand.png");
    public static Block radish_plant = new RadishPlant("DangerZone:Radish Plant", "res/blocks/radish_0.png");
    public static Block radish_plant1 = new RadishPlant("DangerZone:Radish Plant 1", "res/blocks/radish_1.png");
    public static Block radish_plant2 = new RadishPlant("DangerZone:Radish Plant 2", "res/blocks/radish_2.png");
    public static Block radish_plant3 = new RadishPlant("DangerZone:Radish Plant 3", "res/blocks/radish_3.png");
    public static Block rice_plant = new RicePlant("DangerZone:Rice Plant", "res/blocks/rice_0.png");
    public static Block rice_plant1 = new RicePlant("DangerZone:Rice Plant 1", "res/blocks/rice_1.png");
    public static Block rice_plant2 = new RicePlant("DangerZone:Rice Plant 2", "res/blocks/rice_2.png");
    public static Block rice_plant3 = new RicePlant("DangerZone:Rice Plant 3", "res/blocks/rice_3.png");
    public static Block blocksilver = new BlockMetal("DangerZone:Silver Block", "res/blocks/blocksilver.png", 150);
    public static Block blockplatinum = new BlockMetal("DangerZone:Platinum Block", "res/blocks/blockplatinum.png", 250);
    public static Block blockdark = new BlockBlockDark("DangerZone:Dark Block", "res/blocks/blockdark.png", 400);
    public static Block blocklight = new BlockBlockLight("DangerZone:Light Block", "res/blocks/blocklight.png", 150);
    public static Block[] BlockArray;
    public static final int blocksMAX = 2048;
    public static Properties prop;

    static {
        prop = null;
    }

    Blocks() {
        BlockArray = new Block[2048];
        int i = 0;
        while (i < 2048) {
            Blocks.BlockArray[i] = null;
            ++i;
        }
    }

    public static int registerBlock(Block b) {
        int i = 0;
        if (prop != null) {
            i = Utils.getPropertyInt(prop, b.uniquename, 0, 2047, 0);
        }
        if (i == 0) {
            i = 1;
            while (i < 2048) {
                if (BlockArray[i] == null) {
                    Blocks.BlockArray[i] = b;
                    b.blockID = i;
                    if (prop != null) {
                        prop.setProperty(b.uniquename, String.format("%d", i));
                    }
                    return i;
                }
                ++i;
            }
        } else {
            if (BlockArray[i] == null) {
                Blocks.BlockArray[i] = b;
                b.blockID = i;
                return i;
            }
            Block intruder = BlockArray[i];
            int isave = i;
            Blocks.BlockArray[i] = b;
            b.blockID = i;
            i = 1;
            while (i < 2048) {
                if (BlockArray[i] == null) {
                    Blocks.BlockArray[i] = intruder;
                    intruder.blockID = i;
                    prop.setProperty(intruder.uniquename, String.format("%d", i));
                }
                ++i;
            }
            return isave;
        }
        return 0;
    }

    public static void reRegisterBlockAt(String s, int loc) {
        if (loc <= 0 || loc >= 2048) {
            return;
        }
        if (s == null || s.equals("")) {
            return;
        }
        if (BlockArray[loc] != null) {
            if (s.equals(Blocks.BlockArray[loc].uniquename)) {
                return;
            }
            int i = 1;
            while (i < 2048) {
                if (BlockArray[i] != null && s.equals(Blocks.BlockArray[i].uniquename)) {
                    Block me = BlockArray[i];
                    Block intruder = BlockArray[loc];
                    Blocks.BlockArray[loc] = me;
                    Blocks.BlockArray[loc].blockID = loc;
                    Blocks.BlockArray[i] = intruder;
                    Blocks.BlockArray[i].blockID = i;
                    return;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < 2048) {
                if (BlockArray[i] != null && s.equals(Blocks.BlockArray[i].uniquename)) {
                    Blocks.BlockArray[loc] = BlockArray[i];
                    Blocks.BlockArray[loc].blockID = loc;
                    Blocks.BlockArray[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static void load() {
        FileInputStream input = null;
        prop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/blockIDs.dat", DangerZone.worldname);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/blockIDs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            output = new FileOutputStream(filepath);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isSolid(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isSolid;
    }

    public static boolean isLiquid(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isLiquid;
    }

    public static boolean isSolidForRender(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isSolidForRendering;
    }

    public static boolean renderAllSides(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].renderAllSides;
    }

    public static boolean shouldShow(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].showInInventory;
    }

    public static boolean isTranslucentForRender(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isTranslucent;
    }

    public static boolean hasOwnRenderer(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].hasOwnRenderer;
    }

    public static boolean alwaystick(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].alwaystick;
    }

    public static boolean randomtick(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].randomtick;
    }

    public static boolean isWood(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isWood;
    }

    public static boolean isStone(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isStone;
    }

    public static boolean isDirt(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isDirt;
    }

    public static boolean isLeaves(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].isLeaves;
    }

    public static boolean canLeavesGrow(int blockid) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return Blocks.BlockArray[blockid].canLeavesGrow;
    }

    public static void doblocktick(World w, int d, int x, int y, int z, int blockid) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].tickMe(w, d, x, y, z);
    }

    public static void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].renderMe(wr, w, d, x, y, z, blockid, meta, sides, focused);
    }

    public static void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int blockid, int meta, int sides, boolean focused, int xo, int yo, int zo) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].renderMeToVBO(chunkvbos, wr, w, d, x, y, z, blockid, meta, sides, focused, xo, yo, zo);
    }

    public static String getBreakSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getBreakSound();
    }

    public static String getPlaceSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getPlaceSound();
    }

    public static String getHitSound(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getHitSound();
    }

    public static String getParticleName(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getParticleName();
    }

    public static int getMaxStack(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].maxstack;
    }

    public static int getMinDamage(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].mindamage;
    }

    public static Texture getTexture(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return BlockArray[blockid].getTexture(1);
    }

    public static void notifyNeighborChanged(int blockid, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].notifyNeighborChanged(w, d, x, y, z);
    }

    public static String getUniqueName(int blockid) {
        if (blockid <= 0) {
            return null;
        }
        if (blockid >= 2048) {
            return null;
        }
        if (BlockArray[blockid] == null) {
            return null;
        }
        return Blocks.BlockArray[blockid].uniquename;
    }

    public static int findByName(String name) {
        if (name == null) {
            return 0;
        }
        int i = 1;
        while (i < 2048) {
            if (BlockArray[i] != null && Blocks.BlockArray[i].uniquename != null && name.equals(Blocks.BlockArray[i].uniquename)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static boolean rightClickOnBlock(int blockid, Player p, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].rightClickOnBlock(p, d, x, y, z);
    }

    public static boolean leftClickOnBlock(int blockid, Player p, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return false;
        }
        if (blockid >= 2048) {
            return false;
        }
        if (BlockArray[blockid] == null) {
            return false;
        }
        return BlockArray[blockid].leftClickOnBlock(p, d, x, y, z);
    }

    public static void onBlockBroken(int blockid, Player p, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].onBlockBroken(p, d, x, y, z);
    }

    public static int getMaxDamage(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].maxdamage;
    }

    public static int getBlockDrop(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getBlockDrop(p, w, d, x, y, z);
    }

    public static int getItemDrop(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getItemDrop(p, w, d, x, y, z);
    }

    public static int getDropCount(int blockid, Player p, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return BlockArray[blockid].getDropCount(p, w, d, x, y, z);
    }

    public static float getFriction(int blockid) {
        if (blockid <= 0) {
            return 0.0f;
        }
        if (blockid >= 2048) {
            return 0.0f;
        }
        if (BlockArray[blockid] == null) {
            return 0.0f;
        }
        return Blocks.BlockArray[blockid].friction;
    }

    public static float getLightLevel(int blockid) {
        if (blockid <= 0) {
            return 0.0f;
        }
        if (blockid >= 2048) {
            return 0.0f;
        }
        if (BlockArray[blockid] == null) {
            return 0.0f;
        }
        return Blocks.BlockArray[blockid].brightness;
    }

    public static void doSteppedOn(int blockid, Entity e, World w, int d, int x, int y, int z) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].doSteppedOn(e, w, d, x, y, z);
    }

    public static void doPlaceBlock(int blockid, int focusblockid, Player p, World w, int d, int x, int y, int z, int side) {
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        BlockArray[blockid].doPlaceBlock(focusblockid, p, w, d, x, y, z, side);
    }

    public static void doBreakBlock(int blockid, World w, int d, int x, int y, int z) {
        EntityBlockItem eb;
        if (blockid <= 0) {
            return;
        }
        if (blockid >= 2048) {
            return;
        }
        if (BlockArray[blockid] == null) {
            return;
        }
        int bid = BlockArray[blockid].getBlockDrop(null, w, d, x, y, z);
        int iid = BlockArray[blockid].getItemDrop(null, w, d, x, y, z);
        if ((bid != 0 || iid != 0) && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f)) != null) {
            eb.setBID(bid);
            eb.setIID(iid);
            w.spawnEntityInWorld(eb);
        }
    }

    public static int getBurnTime(int blockid) {
        if (blockid <= 0) {
            return 0;
        }
        if (blockid >= 2048) {
            return 0;
        }
        if (BlockArray[blockid] == null) {
            return 0;
        }
        return Blocks.BlockArray[blockid].burntime;
    }
}

