package dangerzone.entities;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2020.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * This copyright remains in effect until January 1st, 2021. 
 * At that time, this code becomes public domain.
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import org.lwjgl.opengl.GL11;

import dangerzone.DangerZone;
import dangerzone.ModelBase;


public class ModelCloud extends ModelBase {



	public ModelCloud()
	{

	}

	public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
	{
		EntityCloud ec = (EntityCloud)entity;
		int mybid = ec.getBID();
		int sides;
		if(mybid != 0 && DangerZone.show_clouds){
			GL11.glScalef(4.0f, 4.0f, 4.0f);
			for(int i=0;i<32;i++){
				for(int j=0;j<32;j++){
					if(ec.getpart(i, j)){
						sides = 0x30; //always draw top and bottom!
						if(!ec.getpart(i+1, j))sides |= 0x02;
						if(!ec.getpart(i-1, j))sides |= 0x01;
						if(!ec.getpart(i, j+1))sides |= 0x08;
						if(!ec.getpart(i, j-1))sides |= 0x04;
						GL11.glTranslatef((i-16)*16, 0, (j-16)*16);
						DangerZone.wr.drawTexturedCube(sides, false, mybid, 0, false);
						GL11.glTranslatef(-(i-16)*16, 0, -(j-16)*16);
					}
				}
			}
			GL11.glScalef(0.25f, 0.25f, 0.25f);
		}

	}

}
